/*
 * Decompiled with CFR 0.152.
 */
package com.veracode.apiwrapper.dynamicanalysis.model.api;

import com.google.gson.annotations.SerializedName;
import com.veracode.apiwrapper.dynamicanalysis.model.api.ScanURL;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

@ApiModel(description="Representation of a blacklist configuration for a scan")
public class BlacklistConfiguration {
    @SerializedName(value="blackList")
    private List<ScanURL> blackList = null;

    public BlacklistConfiguration blackList(List<ScanURL> blackList) {
        this.blackList = blackList;
        return this;
    }

    public BlacklistConfiguration addBlackListItem(ScanURL blackListItem) {
        if (this.blackList == null) {
            this.blackList = new ArrayList<ScanURL>();
        }
        this.blackList.add(blackListItem);
        return this;
    }

    @ApiModelProperty(value="Black listed scan urls")
    public List<ScanURL> getBlackList() {
        return this.blackList;
    }

    public void setBlackList(List<ScanURL> blackList) {
        this.blackList = blackList;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BlacklistConfiguration blacklistConfiguration = (BlacklistConfiguration)o;
        return Objects.equals(this.blackList, blacklistConfiguration.blackList);
    }

    public int hashCode() {
        return Objects.hash(this.blackList);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class BlacklistConfiguration {\n");
        sb.append("    blackList: ").append(this.toIndentedString(this.blackList)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

