/*
 * Decompiled with CFR 0.152.
 */
package com.veracode.apiwrapper.dynamicanalysis.model.api;

import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import com.veracode.apiwrapper.dynamicanalysis.model.api.Source;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.util.Objects;

@ApiModel(description="Represents an error related to an API call")
public class ServiceError {
    @SerializedName(value="code")
    private CodeEnum code = null;
    @SerializedName(value="id")
    private String id = null;
    @SerializedName(value="title")
    private String title = null;
    @SerializedName(value="detail")
    private String detail = null;
    @SerializedName(value="meta")
    private Object meta = null;
    @SerializedName(value="source")
    private Source source = null;
    @SerializedName(value="status")
    private String status = null;

    public ServiceError code(CodeEnum code) {
        this.code = code;
        return this;
    }

    @ApiModelProperty(value="A coded representation of the error")
    public CodeEnum getCode() {
        return this.code;
    }

    public void setCode(CodeEnum code) {
        this.code = code;
    }

    public ServiceError id(String id) {
        this.id = id;
        return this;
    }

    @ApiModelProperty(value="A unique identity of the error. This value if present indicates that the error was logged on the service and can be used to troubleshoot")
    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public ServiceError title(String title) {
        this.title = title;
        return this;
    }

    @ApiModelProperty(value="Title of the error")
    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public ServiceError detail(String detail) {
        this.detail = detail;
        return this;
    }

    @ApiModelProperty(value="Details regarding the error")
    public String getDetail() {
        return this.detail;
    }

    public void setDetail(String detail) {
        this.detail = detail;
    }

    public ServiceError meta(Object meta) {
        this.meta = meta;
        return this;
    }

    @ApiModelProperty(value="Additional information regarding the error")
    public Object getMeta() {
        return this.meta;
    }

    public void setMeta(Object meta) {
        this.meta = meta;
    }

    public ServiceError source(Source source) {
        this.source = source;
        return this;
    }

    @ApiModelProperty(value="A pointer to the location where the error originates - if this error is related to an API parameter")
    public Source getSource() {
        return this.source;
    }

    public void setSource(Source source) {
        this.source = source;
    }

    public ServiceError status(String status) {
        this.status = status;
        return this;
    }

    @ApiModelProperty(value="String representation of HTTP status that best represents the error. E.g. '404'")
    public String getStatus() {
        return this.status;
    }

    public void setStatus(String status) {
        this.status = status;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ServiceError serviceError = (ServiceError)o;
        return Objects.equals((Object)this.code, (Object)serviceError.code) && Objects.equals(this.id, serviceError.id) && Objects.equals(this.title, serviceError.title) && Objects.equals(this.detail, serviceError.detail) && Objects.equals(this.meta, serviceError.meta) && Objects.equals(this.source, serviceError.source) && Objects.equals(this.status, serviceError.status);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.code, this.id, this.title, this.detail, this.meta, this.source, this.status});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ServiceError {\n");
        sb.append("    code: ").append(this.toIndentedString((Object)this.code)).append("\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    title: ").append(this.toIndentedString(this.title)).append("\n");
        sb.append("    detail: ").append(this.toIndentedString(this.detail)).append("\n");
        sb.append("    meta: ").append(this.toIndentedString(this.meta)).append("\n");
        sb.append("    source: ").append(this.toIndentedString(this.source)).append("\n");
        sb.append("    status: ").append(this.toIndentedString(this.status)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    @JsonAdapter(value=Adapter.class)
    public static enum CodeEnum {
        INVALID_ANALYSIS_IDENTIFIER("INVALID_ANALYSIS_IDENTIFIER"),
        INVALID_ANALYSIS_STATE("INVALID_ANALYSIS_STATE"),
        NAME_ERROR("NAME_ERROR"),
        INVALID_NUMBER_OF_SCANS("INVALID_NUMBER_OF_SCANS"),
        INVALID_SCHEDULE("INVALID_SCHEDULE"),
        INVALID_BATCH_SETTING("INVALID_BATCH_SETTING"),
        SCAN_VALIDATION_ERROR("SCAN_VALIDATION_ERROR"),
        INVALID_ACTION_TYPE("INVALID_ACTION_TYPE"),
        SCAN_IDENTIFIER_NOT_SPECIFIED("SCAN_IDENTIFIER_NOT_SPECIFIED"),
        INVALID_SCAN_IDENTIFIER("INVALID_SCAN_IDENTIFIER"),
        SCAN_IN_USE("SCAN_IN_USE"),
        INVALID_APPLICATION_REQUEST("INVALID_APPLICATION_REQUEST"),
        INVALID_SCAN_CONFIGURATION_REQUEST("INVALID_SCAN_CONFIGURATION_REQUEST"),
        SCAN_LOCKED("SCAN_LOCKED"),
        GATEWAY_IDENTIFIER_NOT_SPECIFIED("GATEWAY_IDENTIFIER_NOT_SPECIFIED"),
        ENDPOINT_IDENTIFIER_NOT_SPECIFIED("ENDPOINT_IDENTIFIER_NOT_SPECIFIED"),
        INVALID_GATEWAY_OR_ENDPOINT_IDENTIFIER("INVALID_GATEWAY_OR_ENDPOINT_IDENTIFIER"),
        FAILED_TO_VALIDATE_INTERNAL_SCAN_CONFIGURATION("FAILED_TO_VALIDATE_INTERNAL_SCAN_CONFIGURATION"),
        APP_LINK_ERROR("APP_LINK_ERROR"),
        INVALID_APPLICATION_IDENTIFIER("INVALID_APPLICATION_IDENTIFIER"),
        NAME_NOT_SPECIFIED("NAME_NOT_SPECIFIED"),
        NAME_NOT_UNIQUE("NAME_NOT_UNIQUE"),
        NAME_INVALID_LENGTH("NAME_INVALID_LENGTH"),
        APPLICATION_ID_NOT_SPECIFIED("APPLICATION_ID_NOT_SPECIFIED"),
        INVALID_APPLICATION_ID("INVALID_APPLICATION_ID"),
        SCAN_NOT_LINKED_TO_AN_APP("SCAN_NOT_LINKED_TO_AN_APP"),
        RESULT_IMPORT_INPROGRESS_FOR_SCAN("RESULT_IMPORT_INPROGRESS_FOR_SCAN"),
        APPLICATION_NOT_FOUND("APPLICATION_NOT_FOUND"),
        ACCESS_DENIED_FOR_APPLICATION("ACCESS_DENIED_FOR_APPLICATION"),
        UNEXPECTED_RESPONSE_ON_RETRIEVE_APP("UNEXPECTED_RESPONSE_ON_RETRIEVE_APP"),
        UNEXPECTED_RESPONSE_ON_RETRIEVE_APPS("UNEXPECTED_RESPONSE_ON_RETRIEVE_APPS"),
        DUPLICATE_LINK_APP_ID_IN_SAME_ANALYSIS("DUPLICATE_LINK_APP_ID_IN_SAME_ANALYSIS"),
        MISSING_SCAN_CONFIGURATION("MISSING_SCAN_CONFIGURATION"),
        INVALID_SCAN_CONFIGURATION_IDENTIFIER("INVALID_SCAN_CONFIGURATION_IDENTIFIER"),
        INVALID_TARGET_URL("INVALID_TARGET_URL"),
        DUPLICATE_SCAN_CONFIGURATION("DUPLICATE_SCAN_CONFIGURATION"),
        INVALID_AUTH_SETTING("INVALID_AUTH_SETTING"),
        INVALID_CRAWL_SETTING("INVALID_CRAWL_SETTING"),
        INVALID_SCAN_SETTING("INVALID_SCAN_SETTING"),
        INVALID_INCLUSION_LIST("INVALID_INCLUSION_LIST"),
        START_DATE_NOT_SPECIFIED("START_DATE_NOT_SPECIFIED"),
        MISSING_DURATION("MISSING_DURATION"),
        WRONG_DURATION("WRONG_DURATION"),
        ENDS_IN_PAST("ENDS_IN_PAST"),
        END_DATE_BEFORE_START_DATE("END_DATE_BEFORE_START_DATE"),
        TOO_FAR_IN_FUTURE("TOO_FAR_IN_FUTURE"),
        INVALID_START_DATE("INVALID_START_DATE"),
        INVALID_NUMBER_OF_INTERVALS_FOR_RECURRING_SCANS("INVALID_NUMBER_OF_INTERVALS_FOR_RECURRING_SCANS"),
        INVALID_NUMBER_OF_EVENTS_FOR_RECURRING_SCANS("INVALID_NUMBER_OF_EVENTS_FOR_RECURRING_SCANS"),
        RECURRING_SCAN_STARTS_DURING_INITIAL_SCAN("RECURRING_SCAN_STARTS_DURING_INITIAL_SCAN"),
        INVALID_DURATION_FOR_SCAN_RECURRENCE("INVALID_DURATION_FOR_SCAN_RECURRENCE"),
        INVALID_SCHEDULE_END_FOR_RECURRING_SCHEDULE("INVALID_SCHEDULE_END_FOR_RECURRING_SCHEDULE"),
        INVALID_CONFIGURATION_FOR_WEEKLY_RECURRING_SCHEDULE("INVALID_CONFIGURATION_FOR_WEEKLY_RECURRING_SCHEDULE"),
        INVALID_RECURRENCE_TYPE("INVALID_RECURRENCE_TYPE"),
        INVALID_BLACKOUT_TYPE("INVALID_BLACKOUT_TYPE"),
        BLACKOUT_DAYS_NOT_SPECIFIED("BLACKOUT_DAYS_NOT_SPECIFIED"),
        INVALID_START_TIME_FOR_BLACKOUT_SCHEDULE("INVALID_START_TIME_FOR_BLACKOUT_SCHEDULE"),
        INVALID_END_TIME_FOR_BLACKOUT_SCHEDULE("INVALID_END_TIME_FOR_BLACKOUT_SCHEDULE"),
        TOO_SHORT_BLACKOUT_THESE_HOURS_DURATION("TOO_SHORT_BLACKOUT_THESE_HOURS_DURATION"),
        TOO_LONG_BLACKOUT_THESE_HOURS_DURATION("TOO_LONG_BLACKOUT_THESE_HOURS_DURATION"),
        INVALID_BLACKOUT_DAYS_FOR_THESE_DAYS_SCHEDULE("INVALID_BLACKOUT_DAYS_FOR_THESE_DAYS_SCHEDULE"),
        SCAN_CANNOT_START_INSIDE_BLACKOUT_PERIOD("SCAN_CANNOT_START_INSIDE_BLACKOUT_PERIOD"),
        ONE_OF_THE_RECURRING_SCANS_IS_INSIDE_BLACKOUT_PERIOD("ONE_OF_THE_RECURRING_SCANS_IS_INSIDE_BLACKOUT_PERIOD"),
        TOO_SHORT_SCAN_DURATION_FOR_AUTO_PAUSE_RESUME("TOO_SHORT_SCAN_DURATION_FOR_AUTO_PAUSE_RESUME"),
        NOT_ENOUGH_DURATION_TO_CREATE_OCCURRENCE("NOT_ENOUGH_DURATION_TO_CREATE_OCCURRENCE"),
        ANALYSIS_OCCURRENCE_IS_ACTIVE_FOR_ANALYSIS("ANALYSIS_OCCURRENCE_IS_ACTIVE_FOR_ANALYSIS"),
        ANOTHER_VERIFICATION_OCCURRENCE_IS_ACTIVE_FOR_ANALYSIS("ANOTHER_VERIFICATION_OCCURRENCE_IS_ACTIVE_FOR_ANALYSIS"),
        INVALID_MAX_LINKS("INVALID_MAX_LINKS"),
        INVALID_RESPONSE_TIMEOUT("INVALID_RESPONSE_TIMEOUT"),
        INVALID_EXCLUSION_LIST("INVALID_EXCLUSION_LIST"),
        INVALIDATED_SAVED_SCANS("INVALIDATED_SAVED_SCANS"),
        MISSING_TARGET_URL("MISSING_TARGET_URL"),
        MALFORMED_URL("MALFORMED_URL"),
        IPV6_NOT_SUPPORTED("IPV6_NOT_SUPPORTED"),
        INAPPROPRIATE_PROTOCOL("INAPPROPRIATE_PROTOCOL"),
        USERINFO_DETECTED_IN_URL("USERINFO_DETECTED_IN_URL"),
        OUT_OF_SCOPE_TARGET_URL("OUT_OF_SCOPE_TARGET_URL"),
        EXCLUDED_TARGET_URL("EXCLUDED_TARGET_URL"),
        LOCALHOST_URL("LOCALHOST_URL"),
        PRIVATE_IP_URL("PRIVATE_IP_URL"),
        TOO_SHORT_SCAN_WINDOW("TOO_SHORT_SCAN_WINDOW"),
        TOO_SHORT_VERIFICATION_WINDOW("TOO_SHORT_VERIFICATION_WINDOW"),
        INVALID_SCAN_STATUS("INVALID_SCAN_STATUS"),
        INVALID_ANALYSIS_STATUS("INVALID_ANALYSIS_STATUS"),
        OCCURRENCE_NOT_READY("OCCURRENCE_NOT_READY"),
        LICENSE_NOT_FOUND_FOR_ORGID("LICENSE_NOT_FOUND_FOR_ORGID"),
        ACCESS_DENIED_FOR_ORG("ACCESS_DENIED_FOR_ORG"),
        UNEXPECTED_RESPONSE_ON_RETRIEVE_LICENSE("UNEXPECTED_RESPONSE_ON_RETRIEVE_LICENSE"),
        EXCLUDED_INCLUSION_URL("EXCLUDED_INCLUSION_URL"),
        INVALID_AUTH_IDENTIFIER("INVALID_AUTH_IDENTIFIER"),
        MISSING_USERNAME("MISSING_USERNAME"),
        INVALID_USERNAME_LENGTH("INVALID_USERNAME_LENGTH"),
        MISSING_PASSWORD("MISSING_PASSWORD"),
        INVALID_PASSWORD_LENGTH("INVALID_PASSWORD_LENGTH"),
        INVALID_DOMAIN_LENGTH("INVALID_DOMAIN_LENGTH"),
        MISSING_SELENIUM_SCRIPT("MISSING_SELENIUM_SCRIPT"),
        INVALID_SELENIUM_SCRIPT_LENGTH("INVALID_SELENIUM_SCRIPT_LENGTH"),
        INVALID_SELENIUM_SCRIPT_CONTENT("INVALID_SELENIUM_SCRIPT_CONTENT"),
        UNSUPPORTED_SCRIPT_TYPE("UNSUPPORTED_SCRIPT_TYPE"),
        MORE_THAN_ONE_SCRIPT("MORE_THAN_ONE_SCRIPT"),
        UNSUPPORTED_SCRIPT_FEATURES("UNSUPPORTED_SCRIPT_FEATURES"),
        NO_SCRIPT("NO_SCRIPT"),
        MISSING_SCRIPT_FEATURES("MISSING_SCRIPT_FEATURES"),
        MISSING_SELENIUM_VERIFICATION_URL_OR_PATTERN("MISSING_SELENIUM_VERIFICATION_URL_OR_PATTERN"),
        INVALID_VERIFICATION_URL("INVALID_VERIFICATION_URL"),
        MISSING_VERIFICATION_AND_LOGOUTDETECTION("MISSING_VERIFICATION_AND_LOGOUTDETECTION"),
        INVALID_LOGOUT_DETECTION_PATTERN_LENGTH("INVALID_LOGOUT_DETECTION_PATTERN_LENGTH"),
        INVALID_VERIFICATION_URL_LENGTH("INVALID_VERIFICATION_URL_LENGTH"),
        INVALID_VERIFICATION_PATTERN_LENGTH("INVALID_VERIFICATION_PATTERN_LENGTH"),
        ANALYSIS_OCCURRENCE_REQUEST_ERROR("ANALYSIS_OCCURRENCE_REQUEST_ERROR"),
        SERVICE_ACCESS_ERROR("SERVICE_ACCESS_ERROR"),
        EMPTY_FILE_CONTENT("EMPTY_FILE_CONTENT"),
        RESOURCE_DELETED("RESOURCE_DELETED"),
        INVALID_ID("INVALID_ID"),
        INTERNAL_ERROR("INTERNAL_ERROR");

        private String value;

        private CodeEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static CodeEnum fromValue(String text) {
            for (CodeEnum b : CodeEnum.values()) {
                if (!String.valueOf(b.value).equals(text)) continue;
                return b;
            }
            return null;
        }

        public static class Adapter
        extends TypeAdapter<CodeEnum> {
            @Override
            public void write(JsonWriter jsonWriter, CodeEnum enumeration) throws IOException {
                jsonWriter.value(enumeration.getValue());
            }

            @Override
            public CodeEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return CodeEnum.fromValue(String.valueOf(value));
            }
        }
    }
}

