/*
 * Decompiled with CFR 0.152.
 */
package com.veracode.apiwrapper.services.impl;

import com.veracode.apiwrapper.adapters.AdapterManager;
import com.veracode.apiwrapper.adapters.ApplicationAdapter;
import com.veracode.apiwrapper.application.model.api.Application;
import com.veracode.apiwrapper.application.model.api.PagedResourceOfApplication;
import com.veracode.apiwrapper.application.model.client.ApplicationInfo;
import com.veracode.apiwrapper.exceptions.ApiException;
import com.veracode.apiwrapper.exceptions.InvalidMediaTypeException;
import com.veracode.apiwrapper.exceptions.InvocationException;
import com.veracode.apiwrapper.services.ApplicationApiService;
import com.veracode.apiwrapper.transformer.APIToClientModelTransformer;
import com.veracode.apiwrapper.utils.UserAgent;
import com.veracode.http.Credentials;
import com.veracode.util.lang.StringUtility;
import java.net.Proxy;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class ApplicationApiServiceImpl
implements ApplicationApiService {
    private final ApplicationAdapter applicationAdapter;

    public ApplicationApiServiceImpl(Credentials creds) {
        this(creds, Proxy.NO_PROXY);
    }

    public ApplicationApiServiceImpl(Credentials creds, Proxy proxy) {
        if (null == creds) {
            throw new IllegalArgumentException("Cannot initialize without credentials.");
        }
        this.applicationAdapter = AdapterManager.createApplicationAdapter(creds, proxy);
    }

    public ApplicationApiServiceImpl(Credentials creds, Proxy proxy, UserAgent userAgent) {
        if (null == creds) {
            throw new IllegalArgumentException("Cannot initialize without credentials.");
        }
        this.applicationAdapter = AdapterManager.createApplicationAdapter(creds, proxy, userAgent);
    }

    @Override
    public List<Application> getApplications(String modifiedAfter, String policyComplianceCheckedAfter, String appId) throws ApiException, InvocationException {
        HashMap<String, String> query = new HashMap<String, String>();
        query.put("modified_after", modifiedAfter);
        query.put("policy_compliance_checked_after", policyComplianceCheckedAfter);
        query.put("legacy_id", appId);
        ArrayList<PagedResourceOfApplication> pagedResourceOfApplications = new ArrayList<PagedResourceOfApplication>();
        int pageCount = 1;
        int pageNumber = 0;
        try {
            do {
                query.put("page", String.valueOf(pageNumber));
                PagedResourceOfApplication pagedResourceOfApplicationObj = this.applicationAdapter.getApplications(query);
                if (pagedResourceOfApplicationObj == null) continue;
                pagedResourceOfApplications.add(pagedResourceOfApplicationObj);
                pageCount = pagedResourceOfApplicationObj.getPage().getTotalPages().intValue();
                ++pageNumber;
            } while (pageNumber < pageCount);
        }
        catch (InvalidMediaTypeException ae) {
            throw new InvalidMediaTypeException(ae.getResponseCode(), ae.getContent().toString(), ae.getCause());
        }
        catch (ApiException ae) {
            Object contentObject = ae.getContent();
            if (null != contentObject) {
                if (contentObject instanceof String) {
                    throw new ApiException(ae.getResponseCode(), contentObject.toString(), ae.getCause());
                }
                throw new ApiException(ae.getResponseCode(), (Throwable)ae);
            }
            throw new ApiException(ae.getResponseCode(), null, ae.getCause());
        }
        return this.getApplicationObjList(pagedResourceOfApplications);
    }

    @Override
    public Set<ApplicationInfo> getApplicationsModifiedAfter(String modifiedAfter) throws ApiException, InvocationException {
        if (StringUtility.isNullOrEmpty(modifiedAfter)) {
            return null;
        }
        return this.transformToApplicationInfo(this.getApplications(modifiedAfter, null, null));
    }

    @Override
    public Set<ApplicationInfo> getApplicationsPolicyComplianceCheckedAfter(String policyComplianceCheckedAfter) throws ApiException, InvocationException {
        if (StringUtility.isNullOrEmpty(policyComplianceCheckedAfter)) {
            return null;
        }
        return this.transformToApplicationInfo(this.getApplications(null, policyComplianceCheckedAfter, null));
    }

    private Set<ApplicationInfo> transformToApplicationInfo(List<Application> applicationList) {
        HashSet<ApplicationInfo> result = new HashSet<ApplicationInfo>();
        for (Application application : applicationList) {
            result.add(APIToClientModelTransformer.transform(application));
        }
        return result;
    }

    private List<Application> getApplicationObjList(List<PagedResourceOfApplication> pagedResourceOfApplicationList) {
        ArrayList<Application> applicationObjList = new ArrayList<Application>();
        for (PagedResourceOfApplication pagedApplication : pagedResourceOfApplicationList) {
            if (pagedApplication == null || pagedApplication.getEmbedded() == null) continue;
            applicationObjList.addAll(pagedApplication.getEmbedded().getApplications());
        }
        return applicationObjList;
    }
}

