/*
 * Decompiled with CFR 0.152.
 */
package com.veracode.apiwrapper.services.impl;

import com.veracode.apiwrapper.adapters.AdapterManager;
import com.veracode.apiwrapper.adapters.IdentityAdapter;
import com.veracode.apiwrapper.exceptions.ApiException;
import com.veracode.apiwrapper.exceptions.InvocationException;
import com.veracode.apiwrapper.identity.model.api.CredentialValidityDetails;
import com.veracode.apiwrapper.services.IdentityAPIService;
import com.veracode.apiwrapper.utils.UserAgent;
import com.veracode.http.Credentials;
import java.net.Proxy;

public class IdentityAPIServiceImpl
implements IdentityAPIService {
    private final IdentityAdapter identityAdapter;

    public IdentityAPIServiceImpl(Credentials creds) {
        this(creds, Proxy.NO_PROXY);
    }

    public IdentityAPIServiceImpl(Credentials creds, Proxy proxy) {
        if (null == creds) {
            throw new IllegalArgumentException("Cannot initialize without credentials.");
        }
        this.identityAdapter = AdapterManager.createIdentityAdapter(creds, proxy);
    }

    public IdentityAPIServiceImpl(Credentials creds, Proxy proxy, UserAgent userAgent) {
        if (null == creds) {
            throw new IllegalArgumentException("Cannot initialize without credentials.");
        }
        this.identityAdapter = AdapterManager.createIdentityAdapter(creds, proxy, userAgent);
    }

    @Override
    public Boolean isFeatureEnabled(String feature) throws ApiException, InvocationException {
        return this.identityAdapter.getPrincipal().getFeatures().contains(feature);
    }

    @Override
    public CredentialValidityDetails getApiCredentialDetails() throws ApiException, InvocationException {
        CredentialValidityDetails validityDetails = new CredentialValidityDetails(this.identityAdapter.getApiCredentials().getExpirationTimestamp());
        validityDetails.checkValidity();
        return validityDetails;
    }
}

