/*
 * Decompiled with CFR 0.152.
 */
package com.veracode.apiwrapper.transformer;

import com.google.gson.reflect.TypeToken;
import com.veracode.apiwrapper.dynamicanalysis.model.api.AnalysisRequest;
import com.veracode.apiwrapper.model.util.JSON;
import java.lang.reflect.Type;

public class ClientToAPIModelTransformer {
    private static final String SCHEUDLE_NOW_WITH_DURATION_TEMPLATE = "{\"schedule\": {\"now\" : true,\"start_date\" : \"\",\"duration\" : {\"length\" : %d,\"unit\" : \"HOUR\"},\"schedule_status\": \"ACTIVE\"}}";

    public static final AnalysisRequest transform(int duration) {
        if (duration <= 0) {
            throw new IllegalArgumentException("Invalid scan duration.");
        }
        Type returnType = new TypeToken<AnalysisRequest>(){}.getType();
        return (AnalysisRequest)new JSON().deserialize(ClientToAPIModelTransformer.createAnalysisRequestJSON(duration), returnType);
    }

    private static final String createAnalysisRequestJSON(int duration) {
        return String.format(SCHEUDLE_NOW_WITH_DURATION_TEMPLATE, duration);
    }
}

