/*
 * Decompiled with CFR 0.152.
 */
package com.veracode.apiwrapper.utils;

import com.veracode.parser.util.StringUtility;
import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;

public class UserAgent {
    private static final String DEFAULT_VALUE = "Unknown";
    private static final String DEFAULT_TITLE = "VeracodeJavaAPI";
    private static final String JRE_VERSION = UserAgent.getJreVersion();
    private static final String DEFAULT_AGENT_HEADER_FORMAT = "%s/%s (Java/%s)";
    private static final String INTG_AGENT_HEADER_FORMAT = "%s/%s (%s/%s; Java/%s)";
    private static final String AGENT_HEADER_VALUE_REGEX_PATTERN = "^\\w[a-zA-Z0-9\\(\\)\\.\\/;\\\\-_ ]+$";
    private static final String JRE_VERSION_REGEX_PATTERN = "^[1-9][0-9]?(\\.[0-9]\\.[0-9](_\\d{1,4}(-\\S{0,20})?)?)?";
    private String intgName = "Unknown";
    private String intgVersion = "Unknown";
    private String frameworkName = "Unknown";
    private String frameworkVersion = "Unknown";
    private String headerValue = "";

    public UserAgent() {
        this.initWrapperUserAgent();
    }

    public UserAgent(String intgName, String intgVersion, String frameworkName, String frameworkVersion) {
        if (StringUtility.isNullOrEmpty(intgName) || StringUtility.isNullOrEmpty(intgVersion) || StringUtility.isNullOrEmpty(frameworkName)) {
            throw new IllegalArgumentException("Missing information for a valid user-agent header.");
        }
        this.intgName = intgName;
        this.intgVersion = intgVersion;
        this.frameworkName = frameworkName;
        if (!StringUtility.isNullOrEmpty(frameworkVersion)) {
            this.frameworkVersion = frameworkVersion;
        }
        this.headerValue = String.format(INTG_AGENT_HEADER_FORMAT, intgName, intgVersion, frameworkName, frameworkVersion, JRE_VERSION);
        if (!this.headerValue.matches(AGENT_HEADER_VALUE_REGEX_PATTERN)) {
            throw new IllegalArgumentException("The user-agent header value does not meet the expected format.");
        }
    }

    public String getIntegrationName() {
        return this.intgName;
    }

    public String getIntegrationVersion() {
        return this.intgVersion;
    }

    public String getFrameworkName() {
        return this.frameworkName;
    }

    public String getFrameworkVersion() {
        return this.frameworkVersion;
    }

    public String getHeaderValue() {
        return this.headerValue;
    }

    private static String getJreVersion() {
        String jreVersion;
        try {
            String sysJreVersion = System.getProperty("java.version");
            jreVersion = !StringUtility.isNullOrEmpty(sysJreVersion) && sysJreVersion.matches(JRE_VERSION_REGEX_PATTERN) ? sysJreVersion : DEFAULT_VALUE;
        }
        catch (Throwable e) {
            jreVersion = DEFAULT_VALUE;
        }
        return jreVersion;
    }

    private void initWrapperUserAgent() {
        String result = "";
        try {
            ClassLoader loader = UserAgent.class.getClassLoader();
            try (InputStream is = loader.getResourceAsStream("version.properties");){
                if (null == is) {
                    this.intgName = DEFAULT_TITLE;
                    this.intgVersion = DEFAULT_VALUE;
                    result = String.format(DEFAULT_AGENT_HEADER_FORMAT, this.intgName, this.intgVersion, JRE_VERSION);
                } else {
                    Properties properties = new Properties();
                    properties.load(is);
                    this.intgName = properties.getProperty("title");
                    this.intgName = !StringUtility.isNullOrEmpty(this.intgName) ? this.intgName : DEFAULT_TITLE;
                    this.intgVersion = properties.getProperty("version");
                    this.intgVersion = !StringUtility.isNullOrEmpty(this.intgVersion) ? this.intgVersion : DEFAULT_VALUE;
                    result = String.format(DEFAULT_AGENT_HEADER_FORMAT, this.intgName, this.intgVersion, JRE_VERSION);
                    if (!result.matches(AGENT_HEADER_VALUE_REGEX_PATTERN)) {
                        result = String.format(DEFAULT_AGENT_HEADER_FORMAT, DEFAULT_TITLE, DEFAULT_VALUE, JRE_VERSION);
                    }
                }
            }
            catch (IOException e) {
                result = String.format(DEFAULT_AGENT_HEADER_FORMAT, DEFAULT_TITLE, DEFAULT_VALUE, JRE_VERSION);
            }
        }
        catch (SecurityException se) {
            result = String.format(DEFAULT_AGENT_HEADER_FORMAT, DEFAULT_TITLE, DEFAULT_VALUE, JRE_VERSION);
        }
        this.headerValue = result;
    }
}

