/*
 * Decompiled with CFR 0.152.
 */
package com.veracode.apiwrapper.wrappers;

import com.veracode.apiwrapper.AbstractAPIWrapper;
import com.veracode.apiwrapper.wrappers.AdminAPIWrapper;
import com.veracode.apiwrapper.wrappers.SandboxAPIWrapper;
import com.veracode.http.Credentials;
import com.veracode.http.util.HttpUtility;
import java.io.IOException;
import java.net.Proxy;
import java.util.HashMap;

public final class UploadAPIWrapper
extends AbstractAPIWrapper {
    public static final String BEGIN_PRE_SCAN_URI = "api/5.0/beginprescan.do";
    public static final String BEGIN_SCAN_URI = "api/5.0/beginscan.do";
    public static final String CREATE_APP_URI = "api/5.0/createapp.do";
    public static final String CREATE_BUILD_URI = "api/5.0/createbuild.do";
    public static final String CREATE_SANDBOX_URI = "api/5.0/createsandbox.do";
    public static final String DELETE_APP_URI = "api/5.0/deleteapp.do";
    public static final String DELETE_BUILD_URI = "api/5.0/deletebuild.do";
    public static final String GET_APP_INFO_URI = "api/5.0/getappinfo.do";
    public static final String GET_APP_LIST_URI = "api/5.0/getapplist.do";
    public static final String GET_BUILD_INFO_URI = "api/5.0/getbuildinfo.do";
    public static final String GET_BUILD_LIST_URI = "api/5.0/getbuildlist.do";
    public static final String GET_FILE_LIST_URI = "api/5.0/getfilelist.do";
    public static final String GET_POLICY_LIST_URI = "api/5.0/getpolicylist.do";
    public static final String GET_PRE_SCAN_RESULTS_URI = "api/5.0/getprescanresults.do";
    public static final String GET_SANDBOX_LIST_URI = "api/5.0/getsandboxlist.do";
    public static final String GET_VENDOR_LIST_URI = "api/5.0/getvendorlist.do";
    public static final String REMOVE_FILE_URI = "api/5.0/removefile.do";
    public static final String UPDATE_APP_URI = "api/5.0/updateapp.do";
    public static final String UPDATE_BUILD_URI = "api/5.0/updatebuild.do";
    public static final String UPLOAD_FILE_URI = "api/5.0/uploadfile.do";
    public static final String GET_TEAM_LIST_URI = "api/3.0/getteamlist.do";
    public static final String DYNAMIC_RESCAN_URI = "api/5.0/rescandynamicscan.do";
    public static final String SUBMIT_DYNAMIC_RESCAN_URI = "api/5.0/submitdynamicscan.do";
    private SandboxAPIWrapper sandboxAPIWrapper;
    private AdminAPIWrapper adminAPIWrapper;

    @Override
    public void setUpApiCredentials(String apiID, String apiKey) {
        super.setUpApiCredentials(Credentials.create(apiID, apiKey));
        this.sandboxAPIWrapper = new SandboxAPIWrapper();
        this.sandboxAPIWrapper.setUpApiCredentials(Credentials.create(apiID, apiKey));
        this.adminAPIWrapper = new AdminAPIWrapper();
        this.adminAPIWrapper.setUpApiCredentials(Credentials.create(apiID, apiKey));
    }

    @Override
    public void setUpProxy(Proxy proxy) {
        super.setUpProxy(proxy);
        if (this.sandboxAPIWrapper != null) {
            this.sandboxAPIWrapper.setUpProxy(proxy);
        }
        if (this.adminAPIWrapper != null) {
            this.adminAPIWrapper.setUpProxy(proxy);
        }
    }

    @Override
    public void setUpProxy(String host, String port) {
        super.setUpProxy(host, port);
        if (this.sandboxAPIWrapper != null) {
            this.sandboxAPIWrapper.setUpProxy(host, port);
        }
        if (this.adminAPIWrapper != null) {
            this.adminAPIWrapper.setUpProxy(host, port);
        }
    }

    @Override
    public void setUpProxy(String host, String port, String username, String password) {
        super.setUpProxy(host, port, username, password);
        if (this.sandboxAPIWrapper != null) {
            this.sandboxAPIWrapper.setUpProxy(host, port, username, password);
        }
        if (this.adminAPIWrapper != null) {
            this.adminAPIWrapper.setUpProxy(host, port, username, password);
        }
    }

    public String beginPreScan(String app_id) throws IOException {
        return this.beginPreScan(app_id, null, null);
    }

    public String beginPreScan(String app_id, String sandbox_id) throws IOException {
        return this.beginPreScan(app_id, sandbox_id, null);
    }

    public String beginPreScan(String app_id, String sandbox_id, String auto_scan) throws IOException {
        return this.beginPreScan(app_id, sandbox_id, auto_scan, null);
    }

    public String beginPreScan(String app_id, String sandbox_id, String auto_scan, String scan_all_nonfatal_top_level_modules) throws IOException {
        HashMap<String, Object> queryString = new HashMap<String, Object>();
        if (app_id != null) {
            queryString.put("app_id", HttpUtility.urlEncode(app_id));
        }
        if (sandbox_id != null) {
            queryString.put("sandbox_id", HttpUtility.urlEncode(sandbox_id));
        }
        if (auto_scan != null) {
            queryString.put("auto_scan", HttpUtility.urlEncode(auto_scan));
        }
        if (scan_all_nonfatal_top_level_modules != null) {
            queryString.put("scan_all_nonfatal_top_level_modules", HttpUtility.urlEncode(scan_all_nonfatal_top_level_modules));
        }
        this.webClient.queryString = queryString;
        return this.webClient.downloadString(BEGIN_PRE_SCAN_URI);
    }

    public String beginScan(String app_id, String modules, String scan_all_top_level_modules) throws IOException {
        return this.beginScan(app_id, modules, scan_all_top_level_modules, null);
    }

    public String beginScan(String app_id, String modules, String scan_all_top_level_modules, String scan_selected_modules) throws IOException {
        return this.beginScan(app_id, modules, scan_all_top_level_modules, scan_selected_modules, null);
    }

    public String beginScan(String app_id, String modules, String scan_all_top_level_modules, String scan_selected_modules, String scan_previously_selected_modules) throws IOException {
        return this.beginScan(app_id, modules, scan_all_top_level_modules, scan_selected_modules, scan_previously_selected_modules, null);
    }

    public String beginScan(String app_id, String modules, String scan_all_top_level_modules, String scan_selected_modules, String scan_previously_selected_modules, String sandbox_id) throws IOException {
        HashMap<String, Object> queryString = new HashMap<String, Object>();
        if (app_id != null) {
            queryString.put("app_id", HttpUtility.urlEncode(app_id));
        }
        if (modules != null) {
            queryString.put("modules", HttpUtility.urlEncode(modules));
        }
        if (scan_all_top_level_modules != null) {
            queryString.put("scan_all_top_level_modules", HttpUtility.urlEncode(scan_all_top_level_modules));
        }
        if (scan_selected_modules != null) {
            queryString.put("scan_selected_modules", HttpUtility.urlEncode(scan_selected_modules));
        }
        if (scan_previously_selected_modules != null) {
            queryString.put("scan_previously_selected_modules", HttpUtility.urlEncode(scan_previously_selected_modules));
        }
        if (sandbox_id != null) {
            queryString.put("sandbox_id", HttpUtility.urlEncode(sandbox_id));
        }
        this.webClient.queryString = queryString;
        return this.webClient.downloadString(BEGIN_SCAN_URI);
    }

    public String createApp(String app_name, String business_criticality) throws IOException {
        return this.createApp(app_name, null, null, business_criticality, null, null, null, null, null, null, null, null, null, null, null, null, null);
    }

    public String createApp(String app_name, String description, String vendor_id, String business_criticality, String policy, String business_unit, String business_owner, String business_owner_email, String teams, String origin, String industry, String app_type, String deployment_type, String web_application, String archer_app_name, String tags) throws IOException {
        return this.createApp(app_name, description, vendor_id, business_criticality, policy, business_unit, business_owner, business_owner_email, teams, origin, industry, app_type, deployment_type, web_application, archer_app_name, tags, null);
    }

    public String createApp(String app_name, String description, String vendor_id, String business_criticality, String policy, String business_unit, String business_owner, String business_owner_email, String teams, String origin, String industry, String app_type, String deployment_type, String web_application, String archer_app_name, String tags, String next_day_scheduling_enabled) throws IOException {
        HashMap<String, Object> queryString = new HashMap<String, Object>();
        if (app_name != null) {
            queryString.put("app_name", HttpUtility.urlEncode(app_name));
        }
        if (description != null) {
            queryString.put("description", HttpUtility.urlEncode(description));
        }
        if (vendor_id != null) {
            queryString.put("vendor_id", HttpUtility.urlEncode(vendor_id));
        }
        if (business_criticality != null) {
            queryString.put("business_criticality", HttpUtility.urlEncode(business_criticality));
        }
        if (policy != null) {
            queryString.put("policy", HttpUtility.urlEncode(policy));
        }
        if (business_unit != null) {
            queryString.put("business_unit", HttpUtility.urlEncode(business_unit));
        }
        if (business_owner != null) {
            queryString.put("business_owner", HttpUtility.urlEncode(business_owner));
        }
        if (business_owner_email != null) {
            queryString.put("business_owner_email", HttpUtility.urlEncode(business_owner_email));
        }
        if (teams != null) {
            queryString.put("teams", HttpUtility.urlEncode(teams));
        }
        if (origin != null) {
            queryString.put("origin", HttpUtility.urlEncode(origin));
        }
        if (industry != null) {
            queryString.put("industry", HttpUtility.urlEncode(industry));
        }
        if (app_type != null) {
            queryString.put("app_type", HttpUtility.urlEncode(app_type));
        }
        if (deployment_type != null) {
            queryString.put("deployment_method", HttpUtility.urlEncode(deployment_type));
        }
        if (web_application != null) {
            queryString.put("web_application", HttpUtility.urlEncode(web_application));
        }
        if (archer_app_name != null) {
            queryString.put("archer_app_name", HttpUtility.urlEncode(archer_app_name));
        }
        if (tags != null) {
            queryString.put("tags", HttpUtility.urlEncode(tags));
        }
        if (next_day_scheduling_enabled != null) {
            queryString.put("next_day_scheduling_enabled", HttpUtility.urlEncode(next_day_scheduling_enabled));
        }
        this.webClient.queryString = queryString;
        return this.webClient.downloadString(CREATE_APP_URI);
    }

    public String createBuild(String app_id, String version) throws IOException {
        return this.createBuild(app_id, version, null, null, null, null, null, null);
    }

    public String createBuild(String app_id, String version, String platform, String platform_id, String lifecycle_stage, String lifecycle_stage_id, String launch_date) throws IOException {
        return this.createBuild(app_id, version, platform, platform_id, lifecycle_stage, lifecycle_stage_id, launch_date, null);
    }

    public String createBuild(String app_id, String version, String platform, String platform_id, String lifecycle_stage, String lifecycle_stage_id, String launch_date, String sandbox_id) throws IOException {
        return this.createBuild(app_id, version, platform, platform_id, lifecycle_stage, lifecycle_stage_id, launch_date, sandbox_id, null);
    }

    public String createBuild(String app_id, String version, String platform, String platform_id, String lifecycle_stage, String lifecycle_stage_id, String launch_date, String sandbox_id, String legacy_scan_engine) throws IOException {
        HashMap<String, Object> queryString = new HashMap<String, Object>();
        if (app_id != null) {
            queryString.put("app_id", HttpUtility.urlEncode(app_id));
        }
        if (version != null) {
            queryString.put("version", HttpUtility.urlEncode(version));
        }
        if (platform != null) {
            queryString.put("platform", HttpUtility.urlEncode(platform));
        }
        if (platform_id != null) {
            queryString.put("platform_id", HttpUtility.urlEncode(platform_id));
        }
        if (lifecycle_stage != null) {
            queryString.put("lifecycle_stage", HttpUtility.urlEncode(lifecycle_stage));
        }
        if (lifecycle_stage_id != null) {
            queryString.put("lifecycle_stage_id", HttpUtility.urlEncode(lifecycle_stage_id));
        }
        if (launch_date != null) {
            queryString.put("launch_date", HttpUtility.urlEncode(launch_date));
        }
        if (sandbox_id != null) {
            queryString.put("sandbox_id", HttpUtility.urlEncode(sandbox_id));
        }
        if (legacy_scan_engine != null) {
            queryString.put("legacy_scan_engine", HttpUtility.urlEncode(legacy_scan_engine));
        }
        this.webClient.queryString = queryString;
        return this.webClient.downloadString(CREATE_BUILD_URI);
    }

    @Deprecated
    public String createSandbox(String app_id, String sandbox_name) throws IOException {
        return this.sandboxAPIWrapper.createSandbox(app_id, sandbox_name);
    }

    public String deleteApp(String app_id) throws IOException {
        HashMap<String, Object> queryString = new HashMap<String, Object>();
        if (app_id != null) {
            queryString.put("app_id", HttpUtility.urlEncode(app_id));
        }
        this.webClient.queryString = queryString;
        return this.webClient.downloadString(DELETE_APP_URI);
    }

    public String deleteBuild(String app_id) throws IOException {
        return this.deleteBuild(app_id, null);
    }

    public String deleteBuild(String app_id, String sandbox_id) throws IOException {
        HashMap<String, Object> queryString = new HashMap<String, Object>();
        if (app_id != null) {
            queryString.put("app_id", HttpUtility.urlEncode(app_id));
        }
        if (sandbox_id != null) {
            queryString.put("sandbox_id", HttpUtility.urlEncode(sandbox_id));
        }
        this.webClient.queryString = queryString;
        return this.webClient.downloadString(DELETE_BUILD_URI);
    }

    public String getAppInfo(String app_id) throws IOException {
        HashMap<String, Object> queryString = new HashMap<String, Object>();
        if (app_id != null) {
            queryString.put("app_id", HttpUtility.urlEncode(app_id));
        }
        this.webClient.queryString = queryString;
        return this.webClient.downloadString(GET_APP_INFO_URI);
    }

    public String getAppList() throws IOException {
        return this.getAppList(null);
    }

    public String getAppList(String include_user_info) throws IOException {
        HashMap<String, Object> queryString = new HashMap<String, Object>();
        if (include_user_info != null) {
            queryString.put("include_user_info", HttpUtility.urlEncode(include_user_info));
        }
        this.webClient.queryString = queryString;
        return this.webClient.downloadString(GET_APP_LIST_URI);
    }

    public String getBuildInfo(String app_id) throws IOException {
        return this.getBuildInfo(app_id, null, null);
    }

    public String getBuildInfo(String app_id, String build_id) throws IOException {
        return this.getBuildInfo(app_id, build_id, null);
    }

    public String getBuildInfo(String app_id, String build_id, String sandbox_id) throws IOException {
        HashMap<String, Object> queryString = new HashMap<String, Object>();
        if (app_id != null) {
            queryString.put("app_id", HttpUtility.urlEncode(app_id));
        }
        if (build_id != null) {
            queryString.put("build_id", HttpUtility.urlEncode(build_id));
        }
        if (sandbox_id != null) {
            queryString.put("sandbox_id", HttpUtility.urlEncode(sandbox_id));
        }
        this.webClient.queryString = queryString;
        return this.webClient.downloadString(GET_BUILD_INFO_URI);
    }

    public String getBuildList(String app_id) throws IOException {
        return this.getBuildList(app_id, null);
    }

    public String getBuildList(String app_id, String sandbox_id) throws IOException {
        HashMap<String, Object> queryString = new HashMap<String, Object>();
        if (app_id != null) {
            queryString.put("app_id", HttpUtility.urlEncode(app_id));
        }
        if (sandbox_id != null) {
            queryString.put("sandbox_id", HttpUtility.urlEncode(sandbox_id));
        }
        this.webClient.queryString = queryString;
        return this.webClient.downloadString(GET_BUILD_LIST_URI);
    }

    public String getFileList(String app_id) throws IOException {
        return this.getFileList(app_id, null, null);
    }

    public String getFileList(String app_id, String build_id) throws IOException {
        return this.getFileList(app_id, build_id, null);
    }

    public String getFileList(String app_id, String build_id, String sandbox_id) throws IOException {
        HashMap<String, Object> queryString = new HashMap<String, Object>();
        if (app_id != null) {
            queryString.put("app_id", HttpUtility.urlEncode(app_id));
        }
        if (build_id != null) {
            queryString.put("build_id", HttpUtility.urlEncode(build_id));
        }
        if (sandbox_id != null) {
            queryString.put("sandbox_id", HttpUtility.urlEncode(sandbox_id));
        }
        this.webClient.queryString = queryString;
        return this.webClient.downloadString(GET_FILE_LIST_URI);
    }

    public String getPolicyList() throws IOException {
        HashMap<String, Object> queryString = new HashMap<String, Object>();
        this.webClient.queryString = queryString;
        return this.webClient.downloadString(GET_POLICY_LIST_URI);
    }

    public String getPreScanResults(String app_id) throws IOException {
        return this.getPreScanResults(app_id, null, null);
    }

    public String getPreScanResults(String app_id, String build_id) throws IOException {
        return this.getPreScanResults(app_id, build_id, null);
    }

    public String getPreScanResults(String app_id, String build_id, String sandbox_id) throws IOException {
        HashMap<String, Object> queryString = new HashMap<String, Object>();
        if (app_id != null) {
            queryString.put("app_id", HttpUtility.urlEncode(app_id));
        }
        if (build_id != null) {
            queryString.put("build_id", HttpUtility.urlEncode(build_id));
        }
        if (sandbox_id != null) {
            queryString.put("sandbox_id", HttpUtility.urlEncode(sandbox_id));
        }
        this.webClient.queryString = queryString;
        return this.webClient.downloadString(GET_PRE_SCAN_RESULTS_URI);
    }

    @Deprecated
    public String getSandboxList(String app_id) throws IOException {
        return this.sandboxAPIWrapper.getSandboxList(app_id);
    }

    public String getTeamList() throws IOException {
        return this.adminAPIWrapper.getTeamList();
    }

    public String getVendorList() throws IOException {
        HashMap<String, Object> queryString = new HashMap<String, Object>();
        this.webClient.queryString = queryString;
        return this.webClient.downloadString(GET_VENDOR_LIST_URI);
    }

    public String removeFile(String app_id, String file_id) throws IOException {
        return this.removeFile(app_id, file_id, null);
    }

    public String removeFile(String app_id, String file_id, String sandbox_id) throws IOException {
        HashMap<String, Object> queryString = new HashMap<String, Object>();
        if (app_id != null) {
            queryString.put("app_id", HttpUtility.urlEncode(app_id));
        }
        if (file_id != null) {
            queryString.put("file_id", HttpUtility.urlEncode(file_id));
        }
        if (sandbox_id != null) {
            queryString.put("sandbox_id", HttpUtility.urlEncode(sandbox_id));
        }
        this.webClient.queryString = queryString;
        return this.webClient.downloadString(REMOVE_FILE_URI);
    }

    public String updateApp(String app_id, String business_criticality) throws IOException {
        return this.updateApp(app_id, null, null, business_criticality, null, null, null, null, null, null, null, null, null, null, null, null, null, null);
    }

    public String updateApp(String app_id, String app_name, String description, String business_criticality, String policy, String business_unit, String business_owner, String business_owner_email, String teams, String origin, String industry, String app_type, String deployment_type, String archer_app_name, String tags, String custom_field_name, String custom_field_value) throws IOException {
        return this.updateApp(app_id, app_name, description, business_criticality, policy, business_unit, business_owner, business_owner_email, teams, origin, industry, app_type, deployment_type, archer_app_name, tags, custom_field_name, custom_field_value, null);
    }

    public String updateApp(String app_id, String app_name, String description, String business_criticality, String policy, String business_unit, String business_owner, String business_owner_email, String teams, String origin, String industry, String app_type, String deployment_type, String archer_app_name, String tags, String custom_field_name, String custom_field_value, String next_day_scheduling_enabled) throws IOException {
        HashMap<String, Object> queryString = new HashMap<String, Object>();
        if (app_id != null) {
            queryString.put("app_id", HttpUtility.urlEncode(app_id));
        }
        if (app_name != null) {
            queryString.put("app_name", HttpUtility.urlEncode(app_name));
        }
        if (description != null) {
            queryString.put("description", HttpUtility.urlEncode(description));
        }
        if (business_criticality != null) {
            queryString.put("business_criticality", HttpUtility.urlEncode(business_criticality));
        }
        if (policy != null) {
            queryString.put("policy", HttpUtility.urlEncode(policy));
        }
        if (business_unit != null) {
            queryString.put("business_unit", HttpUtility.urlEncode(business_unit));
        }
        if (business_owner != null) {
            queryString.put("business_owner", HttpUtility.urlEncode(business_owner));
        }
        if (business_owner_email != null) {
            queryString.put("business_owner_email", HttpUtility.urlEncode(business_owner_email));
        }
        if (teams != null) {
            queryString.put("teams", HttpUtility.urlEncode(teams));
        }
        if (origin != null) {
            queryString.put("origin", HttpUtility.urlEncode(origin));
        }
        if (industry != null) {
            queryString.put("industry", HttpUtility.urlEncode(industry));
        }
        if (app_type != null) {
            queryString.put("app_type", HttpUtility.urlEncode(app_type));
        }
        if (deployment_type != null) {
            queryString.put("deployment_method", HttpUtility.urlEncode(deployment_type));
        }
        if (archer_app_name != null) {
            queryString.put("archer_app_name", HttpUtility.urlEncode(archer_app_name));
        }
        if (tags != null) {
            queryString.put("tags", HttpUtility.urlEncode(tags));
        }
        if (custom_field_name != null) {
            queryString.put("custom_field_name", HttpUtility.urlEncode(custom_field_name));
        }
        if (custom_field_value != null) {
            queryString.put("custom_field_value", HttpUtility.urlEncode(custom_field_value));
        }
        if (next_day_scheduling_enabled != null) {
            queryString.put("next_day_scheduling_enabled", HttpUtility.urlEncode(next_day_scheduling_enabled));
        }
        this.webClient.queryString = queryString;
        return this.webClient.downloadString(UPDATE_APP_URI);
    }

    public String updateBuild(String app_id) throws IOException {
        return this.updateBuild(app_id, null, null, null, null, null);
    }

    public String updateBuild(String app_id, String build_id, String version, String lifecycle_stage, String launch_date) throws IOException {
        return this.updateBuild(app_id, build_id, version, lifecycle_stage, launch_date, null);
    }

    public String updateBuild(String app_id, String build_id, String version, String lifecycle_stage, String launch_date, String sandbox_id) throws IOException {
        HashMap<String, Object> queryString = new HashMap<String, Object>();
        if (app_id != null) {
            queryString.put("app_id", HttpUtility.urlEncode(app_id));
        }
        if (build_id != null) {
            queryString.put("build_id", HttpUtility.urlEncode(build_id));
        }
        if (version != null) {
            queryString.put("version", HttpUtility.urlEncode(version));
        }
        if (lifecycle_stage != null) {
            queryString.put("lifecycle_stage", HttpUtility.urlEncode(lifecycle_stage));
        }
        if (launch_date != null) {
            queryString.put("launch_date", HttpUtility.urlEncode(launch_date));
        }
        if (sandbox_id != null) {
            queryString.put("sandbox_id", HttpUtility.urlEncode(sandbox_id));
        }
        this.webClient.queryString = queryString;
        return this.webClient.downloadString(UPDATE_BUILD_URI);
    }

    public String uploadFile(String app_id, String file) throws IOException {
        return this.uploadFile(app_id, file, null, null);
    }

    public String uploadFile(String app_id, String file, String sandbox_id) throws IOException {
        return this.uploadFile(app_id, file, sandbox_id, null);
    }

    public String uploadFile(String app_id, String file, String sandbox_id, String save_as) throws IOException {
        HashMap<String, Object> queryString = new HashMap<String, Object>();
        if (app_id != null) {
            queryString.put("app_id", HttpUtility.urlEncode(app_id));
        }
        if (sandbox_id != null) {
            queryString.put("sandbox_id", HttpUtility.urlEncode(sandbox_id));
        }
        if (save_as != null) {
            queryString.put("save_as", HttpUtility.urlEncode(save_as));
        }
        this.webClient.queryString = queryString;
        return this.webClient.uploadFile(UPLOAD_FILE_URI, file);
    }

    @Deprecated
    String uploadFileAsync(String app_id, String file) throws IOException {
        return this.uploadFileAsync(app_id, file, null, null);
    }

    @Deprecated
    String uploadFileAsync(String app_id, String file, String sandbox_id) throws IOException {
        return this.uploadFileAsync(app_id, file, sandbox_id, null);
    }

    @Deprecated
    String uploadFileAsync(String app_id, String file, String sandbox_id, String save_as) throws IOException {
        return this.uploadFile(app_id, file, sandbox_id, save_as);
    }

    public String dynamicRescan(String app_id, String flaw_only, String version) throws IOException {
        HashMap<String, Object> queryString = new HashMap<String, Object>();
        if (app_id != null) {
            queryString.put("app_id", HttpUtility.urlEncode(app_id));
        }
        if (flaw_only != null && flaw_only.equalsIgnoreCase("True")) {
            queryString.put("flaw_only", HttpUtility.urlEncode(flaw_only));
        }
        if (version != null) {
            queryString.put("scan_name", HttpUtility.urlEncode(version));
        }
        this.webClient.queryString = queryString;
        return this.webClient.downloadString(DYNAMIC_RESCAN_URI);
    }

    public String submitDynamicRescan(String app_id, String startTime, String endTime) throws IOException {
        HashMap<String, Object> queryString = new HashMap<String, Object>();
        if (app_id != null) {
            queryString.put("app_id", HttpUtility.urlEncode(app_id));
        }
        if (startTime != null) {
            queryString.put("start_time", HttpUtility.urlEncode(startTime));
        }
        if (endTime != null) {
            queryString.put("end_time", HttpUtility.urlEncode(endTime));
        }
        this.webClient.queryString = queryString;
        return this.webClient.downloadString(SUBMIT_DYNAMIC_RESCAN_URI);
    }
}

