/*
 * Decompiled with CFR 0.152.
 */
package com.veracode.http;

import java.io.IOException;
import java.net.InetAddress;
import java.net.Socket;
import java.net.UnknownHostException;
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import java.util.Arrays;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.SSLSocketFactory;

public class TLSSocketCustomFactory
extends SSLSocketFactory {
    private SSLSocketFactory customSSLSocketFactory;
    private String[] allowTLS = new String[]{"TLSv1.2", "TLSv1.3"};

    public TLSSocketCustomFactory() throws KeyManagementException, NoSuchAlgorithmException {
        SSLContext context = SSLContext.getInstance("TLSv1.2");
        context.init(null, null, null);
        this.customSSLSocketFactory = context.getSocketFactory();
    }

    @Override
    public String[] getDefaultCipherSuites() {
        return this.customSSLSocketFactory.getDefaultCipherSuites();
    }

    @Override
    public String[] getSupportedCipherSuites() {
        return this.customSSLSocketFactory.getSupportedCipherSuites();
    }

    @Override
    public Socket createSocket(Socket s, String host, int port, boolean autoClose) throws IOException {
        return this.enableTLSSocket(this.customSSLSocketFactory.createSocket(s, host, port, autoClose));
    }

    @Override
    public Socket createSocket(String host, int port) throws IOException, UnknownHostException {
        return this.enableTLSSocket(this.customSSLSocketFactory.createSocket(host, port));
    }

    @Override
    public Socket createSocket(String host, int port, InetAddress localHost, int localPort) throws IOException, UnknownHostException {
        return this.enableTLSSocket(this.customSSLSocketFactory.createSocket(host, port, localHost, localPort));
    }

    @Override
    public Socket createSocket(InetAddress host, int port) throws IOException {
        return this.enableTLSSocket(this.customSSLSocketFactory.createSocket(host, port));
    }

    @Override
    public Socket createSocket(InetAddress address, int port, InetAddress localAddress, int localPort) throws IOException {
        return this.enableTLSSocket(this.customSSLSocketFactory.createSocket(address, port, localAddress, localPort));
    }

    private Socket enableTLSSocket(Socket socket) {
        if (socket != null && socket instanceof SSLSocket) {
            SSLSocket sslSocket = (SSLSocket)socket;
            String[] supportedProtocols = sslSocket.getSupportedProtocols();
            if (Arrays.asList(supportedProtocols).containsAll(Arrays.asList(this.allowTLS))) {
                sslSocket.setEnabledProtocols(this.allowTLS);
            } else {
                String[] enabledProtocols = new String[]{"TLSv1.2"};
                sslSocket.setEnabledProtocols(enabledProtocols);
            }
        }
        return socket;
    }
}

