/*
 * Decompiled with CFR 0.152.
 */
package com.veracode.http;

import com.veracode.http.WebRequestHandler;
import com.veracode.http.WebRequestHandlerImpl;
import com.veracode.http.events.PreMakeRequestEventArgs;
import com.veracode.http.events.PreMakeRequestListener;
import com.veracode.http.events.UploadFileCompletedEventArgs;
import com.veracode.http.events.UploadFileCompletedListener;
import com.veracode.http.events.UploadProgressChangedEventArgs;
import com.veracode.http.events.UploadProgressChangedListener;
import com.veracode.http.proxy.ProxyData;
import com.veracode.parser.constants.Constants;
import com.veracode.parser.util.XmlUtils;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.io.UnsupportedEncodingException;
import java.net.SocketTimeoutException;
import java.net.URL;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.security.SecureRandom;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;

public class WebClient {
    private static byte numberOfRetriesOn401;
    private static boolean useStreamingMode;
    private static boolean verbose;
    private static final int RETRY_TIMEOUT_MS = 2000;
    private static final int DEFAULT_READ_RESPONSE_TIMEOUT_MSECS = 610000;
    private static final String RequestURLQueryStringEncoding = "ISO-8859-1";
    private static final String RequestBodyQueryStringEncoding = "UTF-8";
    private static final String ResponseBodyEncoding = "UTF-8";
    private static Class<?> webRequestHandlerType;
    private List<PreMakeRequestListener> preMakeRequestListeners;
    private List<UploadProgressChangedListener> uploadProgressChangedListeners;
    private List<UploadFileCompletedListener> uploadFileCompletedListeners;
    public Map<String, String> headers;
    public Map<String, Object> queryString;
    public ProxyData proxyData;
    public String baseAddress;
    private static String transactionId;
    private static int maxRetryCount;
    public PrintStream outputWriter = System.out;

    public final byte[] downloadData(String uriString) throws IOException {
        return this.makeRequest(uriString, null);
    }

    public final String downloadString(String uriString) throws IOException {
        return XmlUtils.getDecodedXmlResponse(new String(this.makeRequest(uriString, null), "UTF-8"), true);
    }

    public final String uploadFile(String uriString, String filePath) throws IOException {
        File binaryData = filePath != null ? new File(filePath) : null;
        return XmlUtils.getDecodedXmlResponse(new String(this.makeRequest(uriString, binaryData), "UTF-8"), true);
    }

    public final void uploadFileAsync(final String uriString, final String filePath, final Object userState) {
        Thread thread = new Thread(new Runnable(){

            @Override
            public void run() {
                String result = null;
                Throwable error = null;
                try {
                    result = WebClient.this.uploadFile(uriString, filePath);
                }
                catch (Throwable e) {
                    error = e;
                }
                WebClient.this.onUploadFileCompleted(error, userState, result);
            }
        });
        thread.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected byte[] makeRequest(String uriString, File binaryFile) throws IOException {
        Map<String, Object> urlQueryString = binaryFile != null ? WebClient.getURLQueryStringForFileUpload(this.queryString, binaryFile) : null;
        uriString = uriString != null && uriString.endsWith("uploadfile.do") ? uriString.replace("uploadfile.do", "uploadlargefile.do") : uriString;
        URL url = WebClient.buildURL(this.baseAddress, uriString, urlQueryString, RequestURLQueryStringEncoding);
        int retryCount = 1;
        byte[] response = null;
        boolean isRetryRequired = false;
        boolean isRetryEnabled = false;
        if (WebClient.getMaxRetryCount() > 0) {
            isRetryEnabled = true;
        }
        WebRequestHandler requestHandler = null;
        try {
            do {
                this.onPreMakeRequest(url.getHost(), url.getPath(), this.urlQueryStringMapToString(urlQueryString), "POST");
                requestHandler = WebClient.newWebRequestHandler(url, this.proxyData);
                requestHandler.addHeaders(this.headers);
                requestHandler.setOutputStream(this.outputWriter);
                if (isRetryRequired) {
                    requestHandler.errorWriteLine("Do retry #" + retryCount + " out of " + WebClient.getMaxRetryCount() + " attempts for URL: " + url);
                    ++retryCount;
                }
                if (binaryFile != null) {
                    if (!binaryFile.exists()) throw new IOException(String.format("File %s does not exist", binaryFile.getAbsolutePath()));
                    requestHandler.makeOctetStreamPostRequest(binaryFile, useStreamingMode, new UploadProgressChangedListener(){

                        @Override
                        public void uploadProgressChanged(UploadProgressChangedEventArgs e) {
                            WebClient.this.onUploadProgressChanged(e.getProgressPercentage(), e.getBytesSent(), e.getTotalBytesToSend(), e.getIsSignificant());
                        }
                    });
                } else {
                    requestHandler.makeFormUrlEncodedPostRequest(WebClient.getURLEncodedQueryString(this.queryString, false, "UTF-8"), "UTF-8");
                }
                int responseStatusCode = 0;
                try {
                    responseStatusCode = requestHandler.getResponseCode();
                    requestHandler.debugWriteLine("Server returned HTTP response code: " + responseStatusCode);
                    if (responseStatusCode == 429) {
                        throw new RuntimeException("Server returned HTTP response code: 429 for URL: " + url + System.lineSeparator() + Constants.ERROR_MESSAGE_FOR_429);
                    }
                    if (responseStatusCode == 204) {
                        requestHandler.errorWriteLine("Request succeeded, but did not return a response body. Please try again.");
                    }
                    if (!isRetryEnabled) continue;
                    if (responseStatusCode == 401 || responseStatusCode == 502 || responseStatusCode == 504 || responseStatusCode == 524) {
                        isRetryRequired = true;
                        continue;
                    }
                    requestHandler.debugWriteLine("Retry is not required");
                    isRetryRequired = false;
                }
                catch (SocketTimeoutException ie) {
                    requestHandler.errorWriteLine("HTTP response timeout: No response received by the server");
                    if (!isRetryEnabled) continue;
                    isRetryRequired = true;
                }
            } while (isRetryRequired && retryCount <= WebClient.getMaxRetryCount() && WebClient.waitBeforeRetry());
            response = requestHandler.getResponse();
            return response;
        }
        finally {
            if (requestHandler != null) {
                requestHandler.releaseResources();
            }
        }
    }

    private static Map<String, Object> getURLQueryStringForFileUpload(Map<String, Object> queryString, File binaryFile) {
        HashMap<String, Object> queryStringForFileUpload = queryString != null ? new HashMap<String, Object>(queryString) : new HashMap();
        Object saveAsParamValue = queryStringForFileUpload.containsKey("save_as") ? queryStringForFileUpload.get("save_as") : null;
        queryStringForFileUpload.put("filename", saveAsParamValue instanceof String ? (String)saveAsParamValue : binaryFile.getName());
        return queryStringForFileUpload;
    }

    private static URL buildURL(String baseAddress, String endPointPath, Map<String, Object> queryString, String encoding) throws IOException {
        String endPointPathWithQueryString = queryString != null ? endPointPath + WebClient.getURLEncodedQueryString(queryString, true, encoding) : endPointPath;
        return baseAddress != null && !"".equals(baseAddress) ? new URL(new URL(baseAddress), endPointPathWithQueryString) : new URL(endPointPathWithQueryString);
    }

    public static void setTransactionId(String id) {
        transactionId = id;
    }

    public static String getTransactionId() {
        return transactionId;
    }

    public static void setMaxRetryCount(int count) {
        maxRetryCount = count;
    }

    public static int getMaxRetryCount() {
        return maxRetryCount;
    }

    private static WebRequestHandler newWebRequestHandler(URL url, ProxyData proxyData) throws IOException {
        WebRequestHandler requestHandler = WebClient.newWebRequestHandler();
        requestHandler.init(url, proxyData);
        requestHandler.setConnectTimeout(0);
        requestHandler.setReadTimeout(610000);
        String myTraceId = WebClient.getTransactionId();
        String userAgentStr = "";
        userAgentStr = myTraceId != null ? requestHandler.getDefaultUserAgentHeaderValue() + " {trans-id:" + myTraceId + "}" : requestHandler.getDefaultUserAgentHeaderValue();
        requestHandler.addUserAgentHeader(userAgentStr);
        requestHandler.setVerboseMode(verbose);
        return requestHandler;
    }

    private static WebRequestHandler newWebRequestHandler() throws IOException {
        if (webRequestHandlerType == null) {
            String[] classNames;
            for (String className : classNames = new String[]{"com.veracode.eclipse.plugin.api.ACWebRequestHandler", "com.veracode.intellij.plugin.api.ACWebRequestHandler", "com.veracode.jenkins.plugin.api.ACWebRequestHandler", "com.veracode.jira.plugin.api.ACWebRequestHandler", "com.veracode.jira.plugin.server.api.ACWebRequestHandler", "com.veracode.hpalm.plugin.api.ACWebRequestHandler", "com.ca.veracode.agilecentral.api.ACWebRequestHandler", "com.ca.veracode.teamcityplugin.agent.ACWebRequestHandler"}) {
                try {
                    Class<?> type = Class.forName(className);
                    if (type == null || !WebRequestHandler.class.isAssignableFrom(type)) continue;
                    webRequestHandlerType = type;
                    return WebClient.newWebRequestHandler();
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
            webRequestHandlerType = WebRequestHandlerImpl.class;
        }
        try {
            return (WebRequestHandler)webRequestHandlerType.newInstance();
        }
        catch (Throwable e) {
            return new WebRequestHandlerImpl();
        }
    }

    private static String getURLEncodedQueryString(Map<String, Object> queryString, boolean includeURLQueryStringSeparator, String encoding) {
        String urlQueryString = "";
        if (queryString != null && queryString.size() > 0) {
            StringBuilder builder = new StringBuilder();
            for (Map.Entry<String, Object> pair : queryString.entrySet()) {
                if (pair == null) continue;
                String key = pair.getKey();
                Object value = pair.getValue();
                if (key == null || value == null) continue;
                builder.append(builder.length() == 0 ? (includeURLQueryStringSeparator ? "?" : "") : "&");
                builder.append(key + "=" + WebClient.urlEncode(value.toString(), encoding));
            }
            urlQueryString = builder.toString();
        }
        return urlQueryString;
    }

    private static String urlEncode(String urlParam, String encoding) {
        String encodedUrlParam = "";
        try {
            encodedUrlParam = URLEncoder.encode(urlParam, encoding);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return encodedUrlParam;
    }

    private static String newMultiPartBoundaryString() {
        StringBuilder builder = new StringBuilder();
        SecureRandom rand = new SecureRandom();
        for (int x = 0; x < 5; ++x) {
            builder.append(Long.toString(rand.nextLong(), 36));
        }
        return builder.toString();
    }

    private static boolean waitBeforeRetry() {
        try {
            Thread.sleep(2000L);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
        return true;
    }

    public final void addPreMakeRequestListener(PreMakeRequestListener listener) {
        if (listener != null) {
            if (this.preMakeRequestListeners == null) {
                this.preMakeRequestListeners = new ArrayList<PreMakeRequestListener>();
            }
            this.preMakeRequestListeners.add(listener);
        }
    }

    public final void removePreMakeRequestListener(PreMakeRequestListener listener) {
        if (listener != null && this.preMakeRequestListeners != null) {
            this.preMakeRequestListeners.remove(listener);
        }
    }

    protected final void onPreMakeRequest(String hostName, String uriString, String urlQueryParams, String httpMethod) {
        if (this.preMakeRequestListeners != null) {
            for (PreMakeRequestListener listener : this.preMakeRequestListeners) {
                if (listener == null) continue;
                listener.preMakeRequest(new PreMakeRequestEventArgs(hostName, uriString, urlQueryParams, httpMethod));
            }
        }
    }

    public final void addUploadProgressChangedListener(UploadProgressChangedListener listener) {
        if (listener != null) {
            if (this.uploadProgressChangedListeners == null) {
                this.uploadProgressChangedListeners = new ArrayList<UploadProgressChangedListener>();
            }
            this.uploadProgressChangedListeners.add(listener);
        }
    }

    public final void removeUploadProgressChangedListener(UploadProgressChangedListener listener) {
        if (listener != null && this.uploadProgressChangedListeners != null) {
            this.uploadProgressChangedListeners.remove(listener);
        }
    }

    protected final void onUploadProgressChanged(int progressPercentage, long bytesSent, long totalBytesToSend, boolean isSignificant) {
        if (this.uploadProgressChangedListeners != null) {
            for (UploadProgressChangedListener listener : this.uploadProgressChangedListeners) {
                if (listener == null) continue;
                listener.uploadProgressChanged(new UploadProgressChangedEventArgs(progressPercentage, bytesSent, totalBytesToSend, isSignificant));
            }
        }
    }

    public final void addUploadFileCompletedListener(UploadFileCompletedListener listener) {
        if (listener != null) {
            if (this.uploadFileCompletedListeners == null) {
                this.uploadFileCompletedListeners = new ArrayList<UploadFileCompletedListener>();
            }
            this.uploadFileCompletedListeners.add(listener);
        }
    }

    public final void removeUploadFileCompletedListener(UploadFileCompletedListener listener) {
        if (listener != null && this.uploadFileCompletedListeners != null) {
            this.uploadFileCompletedListeners.remove(listener);
        }
    }

    private void onUploadFileCompleted(Throwable error, Object userState, String result) {
        if (this.uploadFileCompletedListeners != null) {
            for (UploadFileCompletedListener listener : this.uploadFileCompletedListeners) {
                if (listener == null) continue;
                listener.uploadFileCompleted(new UploadFileCompletedEventArgs(error, userState, result));
            }
        }
    }

    private String urlQueryStringMapToString(Map<String, Object> urlQueryStringMap) throws UnsupportedEncodingException {
        if (urlQueryStringMap == null) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        sb.append('?');
        Iterator<String> iterator = urlQueryStringMap.keySet().iterator();
        while (iterator.hasNext()) {
            String key = iterator.next();
            Object value = urlQueryStringMap.get(key);
            if (value == null) continue;
            sb.append(key);
            sb.append('=');
            sb.append(URLEncoder.encode(value.toString(), StandardCharsets.UTF_8.toString()));
            if (!iterator.hasNext()) continue;
            sb.append('&');
        }
        if (sb.length() == 1) {
            return null;
        }
        return sb.toString();
    }

    public static final void setWebRequestHandlerType(Class<? extends WebRequestHandler> handlerClass) {
        webRequestHandlerType = handlerClass;
    }

    public WebClient() {
        this.headers = new HashMap<String, String>();
        this.queryString = new HashMap<String, Object>();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static {
        block11: {
            numberOfRetriesOn401 = 0;
            useStreamingMode = true;
            verbose = false;
            webRequestHandlerType = null;
            try {
                ClassLoader loader = WebClient.class.getClassLoader();
                InputStream is = loader.getResourceAsStream("VeracodeJavaAPI.jar.config");
                if (is == null) break block11;
                try {
                    Properties properties = new Properties();
                    properties.load(is);
                    try {
                        numberOfRetriesOn401 = Byte.parseByte(properties.getProperty("retries", String.valueOf(numberOfRetriesOn401)));
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                    try {
                        useStreamingMode = Boolean.parseBoolean(properties.getProperty("lfmode", String.valueOf(useStreamingMode)));
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                    try {
                        verbose = Boolean.parseBoolean(properties.getProperty("verbose", String.valueOf(verbose)));
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                }
                finally {
                    is.close();
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }
}

