/*
 * Decompiled with CFR 0.152.
 */
package com.veracode.apiwrapper.adapters.impl;

import com.google.gson.reflect.TypeToken;
import com.veracode.apiwrapper.adapters.IdentityAdapter;
import com.veracode.apiwrapper.adapters.impl.BaseAdapter;
import com.veracode.apiwrapper.exceptions.ApiException;
import com.veracode.apiwrapper.exceptions.InvocationException;
import com.veracode.apiwrapper.identity.model.api.ApiCredentials;
import com.veracode.apiwrapper.identity.model.api.UserPrincipal;
import com.veracode.apiwrapper.identityteams.model.api.PagedResourcesOfResourceOfTeamSummary;
import com.veracode.apiwrapper.identityteams.model.api.ResourceOfTeamResource;
import com.veracode.apiwrapper.identityteams.model.client.TeamPayload;
import com.veracode.apiwrapper.identityusers.model.api.PagedResourcesOfResourceOfUser;
import com.veracode.apiwrapper.identityusers.model.api.UserInfoResource;
import com.veracode.apiwrapper.identityusers.model.client.UserPayload;
import com.veracode.apiwrapper.rest.ApiEndpoint;
import com.veracode.apiwrapper.utils.UserAgent;
import com.veracode.http.Credentials;
import java.lang.reflect.Type;
import java.net.Proxy;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Map;

public class IdentityAdapterImpl
extends BaseAdapter
implements IdentityAdapter {
    public static final String AUTHN_ENDPOINT = "api/authn/v2/%s";
    public static final ApiEndpoint PRINCIPLE = new ApiEndpoint.Builder(String.format("api/authn/v2/%s", "principal")).build();
    public static final ApiEndpoint CREDENTIALS = new ApiEndpoint.Builder(String.format("api/authn/v2/%s", "api_credentials")).build();
    public static final ApiEndpoint CREATE_USER = new ApiEndpoint.Builder(String.format("api/authn/v2/%s", "users")).build();
    public static final ApiEndpoint UPDATE_USER = new ApiEndpoint.Builder(String.format("api/authn/v2/%s", "users/{userId}")).withArguments(new HashSet<String>(Arrays.asList("userId"))).allowsParameters(new HashSet<String>(Arrays.asList("partial"))).build();
    public static final ApiEndpoint GET_USER_LIST = new ApiEndpoint.Builder(String.format("api/authn/v2/%s", "users")).allowsParameters(new HashSet<String>(Arrays.asList("user_name", "org_id", "org_name", "deleted", "inactive", "page"))).build();
    public static final ApiEndpoint GET_USER_INFO = new ApiEndpoint.Builder(String.format("api/authn/v2/%s", "users/{userId}")).withArguments(new HashSet<String>(Arrays.asList("userId"))).build();
    public static final ApiEndpoint DELETE_USER = new ApiEndpoint.Builder(String.format("api/authn/v2/%s", "users/{userId}")).withArguments(new HashSet<String>(Arrays.asList("userId"))).build();
    public static final ApiEndpoint CREATE_TEAM = new ApiEndpoint.Builder(String.format("api/authn/v2/%s", "teams")).build();
    public static final ApiEndpoint UPDATE_TEAM = new ApiEndpoint.Builder(String.format("api/authn/v2/%s", "teams/{teamId}")).withArguments(new HashSet<String>(Arrays.asList("teamId"))).allowsParameters(new HashSet<String>(Arrays.asList("partial"))).build();
    public static final ApiEndpoint GET_TEAM_LIST = new ApiEndpoint.Builder(String.format("api/authn/v2/%s", "teams")).allowsParameters(new HashSet<String>(Arrays.asList("page"))).build();
    public static final ApiEndpoint GET_TEAM_INFO = new ApiEndpoint.Builder(String.format("api/authn/v2/%s", "teams/{teamId}")).withArguments(new HashSet<String>(Arrays.asList("teamId"))).build();
    public static final ApiEndpoint DELETE_TEAM = new ApiEndpoint.Builder(String.format("api/authn/v2/%s", "teams/{teamId}")).withArguments(new HashSet<String>(Arrays.asList("teamId"))).build();

    public IdentityAdapterImpl(Credentials creds, Proxy proxy) {
        super(creds, proxy);
    }

    public IdentityAdapterImpl(Credentials creds, Proxy proxy, UserAgent userAgent) {
        super(creds, proxy, userAgent);
    }

    @Override
    public UserPrincipal getPrincipal() throws ApiException, InvocationException {
        String response = this.getRequest(PRINCIPLE, null, null);
        Type returnType = new TypeToken<UserPrincipal>(){}.getType();
        return (UserPrincipal)this.getJSON().deserialize(response, returnType);
    }

    @Override
    public ApiCredentials getApiCredentials() throws ApiException, InvocationException {
        String response = this.getRequest(CREDENTIALS, null, null);
        Type returnType = new TypeToken<ApiCredentials>(){}.getType();
        return (ApiCredentials)this.getJSON().deserialize(response, returnType);
    }

    @Override
    public UserInfoResource createUserAdapter(UserPayload userPayloadObj) throws ApiException, InvocationException {
        String response = this.postRequest(CREATE_USER, null, this.getJSON().serialize(userPayloadObj), null);
        Type returnType = new TypeToken<UserInfoResource>(){}.getType();
        return (UserInfoResource)this.getJSON().deserialize(response, returnType);
    }

    @Override
    public UserInfoResource updateUserAdapter(UserPayload userPayloadObj, Map<String, String> arguments, Map<String, String> query) throws ApiException, InvocationException {
        String response = this.updateRequest(UPDATE_USER, arguments, this.getJSON().serialize(userPayloadObj), query);
        Type returnType = new TypeToken<UserInfoResource>(){}.getType();
        return (UserInfoResource)this.getJSON().deserialize(response, returnType);
    }

    @Override
    public PagedResourcesOfResourceOfUser getUserListAdapter(Map<String, String> query) throws ApiException, InvocationException {
        String response = this.getRequest(GET_USER_LIST, null, query);
        Type returnType = new TypeToken<PagedResourcesOfResourceOfUser>(){}.getType();
        return (PagedResourcesOfResourceOfUser)this.getJSON().deserialize(response, returnType);
    }

    @Override
    public UserInfoResource getUserInfoAdapter(Map<String, String> arguments) throws ApiException, InvocationException {
        String response = this.getRequest(GET_USER_INFO, arguments, null);
        Type returnType = new TypeToken<UserInfoResource>(){}.getType();
        return (UserInfoResource)this.getJSON().deserialize(response, returnType);
    }

    @Override
    public String deleteUserAdapter(Map<String, String> arguments) throws ApiException, InvocationException {
        return this.deleteRequest(DELETE_USER, arguments);
    }

    @Override
    public ResourceOfTeamResource createTeamAdapter(TeamPayload teamObj) throws ApiException, InvocationException {
        String response = this.postRequest(CREATE_TEAM, null, this.getJSON().serialize(teamObj), null);
        Type returnType = new TypeToken<ResourceOfTeamResource>(){}.getType();
        return (ResourceOfTeamResource)this.getJSON().deserialize(response, returnType);
    }

    @Override
    public ResourceOfTeamResource updateTeamAdapter(TeamPayload teamObj, Map<String, String> arguments, Map<String, String> query) throws ApiException, InvocationException {
        String response = this.updateRequest(UPDATE_TEAM, arguments, this.getJSON().serialize(teamObj), query);
        Type returnType = new TypeToken<ResourceOfTeamResource>(){}.getType();
        return (ResourceOfTeamResource)this.getJSON().deserialize(response, returnType);
    }

    @Override
    public PagedResourcesOfResourceOfTeamSummary getTeamListAdapter(Map<String, String> query) throws ApiException, InvocationException {
        String response = this.getRequest(GET_TEAM_LIST, null, query);
        Type returnType = new TypeToken<PagedResourcesOfResourceOfTeamSummary>(){}.getType();
        return (PagedResourcesOfResourceOfTeamSummary)this.getJSON().deserialize(response, returnType);
    }

    @Override
    public ResourceOfTeamResource getTeamInfoAdapter(Map<String, String> arguments) throws ApiException, InvocationException {
        String response = this.getRequest(GET_TEAM_INFO, arguments, null);
        Type returnType = new TypeToken<ResourceOfTeamResource>(){}.getType();
        return (ResourceOfTeamResource)this.getJSON().deserialize(response, returnType);
    }

    @Override
    public String deleteTeamAdapter(Map<String, String> arguments) throws ApiException, InvocationException {
        return this.deleteRequest(DELETE_TEAM, arguments);
    }
}

