/*
 * Decompiled with CFR 0.152.
 */
package com.veracode.apiwrapper.dynamicanalysis.model.api;

import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import com.veracode.apiwrapper.dynamicanalysis.model.api.AnalysisOccurrenceStatus;
import com.veracode.apiwrapper.dynamicanalysis.model.api.Link;
import com.veracode.apiwrapper.dynamicanalysis.model.api.ScanSchedule;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

@ApiModel(description="Representation of the summary of an analysis that combines part of the analysis data with the occurrence information to present an unified view. The occurrence data includes latest and next occurrences and both regular and verification-only occurrences. ")
public class AnalysisSummary {
    @SerializedName(value="org")
    private String org = null;
    @SerializedName(value="analysis_id")
    private String analysisId = null;
    @SerializedName(value="name")
    private String name = null;
    @SerializedName(value="number_of_scans")
    private Long numberOfScans = null;
    @SerializedName(value="schedule_summary")
    private ScanSchedule scheduleSummary = null;
    @SerializedName(value="latest_occurrence_id")
    private String latestOccurrenceId = null;
    @SerializedName(value="latest_occurrence_date_time")
    private String latestOccurrenceDateTime = null;
    @SerializedName(value="latest_occurrence_status")
    private AnalysisOccurrenceStatus latestOccurrenceStatus = null;
    @SerializedName(value="latest_verification_occurrence_id")
    private String latestVerificationOccurrenceId = null;
    @SerializedName(value="latest_verification_occurrence_status")
    private AnalysisOccurrenceStatus latestVerificationOccurrenceStatus = null;
    @SerializedName(value="next_occurrence_date_time")
    private String nextOccurrenceDateTime = null;
    @SerializedName(value="has_verification_failures")
    private Boolean hasVerificationFailures = null;
    @SerializedName(value="throttled")
    private Boolean throttled = null;
    @SerializedName(value="capabilities")
    private List<String> capabilities = null;
    @SerializedName(value="actions")
    private List<ActionsEnum> actions = null;
    @SerializedName(value="created_on")
    private String createdOn = null;
    @SerializedName(value="last_modified_on")
    private String lastModifiedOn = null;
    @SerializedName(value="links")
    private List<Link> links = null;

    public AnalysisSummary org(String org) {
        this.org = org;
        return this;
    }

    @ApiModelProperty(value="Organization or account identifier")
    public String getOrg() {
        return this.org;
    }

    public void setOrg(String org) {
        this.org = org;
    }

    public AnalysisSummary analysisId(String analysisId) {
        this.analysisId = analysisId;
        return this;
    }

    @ApiModelProperty(value="Unique identifier of the analysis")
    public String getAnalysisId() {
        return this.analysisId;
    }

    public void setAnalysisId(String analysisId) {
        this.analysisId = analysisId;
    }

    public AnalysisSummary name(String name) {
        this.name = name;
        return this;
    }

    @ApiModelProperty(value="Name of the analysis")
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public AnalysisSummary numberOfScans(Long numberOfScans) {
        this.numberOfScans = numberOfScans;
        return this;
    }

    @ApiModelProperty(value="Number of scans in the analysis")
    public Long getNumberOfScans() {
        return this.numberOfScans;
    }

    public void setNumberOfScans(Long numberOfScans) {
        this.numberOfScans = numberOfScans;
    }

    public AnalysisSummary scheduleSummary(ScanSchedule scheduleSummary) {
        this.scheduleSummary = scheduleSummary;
        return this;
    }

    @ApiModelProperty(value="Summary of the schedule for this Analysis")
    public ScanSchedule getScheduleSummary() {
        return this.scheduleSummary;
    }

    public void setScheduleSummary(ScanSchedule scheduleSummary) {
        this.scheduleSummary = scheduleSummary;
    }

    public AnalysisSummary latestOccurrenceId(String latestOccurrenceId) {
        this.latestOccurrenceId = latestOccurrenceId;
        return this;
    }

    @ApiModelProperty(value="Identifier of the latest occurrence, if any, of this Analysis")
    public String getLatestOccurrenceId() {
        return this.latestOccurrenceId;
    }

    public void setLatestOccurrenceId(String latestOccurrenceId) {
        this.latestOccurrenceId = latestOccurrenceId;
    }

    public AnalysisSummary latestOccurrenceDateTime(String latestOccurrenceDateTime) {
        this.latestOccurrenceDateTime = latestOccurrenceDateTime;
        return this;
    }

    @ApiModelProperty(value="Start date and time in ISO-8601 format for the latest occurrence, if any,  of this Analysis")
    public String getLatestOccurrenceDateTime() {
        return this.latestOccurrenceDateTime;
    }

    public void setLatestOccurrenceDateTime(String latestOccurrenceDateTime) {
        this.latestOccurrenceDateTime = latestOccurrenceDateTime;
    }

    public AnalysisSummary latestOccurrenceStatus(AnalysisOccurrenceStatus latestOccurrenceStatus) {
        this.latestOccurrenceStatus = latestOccurrenceStatus;
        return this;
    }

    @ApiModelProperty(value="Status of the latest occurrence, if any, of this Analysis")
    public AnalysisOccurrenceStatus getLatestOccurrenceStatus() {
        return this.latestOccurrenceStatus;
    }

    public void setLatestOccurrenceStatus(AnalysisOccurrenceStatus latestOccurrenceStatus) {
        this.latestOccurrenceStatus = latestOccurrenceStatus;
    }

    public AnalysisSummary latestVerificationOccurrenceId(String latestVerificationOccurrenceId) {
        this.latestVerificationOccurrenceId = latestVerificationOccurrenceId;
        return this;
    }

    @ApiModelProperty(value="Identifier of the latest verification-only Analysis Occurrence, if any, of this Analysis")
    public String getLatestVerificationOccurrenceId() {
        return this.latestVerificationOccurrenceId;
    }

    public void setLatestVerificationOccurrenceId(String latestVerificationOccurrenceId) {
        this.latestVerificationOccurrenceId = latestVerificationOccurrenceId;
    }

    public AnalysisSummary latestVerificationOccurrenceStatus(AnalysisOccurrenceStatus latestVerificationOccurrenceStatus) {
        this.latestVerificationOccurrenceStatus = latestVerificationOccurrenceStatus;
        return this;
    }

    @ApiModelProperty(value="Status of the latest verification-only occurrence, if any, of this Analysis")
    public AnalysisOccurrenceStatus getLatestVerificationOccurrenceStatus() {
        return this.latestVerificationOccurrenceStatus;
    }

    public void setLatestVerificationOccurrenceStatus(AnalysisOccurrenceStatus latestVerificationOccurrenceStatus) {
        this.latestVerificationOccurrenceStatus = latestVerificationOccurrenceStatus;
    }

    public AnalysisSummary nextOccurrenceDateTime(String nextOccurrenceDateTime) {
        this.nextOccurrenceDateTime = nextOccurrenceDateTime;
        return this;
    }

    @ApiModelProperty(value="Date and time in ISO-8601 format for the next occurrence of this Analysis, if any")
    public String getNextOccurrenceDateTime() {
        return this.nextOccurrenceDateTime;
    }

    public void setNextOccurrenceDateTime(String nextOccurrenceDateTime) {
        this.nextOccurrenceDateTime = nextOccurrenceDateTime;
    }

    public AnalysisSummary hasVerificationFailures(Boolean hasVerificationFailures) {
        this.hasVerificationFailures = hasVerificationFailures;
        return this;
    }

    @ApiModelProperty(value="If true, one or more scans in the Analysis has failed verification when this Analysis was verified")
    public Boolean isHasVerificationFailures() {
        return this.hasVerificationFailures;
    }

    public void setHasVerificationFailures(Boolean hasVerificationFailures) {
        this.hasVerificationFailures = hasVerificationFailures;
    }

    public AnalysisSummary throttled(Boolean throttled) {
        this.throttled = throttled;
        return this;
    }

    @ApiModelProperty(value="Flag indicating one or more scans of the latest occurrence, if any, got throttled")
    public Boolean isThrottled() {
        return this.throttled;
    }

    public void setThrottled(Boolean throttled) {
        this.throttled = throttled;
    }

    public AnalysisSummary actions(List<ActionsEnum> actions) {
        this.actions = actions;
        return this;
    }

    public AnalysisSummary addActionsItem(ActionsEnum actionsItem) {
        if (this.actions == null) {
            this.actions = new ArrayList<ActionsEnum>();
        }
        this.actions.add(actionsItem);
        return this;
    }

    @ApiModelProperty(value="List of actions that can be performed related to this Analysis based on the status of its latest occurrence")
    public List<ActionsEnum> getActions() {
        return this.actions;
    }

    public void setActions(List<ActionsEnum> actions) {
        this.actions = actions;
    }

    public AnalysisSummary createdOn(String createdOn) {
        this.createdOn = createdOn;
        return this;
    }

    @ApiModelProperty(value="UTC date time representation of the time the record was created")
    public String getCreatedOn() {
        return this.createdOn;
    }

    public void setCreatedOn(String createdOn) {
        this.createdOn = createdOn;
    }

    public AnalysisSummary lastModifiedOn(String lastModifiedOn) {
        this.lastModifiedOn = lastModifiedOn;
        return this;
    }

    @ApiModelProperty(value="UTC date time representation of the time the record was last modified")
    public String getLastModifiedOn() {
        return this.lastModifiedOn;
    }

    public void setLastModifiedOn(String lastModifiedOn) {
        this.lastModifiedOn = lastModifiedOn;
    }

    public AnalysisSummary links(List<Link> links) {
        this.links = links;
        return this;
    }

    public AnalysisSummary addLinksItem(Link linksItem) {
        if (this.links == null) {
            this.links = new ArrayList<Link>();
        }
        this.links.add(linksItem);
        return this;
    }

    @ApiModelProperty(value="")
    public List<Link> getLinks() {
        return this.links;
    }

    public void setLinks(List<Link> links) {
        this.links = links;
    }

    public AnalysisSummary capabilities(List<String> capabilities) {
        this.capabilities = capabilities;
        return this;
    }

    @ApiModelProperty(value="List of user capabilities")
    public List<String> getUserCapabilites() {
        return this.capabilities;
    }

    public void setUserCapability(List<String> capabilities) {
        this.capabilities = capabilities;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AnalysisSummary analysisSummary = (AnalysisSummary)o;
        return Objects.equals(this.org, analysisSummary.org) && Objects.equals(this.analysisId, analysisSummary.analysisId) && Objects.equals(this.name, analysisSummary.name) && Objects.equals(this.numberOfScans, analysisSummary.numberOfScans) && Objects.equals(this.scheduleSummary, analysisSummary.scheduleSummary) && Objects.equals(this.latestOccurrenceId, analysisSummary.latestOccurrenceId) && Objects.equals(this.latestOccurrenceDateTime, analysisSummary.latestOccurrenceDateTime) && Objects.equals(this.latestOccurrenceStatus, analysisSummary.latestOccurrenceStatus) && Objects.equals(this.latestVerificationOccurrenceId, analysisSummary.latestVerificationOccurrenceId) && Objects.equals(this.latestVerificationOccurrenceStatus, analysisSummary.latestVerificationOccurrenceStatus) && Objects.equals(this.nextOccurrenceDateTime, analysisSummary.nextOccurrenceDateTime) && Objects.equals(this.hasVerificationFailures, analysisSummary.hasVerificationFailures) && Objects.equals(this.throttled, analysisSummary.throttled) && Objects.equals(this.actions, analysisSummary.actions) && Objects.equals(this.createdOn, analysisSummary.createdOn) && Objects.equals(this.lastModifiedOn, analysisSummary.lastModifiedOn) && Objects.equals(this.links, analysisSummary.links) && Objects.equals(this.capabilities, analysisSummary.capabilities);
    }

    public int hashCode() {
        return Objects.hash(this.org, this.analysisId, this.name, this.numberOfScans, this.scheduleSummary, this.latestOccurrenceId, this.latestOccurrenceDateTime, this.latestOccurrenceStatus, this.latestVerificationOccurrenceId, this.latestVerificationOccurrenceStatus, this.nextOccurrenceDateTime, this.hasVerificationFailures, this.throttled, this.actions, this.createdOn, this.lastModifiedOn, this.links);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class AnalysisSummary {\n");
        sb.append("    org: ").append(this.toIndentedString(this.org)).append("\n");
        sb.append("    analysisId: ").append(this.toIndentedString(this.analysisId)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    numberOfScans: ").append(this.toIndentedString(this.numberOfScans)).append("\n");
        sb.append("    scheduleSummary: ").append(this.toIndentedString(this.scheduleSummary)).append("\n");
        sb.append("    latestOccurrenceId: ").append(this.toIndentedString(this.latestOccurrenceId)).append("\n");
        sb.append("    latestOccurrenceDateTime: ").append(this.toIndentedString(this.latestOccurrenceDateTime)).append("\n");
        sb.append("    latestOccurrenceStatus: ").append(this.toIndentedString(this.latestOccurrenceStatus)).append("\n");
        sb.append("    latestVerificationOccurrenceId: ").append(this.toIndentedString(this.latestVerificationOccurrenceId)).append("\n");
        sb.append("    latestVerificationOccurrenceStatus: ").append(this.toIndentedString(this.latestVerificationOccurrenceStatus)).append("\n");
        sb.append("    nextOccurrenceDateTime: ").append(this.toIndentedString(this.nextOccurrenceDateTime)).append("\n");
        sb.append("    hasVerificationFailures: ").append(this.toIndentedString(this.hasVerificationFailures)).append("\n");
        sb.append("    throttled: ").append(this.toIndentedString(this.throttled)).append("\n");
        sb.append("    capabilities: ").append(this.toIndentedString(this.capabilities)).append("\n");
        sb.append("    actions: ").append(this.toIndentedString(this.actions)).append("\n");
        sb.append("    createdOn: ").append(this.toIndentedString(this.createdOn)).append("\n");
        sb.append("    lastModifiedOn: ").append(this.toIndentedString(this.lastModifiedOn)).append("\n");
        sb.append("    links: ").append(this.toIndentedString(this.links)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    @JsonAdapter(value=Adapter.class)
    public static enum ActionsEnum {
        STOP_SAVE("STOP_SAVE"),
        STOP_DELETE("STOP_DELETE"),
        PAUSE("PAUSE"),
        RESUME("RESUME");

        private String value;

        private ActionsEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static ActionsEnum fromValue(String text) {
            for (ActionsEnum b : ActionsEnum.values()) {
                if (!String.valueOf(b.value).equals(text)) continue;
                return b;
            }
            return null;
        }

        public static class Adapter
        extends TypeAdapter<ActionsEnum> {
            @Override
            public void write(JsonWriter jsonWriter, ActionsEnum enumeration) throws IOException {
                jsonWriter.value(enumeration.getValue());
            }

            @Override
            public ActionsEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return ActionsEnum.fromValue(String.valueOf(value));
            }
        }
    }
}

