/*
 * Decompiled with CFR 0.152.
 */
package com.veracode.apiwrapper.dynamicanalysis.model.api;

import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.util.Objects;

@ApiModel(description="Representation of a crawl script. Crawl scripts are application specific and independently maintained. A number of them can be recorded and maintained for an application. One or more of them can be included in any application configuration for use during scanning")
public class CrawlScript {
    @SerializedName(value="crawl_script_id")
    private String crawlScriptId = null;
    @SerializedName(value="name")
    private String name = null;
    @SerializedName(value="script_body")
    private String scriptBody = null;
    @SerializedName(value="script_type")
    private ScriptTypeEnum scriptType = null;

    public CrawlScript crawlScriptId(String crawlScriptId) {
        this.crawlScriptId = crawlScriptId;
        return this;
    }

    @ApiModelProperty(value="Unique record locator. Absent when not persisted")
    public String getCrawlScriptId() {
        return this.crawlScriptId;
    }

    public void setCrawlScriptId(String crawlScriptId) {
        this.crawlScriptId = crawlScriptId;
    }

    public CrawlScript name(String name) {
        this.name = name;
        return this;
    }

    @ApiModelProperty(value="A human readable name for the script. Must be unique among other scripts for the application")
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public CrawlScript scriptBody(String scriptBody) {
        this.scriptBody = scriptBody;
        return this;
    }

    @ApiModelProperty(value="The body of the script")
    public String getScriptBody() {
        return this.scriptBody;
    }

    public void setScriptBody(String scriptBody) {
        this.scriptBody = scriptBody;
    }

    public CrawlScript scriptType(ScriptTypeEnum scriptType) {
        this.scriptType = scriptType;
        return this;
    }

    @ApiModelProperty(value="The type of script. Must be present")
    public ScriptTypeEnum getScriptType() {
        return this.scriptType;
    }

    public void setScriptType(ScriptTypeEnum scriptType) {
        this.scriptType = scriptType;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CrawlScript crawlScript = (CrawlScript)o;
        return Objects.equals(this.crawlScriptId, crawlScript.crawlScriptId) && Objects.equals(this.name, crawlScript.name) && Objects.equals(this.scriptBody, crawlScript.scriptBody) && Objects.equals((Object)this.scriptType, (Object)crawlScript.scriptType);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.crawlScriptId, this.name, this.scriptBody, this.scriptType});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class CrawlScript {\n");
        sb.append("    crawlScriptId: ").append(this.toIndentedString(this.crawlScriptId)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    scriptBody: ").append(this.toIndentedString(this.scriptBody)).append("\n");
        sb.append("    scriptType: ").append(this.toIndentedString((Object)this.scriptType)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    @JsonAdapter(value=Adapter.class)
    public static enum ScriptTypeEnum {
        BURP("BURP"),
        SELENIUM("SELENIUM");

        private String value;

        private ScriptTypeEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static ScriptTypeEnum fromValue(String text) {
            for (ScriptTypeEnum b : ScriptTypeEnum.values()) {
                if (!String.valueOf(b.value).equals(text)) continue;
                return b;
            }
            return null;
        }

        public static class Adapter
        extends TypeAdapter<ScriptTypeEnum> {
            @Override
            public void write(JsonWriter jsonWriter, ScriptTypeEnum enumeration) throws IOException {
                jsonWriter.value(enumeration.getValue());
            }

            @Override
            public ScriptTypeEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return ScriptTypeEnum.fromValue(String.valueOf(value));
            }
        }
    }
}

