/*
 * Decompiled with CFR 0.152.
 */
package com.veracode.apiwrapper.dynamicanalysis.model.api;

import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.util.Objects;

@ApiModel(description="Represents the schedule for blackout - i.e periods within normal schedule when no scanning should take place.")
public class ScanBlackoutSchedule {
    @SerializedName(value="blackout_days")
    private String blackoutDays = null;
    @SerializedName(value="blackout_end_time")
    private String blackoutEndTime = null;
    @SerializedName(value="blackout_start_time")
    private String blackoutStartTime = null;
    @SerializedName(value="blackout_type")
    private BlackoutTypeEnum blackoutType = null;

    public ScanBlackoutSchedule blackoutDays(String blackoutDays) {
        this.blackoutDays = blackoutDays;
        return this;
    }

    @ApiModelProperty(example="TUESDAY, THURSDAY", value="Indicates the days of blackout period - a comma separated list of days")
    public String getBlackoutDays() {
        return this.blackoutDays;
    }

    public void setBlackoutDays(String blackoutDays) {
        this.blackoutDays = blackoutDays;
    }

    public ScanBlackoutSchedule blackoutEndTime(String blackoutEndTime) {
        this.blackoutEndTime = blackoutEndTime;
        return this;
    }

    @ApiModelProperty(value="Indicates the end time of a blackout period in HH:MM format")
    public String getBlackoutEndTime() {
        return this.blackoutEndTime;
    }

    public void setBlackoutEndTime(String blackoutEndTime) {
        this.blackoutEndTime = blackoutEndTime;
    }

    public ScanBlackoutSchedule blackoutStartTime(String blackoutStartTime) {
        this.blackoutStartTime = blackoutStartTime;
        return this;
    }

    @ApiModelProperty(value="Indicates the start time of a blackout period in HH:MM format")
    public String getBlackoutStartTime() {
        return this.blackoutStartTime;
    }

    public void setBlackoutStartTime(String blackoutStartTime) {
        this.blackoutStartTime = blackoutStartTime;
    }

    public ScanBlackoutSchedule blackoutType(BlackoutTypeEnum blackoutType) {
        this.blackoutType = blackoutType;
        return this;
    }

    @ApiModelProperty(value="Indicates the blackout window schedule type")
    public BlackoutTypeEnum getBlackoutType() {
        return this.blackoutType;
    }

    public void setBlackoutType(BlackoutTypeEnum blackoutType) {
        this.blackoutType = blackoutType;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ScanBlackoutSchedule scanBlackoutSchedule = (ScanBlackoutSchedule)o;
        return Objects.equals(this.blackoutDays, scanBlackoutSchedule.blackoutDays) && Objects.equals(this.blackoutEndTime, scanBlackoutSchedule.blackoutEndTime) && Objects.equals(this.blackoutStartTime, scanBlackoutSchedule.blackoutStartTime) && Objects.equals((Object)this.blackoutType, (Object)scanBlackoutSchedule.blackoutType);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.blackoutDays, this.blackoutEndTime, this.blackoutStartTime, this.blackoutType});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ScanBlackoutSchedule {\n");
        sb.append("    blackoutDays: ").append(this.toIndentedString(this.blackoutDays)).append("\n");
        sb.append("    blackoutEndTime: ").append(this.toIndentedString(this.blackoutEndTime)).append("\n");
        sb.append("    blackoutStartTime: ").append(this.toIndentedString(this.blackoutStartTime)).append("\n");
        sb.append("    blackoutType: ").append(this.toIndentedString((Object)this.blackoutType)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    @JsonAdapter(value=Adapter.class)
    public static enum BlackoutTypeEnum {
        THESE_HOURS("THESE_HOURS"),
        THESE_DAYS("THESE_DAYS"),
        WEEKDAYS("WEEKDAYS"),
        WEEKEND("WEEKEND");

        private String value;

        private BlackoutTypeEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static BlackoutTypeEnum fromValue(String text) {
            for (BlackoutTypeEnum b : BlackoutTypeEnum.values()) {
                if (!String.valueOf(b.value).equals(text)) continue;
                return b;
            }
            return null;
        }

        public static class Adapter
        extends TypeAdapter<BlackoutTypeEnum> {
            @Override
            public void write(JsonWriter jsonWriter, BlackoutTypeEnum enumeration) throws IOException {
                jsonWriter.value(enumeration.getValue());
            }

            @Override
            public BlackoutTypeEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return BlackoutTypeEnum.fromValue(String.valueOf(value));
            }
        }
    }
}

