/*
 * Decompiled with CFR 0.152.
 */
package com.veracode.apiwrapper.dynamicanalysis.model.api;

import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import com.veracode.apiwrapper.dynamicanalysis.model.api.BlacklistConfiguration;
import com.veracode.apiwrapper.dynamicanalysis.model.api.UserAgent;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.util.Objects;

@ApiModel(description="Represents the basic scan setting. Contains everything except URL specific details like target url,  authentications etc. ScanSetting can be specified at multiple contexts - Scan, Analysis, Account and System. The final ScanSetting of a Scan is determined by combining the aspects of ScanSetting from all different contexts. ")
public class ScanSetting {
    @SerializedName(value="blacklist_configuration")
    private BlacklistConfiguration blacklistConfiguration = null;
    @SerializedName(value="advanced_mode")
    private Boolean advancedMode = null;
    @SerializedName(value="max_links")
    private Integer maxLinks = null;
    @SerializedName(value="min_priority")
    private MinPriorityEnum minPriority = null;
    @SerializedName(value="multi_threading")
    private Boolean multiThreading = null;
    @SerializedName(value="response_timeout")
    private Integer responseTimeout = null;
    @SerializedName(value="user_agent")
    private UserAgent userAgent = null;
    @SerializedName(value="browser_version")
    private String browserVersion = null;

    public ScanSetting blacklistConfiguration(BlacklistConfiguration blacklistConfiguration) {
        this.blacklistConfiguration = blacklistConfiguration;
        return this;
    }

    @ApiModelProperty(value="Blacklist configuration for scan. Includes rules to avoid specific URLs during scan")
    public BlacklistConfiguration getBlacklistConfiguration() {
        return this.blacklistConfiguration;
    }

    public void setBlacklistConfiguration(BlacklistConfiguration blacklistConfiguration) {
        this.blacklistConfiguration = blacklistConfiguration;
    }

    public ScanSetting advancedMode(Boolean advancedMode) {
        this.advancedMode = advancedMode;
        return this;
    }

    @ApiModelProperty(value="True, if advanced mode is enabled")
    public Boolean isAdvancedMode() {
        return this.advancedMode;
    }

    public void setAdvancedMode(Boolean advancedMode) {
        this.advancedMode = advancedMode;
    }

    public ScanSetting maxLinks(Integer maxLinks) {
        this.maxLinks = maxLinks;
        return this;
    }

    @ApiModelProperty(example="5000", value="Max links to crawl")
    public Integer getMaxLinks() {
        return this.maxLinks;
    }

    public void setMaxLinks(Integer maxLinks) {
        this.maxLinks = maxLinks;
    }

    public ScanSetting minPriority(MinPriorityEnum minPriority) {
        this.minPriority = minPriority;
        return this;
    }

    @ApiModelProperty(value="Minimum scan priority. The Scan exits when all tasks have lower priority than this")
    public MinPriorityEnum getMinPriority() {
        return this.minPriority;
    }

    public void setMinPriority(MinPriorityEnum minPriority) {
        this.minPriority = minPriority;
    }

    public ScanSetting multiThreading(Boolean multiThreading) {
        this.multiThreading = multiThreading;
        return this;
    }

    @ApiModelProperty(example="false", value="If true, multithreading is enabled during scanning. Results in more simultaneous requests during scan. Applies for non advanced-mode scans only")
    public Boolean isMultiThreading() {
        return this.multiThreading;
    }

    public void setMultiThreading(Boolean multiThreading) {
        this.multiThreading = multiThreading;
    }

    public ScanSetting responseTimeout(Integer responseTimeout) {
        this.responseTimeout = responseTimeout;
        return this;
    }

    @ApiModelProperty(example="90", value="Response timeout in seconds to use when making requests during scanning")
    public Integer getResponseTimeout() {
        return this.responseTimeout;
    }

    public void setResponseTimeout(Integer responseTimeout) {
        this.responseTimeout = responseTimeout;
    }

    public ScanSetting userAgent(UserAgent userAgent) {
        this.userAgent = userAgent;
        return this;
    }

    @ApiModelProperty(value="User agent header to use for scanning. This is the header string that will be attached to all requests made to target site")
    public UserAgent getUserAgent() {
        return this.userAgent;
    }

    public void setUserAgent(UserAgent userAgent) {
        this.userAgent = userAgent;
    }

    public ScanSetting browserVersion(String browserVersion) {
        this.browserVersion = browserVersion;
        return this;
    }

    @ApiModelProperty(value="Type of browser to use during scanning.")
    public String getBrowserVersion() {
        return this.browserVersion;
    }

    public void setBrowserVersion(String browserVersion) {
        this.browserVersion = browserVersion;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ScanSetting scanSetting = (ScanSetting)o;
        return Objects.equals(this.blacklistConfiguration, scanSetting.blacklistConfiguration) && Objects.equals(this.advancedMode, scanSetting.advancedMode) && Objects.equals(this.maxLinks, scanSetting.maxLinks) && Objects.equals((Object)this.minPriority, (Object)scanSetting.minPriority) && Objects.equals(this.multiThreading, scanSetting.multiThreading) && Objects.equals(this.responseTimeout, scanSetting.responseTimeout) && Objects.equals(this.userAgent, scanSetting.userAgent) && Objects.equals(this.browserVersion, scanSetting.browserVersion);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.blacklistConfiguration, this.advancedMode, this.maxLinks, this.minPriority, this.multiThreading, this.responseTimeout, this.userAgent, this.browserVersion});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ScanSetting {\n");
        sb.append("    blacklistConfiguration: ").append(this.toIndentedString(this.blacklistConfiguration)).append("\n");
        sb.append("    advancedMode: ").append(this.toIndentedString(this.advancedMode)).append("\n");
        sb.append("    maxLinks: ").append(this.toIndentedString(this.maxLinks)).append("\n");
        sb.append("    minPriority: ").append(this.toIndentedString((Object)this.minPriority)).append("\n");
        sb.append("    multiThreading: ").append(this.toIndentedString(this.multiThreading)).append("\n");
        sb.append("    responseTimeout: ").append(this.toIndentedString(this.responseTimeout)).append("\n");
        sb.append("    userAgent: ").append(this.toIndentedString(this.userAgent)).append("\n");
        sb.append("    browserVersion: ").append(this.toIndentedString(this.browserVersion)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    @JsonAdapter(value=Adapter.class)
    public static enum MinPriorityEnum {
        VERY_HIGH("VERY_HIGH"),
        HIGH("HIGH"),
        MEDIUM("MEDIUM"),
        LOW("LOW"),
        VERY_LOW("VERY_LOW");

        private String value;

        private MinPriorityEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static MinPriorityEnum fromValue(String text) {
            for (MinPriorityEnum b : MinPriorityEnum.values()) {
                if (!String.valueOf(b.value).equals(text)) continue;
                return b;
            }
            return null;
        }

        public static class Adapter
        extends TypeAdapter<MinPriorityEnum> {
            @Override
            public void write(JsonWriter jsonWriter, MinPriorityEnum enumeration) throws IOException {
                jsonWriter.value(enumeration.getValue());
            }

            @Override
            public MinPriorityEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return MinPriorityEnum.fromValue(String.valueOf(value));
            }
        }
    }
}

