/*
 * Decompiled with CFR 0.152.
 */
package com.veracode.apiwrapper.exceptions;

public class ApiException
extends Exception {
    private static final long serialVersionUID = 4819379927704502552L;
    private final int responseCode;
    private Class contentClass;
    private Object content;

    public ApiException(int code, Throwable cause) {
        this(code, null, cause);
    }

    public ApiException(int code, Object content) {
        this.responseCode = code;
        this.content = content;
        this.contentClass = null == content ? null : content.getClass();
    }

    public ApiException(int code, Object content, Throwable cause) {
        super(cause);
        this.responseCode = code;
        this.content = content;
        this.contentClass = null == content ? null : content.getClass();
    }

    protected void setContent(Object content) {
        this.content = content;
        this.contentClass = null == content ? null : content.getClass();
    }

    public int getResponseCode() {
        return this.responseCode;
    }

    public <T> T getContent() {
        if (null == this.contentClass) {
            return null;
        }
        return this.contentClass.cast(this.content);
    }

    @Override
    public String getMessage() {
        if (this.contentClass == String.class) {
            return (String)this.getContent();
        }
        return super.getMessage();
    }
}

