/*
 * Decompiled with CFR 0.152.
 */
package com.veracode.apiwrapper.services.impl;

import com.veracode.apiwrapper.adapters.AdapterManager;
import com.veracode.apiwrapper.adapters.DynamicAnalysisAdapter;
import com.veracode.apiwrapper.dynamicanalysis.model.api.AnalysisOccurrence;
import com.veracode.apiwrapper.dynamicanalysis.model.api.AnalysisSummary;
import com.veracode.apiwrapper.dynamicanalysis.model.api.DetailedScanOccurrence;
import com.veracode.apiwrapper.dynamicanalysis.model.api.EmbeddedErrorData;
import com.veracode.apiwrapper.dynamicanalysis.model.api.PagedDetailedScanOccurrence;
import com.veracode.apiwrapper.dynamicanalysis.model.client.AnalysisInfo;
import com.veracode.apiwrapper.dynamicanalysis.model.client.AnalysisOccurrenceInfo;
import com.veracode.apiwrapper.dynamicanalysis.model.client.ScanOccurrenceInfo;
import com.veracode.apiwrapper.exceptions.ApiException;
import com.veracode.apiwrapper.exceptions.InvalidMediaTypeException;
import com.veracode.apiwrapper.exceptions.InvocationException;
import com.veracode.apiwrapper.services.DynamicAnalysisAPIService;
import com.veracode.apiwrapper.transformer.APIToClientModelTransformer;
import com.veracode.apiwrapper.transformer.ClientToAPIModelTransformer;
import com.veracode.apiwrapper.utils.UserAgent;
import com.veracode.http.Credentials;
import com.veracode.util.lang.StringUtility;
import java.net.Proxy;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class DefaultDynamicAnalysisAPIService
implements DynamicAnalysisAPIService {
    private final DynamicAnalysisAdapter daAdapter;
    private static final String METHOD_TYPE_PATCH = "PATCH";

    public DefaultDynamicAnalysisAPIService(Credentials creds) {
        this(creds, Proxy.NO_PROXY);
    }

    public DefaultDynamicAnalysisAPIService(Credentials creds, Proxy proxy) {
        if (null == creds) {
            throw new IllegalArgumentException("Cannot initialize without credentials.");
        }
        this.daAdapter = AdapterManager.createDynamicAnalysisAdapter(creds, proxy);
    }

    public DefaultDynamicAnalysisAPIService(Credentials creds, Proxy proxy, UserAgent userAgent) {
        if (null == creds) {
            throw new IllegalArgumentException("Cannot initialize without credentials.");
        }
        this.daAdapter = AdapterManager.createDynamicAnalysisAdapter(creds, proxy, userAgent);
    }

    @Override
    public AnalysisInfo getAnalysisByName(String name) throws ApiException, InvocationException {
        if (StringUtility.isNullOrEmpty(name)) {
            return null;
        }
        HashMap<String, String> query = new HashMap<String, String>();
        query.put("name", name);
        List<AnalysisSummary> summaries = null;
        try {
            summaries = this.daAdapter.getAnalysisSummary(query).getEmbedded().getAnalyses();
        }
        catch (ApiException ae) {
            Object contentObject = ae.getContent();
            if (null != contentObject) {
                if (contentObject instanceof String) {
                    throw new ApiException(ae.getResponseCode(), contentObject.toString(), ae.getCause());
                }
                EmbeddedErrorData content = (EmbeddedErrorData)ae.getContent();
                throw new ApiException(ae.getResponseCode(), APIToClientModelTransformer.transform(content), ae);
            }
            throw new ApiException(ae.getResponseCode(), ae.getCause());
        }
        if (null == summaries || summaries.size() == 0) {
            return null;
        }
        AnalysisInfo result = null;
        for (AnalysisSummary summary : summaries) {
            if (!summary.getName().equals(name)) continue;
            try {
                result = APIToClientModelTransformer.transform(summary);
            }
            catch (IllegalArgumentException iae) {
                throw new RuntimeException("Error occurred when transforming Analysis Summary.", iae);
            }
        }
        return result;
    }

    @Override
    public void resubmitAnalysisById(String id, int duration) throws ApiException, InvocationException {
        if (StringUtility.isNullOrEmpty(id) || duration <= 0) {
            throw new IllegalArgumentException("Invalid argument for resubmission.");
        }
        HashMap<String, String> query = new HashMap<String, String>();
        query.put("method", METHOD_TYPE_PATCH);
        try {
            this.daAdapter.updateAnalysis(id, ClientToAPIModelTransformer.transform(duration), query);
        }
        catch (InvalidMediaTypeException ae) {
            throw new ApiException(ae.getResponseCode(), ae.getContent(), ae.getCause());
        }
        catch (ApiException ae) {
            Object contentObject = ae.getContent();
            if (null != contentObject) {
                if (contentObject instanceof String) {
                    throw new ApiException(ae.getResponseCode(), contentObject.toString(), ae.getCause());
                }
                EmbeddedErrorData content = (EmbeddedErrorData)ae.getContent();
                throw new ApiException(ae.getResponseCode(), APIToClientModelTransformer.transform(content), ae);
            }
            throw new ApiException(ae.getResponseCode(), null, ae.getCause());
        }
    }

    @Override
    public AnalysisOccurrenceInfo getLatestAnalysisOccurrence(String id) throws ApiException, InvocationException {
        if (StringUtility.isNullOrEmpty(id)) {
            return null;
        }
        AnalysisOccurrence analysisOccurrence = null;
        HashMap<String, String> query = new HashMap<String, String>();
        query.put("analysis_occurrence_id", id);
        try {
            analysisOccurrence = this.daAdapter.getLatestAnalysisOccurrence(id, null);
        }
        catch (InvalidMediaTypeException ae) {
            throw new InvalidMediaTypeException(ae.getResponseCode(), ae.getContent().toString(), ae.getCause());
        }
        catch (ApiException ae) {
            Object contentObject = ae.getContent();
            if (null != contentObject) {
                if (contentObject instanceof String) {
                    throw new ApiException(ae.getResponseCode(), contentObject.toString(), ae.getCause());
                }
                EmbeddedErrorData content = (EmbeddedErrorData)ae.getContent();
                throw new ApiException(ae.getResponseCode(), APIToClientModelTransformer.transform(content), ae);
            }
            throw new ApiException(ae.getResponseCode(), null, ae.getCause());
        }
        if (null == analysisOccurrence) {
            return null;
        }
        AnalysisOccurrenceInfo result = null;
        result = APIToClientModelTransformer.transform(analysisOccurrence);
        return result;
    }

    @Override
    public Set<ScanOccurrenceInfo> getScanOccurrences(String id) throws ApiException, InvocationException {
        if (StringUtility.isNullOrEmpty(id)) {
            return null;
        }
        PagedDetailedScanOccurrence pagedScanOccurrence = null;
        try {
            pagedScanOccurrence = this.daAdapter.getScanOccurrences(id, null);
        }
        catch (InvalidMediaTypeException ae) {
            throw new InvalidMediaTypeException(ae.getResponseCode(), ae.getContent().toString(), ae.getCause());
        }
        catch (ApiException ae) {
            Object contentObject = ae.getContent();
            if (null != contentObject) {
                if (contentObject instanceof String) {
                    throw new ApiException(ae.getResponseCode(), contentObject.toString(), ae.getCause());
                }
                EmbeddedErrorData content = (EmbeddedErrorData)ae.getContent();
                throw new ApiException(ae.getResponseCode(), APIToClientModelTransformer.transform(content), ae);
            }
            throw new ApiException(ae.getResponseCode(), null, ae.getCause());
        }
        if (null == pagedScanOccurrence) {
            return null;
        }
        List<DetailedScanOccurrence> detailedScanOccurrences = pagedScanOccurrence.getEmbedded().getScanOccurrences();
        HashSet<ScanOccurrenceInfo> result = new HashSet<ScanOccurrenceInfo>();
        if (null != detailedScanOccurrences) {
            for (DetailedScanOccurrence thisOccurrence : detailedScanOccurrences) {
                result.add(APIToClientModelTransformer.transform(thisOccurrence));
            }
        }
        return result;
    }
}

