/*
 * Decompiled with CFR 0.152.
 */
package com.veracode.apiwrapper.services.impl;

import com.veracode.apiwrapper.adapters.AdapterManager;
import com.veracode.apiwrapper.adapters.IdentityAdapter;
import com.veracode.apiwrapper.exceptions.ApiException;
import com.veracode.apiwrapper.exceptions.InvalidMediaTypeException;
import com.veracode.apiwrapper.exceptions.InvocationException;
import com.veracode.apiwrapper.identity.model.api.CredentialValidityDetails;
import com.veracode.apiwrapper.identityteams.model.api.EmbeddedTeams;
import com.veracode.apiwrapper.identityteams.model.api.PagedResourcesOfResourceOfTeamSummary;
import com.veracode.apiwrapper.identityteams.model.api.ResourceOfTeamResource;
import com.veracode.apiwrapper.identityteams.model.api.Team;
import com.veracode.apiwrapper.identityteams.model.client.TeamPayload;
import com.veracode.apiwrapper.identityteams.model.client.UsersOfTeam;
import com.veracode.apiwrapper.identityusers.model.api.EmbeddedUsers;
import com.veracode.apiwrapper.identityusers.model.api.ErrorModel;
import com.veracode.apiwrapper.identityusers.model.api.PagedResourcesOfResourceOfUser;
import com.veracode.apiwrapper.identityusers.model.api.User;
import com.veracode.apiwrapper.identityusers.model.api.UserInfoResource;
import com.veracode.apiwrapper.identityusers.model.client.RolesOfUserPayload;
import com.veracode.apiwrapper.identityusers.model.client.TeamsOfUserPayload;
import com.veracode.apiwrapper.identityusers.model.client.UserPayload;
import com.veracode.apiwrapper.services.IdentityAPIService;
import com.veracode.apiwrapper.utils.UserAgent;
import com.veracode.http.Credentials;
import java.net.Proxy;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;

public class IdentityAPIServiceImpl
implements IdentityAPIService {
    private final IdentityAdapter identityAdapter;

    public IdentityAPIServiceImpl(Credentials creds) {
        this(creds, Proxy.NO_PROXY);
    }

    public IdentityAPIServiceImpl(Credentials creds, Proxy proxy) {
        if (null == creds) {
            throw new IllegalArgumentException("Cannot initialize without credentials.");
        }
        this.identityAdapter = AdapterManager.createIdentityAdapter(creds, proxy);
    }

    public IdentityAPIServiceImpl(Credentials creds, Proxy proxy, UserAgent userAgent) {
        if (null == creds) {
            throw new IllegalArgumentException("Cannot initialize without credentials.");
        }
        this.identityAdapter = AdapterManager.createIdentityAdapter(creds, proxy, userAgent);
    }

    @Override
    public Boolean isFeatureEnabled(String feature) throws ApiException, InvocationException {
        return this.identityAdapter.getPrincipal().getFeatures().contains(feature);
    }

    @Override
    public CredentialValidityDetails getApiCredentialDetails() throws ApiException, InvocationException {
        CredentialValidityDetails validityDetails = new CredentialValidityDetails(this.identityAdapter.getApiCredentials().getExpirationTimestamp());
        validityDetails.checkValidity();
        return validityDetails;
    }

    @Override
    public UserInfoResource createUser(String firstName, String lastName, String userName, String emailAddress, List<String> roles, List<String> teams, String isSamlUser, String samlSubject, String isActive) throws ApiException, InvocationException {
        try {
            return this.identityAdapter.createUserAdapter(this.getUserPayloadObj(firstName, lastName, userName, emailAddress, roles, teams, isSamlUser, samlSubject, isActive));
        }
        catch (InvalidMediaTypeException ae) {
            throw new InvalidMediaTypeException(ae.getResponseCode(), ae.getContent().toString(), ae.getCause());
        }
        catch (ApiException ae) {
            ErrorModel contentObject = (ErrorModel)ae.getContent();
            if (null != contentObject) {
                throw new ApiException(ae.getResponseCode(), contentObject.getMessage(), ae);
            }
            throw new ApiException(ae.getResponseCode(), null, ae.getCause());
        }
    }

    @Override
    public UserInfoResource updateUser(String userId, String firstName, String lastName, String userName, String emailAddress, List<String> roles, List<String> teams, String isSamlUser, String samlSubject, String title, String userType, String isActive, String isLoginEnabled, String phone, String customOne, String customTwo, String customThree, String customFour, String customFive) throws ApiException, InvocationException {
        HashMap<String, String> arguments = new HashMap<String, String>();
        arguments.put("userId", userId);
        HashMap<String, String> query = new HashMap<String, String>();
        query.put("partial", "true");
        UserPayload userPayloadObj = this.getUserPayloadObj(firstName, lastName, userName, emailAddress, roles, teams, isSamlUser, samlSubject, title, userType, isActive, isLoginEnabled, phone, customOne, customTwo, customThree, customFour, customFive);
        try {
            return this.identityAdapter.updateUserAdapter(userPayloadObj, arguments, query);
        }
        catch (InvalidMediaTypeException ae) {
            throw new InvalidMediaTypeException(ae.getResponseCode(), ae.getContent().toString(), ae.getCause());
        }
        catch (ApiException ae) {
            ErrorModel contentObject = (ErrorModel)ae.getContent();
            if (null != contentObject) {
                throw new ApiException(ae.getResponseCode(), contentObject.getMessage(), ae);
            }
            throw new ApiException(ae.getResponseCode(), null, ae.getCause());
        }
    }

    @Override
    public List<User> getUserList(String userNames, String orgId, String orgName, String deleted, String inactive) throws ApiException, InvocationException {
        HashMap<String, String> query = new HashMap<String, String>();
        query.put("user_name", userNames);
        query.put("org_id", orgId);
        query.put("org_name", orgName);
        query.put("deleted", deleted);
        query.put("inactive", inactive);
        ArrayList<PagedResourcesOfResourceOfUser> pagedResourcesUsersObjList = new ArrayList<PagedResourcesOfResourceOfUser>();
        int pageCount = 1;
        int pageNumber = 0;
        try {
            do {
                query.put("page", String.valueOf(pageNumber));
                PagedResourcesOfResourceOfUser pagedResourcesOfUsersObj = this.identityAdapter.getUserListAdapter(query);
                if (null == pagedResourcesOfUsersObj) continue;
                pagedResourcesUsersObjList.add(pagedResourcesOfUsersObj);
                pageCount = pagedResourcesOfUsersObj.getPage().getTotalPages().intValue();
                ++pageNumber;
            } while (pageNumber < pageCount);
        }
        catch (InvalidMediaTypeException ae) {
            throw new InvalidMediaTypeException(ae.getResponseCode(), ae.getContent().toString(), ae.getCause());
        }
        catch (ApiException ae) {
            ErrorModel contentObject = (ErrorModel)ae.getContent();
            if (null != contentObject) {
                throw new ApiException(ae.getResponseCode(), contentObject.getMessage(), ae);
            }
            throw new ApiException(ae.getResponseCode(), null, ae.getCause());
        }
        return this.getAllUserObjects(pagedResourcesUsersObjList);
    }

    @Override
    public UserInfoResource getUserInfo(String userId) throws ApiException, InvocationException {
        HashMap<String, String> arguments = new HashMap<String, String>();
        arguments.put("userId", userId);
        try {
            return this.identityAdapter.getUserInfoAdapter(arguments);
        }
        catch (InvalidMediaTypeException ae) {
            throw new InvalidMediaTypeException(ae.getResponseCode(), ae.getContent().toString(), ae.getCause());
        }
        catch (ApiException ae) {
            ErrorModel contentObject = (ErrorModel)ae.getContent();
            if (null != contentObject) {
                throw new ApiException(ae.getResponseCode(), contentObject.getMessage(), ae);
            }
            throw new ApiException(ae.getResponseCode(), null, ae.getCause());
        }
    }

    @Override
    public String deleteUser(String userId) throws ApiException, InvocationException {
        HashMap<String, String> arguments = new HashMap<String, String>();
        arguments.put("userId", userId);
        try {
            return this.identityAdapter.deleteUserAdapter(arguments);
        }
        catch (InvalidMediaTypeException ae) {
            throw new InvalidMediaTypeException(ae.getResponseCode(), ae.getContent().toString(), ae.getCause());
        }
        catch (ApiException ae) {
            ErrorModel contentObject = (ErrorModel)ae.getContent();
            if (null != contentObject) {
                throw new ApiException(ae.getResponseCode(), contentObject.getMessage(), ae);
            }
            throw new ApiException(ae.getResponseCode(), null, ae.getCause());
        }
    }

    @Override
    public ResourceOfTeamResource createTeam(String teamName, List<String> userIds) throws ApiException, InvocationException {
        try {
            return this.identityAdapter.createTeamAdapter(this.getTeamPayloadObj(teamName, userIds));
        }
        catch (InvalidMediaTypeException ae) {
            throw new InvalidMediaTypeException(ae.getResponseCode(), ae.getContent().toString(), ae.getCause());
        }
        catch (ApiException ae) {
            ErrorModel contentObject = (ErrorModel)ae.getContent();
            if (null != contentObject) {
                throw new ApiException(ae.getResponseCode(), contentObject.getMessage(), ae);
            }
            throw new ApiException(ae.getResponseCode(), null, ae.getCause());
        }
    }

    @Override
    public ResourceOfTeamResource updateTeam(String teamId, String teamName, List<String> usersIds) throws ApiException, InvocationException {
        HashMap<String, String> arguments = new HashMap<String, String>();
        arguments.put("teamId", teamId);
        HashMap<String, String> query = new HashMap<String, String>();
        query.put("partial", "true");
        try {
            return this.identityAdapter.updateTeamAdapter(this.getTeamPayloadObj(teamName, usersIds), arguments, query);
        }
        catch (InvalidMediaTypeException ae) {
            throw new InvalidMediaTypeException(ae.getResponseCode(), ae.getContent().toString(), ae.getCause());
        }
        catch (ApiException ae) {
            ErrorModel contentObject = (ErrorModel)ae.getContent();
            if (null != contentObject) {
                throw new ApiException(ae.getResponseCode(), contentObject.getMessage(), ae);
            }
            throw new ApiException(ae.getResponseCode(), null, ae.getCause());
        }
    }

    @Override
    public List<Team> getTeamList() throws ApiException, InvocationException {
        HashMap<String, String> query = new HashMap<String, String>();
        ArrayList<PagedResourcesOfResourceOfTeamSummary> pagedResourcesOfResourceOfTeamSummaryList = new ArrayList<PagedResourcesOfResourceOfTeamSummary>();
        int pageCount = 1;
        int pageNumber = 0;
        try {
            do {
                query.put("page", String.valueOf(pageNumber));
                PagedResourcesOfResourceOfTeamSummary pagedResourcesOfResourceOfTeamSummaryObj = this.identityAdapter.getTeamListAdapter(query);
                if (null == pagedResourcesOfResourceOfTeamSummaryObj) continue;
                pagedResourcesOfResourceOfTeamSummaryList.add(pagedResourcesOfResourceOfTeamSummaryObj);
                pageCount = pagedResourcesOfResourceOfTeamSummaryObj.getPage().getTotalPages().intValue();
                ++pageNumber;
            } while (pageNumber < pageCount);
        }
        catch (InvalidMediaTypeException ae) {
            throw new InvalidMediaTypeException(ae.getResponseCode(), ae.getContent().toString(), ae.getCause());
        }
        catch (ApiException ae) {
            ErrorModel contentObject = (ErrorModel)ae.getContent();
            if (null != contentObject) {
                throw new ApiException(ae.getResponseCode(), contentObject.getMessage(), ae);
            }
            throw new ApiException(ae.getResponseCode(), null, ae.getCause());
        }
        return this.getAllTeamsObjects(pagedResourcesOfResourceOfTeamSummaryList);
    }

    @Override
    public ResourceOfTeamResource getTeamInfo(String teamId) throws ApiException, InvocationException {
        HashMap<String, String> arguments = new HashMap<String, String>();
        arguments.put("teamId", teamId);
        try {
            return this.identityAdapter.getTeamInfoAdapter(arguments);
        }
        catch (InvalidMediaTypeException ae) {
            throw new InvalidMediaTypeException(ae.getResponseCode(), ae.getContent().toString(), ae.getCause());
        }
        catch (ApiException ae) {
            ErrorModel contentObject = (ErrorModel)ae.getContent();
            if (null != contentObject) {
                throw new ApiException(ae.getResponseCode(), contentObject.getMessage(), ae);
            }
            throw new ApiException(ae.getResponseCode(), null, ae.getCause());
        }
    }

    @Override
    public String deleteTeam(String teamId) throws ApiException, InvocationException {
        HashMap<String, String> arguments = new HashMap<String, String>();
        arguments.put("teamId", teamId);
        try {
            return this.identityAdapter.deleteTeamAdapter(arguments);
        }
        catch (InvalidMediaTypeException ae) {
            throw new InvalidMediaTypeException(ae.getResponseCode(), ae.getContent().toString(), ae.getCause());
        }
        catch (ApiException ae) {
            ErrorModel contentObject = (ErrorModel)ae.getContent();
            if (null != contentObject) {
                throw new ApiException(ae.getResponseCode(), contentObject.getMessage(), ae);
            }
            throw new ApiException(ae.getResponseCode(), null, ae.getCause());
        }
    }

    private UserPayload getUserPayloadObj(String firstName, String lastName, String userName, String emailAddress, List<String> roles, List<String> teams, String isSamlUser, String samlSubject, String isActive) {
        return this.getUserPayloadObj(firstName, lastName, userName, emailAddress, roles, teams, isSamlUser, samlSubject, null, null, isActive, null, null, null, null, null, null, null);
    }

    private UserPayload getUserPayloadObj(String firstName, String lastName, String userName, String emailAddress, List<String> roles, List<String> teams, String isSamlUser, String samlSubject, String title, String userType, String isActive, String isLoginEnabled, String phone, String customOne, String customTwo, String customThree, String customFour, String customFive) {
        UserPayload userPayloadObj = new UserPayload();
        if (null != firstName) {
            userPayloadObj.setFirstName(firstName);
        }
        if (null != lastName) {
            userPayloadObj.setLastName(lastName);
        }
        if (null != userName) {
            userPayloadObj.setUserName(userName);
        }
        if (null != emailAddress) {
            userPayloadObj.setEmail(emailAddress);
        }
        if (null != roles) {
            List<RolesOfUserPayload> listOfUserRoles = roles.stream().map(role -> {
                RolesOfUserPayload rolesOfUserPayload = new RolesOfUserPayload();
                rolesOfUserPayload.setRoleName((String)role);
                return rolesOfUserPayload;
            }).collect(Collectors.toList());
            userPayloadObj.setRoles(listOfUserRoles);
        }
        if (null != teams) {
            List<TeamsOfUserPayload> listOfUserTeams = teams.stream().map(team -> {
                TeamsOfUserPayload teamsOfUserPayload = new TeamsOfUserPayload();
                teamsOfUserPayload.setTeamName((String)team);
                return teamsOfUserPayload;
            }).collect(Collectors.toList());
            userPayloadObj.setTeams(listOfUserTeams);
        }
        if (null != isSamlUser) {
            userPayloadObj.setSamlUser(Boolean.valueOf(isSamlUser));
        }
        if (null != samlSubject) {
            userPayloadObj.setSamlSubject(samlSubject);
        }
        if (null != title) {
            userPayloadObj.setTitle(title);
        }
        if (null != userType) {
            userPayloadObj.setUserType(userType);
        }
        if (null != isActive) {
            userPayloadObj.setActive(Boolean.valueOf(isActive));
        }
        if (null != isLoginEnabled) {
            userPayloadObj.setLoginEnabled(Boolean.valueOf(isLoginEnabled));
        }
        if (null != phone) {
            userPayloadObj.setPhone(phone);
        }
        if (null != customOne) {
            userPayloadObj.setCustomOne(customOne);
        }
        if (null != customTwo) {
            userPayloadObj.setCustomTwo(customTwo);
        }
        if (null != customThree) {
            userPayloadObj.setCustomThree(customThree);
        }
        if (null != customFour) {
            userPayloadObj.setCustomFour(customFour);
        }
        if (null != customFive) {
            userPayloadObj.setCustomFive(customFive);
        }
        return userPayloadObj;
    }

    private TeamPayload getTeamPayloadObj(String teamName, List<String> userIds) {
        TeamPayload teamObj = new TeamPayload();
        teamObj.setTeamName(teamName);
        if (null != userIds) {
            List<UsersOfTeam> userObjList = userIds.stream().map(userId -> {
                UsersOfTeam usersOfTeam = new UsersOfTeam();
                usersOfTeam.setUserId((String)userId);
                return usersOfTeam;
            }).collect(Collectors.toList());
            teamObj.setUsers(userObjList);
        }
        return teamObj;
    }

    private List<User> getAllUserObjects(List<PagedResourcesOfResourceOfUser> pagedResourcesOfUsersObjList) {
        ArrayList<User> userList = new ArrayList<User>();
        for (PagedResourcesOfResourceOfUser pagedResourcesOfUserObj : pagedResourcesOfUsersObjList) {
            if (null == pagedResourcesOfUserObj.getEmbeddedUsers()) continue;
            EmbeddedUsers embeddedUsers = pagedResourcesOfUserObj.getEmbeddedUsers();
            userList.addAll(embeddedUsers.getUsers());
        }
        return userList;
    }

    private List<Team> getAllTeamsObjects(List<PagedResourcesOfResourceOfTeamSummary> pagedResourcesOfTeamsObjList) {
        ArrayList<Team> teamList = new ArrayList<Team>();
        for (PagedResourcesOfResourceOfTeamSummary pagedResourcesOfResourceOfTeamSummary : pagedResourcesOfTeamsObjList) {
            if (null == pagedResourcesOfResourceOfTeamSummary.getEmbedded()) continue;
            EmbeddedTeams pagedResourceEmbeddedTeams = pagedResourcesOfResourceOfTeamSummary.getEmbedded();
            teamList.addAll(pagedResourceEmbeddedTeams.getTeams());
        }
        return teamList;
    }
}

