/*
 * Decompiled with CFR 0.152.
 */
package com.veracode.http;

import com.veracode.apiwrapper.cli.VeracodeCommand;
import com.veracode.apiwrapper.services.ServiceManager;
import com.veracode.http.TLSSocketCustomFactory;
import com.veracode.http.WebRequestHandler;
import com.veracode.http.events.UploadProgressChangedListener;
import com.veracode.http.exceptions.TooManyRequestsException;
import com.veracode.http.proxy.ProxyData;
import com.veracode.http.util.ProxyAuthenticator;
import com.veracode.util.lang.StringUtility;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.Proxy;
import java.net.URL;
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import java.util.Map;
import java.util.Optional;
import javax.net.ssl.HttpsURLConnection;

public class WebRequestHandlerImpl
extends WebRequestHandler {
    private HttpURLConnection connection;

    @Override
    public void makeFormUrlEncodedPostRequest(String encodedQueryString, String encoding) throws IOException {
        this.connection.setRequestProperty("Content-Type", String.format("application/x-www-form-urlencoded; charset=%s", encoding));
        super.debugWriteLine("Invoking API " + this.connection.getURL());
        if (encodedQueryString != null && !encodedQueryString.isEmpty()) {
            super.debugWriteLine("Query string: " + encodedQueryString);
        }
        super.debugWriteLine("Connecting to host: " + this.connection.getURL().getHost());
        OutputStream requestOutputStream = this.connection.getOutputStream();
        super.debugWriteLine("Writing to request output stream");
        super.writeText(requestOutputStream, encodedQueryString, encoding);
        super.debugWriteLine("Close request output stream");
        requestOutputStream.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void makeOctetStreamPostRequest(File binaryFile, boolean useStreamingMode, UploadProgressChangedListener listener) throws IOException {
        super.debugWriteLine("Invoking API " + this.connection.getURL());
        super.debugWriteLine("Uploading file: " + binaryFile);
        if (useStreamingMode) {
            super.debugWriteLine("Using 'FixedLengthStreamingMode' with Content-Length=" + binaryFile.length());
            this.connection.setFixedLengthStreamingMode(binaryFile.length());
        }
        this.connection.setRequestProperty("Content-Type", "binary/octet-stream");
        this.connection.setRequestProperty("Content-Length", Long.toString(binaryFile.length()));
        super.debugWriteLine("Connecting to request output stream");
        OutputStream requestOutputStream = this.connection.getOutputStream();
        super.debugWriteLine("Writing to request output stream");
        FileInputStream fileInputStream = new FileInputStream(binaryFile);
        try {
            super.writeFile(requestOutputStream, fileInputStream, binaryFile.length(), listener);
        }
        finally {
            super.debugWriteLine("Close request input stream");
            fileInputStream.close();
        }
        super.debugWriteLine("Close request output stream");
        requestOutputStream.close();
    }

    @Override
    public void makeMultiPartPostRequest(Map<String, Object> formParameters, String boundaryString, String encoding, boolean useStreamingMode, UploadProgressChangedListener listener) throws IOException {
        if (useStreamingMode) {
            super.debugWriteLine("Using 'ChunkedStreamingMode' with CHUNK_SIZE=65536");
            this.connection.setChunkedStreamingMode(65536);
        }
        this.connection.setRequestProperty("Content-Type", String.format("multipart/form-data; boundary=%s", boundaryString));
        super.debugWriteLine("Connecting to request output stream");
        OutputStream requestOutputStream = this.connection.getOutputStream();
        super.debugWriteLine("Writing to request output stream");
        super.writeMultiPartPostRequestBody(requestOutputStream, boundaryString, formParameters, encoding, listener);
        super.debugWriteLine("Close request output stream");
        requestOutputStream.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public byte[] getResponse() throws IOException {
        InputStream responseInputStream = null;
        try {
            super.debugWriteLine("Connecting to response input stream");
            if (this.connection.getResponseCode() == 429) {
                int remainingTime = -1;
                try {
                    remainingTime = Integer.parseInt(this.connection.getHeaderField("Retry-After"));
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
                throw new TooManyRequestsException(this.connection.getResponseMessage(), this.connection.getResponseCode(), remainingTime, this.connection.getURL().toString());
            }
            responseInputStream = this.connection.getInputStream();
            super.debugWriteLine("Reading response input stream");
            byte[] byArray = super.getBytes(responseInputStream);
            return byArray;
        }
        finally {
            if (responseInputStream != null) {
                super.debugWriteLine("Close response input stream");
                responseInputStream.close();
            }
        }
    }

    @Override
    public int getResponseCode() throws IOException {
        super.debugWriteLine("Getting response status code from HTTP response message");
        return this.connection.getResponseCode();
    }

    @Override
    public void setConnectTimeout(int timeout) {
        this.connection.setConnectTimeout(timeout);
    }

    @Override
    public void setReadTimeout(int timeout) {
        this.connection.setReadTimeout(timeout);
    }

    @Override
    public void addHeader(String name, String value) {
        this.connection.setRequestProperty(name, StringUtility.escapeNewline(value));
    }

    @Override
    public void addUserAgentHeader(String userAgentValue) {
        this.connection.setRequestProperty("User-Agent", StringUtility.escapeNewline(userAgentValue));
    }

    @Override
    public String getDefaultUserAgentHeaderValue() {
        String userAgentName = VeracodeCommand.getUserAgentName();
        String userAgentVersion = VeracodeCommand.getUserAgentVersion();
        String jreVersion = VeracodeCommand.getJreVersion();
        String userAgentTool = VeracodeCommand.getUserAgentTool();
        if (!StringUtility.isNullOrEmpty(userAgentTool) && userAgentTool.matches("^\\w[a-zA-Z0-9\\(\\)\\.\\/;\\\\-_ ]+$")) {
            return String.format("%s", userAgentTool);
        }
        return String.format("%s/%s (Java/%s)", userAgentName, userAgentVersion, jreVersion);
    }

    @Override
    public int getUnauthorizedResponseCodeConstant() {
        return 401;
    }

    @Override
    public boolean releaseResources() {
        try {
            this.connection.disconnect();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return true;
    }

    @Override
    public void init(URL url, ProxyData proxyData) throws IOException {
        HttpsURLConnection securedConn;
        Proxy proxy = null;
        if (proxyData != null) {
            proxy = ProxyAuthenticator.newProxy(proxyData);
        } else {
            Optional<Proxy> proxyEnv = ServiceManager.getProxyService().getProxy();
            if (proxyEnv.isPresent()) {
                proxy = proxyEnv.get();
            }
        }
        if (proxy != null) {
            this.connection = (HttpURLConnection)url.openConnection(proxy);
            if (this.connection instanceof HttpsURLConnection) {
                securedConn = (HttpsURLConnection)this.connection;
                try {
                    TLSSocketCustomFactory factory = new TLSSocketCustomFactory();
                    securedConn.setSSLSocketFactory(factory);
                }
                catch (KeyManagementException ex) {
                    super.debugWriteLine("Error:" + ex.getMessage());
                }
                catch (NoSuchAlgorithmException ex) {
                    super.debugWriteLine("Error:" + ex.getMessage());
                }
            }
        } else {
            this.connection = (HttpURLConnection)url.openConnection();
            if (this.connection instanceof HttpsURLConnection) {
                securedConn = (HttpsURLConnection)this.connection;
                try {
                    TLSSocketCustomFactory factory = new TLSSocketCustomFactory();
                    securedConn.setSSLSocketFactory(factory);
                }
                catch (KeyManagementException ex) {
                    super.debugWriteLine("Error:" + ex.getMessage());
                }
                catch (NoSuchAlgorithmException ex) {
                    super.debugWriteLine("Error:" + ex.getMessage());
                }
            }
        }
        this.connection.setDoOutput(true);
        this.connection.setDoInput(true);
    }

    protected String getRequestHeader(String header) {
        if (StringUtility.isNullOrEmpty(header)) {
            throw new IllegalArgumentException("Cannot retrieve value of a request header. The specified header is empty.");
        }
        return this.connection.getRequestProperty(header);
    }
}

