/*
 * Decompiled with CFR 0.152.
 */
package com.veracode.http.util;

import com.google.gson.reflect.TypeToken;
import com.veracode.apiwrapper.dynamicanalysis.model.api.EmbeddedErrorData;
import com.veracode.apiwrapper.exceptions.ApiException;
import com.veracode.apiwrapper.exceptions.InvalidMediaTypeException;
import com.veracode.apiwrapper.model.util.JSON;
import com.veracode.parser.util.StringUtility;
import java.lang.reflect.Type;
import java.util.Set;

public class ExceptionUtil {
    public static final InvalidMediaTypeException createInvalidMediaTypeException(int code, Set<String> expectedTypes, String actualType) {
        return new InvalidMediaTypeException(code, String.format("Invalid response media type. Excepted %s; Actual [%s]", expectedTypes, actualType));
    }

    public static final InvalidMediaTypeException createInvalidMediaTypeException(int code, Set<String> expectedTypes, String actualType, Throwable cause) {
        return new InvalidMediaTypeException(code, String.format("Invalid response media type. Excepted %s; Actual [%s]", expectedTypes, actualType), cause);
    }

    public static final ApiException createException(int code, String content, Throwable cause) {
        ApiException exception = null;
        JSON json = new JSON();
        switch (code) {
            case 400: 
            case 404: {
                EmbeddedErrorData errorData = null;
                if (!StringUtility.isNullOrEmpty(content)) {
                    Type returnType = new TypeToken<EmbeddedErrorData>(){}.getType();
                    errorData = (EmbeddedErrorData)json.deserialize(content, returnType);
                    exception = new ApiException(code, errorData, cause);
                    break;
                }
                exception = new ApiException(code, cause);
                break;
            }
            case 401: 
            case 403: 
            case 500: {
                exception = new ApiException(code, cause);
                break;
            }
            default: {
                exception = !StringUtility.isNullOrEmpty(content) ? new ApiException(code, content, cause) : new ApiException(code, cause);
            }
        }
        return exception;
    }

    public static final <T> ApiException createException(int code, String content, Throwable cause, Type returnType) {
        ApiException exception = null;
        JSON json = new JSON();
        switch (code) {
            case 400: 
            case 404: {
                Object errorData = null;
                if (!StringUtility.isNullOrEmpty(content)) {
                    errorData = json.deserialize(content, returnType);
                    exception = new ApiException(code, errorData, cause);
                    break;
                }
                exception = new ApiException(code, cause);
                break;
            }
            case 401: 
            case 403: 
            case 500: {
                exception = new ApiException(code, cause);
                break;
            }
            default: {
                exception = !StringUtility.isNullOrEmpty(content) ? new ApiException(code, content, cause) : new ApiException(code, cause);
            }
        }
        return exception;
    }
}

