/*
 * Decompiled with CFR 0.152.
 */
package com.veracode.parser;

import com.veracode.parser.CommandLineParserSettings;
import com.veracode.parser.core.CLineParser;
import com.veracode.parser.enums.ParserState;
import com.veracode.parser.exceptions.ParseException;
import com.veracode.parser.options.CommandLineOptionsBase;
import com.veracode.parser.text.TextBuilder;
import com.veracode.parser.util.Assert;
import com.veracode.parser.util.StringUtility;
import java.util.Arrays;
import java.util.List;

public final class CommandLineParser {
    private CommandLineParserSettings _settings;

    public CommandLineParserSettings getSettings() {
        return this._settings;
    }

    public void setSettings(CommandLineParserSettings settings) {
        this._settings = settings;
    }

    public boolean parse(CommandLineOptionsBase options, String[] arguments) {
        try {
            Assert.notNull(options, "options");
            Assert.notNull(arguments, "arguments");
            if (this._settings.getWriter() != null) {
                if (this.containsUsernameAndPassword(arguments)) {
                    this._settings.getWriter().print(TextBuilder.getDeprecatedUserPassText());
                    return false;
                }
                this.checkBackwardCompatibilityForDeleteIncompleteScan(arguments);
                boolean showOptions = false;
                showOptions = this.parseHelp(options, arguments);
                if (showOptions || this.parseWrapperVerionsCommand(options, arguments) || !this.parseItems(options, arguments)) {
                    TextBuilder textBuilder = TextBuilder.createInstance(options);
                    if (textBuilder != null) {
                        if (showOptions) {
                            this._settings.getWriter().print(textBuilder.getAllText());
                            return arguments.length != 0;
                        }
                        if (this._settings.getReturnSuccess()) {
                            this._settings.getWriter().print(textBuilder.getWrapperVersionText());
                            return true;
                        }
                        if (this._settings.getWriteErrorsOnly()) {
                            this._settings.getWriter().print(textBuilder.getOnlyErrorText());
                        } else {
                            this._settings.getWriter().print(textBuilder.getAllTextSansOptions());
                        }
                    }
                    return false;
                }
                return true;
            }
            return this.parseItems(options, arguments);
        }
        catch (ParseException clpe) {
            throw clpe;
        }
        catch (Exception e) {
            throw new ParseException("Generic Parse Exception", e);
        }
    }

    private boolean containsUsernameAndPassword(String[] arguments) {
        List<String> args = Arrays.asList(arguments);
        return args.contains("-vuser") || args.contains("-vpassword");
    }

    private boolean parseHelp(CommandLineOptionsBase options, String[] arguments) {
        boolean caseSensitive = this._settings.getCaseSensitive();
        if (arguments.length == 0) {
            return true;
        }
        for (int i = 0; i < arguments.length; ++i) {
            if (StringUtility.compare(arguments[i], options.longSwitch + "help", !caseSensitive) != 0) continue;
            this._settings.setReturnSuccess(true);
            return true;
        }
        return false;
    }

    private boolean parseItems(CommandLineOptionsBase options, String[] arguments) {
        boolean hadError = false;
        CLineParser parser = new CLineParser(options, this._settings, arguments);
        while (parser.moveNext()) {
            ParserState result;
            if (StringUtility.isNullOrEmpty(parser.getCurrent()) || (result = parser.parseCurrentItem()) != ParserState.Failure) continue;
            hadError = true;
        }
        return !(hadError |= !parser.enforceRules());
    }

    private boolean parseWrapperVerionsCommand(CommandLineOptionsBase options, String[] arguments) {
        boolean caseSensitive = this._settings.getCaseSensitive();
        for (int i = 0; i < arguments.length; ++i) {
            if (StringUtility.compare(arguments[i], options.longSwitch + "wrapperversion", !caseSensitive) != 0) continue;
            this._settings.setReturnSuccess(true);
            return true;
        }
        return false;
    }

    public CommandLineParser() {
        this._settings = new CommandLineParserSettings();
    }

    public CommandLineParser(CommandLineParserSettings settings) {
        this._settings = settings;
    }

    private void checkBackwardCompatibilityForDeleteIncompleteScan(String[] arguments) {
        for (int i = 0; i < arguments.length - 1; ++i) {
            if (!arguments[i].equalsIgnoreCase("-deleteincompletescan")) continue;
            if (arguments[i + 1].equalsIgnoreCase("true")) {
                arguments[i + 1] = "1";
                this._settings.getWriter().print("\nThe deleteincompletescan parameter value has range 0,1,2. The value of \"true\" is now represented with value \"1\".\n");
                break;
            }
            if (!arguments[i + 1].equalsIgnoreCase("false")) break;
            arguments[i + 1] = "0";
            this._settings.getWriter().print("\nThe deleteincompletescan parameter value has range 0,1,2. The value of \"false\" is now represented with value \"0\".\n");
            break;
        }
    }
}

