/*
 * Decompiled with CFR 0.152.
 */
package com.javax0.license3j.licensor;

import com.javax0.license3j.licensor.HttpHandler;
import com.javax0.license3j.licensor.License;
import java.io.IOException;
import java.io.Serializable;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.UUID;

public class ExtendedLicense
extends License {
    private static final String EXPIRATION_DATE = "expiryDate";
    private static final String DATE_FORMAT = "yyyy-MM-dd";
    private static final String LICENSE_ID = "licenseId";
    private static final String REVOCATION_URL = "revocationUrl";
    HttpHandler httpHandler = new HttpHandler();

    public boolean isExpired() {
        boolean expired;
        try {
            Date expiryDate = this.getFeature(EXPIRATION_DATE, Date.class);
            GregorianCalendar today = new GregorianCalendar();
            today.set(11, 0);
            today.set(12, 0);
            today.set(13, 0);
            today.set(14, 0);
            expired = today.getTime().after(expiryDate);
        }
        catch (Exception e) {
            expired = true;
        }
        return expired;
    }

    public void setExpiry(Date expiryDate) {
        this.setFeature(EXPIRATION_DATE, expiryDate);
    }

    public UUID generateLicenseId() {
        UUID uuid = UUID.randomUUID();
        this.setLicenseId(uuid);
        return uuid;
    }

    public UUID getLicenseId() {
        UUID licenseId;
        try {
            licenseId = this.getFeature(LICENSE_ID, UUID.class);
        }
        catch (Exception e) {
            licenseId = null;
        }
        return licenseId;
    }

    public void setLicenseId(UUID licenseId) {
        this.setFeature(LICENSE_ID, licenseId);
    }

    public void setFeature(String name, Integer i) {
        this.setFeature(name, i.toString());
    }

    public void setFeature(String name, Date date) {
        SimpleDateFormat formatter = new SimpleDateFormat(DATE_FORMAT);
        this.setFeature(name, formatter.format(date));
    }

    public void setFeature(String name, URL url) {
        this.setFeature(name, url.toString());
    }

    public void setFeature(String name, UUID uuid) {
        this.setFeature(name, uuid.toString());
    }

    public <T> T getFeature(String name, Class<? extends T> klass) {
        Serializable result;
        block6: {
            String resultString = this.getFeature(name);
            try {
                if (Integer.class == klass) {
                    result = Integer.parseInt(resultString);
                    break block6;
                }
                if (Date.class == klass) {
                    result = new SimpleDateFormat(DATE_FORMAT).parse(this.getFeature(name));
                    break block6;
                }
                if (UUID.class == klass) {
                    result = UUID.fromString(this.getFeature(name));
                    break block6;
                }
                if (URL.class == klass) {
                    result = new URL(this.getFeature(name));
                    break block6;
                }
                throw new IllegalArgumentException("'" + klass.toString() + "' is not handled");
            }
            catch (IllegalArgumentException | MalformedURLException | ParseException shouldNotHappen) {
                throw new IllegalArgumentException(shouldNotHappen);
            }
        }
        return (T)result;
    }

    public URL getRevocationURL() throws MalformedURLException {
        URL url = null;
        String revocationURLTemplate = this.getFeature(REVOCATION_URL);
        if (revocationURLTemplate != null) {
            UUID licenseId = this.getLicenseId();
            String revocationURL = licenseId != null ? revocationURLTemplate.replaceAll("\\$\\{licenseId}", licenseId.toString()) : revocationURLTemplate;
            url = new URL(revocationURL);
        }
        return url;
    }

    public void setRevocationURL(String url) {
        this.setFeature(REVOCATION_URL, url);
    }

    public void setRevocationURL(URL url) {
        this.setRevocationURL(url.toString());
    }

    public boolean isRevoked() {
        return this.isRevoked(false);
    }

    public boolean isRevoked(boolean defaultRevocationState) {
        boolean revoked = true;
        try {
            URL url = this.getRevocationURL();
            if (url != null) {
                URLConnection connection = this.httpHandler.openConnection(url);
                this.doNotUseCache(connection);
                if (connection instanceof HttpURLConnection) {
                    HttpURLConnection httpUrlConnection = (HttpURLConnection)connection;
                    httpUrlConnection.connect();
                    int responseCode = this.httpHandler.getResponseCode(httpUrlConnection);
                    revoked = responseCode != 200;
                }
            } else {
                revoked = false;
            }
        }
        catch (IOException exception) {
            revoked = defaultRevocationState;
        }
        return revoked;
    }

    private void doNotUseCache(URLConnection connection) {
        connection.setUseCaches(false);
    }
}

