/*
 * Decompiled with CFR 0.152.
 */
package com.javax0.license3j.licensor;

import com.javax0.license3j.licensor.hardware.InterfaceSelector;
import com.javax0.license3j.licensor.hardware.UUIDCalculator;
import java.io.UnsupportedEncodingException;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.util.UUID;

public class HardwareBinder {
    private final InterfaceSelector selector = new InterfaceSelector();
    private final UUIDCalculator calculator = new UUIDCalculator(this.selector);
    private boolean useHostName = true;
    private boolean useNetwork = true;
    private boolean useArchitecture = true;

    public static void main(String[] args) throws UnsupportedEncodingException, SocketException, UnknownHostException {
        HardwareBinder hb = new HardwareBinder();
        System.out.print(hb.getMachineIdString());
    }

    public HardwareBinder interfaceAllowed(String regex) {
        this.selector.interfaceAllowed(regex);
        return this;
    }

    public HardwareBinder interfaceDenied(String regex) {
        this.selector.interfaceDenied(regex);
        return this;
    }

    public HardwareBinder ignoreHostName() {
        this.useHostName = false;
        return this;
    }

    public HardwareBinder ignoreNetwork() {
        this.useNetwork = false;
        return this;
    }

    public HardwareBinder ignoreArchitecture() {
        this.useArchitecture = false;
        return this;
    }

    public UUID getMachineId() throws UnsupportedEncodingException, SocketException, UnknownHostException {
        return this.calculator.getMachineId(this.useNetwork, this.useHostName, this.useArchitecture);
    }

    public String getMachineIdString() throws UnsupportedEncodingException, SocketException, UnknownHostException {
        return this.calculator.getMachineIdString(this.useNetwork, this.useHostName, this.useArchitecture);
    }

    public boolean assertUUID(UUID uuid) throws UnsupportedEncodingException, SocketException, UnknownHostException {
        return this.calculator.assertUUID(uuid, this.useNetwork, this.useHostName, this.useArchitecture);
    }

    public boolean assertUUID(String uuid) {
        return this.calculator.assertUUID(uuid, this.useNetwork, this.useHostName, this.useArchitecture);
    }
}

