/*
 * Decompiled with CFR 0.152.
 */
package com.javax0.license3j.licensor.hardware;

import com.javax0.license3j.licensor.hardware.InterfaceSelector;
import com.javax0.license3j.licensor.hardware.NetworkInterfaceData;
import java.io.UnsupportedEncodingException;
import java.net.InetAddress;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.util.Comparator;
import java.util.List;
import org.bouncycastle.crypto.digests.MD5Digest;

class HashCalculator {
    private final InterfaceSelector selector;

    HashCalculator(InterfaceSelector selector) {
        this.selector = selector;
    }

    private void updateWithNetworkData(MD5Digest md5, List<NetworkInterfaceData> networkInterfaces) throws UnsupportedEncodingException {
        for (NetworkInterfaceData ni : networkInterfaces) {
            md5.update(ni.name.getBytes("utf-8"), 0, ni.name.getBytes("utf-8").length);
            if (ni.hwAddress == null) continue;
            md5.update(ni.hwAddress, 0, ni.hwAddress.length);
        }
    }

    void updateWithNetworkData(MD5Digest md5) throws UnsupportedEncodingException, SocketException {
        List<NetworkInterfaceData> networkInterfaces = NetworkInterfaceData.gatherUsing(this.selector);
        networkInterfaces.sort(Comparator.comparing(a -> a.name));
        this.updateWithNetworkData(md5, networkInterfaces);
    }

    void updateWithHostName(MD5Digest md5) throws UnknownHostException, UnsupportedEncodingException {
        String hostName = InetAddress.getLocalHost().getHostName();
        md5.update(hostName.getBytes("utf-8"), 0, hostName.getBytes("utf-8").length);
    }

    void updateWithArchitecture(MD5Digest md5) throws UnsupportedEncodingException {
        String architectureString = System.getProperty("os.arch");
        md5.update(architectureString.getBytes("utf-8"), 0, architectureString.getBytes("utf-8").length);
    }
}

