/*
 * Decompiled with CFR 0.152.
 */
package com.versioneye;

import com.versioneye.SuperMojo;
import com.versioneye.dto.ProjectJsonResponse;
import com.versioneye.utils.DependencyUtils;
import com.versioneye.utils.JsonUtils;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathFactory;
import org.apache.maven.model.Dependency;
import org.apache.maven.model.Plugin;
import org.eclipse.aether.artifact.Artifact;
import org.eclipse.aether.collection.CollectRequest;
import org.eclipse.aether.graph.DependencyNode;
import org.eclipse.aether.graph.DependencyVisitor;
import org.eclipse.aether.resolution.DependencyRequest;
import org.eclipse.aether.util.graph.visitor.PreorderNodeListGenerator;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ProjectMojo
extends SuperMojo {
    protected ByteArrayOutputStream getDirectDependenciesJsonStream(String nameStrategy) throws Exception {
        ArrayList<Plugin> plugins = new ArrayList();
        if (this.trackPlugins.booleanValue()) {
            plugins = this.getPluginsFromXml();
        }
        List dependencies = this.project.getDependencies();
        if (this.project.getDependencyManagement() != null && this.project.getDependencyManagement().getDependencies() != null && this.project.getDependencyManagement().getDependencies().size() > 0) {
            dependencies.addAll(this.project.getDependencyManagement().getDependencies());
        }
        List<Dependency> filteredDependencies = this.filterForScopes(dependencies);
        JsonUtils jsonUtils = new JsonUtils();
        return jsonUtils.dependenciesToJson(this.project, filteredDependencies, plugins, nameStrategy);
    }

    protected Map<String, Object> getDirectDependenciesJsonMap(String nameStrategy) throws Exception {
        List dependencies = this.project.getDependencies();
        if (dependencies == null || dependencies.isEmpty()) {
            return null;
        }
        this.iterateThrough(dependencies);
        JsonUtils jsonUtils = new JsonUtils();
        List<Map<String, Object>> dependencyHashes = jsonUtils.getDependencyHashes(dependencies, this.project.getPluginManagement().getPlugins());
        return jsonUtils.getJsonPom(this.project, dependencyHashes, nameStrategy);
    }

    protected ByteArrayOutputStream getDirectArtifactsJsonStream() throws Exception {
        DependencyNode root = this.getDependencyNode(new PreorderNodeListGenerator());
        List<Artifact> directDependencies = DependencyUtils.collectDirectDependencies(root.getChildren());
        JsonUtils jsonUtils = new JsonUtils();
        return jsonUtils.artifactsToJson(directDependencies);
    }

    protected DependencyNode getDependencyNode(PreorderNodeListGenerator nlg) throws Exception {
        CollectRequest collectRequest = DependencyUtils.getCollectRequest(this.project, this.repos);
        DependencyNode root = this.system.collectDependencies(this.session, collectRequest).getRoot();
        DependencyRequest dependencyRequest = new DependencyRequest(root, null);
        this.system.resolveDependencies(this.session, dependencyRequest);
        root.accept((DependencyVisitor)nlg);
        return root;
    }

    protected void prettyPrint0End() throws Exception {
        this.getLog().info((CharSequence)".");
        this.getLog().info((CharSequence)("There are no dependencies in this project! - " + this.project.getGroupId() + "/" + this.project.getArtifactId()));
        this.getLog().info((CharSequence)".");
    }

    protected void prettyPrint(ProjectJsonResponse response) throws Exception {
        this.getLog().info((CharSequence)".");
        this.getLog().info((CharSequence)("Project name: " + response.getName()));
        this.getLog().info((CharSequence)("Project id: " + response.getId()));
        this.getLog().info((CharSequence)("Dependencies: " + response.getDep_number()));
        this.getLog().info((CharSequence)("Outdated: " + response.getOut_number()));
        this.getLog().info((CharSequence)"");
        this.getLog().info((CharSequence)("You can find your updated project here: " + this.baseUrl + "/user/projects/" + response.getId()));
        this.getLog().info((CharSequence)"");
    }

    private void iterateThrough(List<Dependency> dependencies) {
        for (Dependency dep : dependencies) {
            this.getLog().info((CharSequence)(" - dependency: " + dep.getGroupId() + "/" + dep.getArtifactId() + " " + dep.getVersion()));
        }
    }

    private List<Plugin> getPluginsFromXml() {
        ArrayList<Plugin> plugins = new ArrayList<Plugin>();
        try {
            File pom = this.project.getModel().getPomFile();
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            DocumentBuilder builder = factory.newDocumentBuilder();
            Document doc = builder.parse(pom);
            XPathFactory xPathfactory = XPathFactory.newInstance();
            XPath xpath = xPathfactory.newXPath();
            XPathExpression expr = xpath.compile("//plugins/plugin");
            NodeList nl = (NodeList)expr.evaluate(doc, XPathConstants.NODESET);
            for (int i = 0; i < nl.getLength(); ++i) {
                Node node = nl.item(i);
                Plugin plugin = new Plugin();
                this.fillPlugin(node, plugin);
                if (plugin.getGroupId() == null || plugin.getArtifactId() == null) continue;
                plugins.add(plugin);
            }
        }
        catch (Exception exc) {
            this.getLog().error((Throwable)exc);
        }
        return plugins;
    }

    private void fillPlugin(Node node, Plugin plugin) {
        for (int xi = 0; xi < node.getChildNodes().getLength(); ++xi) {
            Node child = node.getChildNodes().item(xi);
            if (child == null) {
                return;
            }
            if (child.getNodeName().equals("groupId")) {
                plugin.setGroupId(child.getTextContent().trim());
            }
            if (child.getNodeName().equals("artifactId")) {
                plugin.setArtifactId(child.getTextContent().trim());
            }
            if (!child.getNodeName().equals("version")) continue;
            String version = this.parseVersionString(child.getTextContent().trim());
            plugin.setVersion(version);
        }
    }

    private String parseVersionString(String version) {
        if (version.startsWith("${")) {
            String verValue = version.replaceAll("\\$\\{", "").replaceAll("\\}", "");
            version = (String)this.project.getProperties().get(verValue);
        }
        return version;
    }

    private List<Dependency> filterForScopes(List<Dependency> dependencies) {
        if (this.skipScopes == null || this.skipScopes.trim().isEmpty() || dependencies == null || dependencies.isEmpty()) {
            return dependencies;
        }
        String[] scopes = this.skipScopes.split(",");
        ArrayList<Dependency> filtered = new ArrayList<Dependency>();
        for (Dependency dependency : dependencies) {
            boolean ignoreScope = false;
            for (String scope : scopes) {
                if (scope == null || dependency == null || dependency.getScope() == null || !dependency.getScope().toLowerCase().equals(scope.toLowerCase())) continue;
                ignoreScope = true;
            }
            if (ignoreScope) continue;
            filtered.add(dependency);
        }
        return filtered;
    }
}

