/*
 * Decompiled with CFR 0.152.
 */
package com.versioneye;

import com.versioneye.utils.PropertiesUtils;
import java.io.File;
import java.io.IOException;
import java.security.SecureRandom;
import java.security.cert.X509Certificate;
import java.util.List;
import java.util.Properties;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;
import org.eclipse.aether.RepositorySystem;
import org.eclipse.aether.RepositorySystemSession;
import org.eclipse.aether.repository.RemoteRepository;

public class SuperMojo
extends AbstractMojo {
    protected static final String propertiesFile = "versioneye.properties";
    @Component
    protected RepositorySystem system;
    @Parameter(defaultValue="${project}")
    protected MavenProject project;
    @Parameter(defaultValue="${repositorySystemSession}")
    protected RepositorySystemSession session;
    @Parameter(defaultValue="${project.remoteProjectRepositories}")
    protected List<RemoteRepository> repos;
    @Parameter(defaultValue="${basedir}", property="basedir", required=true)
    protected File projectDirectory;
    @Parameter(defaultValue="${project.build.directory}", property="outputDir", required=true)
    protected File outputDirectory;
    @Parameter(defaultValue="${user.home}")
    protected File homeDirectory;
    @Parameter(property="baseUrl", defaultValue="https://www.versioneye.com")
    protected String baseUrl;
    @Parameter(property="apiPath", defaultValue="/api/v2")
    protected String apiPath;
    @Parameter(property="projectId")
    protected String projectId;
    @Parameter(property="apiKey")
    protected String apiKey;
    @Parameter(property="propertiesPath")
    protected String propertiesPath = null;
    @Parameter(property="proxyHost")
    protected String proxyHost = null;
    @Parameter(property="proxyPort")
    protected String proxyPort = null;
    @Parameter(property="proxyUser")
    protected String proxyUser = null;
    @Parameter(property="proxyPassword")
    protected String proxyPassword = null;
    @Parameter(property="updatePropertiesAfterCreate")
    protected boolean updatePropertiesAfterCreate = true;
    @Parameter(property="mergeAfterCreate")
    protected boolean mergeAfterCreate = true;
    @Parameter(property="parentGroupId")
    protected String parentGroupId = null;
    @Parameter(property="parentArtifactId")
    protected String parentArtifactId = null;
    @Parameter(property="nameStrategy")
    protected String nameStrategy = "name";
    @Parameter(property="trackPlugins")
    protected Boolean trackPlugins = Boolean.TRUE;
    @Parameter(property="licenseCheckBreakByUnknown")
    protected Boolean licenseCheckBreakByUnknown = Boolean.FALSE;
    @Parameter(property="skipScopes")
    protected String skipScopes = null;
    protected Properties properties = null;
    protected Properties homeProperties = null;

    public void execute() throws MojoExecutionException, MojoFailureException {
    }

    protected String fetchApiKey() throws Exception {
        if (this.apiKey != null && !this.apiKey.isEmpty()) {
            return this.apiKey;
        }
        Properties properties = this.fetchPropertiesFor("api_key");
        this.apiKey = properties.getProperty("api_key");
        if (this.apiKey == null || this.apiKey.isEmpty()) {
            String msg = "versioneye.properties found but without an API Key! Read the instructions at https://github.com/versioneye/versioneye_maven_plugin";
            this.getLog().error((CharSequence)msg);
            throw new MojoExecutionException(msg);
        }
        return this.apiKey;
    }

    protected String fetchProjectId() throws Exception {
        if (this.projectId != null && !this.projectId.isEmpty()) {
            return this.projectId;
        }
        Properties properties = this.fetchPropertiesFor("project_id");
        this.projectId = properties.getProperty("project_id");
        if (this.projectId == null || this.projectId.isEmpty()) {
            String msg = "versioneye.properties found but without project_id! Read the instructions at https://github.com/versioneye/versioneye_maven_plugin";
            this.getLog().error((CharSequence)msg);
            throw new MojoExecutionException(msg);
        }
        return this.projectId;
    }

    protected Properties fetchPropertiesFor(String key) throws Exception {
        Properties properties = this.fetchProjectProperties();
        if (properties == null || properties.getProperty(key) == null) {
            properties = this.fetchHomeProperties();
        }
        return properties;
    }

    protected Properties fetchProjectProperties() throws Exception {
        if (this.properties != null) {
            return this.properties;
        }
        String propertiesPath = this.getPropertiesPath();
        File file = new File(propertiesPath);
        if (!file.exists()) {
            this.createPropertiesFile(file);
        }
        PropertiesUtils propertiesUtils = new PropertiesUtils();
        this.properties = propertiesUtils.readProperties(propertiesPath);
        return this.properties;
    }

    protected Properties fetchHomeProperties() throws Exception {
        if (this.homeProperties != null) {
            return this.homeProperties;
        }
        String propertiesPath = this.homeDirectory + "/.m2/" + propertiesFile;
        File file = new File(propertiesPath);
        if (!file.exists() && (file = new File(propertiesPath = this.projectDirectory + "/src/main/resources/" + propertiesFile)).exists()) {
            this.getLog().warn((CharSequence)"versioneye.properties exists in src/main/resources, should be moved to src/qa/resources");
        }
        if (!file.exists()) {
            String msg = propertiesPath + " is missing! Read the instructions at " + "https://github.com/versioneye/versioneye_maven_plugin";
            this.getLog().error((CharSequence)msg);
            throw new MojoExecutionException(msg);
        }
        PropertiesUtils propertiesUtils = new PropertiesUtils();
        this.homeProperties = propertiesUtils.readProperties(propertiesPath);
        return this.homeProperties;
    }

    protected String getPropertiesPath() throws Exception {
        if (this.propertiesPath != null) {
            return this.propertiesPath;
        }
        String propertiesPath = this.projectDirectory + "/src/qa/resources/" + propertiesFile;
        File file = new File(propertiesPath);
        if (!file.exists()) {
            propertiesPath = this.projectDirectory + "/src/main/resources/" + propertiesFile;
            file = new File(propertiesPath);
        }
        if (!file.exists()) {
            propertiesPath = this.homeDirectory + "/.m2/" + propertiesFile;
            file = new File(propertiesPath);
        }
        if (!file.exists()) {
            propertiesPath = this.projectDirectory + "/src/main/resources/" + propertiesFile;
            file = new File(propertiesPath);
        }
        this.propertiesPath = propertiesPath;
        return propertiesPath;
    }

    private void createPropertiesFile(File file) throws IOException {
        File parent = file.getParentFile();
        if (!parent.exists()) {
            parent.mkdirs();
        }
        file.createNewFile();
    }

    protected void initTls() {
        TrustManager[] trustAllCerts = new TrustManager[]{new X509TrustManager(){

            public X509Certificate[] getAcceptedIssuers() {
                return null;
            }

            public void checkClientTrusted(X509Certificate[] certs, String authType) {
            }

            public void checkServerTrusted(X509Certificate[] certs, String authType) {
            }
        }};
        try {
            SSLContext sc = SSLContext.getInstance("TLS");
            sc.init(null, trustAllCerts, new SecureRandom());
            HttpsURLConnection.setDefaultSSLSocketFactory(sc.getSocketFactory());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    protected void setProxy() {
        boolean emptyProxyPass;
        boolean emptyProxyPort;
        boolean emptyProxyHost = this.proxyHost == null || this.proxyHost.isEmpty();
        boolean bl = emptyProxyPort = this.proxyPort == null || this.proxyPort.isEmpty();
        if (emptyProxyHost && emptyProxyPort) {
            return;
        }
        System.setProperty("proxySet", "true");
        System.setProperty("http.proxyHost", this.proxyHost);
        System.setProperty("http.proxyPort", this.proxyPort);
        System.setProperty("https.proxyHost", this.proxyHost);
        System.setProperty("https.proxyPort", this.proxyPort);
        boolean emptyProxyUser = this.proxyUser == null || this.proxyUser.isEmpty();
        boolean bl2 = emptyProxyPass = this.proxyPassword == null || this.proxyPassword.isEmpty();
        if (emptyProxyUser && emptyProxyPass) {
            return;
        }
        System.getProperties().put("http.proxyUser", this.proxyUser);
        System.getProperties().put("http.proxyPassword", this.proxyPassword);
    }
}

