/*
 * Decompiled with CFR 0.152.
 */
package com.vertica.io;

import com.vertica.core.VConnection;
import com.vertica.dataengine.ColumnDescription;
import com.vertica.dsi.exceptions.NumericOverflowException;
import com.vertica.io.DescriptionResponseMessage;
import com.vertica.io.MessageType;
import com.vertica.io.VStream;
import com.vertica.io.VerticaDBTypeDesc;
import java.io.IOException;
import java.util.ArrayList;

public final class RowDescriptionResponseMessage
extends DescriptionResponseMessage {
    private ArrayList<ColumnDescription> m_rowDescription;
    private int m_numColumns;

    public RowDescriptionResponseMessage(VStream vStream) {
        super(vStream);
    }

    @Override
    protected void buildMessage(int n) throws IOException {
        VConnection vConnection = this.m_vStream.getConnection();
        this.m_numColumns = this.m_vStream.ReceiveIntegerR(2);
        if (this.m_numColumns > 0) {
            this.readTypePool();
            this.m_rowDescription = new ArrayList(this.m_numColumns);
            for (int i = 0; i < this.m_numColumns; ++i) {
                String string = this.m_vStream.ReceiveString();
                long l = this.m_vStream.ReceiveLong();
                String string2 = "";
                String string3 = "";
                String string4 = "";
                if (l != 0L) {
                    string2 = this.m_vStream.ReceiveString();
                    string3 = this.m_vStream.ReceiveString();
                    string4 = vConnection.getUseThreePartNaming() ? vConnection.getDatabaseName() : "";
                }
                int n2 = this.m_vStream.ReceiveIntegerR(2);
                VerticaDBTypeDesc verticaDBTypeDesc = this.readNextTypeInfo();
                int n3 = this.m_vStream.ReceiveIntegerR(2);
                int n4 = this.m_vStream.ReceiveIntegerR(2);
                int n5 = this.m_vStream.ReceiveIntegerR(2);
                int n6 = this.m_vStream.ReceiveIntegerR(4);
                int n7 = this.m_vStream.ReceiveIntegerR(2);
                try {
                    this.m_rowDescription.add(new ColumnDescription(string, string2, string3, string4, verticaDBTypeDesc.getBaseTypeOid(), n4, n5, n6, verticaDBTypeDesc.getTypeName(n6)));
                    continue;
                }
                catch (NumericOverflowException numericOverflowException) {
                    assert (false);
                    continue;
                }
            }
        }
    }

    @Override
    public Object[] getDebugInfo() {
        Object[] objectArray = new Object[2];
        StringBuilder stringBuilder = new StringBuilder();
        for (ColumnDescription columnDescription : this.m_rowDescription) {
            stringBuilder.append("\n\t" + columnDescription.toDebugString());
        }
        objectArray[0] = this.getType();
        objectArray[1] = stringBuilder.toString();
        return objectArray;
    }

    @Override
    public MessageType getType() {
        return MessageType.RowDescription;
    }

    public ArrayList<ColumnDescription> getRowDescription() {
        return this.m_rowDescription;
    }
}

