/*
 * Decompiled with CFR 0.152.
 */
package com.vertica.jdbc.kv;

import com.vertica.jdbc.kv.KVErrors;
import com.vertica.jdbc.kv.ProjectionMetadata;
import com.vertica.util.ClientErrorException;
import com.vertica.util.TypeUtils;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.charset.Charset;
import java.sql.Connection;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.UUID;

public class VHash {
    private static final Charset UTF8 = Charset.forName("UTF-8");
    private static final long defaultInput = 200L;
    static final int NUMERIC_DSCALE_MASK = 8191;
    static final int TYPMODHEADERSZ = 4;
    long currentHash;

    static long hashBoolean(boolean bl, long l) {
        byte by = bl ? (byte)1 : 0;
        ByteBuffer byteBuffer = ByteBuffer.allocate(1);
        byteBuffer.order(ByteOrder.LITTLE_ENDIAN);
        byteBuffer.put(by).flip();
        return VHash.hashFunction(byteBuffer, l);
    }

    static long hashBooleanNull(long l) {
        byte by = 2;
        ByteBuffer byteBuffer = ByteBuffer.allocate(1);
        byteBuffer.order(ByteOrder.LITTLE_ENDIAN);
        byteBuffer.put(by).flip();
        return VHash.hashFunction(byteBuffer, l);
    }

    public static long hashBooleanNull() {
        return VHash.hashBooleanNull(200L);
    }

    public static long hashBoolean(boolean bl) {
        return VHash.hashBoolean(bl, 200L);
    }

    static long hashLong(long l, long l2) {
        ByteBuffer byteBuffer = ByteBuffer.allocate(8);
        byteBuffer.order(ByteOrder.LITTLE_ENDIAN);
        byteBuffer.putLong(l).flip();
        return VHash.hashFunction(byteBuffer, l2);
    }

    public static long hashLong(long l) {
        return VHash.hashLong(l, 200L);
    }

    public static long hashNull(long l) {
        return VHash.hashLong(Long.MIN_VALUE, l);
    }

    public static long hashNull() {
        return VHash.hashNull(200L);
    }

    public static long hashUUID(UUID uUID, long l) {
        ByteBuffer byteBuffer = ByteBuffer.allocate(16);
        byteBuffer.order(ByteOrder.BIG_ENDIAN);
        byteBuffer.putLong(uUID.getMostSignificantBits());
        byteBuffer.putLong(uUID.getLeastSignificantBits());
        byteBuffer.flip();
        byteBuffer.order(ByteOrder.LITTLE_ENDIAN);
        return VHash.hashFunction(byteBuffer, l);
    }

    public static long hashUUIDNull(long l) {
        ByteBuffer byteBuffer = ByteBuffer.allocate(16);
        byteBuffer.order(ByteOrder.LITTLE_ENDIAN);
        byteBuffer.putLong(0L);
        byteBuffer.putLong(8, 0L);
        return VHash.hashFunction(byteBuffer, l);
    }

    public static long hashUUIDNull() {
        return VHash.hashUUIDNull(200L);
    }

    static long hashDouble(double d, long l) {
        return VHash.hashLong(Double.doubleToLongBits(d), l);
    }

    static long hashDoubleNull(long l) {
        return VHash.hashLong(0x7FFFFFFFFFFFFFFEL, l);
    }

    public static long hashDouble(double d) {
        return VHash.hashDouble(d, 200L);
    }

    public static long hashDoubleNull() {
        return VHash.hashDoubleNull(200L);
    }

    static long hashTimestamp(long l, long l2) {
        long l3 = l * 1000L - 946684800000000L;
        return VHash.hashLong(l3, l2);
    }

    static long hashDate(long l, long l2) {
        int n = l % 86400000L < 0L ? -1 : 0;
        long l3 = l / 1000L / 86400L + (long)n - 10957L;
        return VHash.hashLong(l3, l2);
    }

    static long hashTime(long l, long l2) {
        long l3 = l % 86400000L * 1000L;
        return VHash.hashLong(l3, l2);
    }

    public static long hashTimestamp(long l) {
        return VHash.hashTimestamp(l, 200L);
    }

    public static long hashDate(java.util.Date date) {
        return VHash.hashDate(date.getTime(), 200L);
    }

    public static long hashDate(Date date) {
        return VHash.hashDate(date.getTime(), 200L);
    }

    public static long hashTimestamp(Timestamp timestamp) {
        return VHash.hashTimestamp(timestamp.getTime(), 200L);
    }

    public static long hashTime(Time time) {
        return VHash.hashTime(time.getTime(), 200L);
    }

    static long hashString(String string, long l) {
        ByteBuffer byteBuffer = ByteBuffer.wrap(string.getBytes(UTF8));
        byteBuffer.order(ByteOrder.LITTLE_ENDIAN);
        return VHash.hashFunction(byteBuffer, l);
    }

    static long hashStringNull(long l) {
        ByteBuffer byteBuffer = ByteBuffer.allocate(0);
        byteBuffer.flip();
        return VHash.hashFunction(byteBuffer, l ^= 0x3039L);
    }

    public static long hashString(String string) {
        return VHash.hashString(string, 200L);
    }

    public static long hashStringNull() {
        return VHash.hashStringNull(200L);
    }

    public static long hashBytesNull() {
        return VHash.hashStringNull(200L);
    }

    public static long hashBytesNull(long l) {
        return VHash.hashStringNull(l);
    }

    public static long hashBytes(byte[] byArray) {
        return VHash.hashBytes(byArray, 200L);
    }

    static long hashBytes(byte[] byArray, long l) {
        ByteBuffer byteBuffer = ByteBuffer.wrap(byArray);
        return VHash.hashFunction(byteBuffer, l);
    }

    public static long hashNumeric(BigDecimal bigDecimal, int n) {
        return VHash.hashNumeric(bigDecimal, n, 200L);
    }

    static long hashNumeric(BigDecimal bigDecimal, int n, long l) {
        ByteBuffer byteBuffer = VHash.NumericToByteBuf(bigDecimal, n);
        ByteBuffer byteBuffer2 = ByteBuffer.allocate(byteBuffer.remaining());
        byteBuffer2.order(ByteOrder.LITTLE_ENDIAN);
        while (byteBuffer.hasRemaining()) {
            long l2 = byteBuffer.getLong();
            byteBuffer2.putLong(l2);
        }
        byteBuffer2.flip();
        return VHash.hashFunction(byteBuffer2, l);
    }

    private static ByteBuffer NumericToByteBuf(BigDecimal bigDecimal, int n) {
        int n2 = VHash.getNumericWordCount(n);
        int n3 = n2 * 64 / 8;
        int n4 = VHash.getNumericScale(n);
        int n5 = VHash.getNumericPrecision(n);
        BigDecimal bigDecimal2 = BigDecimal.TEN.pow(n5 - n4);
        if (bigDecimal.abs().compareTo(bigDecimal2) >= 0) {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("numeric");
            if (n5 > 0) {
                stringBuilder.append(" (");
                stringBuilder.append(n5);
                if (n4 >= 0) {
                    stringBuilder.append(", ").append(n4);
                }
                stringBuilder.append(")");
            }
            SQLException sQLException = KVErrors.ErrCodeNumericValueOutOfRange.makeException(stringBuilder.toString());
            throw new IllegalArgumentException(sQLException.getMessage());
        }
        ByteBuffer byteBuffer = ByteBuffer.allocate(n3);
        byte[] byArray = bigDecimal.setScale(n4, RoundingMode.HALF_UP).scaleByPowerOfTen(n4).toBigInteger().toByteArray();
        if (bigDecimal.signum() < 0) {
            for (int i = 0; i < n2; ++i) {
                byteBuffer.putLong(-1L);
            }
        }
        byteBuffer.position(n3 - byArray.length);
        byteBuffer.put(byArray);
        byteBuffer.position(0);
        return byteBuffer;
    }

    private static int getNumericPrecision(int n) {
        try {
            return TypeUtils.getColumnSize(16, n);
        }
        catch (ClientErrorException clientErrorException) {
            throw new RuntimeException(clientErrorException);
        }
    }

    private static int getNumericScale(int n) {
        return n - 4 & 0x1FFF;
    }

    private static int getNumericWordCount(int n) {
        return VHash.getNumericPrecision(n) / 19 + 1;
    }

    static long hashFunction(ByteBuffer byteBuffer, long l) {
        HashValues hashValues = new HashValues();
        hashValues.b = hashValues.a = l;
        hashValues.c = -7046029254386353133L;
        while (byteBuffer.remaining() >= 24) {
            hashValues.a += byteBuffer.getLong();
            hashValues.b += byteBuffer.getLong();
            hashValues.c += byteBuffer.getLong();
            hashValues.mix();
        }
        hashValues.c += (long)byteBuffer.limit();
        switch (byteBuffer.remaining()) {
            case 23: {
                hashValues.c += (long)byteBuffer.get(byteBuffer.position() + 22) << 56;
            }
            case 22: {
                hashValues.c += (long)byteBuffer.get(byteBuffer.position() + 21) << 48;
            }
            case 21: {
                hashValues.c += (long)byteBuffer.get(byteBuffer.position() + 20) << 40;
            }
            case 20: {
                hashValues.c += (long)byteBuffer.get(byteBuffer.position() + 19) << 32;
            }
            case 19: {
                hashValues.c += (long)byteBuffer.get(byteBuffer.position() + 18) << 24;
            }
            case 18: {
                hashValues.c += (long)byteBuffer.get(byteBuffer.position() + 17) << 16;
            }
            case 17: {
                hashValues.c += (long)byteBuffer.get(byteBuffer.position() + 16) << 8;
            }
            case 16: {
                hashValues.a += byteBuffer.getLong();
                hashValues.b += byteBuffer.getLong();
                break;
            }
            case 15: {
                hashValues.b += (long)byteBuffer.get(byteBuffer.position() + 14) << 48;
            }
            case 14: {
                hashValues.b += (long)byteBuffer.get(byteBuffer.position() + 13) << 40;
            }
            case 13: {
                hashValues.b += (long)byteBuffer.get(byteBuffer.position() + 12) << 32;
            }
            case 12: {
                hashValues.b += (long)byteBuffer.get(byteBuffer.position() + 11) << 24;
            }
            case 11: {
                hashValues.b += (long)byteBuffer.get(byteBuffer.position() + 10) << 16;
            }
            case 10: {
                hashValues.b += (long)byteBuffer.get(byteBuffer.position() + 9) << 8;
            }
            case 9: {
                hashValues.b += (long)byteBuffer.get(byteBuffer.position() + 8);
            }
            case 8: {
                hashValues.a += byteBuffer.getLong();
                break;
            }
            case 7: {
                hashValues.a += (long)byteBuffer.get(byteBuffer.position() + 6) << 48;
            }
            case 6: {
                hashValues.a += (long)byteBuffer.get(byteBuffer.position() + 5) << 40;
            }
            case 5: {
                hashValues.a += (long)byteBuffer.get(byteBuffer.position() + 4) << 32;
            }
            case 4: {
                hashValues.a += (long)byteBuffer.get(byteBuffer.position() + 3) << 24;
            }
            case 3: {
                hashValues.a += (long)byteBuffer.get(byteBuffer.position() + 2) << 16;
            }
            case 2: {
                hashValues.a += (long)byteBuffer.get(byteBuffer.position() + 1) << 8;
            }
            case 1: {
                hashValues.a += (long)byteBuffer.get(byteBuffer.position() + 0);
            }
        }
        hashValues.mix();
        return hashValues.c >>> 1;
    }

    public VHash() {
        this.reset();
    }

    public void reset() {
        this.currentHash = 200L;
    }

    public void addNull() {
        this.currentHash = VHash.hashNull(this.currentHash);
    }

    public void addBoolean(boolean bl) {
        this.currentHash = VHash.hashBoolean(bl, this.currentHash);
    }

    public void addBooleanNull() {
        this.currentHash = VHash.hashBooleanNull(this.currentHash);
    }

    public void addLong(long l) {
        this.currentHash = VHash.hashLong(l, this.currentHash);
    }

    public void addUUID(UUID uUID) {
        this.currentHash = VHash.hashUUID(uUID, this.currentHash);
    }

    public void addUUIDNull() {
        this.currentHash = VHash.hashUUIDNull(this.currentHash);
    }

    public void addString(String string) {
        this.currentHash = string == null ? VHash.hashStringNull(this.currentHash) : VHash.hashString(string, this.currentHash);
    }

    public void addBytes(byte[] byArray) {
        this.currentHash = byArray == null ? VHash.hashBytesNull(this.currentHash) : VHash.hashBytes(byArray, this.currentHash);
    }

    public void addTimestamp(long l) {
        this.currentHash = VHash.hashTimestamp(l, this.currentHash);
    }

    public void addDate(java.util.Date date, Calendar calendar) {
        if (date == null) {
            this.currentHash = VHash.hashNull(this.currentHash);
        } else {
            long l = calendar.getTimeZone().getOffset(date.getTime());
            this.currentHash = VHash.hashDate(date.getTime() + l, this.currentHash);
        }
    }

    public void addDate(Date date, Calendar calendar) {
        this.addDate((java.util.Date)date, calendar);
    }

    public void addTimestamp(Timestamp timestamp, Calendar calendar) {
        this.addTimestamp((java.util.Date)timestamp, calendar);
    }

    public void addTimestamp(java.util.Date date, Calendar calendar) {
        if (date == null) {
            this.currentHash = VHash.hashNull(this.currentHash);
        } else {
            long l = calendar.getTimeZone().getOffset(date.getTime());
            this.currentHash = VHash.hashTimestamp(date.getTime() + l, this.currentHash);
        }
    }

    public void addTime(Time time, Calendar calendar) {
        this.addTime((java.util.Date)time, calendar);
    }

    public void addTime(java.util.Date date, Calendar calendar) {
        if (date == null) {
            this.currentHash = VHash.hashNull(this.currentHash);
        } else {
            long l = calendar.getTimeZone().getOffset(date.getTime());
            this.currentHash = VHash.hashTime(date.getTime() + l, this.currentHash);
        }
    }

    public void addDouble(double d) {
        this.currentHash = VHash.hashDouble(d, this.currentHash);
    }

    public void addDoubleNull() {
        this.currentHash = VHash.hashDoubleNull(this.currentHash);
    }

    public void addNumeric(BigDecimal bigDecimal, int n) {
        this.currentHash = VHash.hashNumeric(bigDecimal, n, this.currentHash);
    }

    void addByType(Object object, int n, int n2) {
        switch (n) {
            case -1: 
            case 1: 
            case 12: {
                this.addString((String)object);
                break;
            }
            case -4: 
            case -3: 
            case -2: {
                this.addBytes((byte[])object);
                break;
            }
            case 91: 
            case 92: 
            case 93: {
                if (object == null) {
                    this.addNull();
                    break;
                }
                Calendar calendar = null;
                java.util.Date date = null;
                if (object instanceof java.util.Date) {
                    calendar = Calendar.getInstance();
                    date = (java.util.Date)object;
                } else if (object instanceof Calendar) {
                    calendar = (Calendar)object;
                    date = calendar.getTime();
                } else {
                    throw new UnsupportedOperationException("SQL type " + n + " is not supported with class " + object.getClass().getName());
                }
                if (n == 91) {
                    this.addDate(date, calendar);
                    break;
                }
                if (n == 92) {
                    this.addTime(date, calendar);
                    break;
                }
                this.addTimestamp(date, calendar);
                break;
            }
            case -6: 
            case -5: 
            case 4: 
            case 5: {
                if (object == null) {
                    this.addNull();
                    break;
                }
                this.addLong(((Number)object).longValue());
                break;
            }
            case 6: 
            case 8: {
                if (object == null) {
                    this.addDoubleNull();
                    break;
                }
                this.addDouble(((Number)object).doubleValue());
                break;
            }
            case -7: 
            case 16: {
                if (object == null) {
                    this.addBooleanNull();
                    break;
                }
                this.addBoolean((Boolean)object);
                break;
            }
            case 2: {
                if (object == null) {
                    this.addNull();
                    break;
                }
                this.addNumeric((BigDecimal)object, n2);
                break;
            }
            case -11: {
                if (object == null) {
                    this.addUUIDNull();
                    break;
                }
                this.addUUID((UUID)object);
                break;
            }
            default: {
                throw new UnsupportedOperationException("SQL type " + n + " is not supported");
            }
        }
    }

    public long getHash() {
        return this.currentHash;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getNodeFor(Connection connection, String string, String string2, long l) throws SQLException {
        PreparedStatement preparedStatement = null;
        if (string == null || "".equals(string) || string2 == null || "".equals(string2)) {
            throw new IllegalArgumentException("Arguments must not be null or empty");
        }
        try {
            preparedStatement = connection.prepareStatement("select get_projection_segments(?)");
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("\"");
            stringBuilder.append(string);
            stringBuilder.append("\"");
            stringBuilder.append(".");
            stringBuilder.append("\"");
            stringBuilder.append(string2);
            stringBuilder.append("\"");
            preparedStatement.setString(1, stringBuilder.toString());
            ResultSet resultSet = preparedStatement.executeQuery();
            resultSet.next();
            String string3 = VHash.getNodeFor(resultSet.getString(1), l);
            return string3;
        }
        finally {
            if (preparedStatement != null) {
                preparedStatement.close();
            }
        }
    }

    public static String getNodeFor(String string, long l) {
        String[] stringArray;
        ProjectionMetadata projectionMetadata = new ProjectionMetadata("dummy", "dummy", "dummy", true);
        if (string != null && !"".equals(string.trim()) && (stringArray = string.split("\n")).length == 3) {
            String[] stringArray2 = stringArray[0].split("\\|");
            String[] stringArray3 = stringArray[1].split("\\|");
            String[] stringArray4 = stringArray[2].split("\\|");
            if (stringArray2.length == stringArray3.length && stringArray2.length == stringArray4.length) {
                for (int i = 0; i < stringArray2.length; ++i) {
                    long l2 = Long.parseLong(stringArray4[i]);
                    long l3 = Long.parseLong(stringArray3[i]);
                    projectionMetadata.addSegment(stringArray2[i], l2, l3);
                }
                return projectionMetadata.getNodeFor(l);
            }
        }
        throw new IllegalArgumentException("Incorrect get_projection_segments output. Projection must be segmented by HASH() ALL NODES");
    }

    static class HashValues {
        long a;
        long b;
        long c;

        HashValues() {
        }

        void mix() {
            this.a -= this.b;
            this.a -= this.c;
            this.a ^= this.c >>> 43;
            this.b -= this.c;
            this.b -= this.a;
            this.b ^= this.a << 9;
            this.c -= this.a;
            this.c -= this.b;
            this.c ^= this.b >>> 8;
            this.a -= this.b;
            this.a -= this.c;
            this.a ^= this.c >>> 38;
            this.b -= this.c;
            this.b -= this.a;
            this.b ^= this.a << 23;
            this.c -= this.a;
            this.c -= this.b;
            this.c ^= this.b >>> 5;
            this.a -= this.b;
            this.a -= this.c;
            this.a ^= this.c >>> 35;
            this.b -= this.c;
            this.b -= this.a;
            this.b ^= this.a << 49;
            this.c -= this.a;
            this.c -= this.b;
            this.c ^= this.b >>> 11;
            this.a -= this.b;
            this.a -= this.c;
            this.a ^= this.c >>> 12;
            this.b -= this.c;
            this.b -= this.a;
            this.b ^= this.a << 18;
            this.c -= this.a;
            this.c -= this.b;
            this.c ^= this.b >>> 22;
        }

        void print() {
            System.out.println("a: " + Long.toHexString(this.a));
            System.out.println("b: " + Long.toHexString(this.b));
            System.out.println("c: " + Long.toHexString(this.c));
        }
    }
}

