/*
 * Decompiled with CFR 0.152.
 */
package com.vertica.jdbc.common;

import com.vertica.dsi.dataengine.utilities.ParameterMetadata;
import com.vertica.dsi.dataengine.utilities.TypeMetadata;
import com.vertica.dsi.dataengine.utilities.TypeUtilities;
import com.vertica.exceptions.ExceptionConverter;
import com.vertica.exceptions.JDBCMessageKey;
import com.vertica.jdbc.common.utilities.WrapperUtilities;
import com.vertica.support.ILogger;
import com.vertica.support.IWarningListener;
import com.vertica.support.LogUtilities;
import com.vertica.support.exceptions.ExceptionType;
import com.vertica.utilities.TypeNames;
import java.sql.ParameterMetaData;
import java.sql.SQLException;
import java.util.ArrayList;

public abstract class SParameterMetaData
implements ParameterMetaData {
    private ArrayList<ParameterMetadata> m_parameterMetadata = new ArrayList();
    private boolean m_isOpen = false;
    private ILogger m_logger = null;
    private IWarningListener m_warningListener = null;

    protected SParameterMetaData(ArrayList<ParameterMetadata> metadata, ILogger logger, IWarningListener warningListener) {
        this.m_logger = logger;
        LogUtilities.logFunctionEntrance(this.m_logger, metadata, logger);
        this.m_warningListener = warningListener;
        this.m_isOpen = true;
        this.m_parameterMetadata = metadata;
    }

    @Override
    public String getParameterClassName(int paramIndex) throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.m_logger, paramIndex);
            this.checkIfOpen();
            int paramType = this.getParameterType(paramIndex);
            return TypeNames.getTypeClassName(paramType);
        }
        catch (Exception e) {
            throw ExceptionConverter.getInstance().toSQLException(e, this.m_warningListener, this.m_logger);
        }
    }

    @Override
    public int getParameterCount() throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
            this.checkIfOpen();
            return this.m_parameterMetadata.size();
        }
        catch (Exception e) {
            throw ExceptionConverter.getInstance().toSQLException(e, this.m_warningListener, this.m_logger);
        }
    }

    @Override
    public int getParameterMode(int paramIndex) throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.m_logger, paramIndex);
            this.checkIfOpen();
            switch (this.getParameterMetadata(paramIndex).getParameterType()) {
                case INPUT: {
                    return 1;
                }
                case OUTPUT: {
                    return 4;
                }
                case INPUT_OUTPUT: {
                    return 2;
                }
            }
            return 0;
        }
        catch (Exception e) {
            throw ExceptionConverter.getInstance().toSQLException(e, this.m_warningListener, this.m_logger);
        }
    }

    @Override
    public int getParameterType(int paramIndex) throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.m_logger, paramIndex);
            this.checkIfOpen();
            TypeMetadata typeMeta = this.getTypeMetadata(paramIndex);
            return typeMeta.getType();
        }
        catch (Exception e) {
            throw ExceptionConverter.getInstance().toSQLException(e, this.m_warningListener, this.m_logger);
        }
    }

    @Override
    public String getParameterTypeName(int paramIndex) throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.m_logger, paramIndex);
            this.checkIfOpen();
            TypeMetadata typeMeta = this.getTypeMetadata(paramIndex);
            return typeMeta.getTypeName();
        }
        catch (Exception e) {
            throw ExceptionConverter.getInstance().toSQLException(e, this.m_warningListener, this.m_logger);
        }
    }

    @Override
    public int getPrecision(int paramIndex) throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.m_logger, paramIndex);
            this.checkIfOpen();
            ParameterMetadata paramMeta = this.getParameterMetadata(paramIndex);
            TypeMetadata typeMeta = paramMeta.getTypeMetadata();
            short sqlType = typeMeta.getType();
            if (typeMeta.isCharacterOrBinaryType()) {
                long len = paramMeta.getColumnLength();
                return len > Integer.MAX_VALUE ? Integer.MAX_VALUE : (int)len;
            }
            if (91 == sqlType || 92 == sqlType || 93 == sqlType) {
                return (int)TypeUtilities.getDisplaySize(typeMeta, 0L);
            }
            if (typeMeta.isIntervalType()) {
                return typeMeta.getIntervalPrecision();
            }
            return typeMeta.getPrecision();
        }
        catch (Exception e) {
            throw ExceptionConverter.getInstance().toSQLException(e, this.m_warningListener, this.m_logger);
        }
    }

    @Override
    public int getScale(int paramIndex) throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.m_logger, paramIndex);
            this.checkIfOpen();
            TypeMetadata typeMeta = this.getTypeMetadata(paramIndex);
            return typeMeta.getScale();
        }
        catch (Exception e) {
            throw ExceptionConverter.getInstance().toSQLException(e, this.m_warningListener, this.m_logger);
        }
    }

    @Override
    public int isNullable(int paramIndex) throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.m_logger, paramIndex);
            this.checkIfOpen();
            ParameterMetadata paramMeta = this.getParameterMetadata(paramIndex);
            switch (paramMeta.getNullable()) {
                case NO_NULLS: {
                    return 0;
                }
                case NULLABLE: {
                    return 1;
                }
            }
            return 2;
        }
        catch (Exception e) {
            throw ExceptionConverter.getInstance().toSQLException(e, this.m_warningListener, this.m_logger);
        }
    }

    @Override
    public boolean isSigned(int paramIndex) throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.m_logger, paramIndex);
            this.checkIfOpen();
            TypeMetadata typeMeta = this.getTypeMetadata(paramIndex);
            return typeMeta.isSigned();
        }
        catch (Exception e) {
            throw ExceptionConverter.getInstance().toSQLException(e, this.m_warningListener, this.m_logger);
        }
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        return WrapperUtilities.isWrapperFor(iface, this);
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        return WrapperUtilities.unwrap(iface, this);
    }

    protected synchronized void close() {
        this.m_isOpen = false;
    }

    private synchronized void checkIfOpen() throws SQLException {
        if (!this.m_isOpen) {
            SQLException exception = ExceptionConverter.getInstance().toSQLException(JDBCMessageKey.PARAMMETA_CLOSED, this.m_warningListener, ExceptionType.NON_TRANSIENT, new Object[0]);
            LogUtilities.logError(exception, this.m_logger);
            throw exception;
        }
    }

    private ParameterMetadata getParameterMetadata(int paramIndex) throws SQLException {
        if (!this.isValidIndex(paramIndex)) {
            SQLException exception = ExceptionConverter.getInstance().toSQLException(JDBCMessageKey.INVALID_PARAM_INDEX, this.m_warningListener, ExceptionType.DEFAULT, String.valueOf(paramIndex));
            LogUtilities.logError(exception, this.m_logger);
            throw exception;
        }
        return this.m_parameterMetadata.get(paramIndex - 1);
    }

    private TypeMetadata getTypeMetadata(int paramIndex) throws SQLException {
        ParameterMetadata paramMeta = this.getParameterMetadata(paramIndex);
        return paramMeta.getTypeMetadata();
    }

    private boolean isValidIndex(int paramIndex) {
        return 0 < paramIndex && this.m_parameterMetadata.size() >= paramIndex;
    }
}

