/*
 * Decompiled with CFR 0.152.
 */
package com.vertica.support.conv;

import com.vertica.support.Pair;
import com.vertica.support.conv.ApproxNumConverter;
import com.vertica.support.conv.ConversionResult;
import com.vertica.support.conv.IntegralConverter;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.math.RoundingMode;

public class ExactNumConverter {
    private ExactNumConverter() {
        throw new UnsupportedOperationException();
    }

    public static Pair<Short, Short> calculateSQLPrecisionScale(BigDecimal data, ConversionResult cr) {
        int sourcePrec;
        if (data.compareTo(BigDecimal.ZERO) == 0) {
            cr.setState(ConversionResult.TypeConversionState.SUCCESS);
            return new Pair<Short, Short>((short)1, (short)0);
        }
        int sourceScale = data.scale() < 0 ? 0 : data.scale();
        int n = sourcePrec = data.scale() < 0 ? data.precision() - data.scale() : data.precision();
        if (0 > sourcePrec || Short.MAX_VALUE < sourcePrec) {
            cr.setState(ConversionResult.TypeConversionState.NUMERIC_OUT_OF_RANGE_TOO_LARGE);
        } else if (Short.MAX_VALUE < sourceScale) {
            cr.setState(ConversionResult.TypeConversionState.FRAC_TRUNCATION_ROUNDED_DOWN);
            sourceScale = Short.MAX_VALUE;
        } else {
            cr.setState(ConversionResult.TypeConversionState.SUCCESS);
        }
        return new Pair<Short, Short>((short)sourcePrec, (short)sourceScale);
    }

    public static boolean toBoolean(BigDecimal source, ConversionResult conversionResult) {
        int compOne = source.compareTo(BigDecimal.ONE);
        int compZ = source.compareTo(BigDecimal.ZERO);
        if (0 == compOne) {
            conversionResult.setState(ConversionResult.TypeConversionState.SUCCESS);
            return true;
        }
        if (0 == compZ) {
            conversionResult.setState(ConversionResult.TypeConversionState.SUCCESS);
            return false;
        }
        if (0 < compOne) {
            conversionResult.setState(ConversionResult.TypeConversionState.NUMERIC_OUT_OF_RANGE_TOO_LARGE);
            return true;
        }
        conversionResult.setState(ConversionResult.TypeConversionState.NUMERIC_OUT_OF_RANGE_TOO_SMALL);
        return true;
    }

    public static double toDouble(BigDecimal source, ConversionResult conversionResult) {
        double result = source.doubleValue();
        if (Double.POSITIVE_INFINITY == result) {
            conversionResult.setState(ConversionResult.TypeConversionState.NUMERIC_OUT_OF_RANGE_TOO_LARGE);
        } else if (Double.NEGATIVE_INFINITY == result) {
            conversionResult.setState(ConversionResult.TypeConversionState.NUMERIC_OUT_OF_RANGE_TOO_SMALL);
        } else {
            conversionResult.setState(ConversionResult.TypeConversionState.SUCCESS);
        }
        return result;
    }

    public static float toFloat(BigDecimal source, ConversionResult res) {
        double dub = ExactNumConverter.toDouble(source, res);
        if (ConversionResult.TypeConversionState.SUCCESS != res.getState()) {
            return (float)dub;
        }
        return ApproxNumConverter.toFloat(dub, res);
    }

    public static String toChar(BigDecimal input, long targetLength, ConversionResult out_result) {
        String result = input.toString();
        if ((long)result.length() <= targetLength) {
            out_result.setState(ConversionResult.TypeConversionState.SUCCESS);
        } else {
            out_result.setState(ConversionResult.TypeConversionState.STRING_RIGHT_TRUNCATION);
            result = result.substring(0, (int)targetLength);
        }
        return result;
    }

    public static BigInteger toBigInt(BigDecimal input, boolean targetSigned, ConversionResult cr) {
        BigInteger bigInteger = input.toBigInteger();
        BigInteger result = IntegralConverter.toBigInt(bigInteger, targetSigned, cr);
        if (ConversionResult.TypeConversionState.SUCCESS == cr.getState()) {
            int cmp = input.remainder(BigDecimal.ONE).compareTo(BigDecimal.ZERO);
            if (cmp > 0) {
                cr.setState(ConversionResult.TypeConversionState.FRAC_TRUNCATION_ROUNDED_DOWN);
            } else if (cmp < 0) {
                cr.setState(ConversionResult.TypeConversionState.FRAC_TRUNCATION_ROUNDED_UP);
            }
            return result;
        }
        return null;
    }

    public static long toInteger(BigDecimal input, boolean targetSigned, ConversionResult cr) {
        BigInteger bigInteger = input.toBigInteger();
        long result = IntegralConverter.toInteger(bigInteger, targetSigned, cr);
        if (ConversionResult.TypeConversionState.SUCCESS == cr.getState()) {
            int cmp = input.remainder(BigDecimal.ONE).compareTo(BigDecimal.ZERO);
            if (cmp > 0) {
                cr.setState(ConversionResult.TypeConversionState.FRAC_TRUNCATION_ROUNDED_DOWN);
            } else if (cmp < 0) {
                cr.setState(ConversionResult.TypeConversionState.FRAC_TRUNCATION_ROUNDED_UP);
            }
        }
        return result;
    }

    public static int toSmallInt(BigDecimal input, boolean targetSigned, ConversionResult cr) {
        BigInteger bigInteger = input.toBigInteger();
        int result = IntegralConverter.toSmallInt(bigInteger, targetSigned, cr);
        if (ConversionResult.TypeConversionState.SUCCESS == cr.getState()) {
            int cmp = input.remainder(BigDecimal.ONE).compareTo(BigDecimal.ZERO);
            if (cmp > 0) {
                cr.setState(ConversionResult.TypeConversionState.FRAC_TRUNCATION_ROUNDED_DOWN);
            } else if (cmp < 0) {
                cr.setState(ConversionResult.TypeConversionState.FRAC_TRUNCATION_ROUNDED_UP);
            }
        }
        return result;
    }

    public static short toTinyInt(BigDecimal input, boolean targetSigned, ConversionResult cr) {
        BigInteger bigInteger = input.toBigInteger();
        short result = IntegralConverter.toTinyInt(bigInteger, targetSigned, cr);
        if (ConversionResult.TypeConversionState.SUCCESS == cr.getState()) {
            int cmp = input.remainder(BigDecimal.ONE).compareTo(BigDecimal.ZERO);
            if (cmp > 0) {
                cr.setState(ConversionResult.TypeConversionState.FRAC_TRUNCATION_ROUNDED_DOWN);
            } else if (cmp < 0) {
                cr.setState(ConversionResult.TypeConversionState.FRAC_TRUNCATION_ROUNDED_UP);
            }
        }
        return result;
    }

    public static BigDecimal setPrecScale(BigDecimal input, short precision, short scale, ConversionResult out_convRes) {
        int targetIntPrec;
        if (precision < 1 || scale > precision || scale < 0) {
            throw new IllegalArgumentException("Invalid precision scale");
        }
        ConversionResult res = new ConversionResult();
        Pair<Short, Short> sourcePrecScale = ExactNumConverter.calculateSQLPrecisionScale(input, res);
        if (ConversionResult.TypeConversionState.SUCCESS != res.getState()) {
            out_convRes.setState(res.getState());
            return null;
        }
        int sourceIntPrec = sourcePrecScale.key() - sourcePrecScale.value();
        if (sourceIntPrec > (targetIntPrec = precision - scale)) {
            if (input.compareTo(BigDecimal.ZERO) < 0) {
                out_convRes.setState(ConversionResult.TypeConversionState.NUMERIC_OUT_OF_RANGE_TOO_SMALL);
            } else {
                out_convRes.setState(ConversionResult.TypeConversionState.NUMERIC_OUT_OF_RANGE_TOO_LARGE);
            }
            return null;
        }
        if (sourcePrecScale.value() <= scale) {
            out_convRes.setState(ConversionResult.TypeConversionState.SUCCESS);
            return input;
        }
        BigDecimal ret = input.setScale((int)scale, RoundingMode.DOWN);
        int comp = input.compareTo(ret);
        if (comp < 0) {
            out_convRes.setState(ConversionResult.TypeConversionState.FRAC_TRUNCATION_ROUNDED_UP);
        } else if (comp == 0) {
            out_convRes.setState(ConversionResult.TypeConversionState.SUCCESS);
        } else {
            out_convRes.setState(ConversionResult.TypeConversionState.FRAC_TRUNCATION_ROUNDED_DOWN);
        }
        return ret;
    }
}

