/*
 * Decompiled with CFR 0.152.
 */
package com.vertica.io;

import com.vertica.core.VConnection;
import com.vertica.dataengine.ColumnDescription;
import com.vertica.dataengine.ColumnDescriptionFactory;
import com.vertica.dsi.exceptions.NumericOverflowException;
import com.vertica.io.DescriptionResponseMessage;
import com.vertica.io.MessageType;
import com.vertica.io.VStream;
import com.vertica.io.VerticaDBTypeDesc;
import com.vertica.util.ClientErrorException;
import com.vertica.util.Features;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Hashtable;

public final class RowDescriptionResponseMessage
extends DescriptionResponseMessage {
    private ArrayList<ColumnDescription> m_rowDescription;
    private int m_numColumns;
    private boolean m_protocolSupportForTypeParents;

    public RowDescriptionResponseMessage(VStream vStream) {
        super(vStream);
        this.m_protocolSupportForTypeParents = Features.isSupported(Features.Feature.ComplexTypes, this.m_vStream.getConnection().getEffectiveProtocolVersion());
    }

    @Override
    protected void buildMessage(int n) throws IOException, ClientErrorException {
        VConnection vConnection = this.m_vStream.getConnection();
        this.m_numColumns = this.m_vStream.ReceiveIntegerR(2);
        if (this.m_numColumns > 0) {
            this.readTypePool();
            this.readRowDescription(vConnection);
        }
    }

    private void readRowDescription(VConnection vConnection) throws IOException, ClientErrorException {
        this.m_rowDescription = new ArrayList(this.m_numColumns);
        Hashtable<ColumnDescriptionKey, ColumnDescription> hashtable = new Hashtable<ColumnDescriptionKey, ColumnDescription>(this.m_numColumns);
        for (int i = 0; i < this.m_numColumns; ++i) {
            ColumnDescription columnDescription;
            String string = this.m_vStream.ReceiveString();
            long l = this.m_vStream.ReceiveLong();
            String string2 = "";
            String string3 = "";
            String string4 = "";
            if (l != 0L) {
                string2 = this.m_vStream.ReceiveString();
                string3 = this.m_vStream.ReceiveString();
                string4 = vConnection.getUseThreePartNaming() ? vConnection.getDatabaseName() : "";
            }
            int n = this.m_vStream.ReceiveIntegerR(2);
            int n2 = 0;
            if (this.m_protocolSupportForTypeParents) {
                n2 = this.m_vStream.ReceiveIntegerR(2);
            }
            VerticaDBTypeDesc verticaDBTypeDesc = this.readNextTypeInfo();
            int n3 = this.m_vStream.ReceiveIntegerR(2);
            int n4 = this.m_vStream.ReceiveIntegerR(2);
            int n5 = this.m_vStream.ReceiveIntegerR(2);
            int n6 = this.m_vStream.ReceiveIntegerR(4);
            int n7 = this.m_vStream.ReceiveIntegerR(2);
            try {
                columnDescription = ColumnDescriptionFactory.createColumnDescription(string, string2, string3, string4, verticaDBTypeDesc.getBaseTypeOid(), n4, n5, n6, n7, verticaDBTypeDesc.getTypeName(n6), n2, l, n);
            }
            catch (NumericOverflowException numericOverflowException) {
                throw new ClientErrorException(numericOverflowException.getMessage());
            }
            hashtable.put(new ColumnDescriptionKey(l, n), columnDescription);
            if (n2 == 0) {
                this.m_rowDescription.add(columnDescription);
                continue;
            }
            if (this.jsonComplexTypes()) continue;
            ColumnDescription columnDescription2 = (ColumnDescription)hashtable.get(new ColumnDescriptionKey(l, n2));
            if (columnDescription2 == null) {
                throw new ClientErrorException("Complex type parent column not found: parentColumn = " + n2 + ", tableObjectID = " + l);
            }
            columnDescription2.addChildColumn(columnDescription);
        }
    }

    @Override
    public Object[] getDebugInfo() {
        Object[] objectArray = new Object[2];
        StringBuilder stringBuilder = new StringBuilder();
        for (ColumnDescription columnDescription : this.m_rowDescription) {
            stringBuilder.append("\n\t" + columnDescription.toDebugString());
        }
        objectArray[0] = this.getType();
        objectArray[1] = stringBuilder.toString();
        return objectArray;
    }

    @Override
    public MessageType getType() {
        return MessageType.RowDescription;
    }

    public ArrayList<ColumnDescription> getRowDescription() {
        return this.m_rowDescription;
    }

    private class ColumnDescriptionKey {
        private long m_tableObjectId;
        private int m_columnId;

        public ColumnDescriptionKey(long l, int n) {
            this.m_tableObjectId = l;
            this.m_columnId = n;
        }

        public boolean equals(Object object) {
            if (object == null) {
                return false;
            }
            if (this == object) {
                return true;
            }
            if (this.getClass() != object.getClass()) {
                return false;
            }
            ColumnDescriptionKey columnDescriptionKey = (ColumnDescriptionKey)object;
            return this.m_tableObjectId == columnDescriptionKey.getTableObjectId() && this.m_columnId == columnDescriptionKey.getColumnId();
        }

        public int hashCode() {
            Long l = this.m_tableObjectId;
            return l.hashCode() * 31 + this.m_columnId;
        }

        public String toString() {
            return "TableOid: " + this.m_tableObjectId + " ColumnId: " + this.m_columnId;
        }

        public long getTableObjectId() {
            return this.m_tableObjectId;
        }

        public int getColumnId() {
            return this.m_columnId;
        }
    }
}

