/*
 * Decompiled with CFR 0.152.
 */
package com.vertica.jdbc.jdbc42;

import com.vertica.dsi.core.interfaces.IStatement;
import com.vertica.dsi.core.utilities.Variant;
import com.vertica.dsi.dataengine.interfaces.IResultSet;
import com.vertica.exceptions.ExceptionConverter;
import com.vertica.exceptions.JDBCMessageKey;
import com.vertica.jdbc.common.SConnection;
import com.vertica.jdbc.common.SForwardResultSet;
import com.vertica.jdbc.common.SStatement;
import com.vertica.jdbc.jdbc41.S41Statement;
import com.vertica.jdbc.jdbc42.S42ForwardResultSet;
import com.vertica.jdbc.jdbc42.S42UpdatableForwardResultSet;
import com.vertica.support.IWarningListener;
import com.vertica.support.LogUtilities;
import com.vertica.support.Pair;
import com.vertica.support.exceptions.ExceptionType;
import com.vertica.utilities.JDBCVersion;
import java.sql.BatchUpdateException;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Collections;
import java.util.List;

public class S42Statement
extends S41Statement {
    private long m_longTotal = Long.MAX_VALUE;

    public S42Statement(IStatement statement, SConnection conn, int concurrency) {
        super(statement, conn, concurrency);
        this.m_jdbcVersion = JDBCVersion.JDBC42;
    }

    @Override
    protected ResultSet createResultSet(IResultSet internalResultSet, boolean updatable, int fetchSize) throws SQLException {
        SForwardResultSet resultSet = updatable ? new S42UpdatableForwardResultSet(this, internalResultSet, this.getLogger()) : new S42ForwardResultSet(this, internalResultSet, this.getLogger());
        resultSet.setFetchSize(fetchSize);
        return resultSet;
    }

    @Override
    public synchronized long[] executeLargeBatch() throws SQLException, BatchUpdateException {
        try {
            this.executeAnyBatch();
            return this.processLargeBatchResults(this.m_queryExecutor.getResults(), Collections.<Pair<Integer, SQLException>>emptyList(), SStatement.BatchType.MULTI_STATEMENT);
        }
        catch (Exception e) {
            throw ExceptionConverter.getInstance().toSQLException(e, this.m_warningListener, this.m_logger);
        }
    }

    protected static BatchUpdateException largeBatchException(List<SQLException> errorExceptions, long[] ret) {
        return SStatement.largeBatchException(errorExceptions, ret);
    }

    @Override
    public synchronized long executeLargeUpdate(String sql) throws SQLException {
        try {
            return this.executeAnyUpdate(sql);
        }
        catch (Exception e) {
            throw ExceptionConverter.getInstance().toSQLException(e, this.m_warningListener, this.m_logger);
        }
    }

    @Override
    public synchronized long executeLargeUpdate(String sql, int autoGeneratedKeys) throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.m_logger, sql, autoGeneratedKeys);
            this.checkIfOpen();
            if (autoGeneratedKeys == 2 || !S42Statement.isInsertStatement(sql)) {
                return this.executeLargeUpdate(sql);
            }
            throw ExceptionConverter.getInstance().toSQLException(JDBCMessageKey.DRIVER_NOT_CAPABLE, (IWarningListener)this.m_warningListener, ExceptionType.FEATURE_NOT_IMPLEMENTED, new Object[0]);
        }
        catch (Exception e) {
            throw ExceptionConverter.getInstance().toSQLException(e, this.m_warningListener, this.m_logger);
        }
    }

    @Override
    public synchronized long executeLargeUpdate(String sql, int[] columnIndexes) throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.m_logger, sql, columnIndexes);
            this.checkIfOpen();
            if (!S42Statement.isInsertStatement(sql)) {
                return this.executeLargeUpdate(sql);
            }
            throw ExceptionConverter.getInstance().toSQLException(JDBCMessageKey.DRIVER_NOT_CAPABLE, (IWarningListener)this.m_warningListener, ExceptionType.FEATURE_NOT_IMPLEMENTED, new Object[0]);
        }
        catch (Exception e) {
            throw ExceptionConverter.getInstance().toSQLException(e, this.m_warningListener, this.m_logger);
        }
    }

    @Override
    public synchronized long executeLargeUpdate(String sql, String[] columnNames) throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.m_logger, sql, columnNames);
            this.checkIfOpen();
            if (!S42Statement.isInsertStatement(sql)) {
                return this.executeLargeUpdate(sql);
            }
            throw ExceptionConverter.getInstance().toSQLException(JDBCMessageKey.DRIVER_NOT_CAPABLE, (IWarningListener)this.m_warningListener, ExceptionType.FEATURE_NOT_IMPLEMENTED, new Object[0]);
        }
        catch (Exception e) {
            throw ExceptionConverter.getInstance().toSQLException(e, this.m_warningListener, this.m_logger);
        }
    }

    @Override
    public synchronized long getLargeMaxRows() throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
            this.checkIfOpen();
            Variant var = this.m_statement.getProperty(2);
            long maxRows = var.getLong();
            if (Long.MAX_VALUE < maxRows || Long.MIN_VALUE > maxRows) {
                return 0L;
            }
            return maxRows;
        }
        catch (Exception e) {
            throw ExceptionConverter.getInstance().toSQLException(e, this.m_warningListener, this.m_logger);
        }
    }

    @Override
    public synchronized long getLargeUpdateCount() throws SQLException {
        return this.getAnyUpdateCount();
    }

    @Override
    public synchronized void setLargeMaxRows(long max) throws SQLException {
        this.setAnyMaxRows(max);
    }
}

