/*
 * Decompiled with CFR 0.152.
 */
package com.vertica.util;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.vertica.dataengine.ColumnDescription;
import com.vertica.dsi.dataengine.impl.DSIArray;
import com.vertica.dsi.dataengine.interfaces.IArray;
import com.vertica.dsi.dataengine.interfaces.IColumn;
import com.vertica.dsi.dataengine.utilities.TypeMetadata;
import com.vertica.support.exceptions.DiagState;
import com.vertica.support.exceptions.ErrorException;
import com.vertica.util.TypeUtils;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.NoSuchElementException;

public class VerticaArray
extends DSIArray {
    private static final String NULL_ARRAY_ELEMENT = "null";
    JsonArray m_jsonArray;
    protected Object[] m_dataArray;
    protected int m_length;
    private ColumnDescription m_arrayColumn;
    private Class m_arrayClass;
    private ColumnDescription m_baseArrayColumn;
    private int m_baseColumnType;
    private ColumnDescription m_typeArrayColumn;

    public VerticaArray(JsonArray jsonArray, ColumnDescription columnDescription) throws ClassCastException, ErrorException, UnsupportedEncodingException {
        this.initialize(jsonArray, columnDescription);
        this.m_dataArray = TypeUtils.parseArray(this.m_arrayColumn, this.m_jsonArray);
    }

    public VerticaArray(Object[] objectArray, JsonArray jsonArray, ColumnDescription columnDescription) throws ClassCastException, ErrorException {
        this.initialize(jsonArray, columnDescription);
        this.m_dataArray = objectArray;
    }

    private void initialize(JsonArray jsonArray, ColumnDescription columnDescription) throws ClassCastException, ErrorException {
        int n = VerticaArray.getColumnType(columnDescription);
        if (n != 2003) {
            throw new ClassCastException("ArrayMetadata mismatch expected 2003 received " + n);
        }
        this.m_jsonArray = jsonArray;
        this.m_arrayClass = TypeUtils.getClassForColumn(columnDescription);
        this.m_dataArray = null;
        this.m_length = this.m_jsonArray != null ? this.m_jsonArray.size() : 0;
        this.m_arrayColumn = columnDescription;
        this.m_baseArrayColumn = VerticaArray.getBaseArrayColumn(this.m_arrayColumn);
        this.m_typeArrayColumn = this.findTypeArrayColumn(this.m_arrayColumn);
        this.m_baseColumnType = VerticaArray.getColumnType(this.m_baseArrayColumn);
    }

    private static int getColumnType(IColumn iColumn) throws ErrorException {
        TypeMetadata typeMetadata = iColumn.getTypeMetadata();
        if (typeMetadata == null) {
            throw new ErrorException(DiagState.DIAG_GENERAL_ERROR, "Invalid Type Definition.  There is no type metadata.", -1);
        }
        return typeMetadata.getType();
    }

    private ColumnDescription findTypeArrayColumn(ColumnDescription columnDescription) throws ErrorException {
        ColumnDescription columnDescription2 = columnDescription;
        while (VerticaArray.getColumnType(columnDescription2) == 2003) {
            columnDescription2 = VerticaArray.getBaseArrayColumn(columnDescription2);
            assert (columnDescription2 != null);
        }
        return columnDescription2;
    }

    private static ColumnDescription getBaseArrayColumn(ColumnDescription columnDescription) throws ErrorException {
        TypeMetadata typeMetadata = columnDescription.getTypeMetadata();
        if (typeMetadata == null) {
            throw new ErrorException(DiagState.DIAG_GENERAL_ERROR, "Invalid Type Definition.  There is no type metadata.", -1);
        }
        ArrayList<IColumn> arrayList = typeMetadata.getNestedColumnList();
        if (arrayList == null) {
            throw new ErrorException(DiagState.DIAG_GENERAL_ERROR, "Invalid Type Definition.  There is no nested column list.", -1);
        }
        if (arrayList.size() != 1) {
            throw new ErrorException(DiagState.DIAG_GENERAL_ERROR, 101, "Invalid Type Definition.  There should only be one nested column.");
        }
        IColumn iColumn = arrayList.get(0);
        assert (iColumn instanceof ColumnDescription);
        return (ColumnDescription)iColumn;
    }

    private boolean isMultidimensional() {
        return this.m_baseColumnType == 2003;
    }

    @Override
    public Object createArray(long l, int n) throws ErrorException {
        if (l + (long)n > Integer.MAX_VALUE) {
            throw new IndexOutOfBoundsException("Requested range exceeds the maximum integer value 2147483647.");
        }
        int n2 = (int)l;
        if (n2 < 0) {
            throw new IndexOutOfBoundsException("Offset " + n2 + " may not be less than zero.");
        }
        if (n2 >= this.m_length && this.m_jsonArray == null) {
            if (this.isMultidimensional()) {
                return new VerticaArray[0];
            }
            return Array.newInstance(this.m_arrayClass.getComponentType(), 0);
        }
        if (n2 + n >= this.m_length) {
            throw new IndexOutOfBoundsException("Requested array elements exceed the length of the array.");
        }
        int n3 = this.m_length - n2;
        if (n != -1 && n < n3) {
            n3 = n;
        }
        if (this.isMultidimensional()) {
            VerticaArray[] verticaArrayArray = new VerticaArray[n3];
            for (int i = n2; i < n2 + n3; ++i) {
                JsonElement jsonElement = this.m_jsonArray.get(i);
                if (jsonElement.isJsonNull()) {
                    verticaArrayArray[i] = new VerticaArray(null, null, this.m_baseArrayColumn);
                    continue;
                }
                Object[] objectArray = this.getMulitdimensionalArrayElement(i);
                if (!jsonElement.isJsonArray()) {
                    throw new ErrorException(DiagState.DIAG_GENERAL_ERROR, 101, "Array Expected.");
                }
                verticaArrayArray[i] = new VerticaArray(objectArray, jsonElement.getAsJsonArray(), this.m_baseArrayColumn);
            }
            return verticaArrayArray;
        }
        if (n2 > 0 || n3 != this.m_length) {
            Class<?> clazz = this.m_arrayClass.getComponentType();
            Object object = Array.newInstance(clazz, n3);
            System.arraycopy(this.m_dataArray, n2, object, 0, n3);
            return object;
        }
        return this.m_dataArray;
    }

    private Object[] getMulitdimensionalArrayElement(int n) throws ErrorException {
        if (!(this.m_dataArray[n] instanceof Object[])) {
            throw new ErrorException(DiagState.DIAG_GENERAL_ERROR, 101, "Data array Expected.");
        }
        return (Object[])this.m_dataArray[n];
    }

    @Override
    protected Iterator<?> createIterator(long l, int n) {
        if (l >= (long)this.m_length) {
            return Collections.emptyList().iterator();
        }
        int n2 = (int)l;
        int n3 = this.m_length - n2;
        if (-1L != (long)n && n < n3) {
            n3 = n;
        }
        if (this.isMultidimensional()) {
            return new MultidimensionalArrayIterator(n2, n3);
        }
        return new SingleDimensionalArrayIterator(this.m_dataArray, n2, n3);
    }

    @Override
    public IColumn getBaseColumn() {
        return this.m_baseArrayColumn;
    }

    @Override
    public String getStringRepresentation() {
        return this.m_jsonArray != null ? this.m_jsonArray.toString() : NULL_ARRAY_ELEMENT;
    }

    public String toString() {
        return this.getStringRepresentation();
    }

    protected final class SingleDimensionalArrayIterator
    implements Iterator<Object> {
        private int m_currentElement;
        private int m_count;
        private Object[] m_data;

        public SingleDimensionalArrayIterator(Object[] objectArray, int n, int n2) {
            this.m_data = objectArray;
            this.m_currentElement = n;
            this.m_count = n2;
        }

        @Override
        public boolean hasNext() {
            return this.m_currentElement < this.m_count;
        }

        @Override
        public Object next() {
            if (this.m_currentElement >= this.m_count) {
                throw new NoSuchElementException();
            }
            Object object = Array.get(this.m_data, this.m_currentElement);
            ++this.m_currentElement;
            assert (!(object instanceof IArray)) : "IArray provided.";
            assert (!(object instanceof java.sql.Array)) : "java.sql.Array provided.";
            return object;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("remove()");
        }
    }

    protected final class MultidimensionalArrayIterator
    implements Iterator<Object> {
        private int m_currentElement;
        private int m_count;

        public MultidimensionalArrayIterator(int n, int n2) {
            this.m_currentElement = n;
            this.m_count = n2;
        }

        @Override
        public boolean hasNext() {
            return this.m_currentElement < this.m_count;
        }

        @Override
        public Object next() {
            if (this.m_currentElement >= this.m_count) {
                throw new NoSuchElementException();
            }
            assert (VerticaArray.this.m_jsonArray != null);
            JsonElement jsonElement = VerticaArray.this.m_jsonArray.get(this.m_currentElement);
            try {
                if (jsonElement.isJsonNull()) {
                    ++this.m_currentElement;
                    return new VerticaArray(null, null, VerticaArray.this.m_baseArrayColumn);
                }
                assert (jsonElement.isJsonArray());
                Object[] objectArray = VerticaArray.this.getMulitdimensionalArrayElement(this.m_currentElement);
                ++this.m_currentElement;
                return new VerticaArray(objectArray, jsonElement.getAsJsonArray(), VerticaArray.this.m_baseArrayColumn);
            }
            catch (ErrorException errorException) {
                assert (false) : "Internal Vertica JDBC Driver error.  Error constructing VerticaArray.";
                return null;
            }
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("remove()");
        }
    }
}

