/*
 * Decompiled with CFR 0.152.
 */
package com.vertica.dataengine;

import com.vertica.dsi.dataengine.interfaces.IColumn;
import com.vertica.dsi.dataengine.utilities.ColumnMetadata;
import com.vertica.dsi.dataengine.utilities.Nullable;
import com.vertica.dsi.dataengine.utilities.TypeMetadata;
import com.vertica.dsi.dataengine.utilities.Updatable;
import com.vertica.dsi.exceptions.NumericOverflowException;
import com.vertica.support.exceptions.DiagState;
import com.vertica.support.exceptions.ErrorException;
import com.vertica.util.ClientErrorException;
import com.vertica.util.TypeUtils;
import java.util.ArrayList;
import java.util.ListIterator;

public class ColumnDescription
extends ColumnMetadata {
    private int m_baseTypeOid;
    private int m_typemod;
    private int m_formatCode;
    private short m_sqlType;
    private int m_parentColID;
    private long m_tableOID;
    private int m_AttributeNum;

    public ColumnDescription(String string, String string2, String string3, String string4, int n, int n2, int n3, int n4, int n5, String string5, int n6, long l, int n7) throws NumericOverflowException, ClientErrorException {
        super(TypeUtils.createTypeMetadata(n, n4, string5));
        this.m_baseTypeOid = n;
        this.m_sqlType = this.getTypeMetadata().getType();
        this.m_typemod = n4;
        this.m_formatCode = n5;
        this.m_parentColID = n6;
        this.m_tableOID = l;
        this.m_AttributeNum = n7;
        this.setTableName(string3);
        this.setName(string);
        this.setLabel(string);
        this.setSchemaName(string2);
        this.setCatalogName(string4);
        this.setNullable(n2 == 1 ? Nullable.NULLABLE : Nullable.NO_NULLS);
        this.setAutoUnique(n3 == 1);
        boolean bl = "".equals(string2) || "v_catalog".equals(string2) || "v_monitor".equals(string2) || "v_internal".equals(string2) || "".equals(string3) || this.isAutoUnique();
        this.setUpdatable(bl ? Updatable.READ_ONLY : Updatable.UNKNOWN);
        if (this.m_baseTypeOid == 116 || this.m_baseTypeOid == 115 || this.m_baseTypeOid == 8 || this.m_baseTypeOid == 4 || this.m_baseTypeOid == 9 || this.m_baseTypeOid == 117 || this.m_baseTypeOid == 17) {
            this.setColumnLength(TypeUtils.getColumnSize(n, n4));
        }
    }

    public void addChildColumn(ColumnDescription columnDescription) throws ClientErrorException {
        throw new ClientErrorException("Fundamental Types do not support child columns.");
    }

    public ListIterator<ColumnDescription> getChildColumnIterator() {
        return null;
    }

    public int getSQLType() {
        return this.m_sqlType;
    }

    public int getTypeOID() {
        return this.m_baseTypeOid;
    }

    public int getTypeMod() {
        return this.m_typemod;
    }

    public int getFormatCode() {
        return this.m_formatCode;
    }

    public int getParentColumnID() {
        return this.m_parentColID;
    }

    public long getTableOID() {
        return this.m_tableOID;
    }

    public int getAttributeNum() {
        return this.m_AttributeNum;
    }

    public String toDebugString() {
        String string;
        String string2 = this.getSchemaName();
        if ("".equals(string2)) {
            string2 = "<none>";
        }
        if ("".equals(string = this.getSchemaName())) {
            string = "<none>";
        }
        TypeMetadata typeMetadata = this.getTypeMetadata();
        return "OID: " + this.m_baseTypeOid + " typemod: " + this.m_typemod + " format code: " + this.m_formatCode + " SQL type: " + this.m_sqlType + " schema: " + string2 + " table: " + string + " name: " + this.getName() + " nullable: " + (Object)((Object)this.getNullable()) + " autounique: " + this.isAutoUnique() + " precision: " + typeMetadata.getPrecision() + " scale: " + typeMetadata.getScale() + " table OID: " + this.m_tableOID;
    }

    public ColumnDescription findEnclosedArrayType() throws ErrorException {
        ColumnDescription columnDescription = this;
        while (columnDescription.getColumnType() == 2003) {
            columnDescription = columnDescription.getBaseArrayColumn();
            assert (columnDescription != null);
        }
        return columnDescription;
    }

    public ColumnDescription getBaseArrayColumn() throws ErrorException {
        TypeMetadata typeMetadata = this.getTypeMetadata();
        if (typeMetadata == null) {
            throw new ErrorException(DiagState.DIAG_GENERAL_ERROR, "Invalid Type Definition.  There is no type metadata.", -1);
        }
        ArrayList<IColumn> arrayList = typeMetadata.getNestedColumnList();
        if (arrayList == null) {
            throw new ErrorException(DiagState.DIAG_GENERAL_ERROR, "Invalid Type Definition.  There is no nested column list.", -1);
        }
        if (arrayList.size() != 1) {
            throw new ErrorException(DiagState.DIAG_GENERAL_ERROR, 101, "Invalid Type Definition.  There should only be one nested column.");
        }
        IColumn iColumn = arrayList.get(0);
        assert (iColumn instanceof ColumnDescription);
        return (ColumnDescription)iColumn;
    }

    public int getColumnType() throws ErrorException {
        TypeMetadata typeMetadata = this.getTypeMetadata();
        if (typeMetadata == null) {
            throw new ErrorException(DiagState.DIAG_GENERAL_ERROR, "Invalid Type Definition.  There is no type metadata.", -1);
        }
        return typeMetadata.getType();
    }
}

