/*
 * Decompiled with CFR 0.152.
 */
package com.vertica.io;

import com.vertica.io.ResponseMessage;
import com.vertica.io.VStream;
import com.vertica.io.VerticaDBTypeDesc;
import com.vertica.util.BaseDataOID;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public abstract class DescriptionResponseMessage
extends ResponseMessage {
    private List<VerticaDBTypeDesc> m_types = null;
    private boolean m_jsonComplexTypesEnabled = this.m_vStream.getConnection().getJsonComplexTypesEnabled();

    public DescriptionResponseMessage(VStream vStream) {
        super(vStream);
    }

    protected boolean jsonComplexTypesEnabled() {
        return this.m_jsonComplexTypesEnabled;
    }

    protected void readTypePool() throws IOException {
        int n = this.m_vStream.ReceiveIntegerR(4);
        if (n > 0) {
            this.m_types = new ArrayList<VerticaDBTypeDesc>(n);
        }
        for (int i = 0; i < n; ++i) {
            this.m_types.add(new VerticaDBTypeDesc(this.m_vStream));
        }
    }

    protected VerticaDBTypeDesc readNextTypeInfo() throws IOException {
        boolean bl = this.m_vStream.ReceiveChar() == 1;
        int n = this.m_vStream.ReceiveIntegerR(4);
        if (this.m_jsonComplexTypesEnabled && BaseDataOID.isComplexType(n)) {
            n = 115;
        }
        VerticaDBTypeDesc verticaDBTypeDesc = null;
        verticaDBTypeDesc = bl ? this.m_types.get(n) : new VerticaDBTypeDesc(n);
        return verticaDBTypeDesc;
    }
}

