/*
 * Decompiled with CFR 0.152.
 */
package com.vertica.util;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.vertica.core.VConnection;
import com.vertica.core.VDriver;
import com.vertica.dataengine.ColumnDescription;
import com.vertica.dsi.dataengine.utilities.DSIMonthSpan;
import com.vertica.dsi.dataengine.utilities.DSITimeSpan;
import com.vertica.dsi.dataengine.utilities.DataWrapper;
import com.vertica.dsi.dataengine.utilities.ParameterInputValue;
import com.vertica.dsi.dataengine.utilities.TimeTz;
import com.vertica.dsi.dataengine.utilities.TimestampTz;
import com.vertica.dsi.dataengine.utilities.TypeMetadata;
import com.vertica.dsi.exceptions.DefaultParamException;
import com.vertica.dsi.exceptions.IncorrectTypeException;
import com.vertica.dsi.exceptions.ParamAlreadyPushedException;
import com.vertica.jdbc.VerticaDayTimeInterval;
import com.vertica.jdbc.VerticaYearMonthInterval;
import com.vertica.localization.VMessageKey;
import com.vertica.support.exceptions.DiagState;
import com.vertica.support.exceptions.ErrorException;
import com.vertica.util.BaseDataOID;
import com.vertica.util.ClientErrorException;
import com.vertica.util.ProtocolUtils;
import com.vertica.util.VerticaArray;
import com.vertica.util.VerticaStruct;
import java.io.ByteArrayOutputStream;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Array;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.nio.ByteBuffer;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.GregorianCalendar;
import java.util.List;
import java.util.ListIterator;
import java.util.SimpleTimeZone;
import java.util.TimeZone;
import java.util.UUID;

public final class TypeUtils {
    private static final int INTERVAL_MASK_MONTH = 131072;
    private static final int INTERVAL_MASK_YEAR = 262144;
    private static final int INTERVAL_MASK_DAY = 524288;
    private static final int INTERVAL_MASK_HOUR = 0x4000000;
    private static final int INTERVAL_MASK_MINUTE = 0x8000000;
    private static final int INTERVAL_MASK_SECOND = 0x10000000;
    private static final int INTERVAL_MASK_YEAR2MONTH = 393216;
    private static final int INTERVAL_MASK_DAY2HOUR = 0x4080000;
    private static final int INTERVAL_MASK_DAY2MIN = 0xC080000;
    private static final int INTERVAL_MASK_DAY2SEC = 470286336;
    private static final int INTERVAL_MASK_HOUR2MIN = 0xC000000;
    private static final int INTERVAL_MASK_HOUR2SEC = 0x1C000000;
    private static final int INTERVAL_MASK_MIN2SEC = 0x18000000;
    private static final byte BACKSLASH = 92;
    private static final byte[] BACKSLASH_ESCAPE = new byte[]{92, 49, 51, 52};
    private static final long MILLIS_PER_MIN = 60000L;
    private static final long MILLIS_PER_HOUR = 3600000L;
    private static final long SECONDS_PER_DAY = 86400L;
    private static final long POSITIVE_INFINITY_MILLISECONDS = 9223372036825200000L;
    private static final long NEGATIVE_INFINITY_MILLISECONDS = -9223372036832400000L;
    private static final char[][] NUMBERS = new char[64][];
    private static final int ASCII_OFFSET = 48;
    public static final int MAX_LONG_STRING_LEN = 32000000;
    public static final int MAX_STRING_LEN = 65000;

    public static boolean deserialize(ColumnDescription columnDescription, long l, long l2, DataWrapper dataWrapper, byte[] byArray) throws ErrorException {
        int n = columnDescription.getTypeOID();
        try {
            if (null == byArray) {
                dataWrapper.setNull(columnDescription.getSQLType());
                return false;
            }
            switch (n) {
                case 4: 
                case 8: 
                case 9: 
                case 115: {
                    return TypeUtils.deserializeString(byArray, l, l2, dataWrapper);
                }
                case 11: 
                case 15: {
                    TypeUtils.deserializeTime(n, dataWrapper, byArray, columnDescription.getFormatCode());
                    return false;
                }
                case 5: {
                    if (columnDescription.getFormatCode() == 1) {
                        dataWrapper.setBoolean(byArray[0] == 1);
                    } else {
                        dataWrapper.setVarChar(new String(byArray, 0, byArray.length, VConnection.VERTICA_CHARSET));
                    }
                    return false;
                }
                case 7: {
                    if (columnDescription.getFormatCode() == 1) {
                        dataWrapper.setDouble(ByteBuffer.wrap(byArray).getDouble());
                    } else {
                        dataWrapper.setVarChar(new String(byArray, 0, byArray.length, VConnection.VERTICA_CHARSET));
                    }
                    return false;
                }
                case 16: {
                    if (columnDescription.getFormatCode() == 1) {
                        BigInteger bigInteger = new BigInteger(byArray);
                        int n2 = TypeUtils.getNumericScale(columnDescription.getTypeMod());
                        dataWrapper.setNumeric(new BigDecimal(bigInteger, n2));
                    } else {
                        dataWrapper.setVarChar(new String(byArray, 0, byArray.length, VConnection.VERTICA_CHARSET));
                    }
                    return false;
                }
                case 6: {
                    if (columnDescription.getFormatCode() == 1) {
                        dataWrapper.setInteger(ByteBuffer.wrap(byArray).getLong());
                    } else {
                        dataWrapper.setLongVarChar(new String(byArray, 0, byArray.length, VConnection.VERTICA_CHARSET));
                    }
                    return false;
                }
                case 12: {
                    if (columnDescription.getFormatCode() == 1) {
                        TypeUtils.deserializeTimestampBinary(n, dataWrapper, byArray);
                    } else if (!TypeUtils.deserializeInfinityTimestamp(dataWrapper, byArray)) {
                        String string = new String(byArray, 0, byArray.length, VConnection.VERTICA_CHARSET);
                        if (string.endsWith(" BC")) {
                            string = '-' + string.substring(0, string.length() - 3);
                        }
                        dataWrapper.setVarChar(string);
                    }
                    return false;
                }
                case 10: {
                    TypeUtils.deserializeDate(dataWrapper, byArray, columnDescription.getFormatCode());
                    return false;
                }
                case 13: {
                    if (columnDescription.getFormatCode() == 1) {
                        TypeUtils.deserializeTimestampBinary(n, dataWrapper, byArray);
                    } else {
                        TypeUtils.deserializeTimestampTZ(dataWrapper, byArray);
                    }
                    return false;
                }
                case 17: 
                case 116: 
                case 117: {
                    if (l2 == -1L || l2 >= (long)byArray.length) {
                        if (0L != l) {
                            byte[] byArray2 = new byte[byArray.length - (int)l];
                            System.arraycopy(byArray, (int)l, byArray2, 0, (int)((long)byArray.length - l));
                            dataWrapper.setVarBinary(byArray2);
                        } else {
                            dataWrapper.setVarBinary(byArray);
                        }
                        return false;
                    }
                    byte[] byArray3 = new byte[Math.min((int)l2, byArray.length - (int)l)];
                    System.arraycopy(byArray, (int)l, byArray3, 0, byArray3.length);
                    dataWrapper.setVarBinary(byArray3);
                    return l + l2 < (long)byArray.length;
                }
                case 20: {
                    if (columnDescription.getFormatCode() == 1) {
                        ByteBuffer byteBuffer = ByteBuffer.wrap(byArray);
                        dataWrapper.setGuid(new UUID(byteBuffer.getLong(), byteBuffer.getLong()));
                    } else {
                        dataWrapper.setGuid(UUID.fromString(new String(byArray)));
                    }
                    return false;
                }
                case 114: {
                    VerticaYearMonthInterval verticaYearMonthInterval = TypeUtils.parseIntervalYM(columnDescription.getSQLType(), byArray, columnDescription.getFormatCode());
                    dataWrapper.setInterval(verticaYearMonthInterval);
                    return false;
                }
                case 14: {
                    VerticaDayTimeInterval verticaDayTimeInterval = TypeUtils.parseInterval(columnDescription.getSQLType(), columnDescription.getTypeMod(), byArray, columnDescription.getFormatCode());
                    dataWrapper.setInterval(verticaDayTimeInterval);
                    return false;
                }
                case 301: 
                case 1505: 
                case 1506: 
                case 1507: 
                case 1508: 
                case 1509: 
                case 1510: 
                case 1511: 
                case 1512: 
                case 1513: 
                case 1514: 
                case 1515: 
                case 1516: 
                case 1517: 
                case 1518: 
                case 1519: 
                case 1520: 
                case 1521: 
                case 1522: 
                case 2705: 
                case 2706: 
                case 2707: 
                case 2708: 
                case 2709: 
                case 2710: 
                case 2711: 
                case 2712: 
                case 2713: 
                case 2714: 
                case 2715: 
                case 2716: 
                case 2717: 
                case 2718: 
                case 2719: 
                case 2720: 
                case 2721: 
                case 2722: {
                    return TypeUtils.deserializeArray(columnDescription, byArray, dataWrapper);
                }
                case 300: 
                case 302: {
                    return TypeUtils.deserializeStruct(columnDescription, byArray, l, l2, dataWrapper);
                }
            }
            return TypeUtils.deserializeString(byArray, l, l2, dataWrapper);
        }
        catch (NumberFormatException numberFormatException) {
            throw VDriver.s_vExceptionBuilder.createGeneralException(VMessageKey.ERROR_TYPE_CONVERSION_FAILED.toString());
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new ClientErrorException(VMessageKey.ERROR_TYPE_CONVERSION_FAILED.toString());
        }
    }

    private static int getYearWidth(byte[] byArray) {
        int n = 0;
        for (n = 0; byArray[n] != 45 && n < byArray.length; ++n) {
        }
        if (n == byArray.length) {
            n = -1;
        }
        return n;
    }

    private static int intFromBytes(byte[] byArray, int n, int n2) {
        int n3 = 0;
        for (int i = n; i < n + n2; ++i) {
            n3 *= 10;
            n3 += byArray[i] - 48;
        }
        return n3;
    }

    public static boolean deserializeString(byte[] byArray, long l, long l2, DataWrapper dataWrapper) throws UnsupportedEncodingException {
        int n = 0;
        n = l2 > 0L && l2 < (long)byArray.length ? byArray.length : (int)l2;
        boolean bl = true;
        if (l2 == -1L || n > 0 && l + (long)n >= (long)byArray.length) {
            n = byArray.length - (int)l;
            bl = false;
        }
        String string = new String(byArray, (int)l, n, VConnection.VERTICA_CHARSET);
        dataWrapper.setLongVarChar(string);
        return bl;
    }

    public static boolean oidMapsToResultSet_getArray(int n) {
        return BaseDataOID.isArrayType(n) || BaseDataOID.isSetType(n);
    }

    public static ColumnDescription getArrayTypeColumnDescription(ColumnDescription columnDescription) throws ClientErrorException {
        if (!TypeUtils.oidMapsToResultSet_getArray(columnDescription.getTypeOID())) {
            throw new ClientErrorException("Invalid type of ColumnDescription. Must be an array type.");
        }
        ListIterator<ColumnDescription> listIterator = columnDescription.getChildColumnIterator();
        if (listIterator == null) {
            throw new ClientErrorException("Complex Nested Array should have childrenColumnDescription");
        }
        ColumnDescription columnDescription2 = listIterator.next();
        return columnDescription2;
    }

    public static Class<?> getClassForColumn(ColumnDescription columnDescription) throws ClientErrorException {
        switch (columnDescription.getTypeOID()) {
            case 5: {
                return Boolean.class;
            }
            case 6: {
                return Long.class;
            }
            case 7: {
                return Double.class;
            }
            case 10: {
                return Date.class;
            }
            case 11: 
            case 15: {
                return Time.class;
            }
            case 12: {
                return Timestamp.class;
            }
            case 13: {
                return TimestampTz.class;
            }
            case 14: {
                return VerticaDayTimeInterval.class;
            }
            case 114: {
                return VerticaYearMonthInterval.class;
            }
            case 20: {
                return UUID.class;
            }
            case 16: {
                return BigDecimal.class;
            }
            case 8: 
            case 9: 
            case 115: {
                return String.class;
            }
            case 17: 
            case 116: 
            case 117: {
                return byte[].class;
            }
            case 300: 
            case 302: {
                return VerticaStruct.class;
            }
            case 301: {
                return TypeUtils.getArrayClassForColumn(columnDescription);
            }
            case 1505: 
            case 2705: {
                return Boolean[].class;
            }
            case 1506: 
            case 2706: {
                return Long[].class;
            }
            case 1507: 
            case 2707: {
                return Double[].class;
            }
            case 1510: 
            case 2710: {
                return Date[].class;
            }
            case 1511: 
            case 1515: 
            case 2711: 
            case 2715: {
                return Time[].class;
            }
            case 1512: 
            case 2712: {
                return Timestamp[].class;
            }
            case 1513: 
            case 2713: {
                return TimestampTz[].class;
            }
            case 1514: 
            case 2714: {
                return VerticaDayTimeInterval[].class;
            }
            case 1521: 
            case 2721: {
                return VerticaYearMonthInterval[].class;
            }
            case 1520: 
            case 2720: {
                return UUID[].class;
            }
            case 1516: 
            case 2716: {
                return BigDecimal[].class;
            }
            case 1508: 
            case 1509: 
            case 1519: 
            case 2708: 
            case 2709: 
            case 2719: {
                return String[].class;
            }
            case 1517: 
            case 1518: 
            case 1522: 
            case 2717: 
            case 2718: 
            case 2722: {
                return byte[][].class;
            }
        }
        return Object.class;
    }

    private static Class<?> getArrayClassForColumn(ColumnDescription columnDescription) throws ClientErrorException {
        ColumnDescription columnDescription2 = TypeUtils.getArrayTypeColumnDescription(columnDescription);
        assert (columnDescription2 != null);
        switch (columnDescription2.getTypeOID()) {
            case 5: {
                return Boolean[].class;
            }
            case 6: {
                return Long[].class;
            }
            case 7: {
                return Double[].class;
            }
            case 10: {
                return Date[].class;
            }
            case 11: 
            case 15: {
                return Time[].class;
            }
            case 12: {
                return Timestamp[].class;
            }
            case 13: {
                return TimestampTz[].class;
            }
            case 14: {
                return VerticaDayTimeInterval[].class;
            }
            case 114: {
                return VerticaYearMonthInterval[].class;
            }
            case 20: {
                return UUID[].class;
            }
            case 16: {
                return BigDecimal[].class;
            }
            case 8: 
            case 9: 
            case 115: {
                return String[].class;
            }
            case 17: 
            case 116: 
            case 117: {
                return byte[][].class;
            }
            case 300: 
            case 302: {
                return VerticaStruct[].class;
            }
            case 301: {
                return Object[].class;
            }
        }
        throw new ClientErrorException("ColumnDescription oid must be an ArrayOid. Currently is " + columnDescription2.getTypeOID());
    }

    public static Object parseJsonElement(ColumnDescription columnDescription, JsonElement jsonElement) throws ClientErrorException, UnsupportedEncodingException {
        if (jsonElement.isJsonNull()) {
            return null;
        }
        int n = columnDescription.getTypeOID();
        switch (n) {
            case 5: {
                return jsonElement.getAsBoolean();
            }
            case 6: {
                return jsonElement.getAsLong();
            }
            case 7: {
                return jsonElement.getAsDouble();
            }
            case 10: {
                return TypeUtils.deserializeDate(null, jsonElement.getAsString().getBytes(), 0);
            }
            case 12: {
                byte[] byArray = jsonElement.getAsString().getBytes();
                if (TypeUtils.isInfinityTimestamp(byArray)) {
                    return TypeUtils.getInfinityTimestamp(byArray);
                }
                Calendar calendar = Calendar.getInstance();
                TypeUtils.setCalendar(12, calendar, byArray);
                Timestamp timestamp = new Timestamp(calendar.getTimeInMillis());
                timestamp.setNanos(TypeUtils.getNano(byArray));
                return timestamp;
            }
            case 13: {
                return TypeUtils.deserializeTimestampTZ_JsonFormat(jsonElement.getAsString().getBytes());
            }
            case 14: {
                VerticaDayTimeInterval verticaDayTimeInterval = TypeUtils.parseInterval(TypeUtils.getSQLTypeFromOID(n, -1), -1, jsonElement.getAsString().getBytes(), 0);
                return verticaDayTimeInterval;
            }
            case 114: {
                VerticaYearMonthInterval verticaYearMonthInterval = TypeUtils.parseIntervalYM(TypeUtils.getSQLTypeFromOID(n, -1), jsonElement.getAsString().getBytes(), 0);
                return verticaYearMonthInterval;
            }
            case 20: {
                return UUID.fromString(jsonElement.getAsString());
            }
            case 16: {
                return new BigDecimal(jsonElement.getAsString());
            }
            case 11: 
            case 15: {
                return TypeUtils.deserializeTimeFromTextEncoding(n, jsonElement.getAsString().getBytes());
            }
            case 17: 
            case 116: 
            case 117: {
                return jsonElement.getAsString().getBytes();
            }
            case 300: 
            case 302: {
                return TypeUtils.parseStruct(columnDescription, jsonElement);
            }
            case 301: 
            case 1505: 
            case 1506: 
            case 1507: 
            case 1508: 
            case 1509: 
            case 1510: 
            case 1511: 
            case 1512: 
            case 1513: 
            case 1514: 
            case 1515: 
            case 1516: 
            case 1517: 
            case 1518: 
            case 1519: 
            case 1520: 
            case 1521: 
            case 1522: 
            case 2705: 
            case 2706: 
            case 2707: 
            case 2708: 
            case 2709: 
            case 2710: 
            case 2711: 
            case 2712: 
            case 2713: 
            case 2714: 
            case 2715: 
            case 2716: 
            case 2717: 
            case 2718: 
            case 2719: 
            case 2720: 
            case 2721: 
            case 2722: {
                return TypeUtils.parseArray(columnDescription, jsonElement);
            }
        }
        return jsonElement.getAsString();
    }

    private static boolean deserializeArray(ColumnDescription columnDescription, byte[] byArray, DataWrapper dataWrapper) throws UnsupportedEncodingException, ClientErrorException, ErrorException {
        String string = new String(byArray, 0, byArray.length, VConnection.VERTICA_CHARSET);
        JsonElement jsonElement = new JsonParser().parse(string);
        if (jsonElement == null) {
            dataWrapper.setArray(null);
        }
        if (!jsonElement.isJsonArray()) {
            throw new ErrorException(DiagState.DIAG_GENERAL_ERROR, 101, "Array Expected.");
        }
        VerticaArray verticaArray = new VerticaArray(jsonElement.getAsJsonArray(), columnDescription);
        dataWrapper.setArray(verticaArray);
        return false;
    }

    public static Object[] parseArray(ColumnDescription columnDescription, JsonElement jsonElement) throws ClientErrorException, UnsupportedEncodingException {
        JsonArray jsonArray = jsonElement.getAsJsonArray();
        ColumnDescription columnDescription2 = TypeUtils.getArrayTypeColumnDescription(columnDescription);
        Class<?> clazz = TypeUtils.getArrayClassForColumn(columnDescription);
        Class<?> clazz2 = clazz.getComponentType();
        if (clazz == null || clazz2 == null) {
            throw new ClientErrorException("Internal Error: Column " + columnDescription.getName() + " does not have array type information.");
        }
        Object[] objectArray = (Object[])Array.newInstance(clazz2, jsonArray.size());
        for (int i = 0; i < jsonArray.size(); ++i) {
            Array.set(objectArray, i, TypeUtils.parseJsonElement(columnDescription2, jsonArray.get(i)));
        }
        return objectArray;
    }

    private static boolean deserializeStruct(ColumnDescription columnDescription, byte[] byArray, long l, long l2, DataWrapper dataWrapper) throws ClientErrorException, UnsupportedEncodingException {
        String string = new String(byArray, 0, byArray.length, VConnection.VERTICA_CHARSET);
        JsonElement jsonElement = new JsonParser().parse(string);
        VerticaStruct verticaStruct = TypeUtils.parseStruct(columnDescription, jsonElement);
        try {
            dataWrapper.setData(2002, verticaStruct);
        }
        catch (IncorrectTypeException incorrectTypeException) {
            throw new ClientErrorException("Unable to convert Complex Type to Struct: " + jsonElement.toString());
        }
        return false;
    }

    public static VerticaStruct parseStruct(ColumnDescription columnDescription, JsonElement jsonElement) {
        JsonObject jsonObject = jsonElement.getAsJsonObject();
        return new VerticaStruct(columnDescription, jsonObject);
    }

    private static long toJavaSecs(long l) {
        if (l < -12219292800L && (l += 864000L) < -14825808000L) {
            int n = (int)((l + 14825808000L) / 3155760000L);
            --n;
            n -= n / 4;
            l += (long)n * 86400L;
        }
        return l;
    }

    public static Date deserializeDate(DataWrapper dataWrapper, byte[] byArray, int n) throws UnsupportedEncodingException {
        if (n == 1) {
            long l = ByteBuffer.wrap(byArray).getLong();
            long l2 = TypeUtils.toJavaSecs((l -= 2440588L) * 86400L) * 1000L;
            long l3 = Calendar.getInstance().getTimeZone().getOffset(l2);
            Date date = new Date(l2 -= l3);
            if (dataWrapper != null) {
                dataWrapper.setDate(date);
            }
            return date;
        }
        Calendar calendar = Calendar.getInstance();
        TypeUtils.setCalendar(10, calendar, byArray);
        Date date = new Date(calendar.getTimeInMillis());
        if (dataWrapper != null) {
            dataWrapper.setDate(date);
        }
        return date;
    }

    private static boolean deserializeInfinityTimestamp(DataWrapper dataWrapper, byte[] byArray) {
        if (TypeUtils.isInfinityTimestamp(byArray)) {
            dataWrapper.setTimestamp(TypeUtils.getInfinityTimestamp(byArray));
            return true;
        }
        return false;
    }

    private static boolean isInfinityTimestamp(byte[] byArray) {
        return byArray[0] == 105 || byArray[0] == 45 && byArray[1] == 105;
    }

    private static TimestampTz getInfinityTimestamp(byte[] byArray) {
        Calendar calendar = Calendar.getInstance();
        Timestamp timestamp = new Timestamp(byArray[0] == 45 ? -9223372036832400000L : 9223372036825200000L);
        timestamp.setNanos(0);
        return new TimestampTz(timestamp, calendar);
    }

    public static TimestampTz deserializeTimestampTZ_JsonFormat(byte[] byArray) throws UnsupportedEncodingException {
        if (TypeUtils.isInfinityTimestamp(byArray)) {
            return TypeUtils.getInfinityTimestamp(byArray);
        }
        Calendar calendar = TypeUtils.getTimeZoneCalendar(byArray);
        TypeUtils.setCalendar(13, calendar, byArray);
        Timestamp timestamp = new Timestamp(calendar.getTimeInMillis());
        timestamp.setNanos(TypeUtils.getNano(byArray));
        return new TimestampTz(timestamp, calendar);
    }

    private static void deserializeTimestampTZ(DataWrapper dataWrapper, byte[] byArray) throws UnsupportedEncodingException {
        if (TypeUtils.deserializeInfinityTimestamp(dataWrapper, byArray)) {
            return;
        }
        Calendar calendar = TypeUtils.getTimeZoneCalendar(byArray);
        TypeUtils.setCalendar(13, calendar, byArray);
        Timestamp timestamp = new Timestamp(calendar.getTimeInMillis());
        timestamp.setNanos(TypeUtils.getNano(byArray));
        dataWrapper.setTimestamp(new TimestampTz(timestamp, calendar));
    }

    private static Calendar getTimeZoneCalendar(byte[] byArray) throws UnsupportedEncodingException {
        int n;
        for (n = byArray.length - 1; n >= 0 && byArray[n] != 43 && byArray[n] != 45; --n) {
        }
        String string = new String(byArray, n, byArray.length - n, VConnection.VERTICA_CHARSET);
        return Calendar.getInstance(new SimpleTimeZone(TypeUtils.getTimeZoneOffSet(byArray, n), string));
    }

    private static void deserializeTimestampBinary(int n, DataWrapper dataWrapper, byte[] byArray) throws ClientErrorException {
        if (n != 12 && n != 13) {
            throw new ClientErrorException("Invalid timestamp/timestamptz OID: " + n);
        }
        long l = ByteBuffer.wrap(byArray).getLong();
        if (l == Long.MAX_VALUE) {
            Timestamp timestamp = new Timestamp(9223372036825200000L);
            timestamp.setNanos(0);
            dataWrapper.setTimestamp(new TimestampTz(timestamp, Calendar.getInstance()));
            return;
        }
        if (l == -9223372036854775807L) {
            Timestamp timestamp = new Timestamp(-9223372036832400000L);
            timestamp.setNanos(0);
            dataWrapper.setTimestamp(new TimestampTz(timestamp, Calendar.getInstance()));
            return;
        }
        long l2 = ((l += 946684800000000L) % 1000000L + 1000000L) % 1000000L;
        long l3 = TypeUtils.toJavaSecs((l - l2) / 1000000L);
        long l4 = l3 * 1000L;
        if (n == 12) {
            StringBuilder stringBuilder;
            GregorianCalendar gregorianCalendar = new GregorianCalendar();
            ((Calendar)gregorianCalendar).setTimeZone(TimeZone.getTimeZone("UTC"));
            gregorianCalendar.setTimeInMillis(l4);
            int n2 = gregorianCalendar.get(0);
            int n3 = gregorianCalendar.get(1);
            int n4 = gregorianCalendar.get(2) + 1;
            int n5 = gregorianCalendar.get(5);
            int n6 = gregorianCalendar.get(11);
            int n7 = gregorianCalendar.get(12);
            int n8 = gregorianCalendar.get(13);
            StringBuilder stringBuilder2 = stringBuilder = n2 == 0 ? new StringBuilder("-") : new StringBuilder();
            if (n3 < 1000) {
                stringBuilder.append('0');
            }
            if (n3 < 100) {
                stringBuilder.append('0');
            }
            if (n3 < 10) {
                stringBuilder.append('0');
            }
            stringBuilder.append(n3);
            stringBuilder.append('-');
            stringBuilder.append(NUMBERS[n4]);
            stringBuilder.append('-');
            stringBuilder.append(NUMBERS[n5]);
            stringBuilder.append(' ');
            stringBuilder.append(NUMBERS[n6]);
            stringBuilder.append(':');
            stringBuilder.append(NUMBERS[n7]);
            stringBuilder.append(':');
            stringBuilder.append(NUMBERS[n8]);
            if (l2 > 0L) {
                stringBuilder.append('.');
                if (l2 < 100000L) {
                    stringBuilder.append('0');
                }
                if (l2 < 10000L) {
                    stringBuilder.append('0');
                }
                if (l2 < 1000L) {
                    stringBuilder.append('0');
                }
                if (l2 < 100L) {
                    stringBuilder.append('0');
                }
                if (l2 < 10L) {
                    stringBuilder.append('0');
                }
                stringBuilder.append(l2);
                int n9 = stringBuilder.length() - 1;
                while (stringBuilder.charAt(n9) == '0') {
                    stringBuilder.deleteCharAt(n9);
                    --n9;
                }
            }
            String string = stringBuilder.toString();
            dataWrapper.setVarChar(string);
        } else {
            Timestamp timestamp = new Timestamp(l4);
            timestamp.setNanos((int)l2 * 1000);
            Calendar calendar = Calendar.getInstance();
            dataWrapper.setTimestamp(new TimestampTz(timestamp, calendar));
        }
    }

    private static void setCalendar(int n, Calendar calendar, byte[] byArray) {
        int n2 = TypeUtils.getYearWidth(byArray);
        calendar.set(1, TypeUtils.intFromBytes(byArray, 0, n2));
        calendar.set(2, TypeUtils.intFromBytes(byArray, n2 + 1, 2) - 1);
        calendar.set(5, TypeUtils.intFromBytes(byArray, n2 + 4, 2));
        if (n != 10) {
            calendar.set(11, TypeUtils.intFromBytes(byArray, n2 + 7, 2));
            calendar.set(12, TypeUtils.intFromBytes(byArray, n2 + 10, 2));
            calendar.set(13, TypeUtils.intFromBytes(byArray, n2 + 13, 2));
        } else {
            calendar.set(11, 0);
            calendar.set(12, 0);
            calendar.set(13, 0);
            calendar.set(14, 0);
        }
        if (byArray[byArray.length - 2] == 66 && byArray[byArray.length - 1] == 67) {
            calendar.set(0, 0);
        }
    }

    private static void deserializeTime(int n, DataWrapper dataWrapper, byte[] byArray, int n2) throws UnsupportedEncodingException, ClientErrorException {
        int n3;
        if (n2 == 1) {
            long l = ByteBuffer.wrap(byArray).getLong();
            if (n == 11) {
                long l2 = Math.round((double)l / 1000.0);
                long l3 = Calendar.getInstance().getTimeZone().getOffset(0L);
                dataWrapper.setTime(new Time(l2 -= l3));
            } else if (n == 15) {
                int n4 = (int)(86400L - (l & 0xFFFFFFL)) * 1000;
                long l4 = Math.round((double)(l >> 24) / 1000.0);
                SimpleTimeZone simpleTimeZone = new SimpleTimeZone(n4, "");
                TimeTz timeTz = new TimeTz(new Time(l4), Calendar.getInstance(simpleTimeZone));
                dataWrapper.setTime(timeTz);
            } else {
                throw new ClientErrorException("Invalid time/timetz type " + n);
            }
            return;
        }
        int[] nArray = new int[4];
        int n5 = 0;
        int n6 = 0;
        int n7 = 0;
        boolean bl = false;
        for (n3 = 0; n3 < byArray.length; ++n3) {
            if (byArray[n3] == 58 || byArray[n3] == 58 || byArray[n3] == 32) {
                ++n5;
                continue;
            }
            if (byArray[n3] == 46) {
                ++n5;
                n6 = n3 + 1;
                continue;
            }
            if (byArray[n3] == 43 || byArray[n3] == 45) {
                n7 = n3;
                bl = true;
                break;
            }
            nArray[n5] = byArray[n3] - 48 + nArray[n5] * 10;
        }
        if (n7 == 0) {
            n7 = byArray.length;
        }
        long l = (long)nArray[0] * 3600000L + (long)nArray[1] * 60000L + (long)(nArray[2] * 1000);
        for (int i = n7 - n6; i < 9; ++i) {
            nArray[3] = nArray[3] * 10;
        }
        l += (long)((nArray[3] + 500000) / 1000000);
        Calendar calendar = null;
        if (bl) {
            if (n != 15) {
                throw new ClientErrorException("Invalid timetz type " + n);
            }
            int n8 = n3;
            int n9 = TypeUtils.getTimeZoneOffSet(byArray, n8);
            calendar = Calendar.getInstance(new SimpleTimeZone(n9, new String(byArray, n8, byArray.length - n8, VConnection.VERTICA_CHARSET)));
            TimeTz timeTz = new TimeTz(new Time(l -= (long)n9), calendar);
            dataWrapper.setTime(timeTz);
        } else {
            long l5 = Calendar.getInstance().getTimeZone().getOffset(0L);
            l -= l5;
            if (n != 11) {
                throw new ClientErrorException("Invalid time type " + n);
            }
            Time time = new Time(l);
            dataWrapper.setTime(time);
        }
    }

    private static int getTimeZoneOffSet(byte[] byArray, int n) {
        int n2 = byArray[n] == 45 ? -1 : 1;
        ++n;
        int n3 = 0;
        int n4 = 0;
        int[] nArray = new int[3];
        while (n < byArray.length) {
            if (byArray[n] == 58) {
                ++n3;
            } else {
                if (byArray[n] == 32) break;
                nArray[n3] = byArray[n] - 48 + nArray[n3] * 10;
            }
            ++n;
        }
        n4 = nArray[0] * 60 * 60 * 1000 + nArray[1] * 60 * 1000 + nArray[2] * 1000;
        return n4 *= n2;
    }

    public static List<byte[]> serialize(ParameterInputValue parameterInputValue, int n, int n2, boolean bl, List<DataWrapper> list, boolean bl2) {
        ArrayList<byte[]> arrayList = new ArrayList<byte[]>();
        try {
            block40: {
                block39: {
                    if (!parameterInputValue.isPushed()) break block39;
                    switch (n) {
                        case -4: 
                        case -3: 
                        case -2: {
                            if (list != null) {
                                for (int i = 0; i < list.size(); ++i) {
                                    byte[] byArray = (byte[])list.get(i).getObject();
                                    if (byArray == null) continue;
                                    arrayList.add(TypeUtils.binaryToString(byArray));
                                }
                            }
                            break block40;
                        }
                        case -1: 
                        case 1: 
                        case 12: {
                            TypeUtils.serializeChar(list, arrayList);
                            break;
                        }
                        default: {
                            TypeUtils.serializeChar(list, arrayList);
                            break;
                        }
                    }
                    break block40;
                }
                DataWrapper dataWrapper = parameterInputValue.getData();
                String string = null;
                if (dataWrapper.isNull()) {
                    return arrayList;
                }
                if (parameterInputValue.getMetadata().shouldConvertInputToString()) {
                    string = (String)dataWrapper.getObject();
                } else {
                    switch (n) {
                        case -7: {
                            string = dataWrapper.getBit() != false ? "1" : "0";
                            break;
                        }
                        case -5: {
                            string = dataWrapper.getInteger().toString();
                            break;
                        }
                        case 1: {
                            string = dataWrapper.getChar();
                            break;
                        }
                        case 12: {
                            string = dataWrapper.getVarChar();
                            break;
                        }
                        case -2: {
                            arrayList.add(TypeUtils.binaryToString(dataWrapper.getBinary()));
                            break;
                        }
                        case -3: {
                            arrayList.add(TypeUtils.binaryToString(dataWrapper.getVarBinary()));
                            break;
                        }
                        case -4: {
                            arrayList.add(TypeUtils.binaryToString(dataWrapper.getLongVarBinary()));
                            break;
                        }
                        case 91: {
                            string = dataWrapper.getDate().toString();
                            break;
                        }
                        case 8: {
                            string = dataWrapper.getDouble().toString();
                            break;
                        }
                        case 2: {
                            string = dataWrapper.getNumeric().toString();
                            break;
                        }
                        case -11: {
                            string = dataWrapper.getGuid().toString();
                            break;
                        }
                        case 92: {
                            TimeTz timeTz = dataWrapper.getTimeTz();
                            if (timeTz != null) {
                                Calendar calendar = timeTz.getTimezoneCalendar();
                                calendar.setTimeInMillis(timeTz.getTime());
                                StringBuilder stringBuilder = new StringBuilder(21);
                                TypeUtils.appendTime(stringBuilder, calendar, calendar.get(14) * 1000000);
                                if (n2 == 15 || bl) {
                                    TypeUtils.appendTimeZone(stringBuilder, calendar, timeTz.getTime());
                                }
                                string = stringBuilder.toString();
                                break;
                            }
                            string = dataWrapper.getTime().toString();
                            break;
                        }
                        case 93: {
                            TimestampTz timestampTz = dataWrapper.getTimestampTz();
                            if (timestampTz != null) {
                                Calendar calendar = timestampTz.getTimezoneCalendar();
                                Timestamp timestamp = timestampTz.getAdjustedTimestamp();
                                StringBuilder stringBuilder = new StringBuilder(32);
                                stringBuilder.append(timestamp.toString());
                                stringBuilder.append(' ');
                                if (n2 == 13 || bl) {
                                    TypeUtils.appendTimeZone(stringBuilder, calendar, timestamp.getTime());
                                }
                                string = stringBuilder.toString();
                                break;
                            }
                            string = dataWrapper.getTime().toString();
                            break;
                        }
                        case 101: 
                        case 102: 
                        case 107: {
                            DSIMonthSpan dSIMonthSpan = (DSIMonthSpan)dataWrapper.getInterval();
                            if (dSIMonthSpan.isNegative()) {
                                string = String.format("-%d-%d", dSIMonthSpan.getYear(), dSIMonthSpan.getMonth());
                                break;
                            }
                            string = String.format("%d-%d", dSIMonthSpan.getYear(), dSIMonthSpan.getMonth());
                            break;
                        }
                        case 103: 
                        case 108: 
                        case 109: 
                        case 110: {
                            DSITimeSpan dSITimeSpan = (DSITimeSpan)dataWrapper.getInterval();
                            if (dSITimeSpan.isNegative()) {
                                string = String.format("-%d %d:%d:%d.%d", dSITimeSpan.getDay(), dSITimeSpan.getHour(), dSITimeSpan.getMinute(), dSITimeSpan.getSecond(), dSITimeSpan.getFraction());
                                break;
                            }
                            string = String.format("%d %d:%d:%d.%d", dSITimeSpan.getDay(), dSITimeSpan.getHour(), dSITimeSpan.getMinute(), dSITimeSpan.getSecond(), dSITimeSpan.getFraction());
                            break;
                        }
                        case 104: 
                        case 105: 
                        case 106: 
                        case 111: 
                        case 112: 
                        case 113: {
                            DSITimeSpan dSITimeSpan = (DSITimeSpan)dataWrapper.getInterval();
                            if (dSITimeSpan.isNegative()) {
                                string = String.format("-%d:%d:%d.%d", dSITimeSpan.getHour(), dSITimeSpan.getMinute(), dSITimeSpan.getSecond(), dSITimeSpan.getFraction());
                                break;
                            }
                            string = String.format("%d:%d:%d.%d", dSITimeSpan.getHour(), dSITimeSpan.getMinute(), dSITimeSpan.getSecond(), dSITimeSpan.getFraction());
                            break;
                        }
                        default: {
                            string = dataWrapper.getObject().toString();
                        }
                    }
                }
                if (arrayList.size() == 0) {
                    arrayList.add(ProtocolUtils.encodeUTF8(string));
                }
            }
            return arrayList;
        }
        catch (ParamAlreadyPushedException paramAlreadyPushedException) {
            throw new RuntimeException("Logic error: pushed parameter handled as a non-pushed parameter.");
        }
        catch (DefaultParamException defaultParamException) {
            throw new RuntimeException("No default parameter support yet");
        }
        catch (IncorrectTypeException incorrectTypeException) {
            incorrectTypeException.printStackTrace();
            throw new RuntimeException("Bind not implemented for this type");
        }
    }

    private static void serializeChar(List<DataWrapper> list, List<byte[]> list2) {
        if (list != null) {
            for (int i = 0; i < list.size(); ++i) {
                String string = (String)list.get(i).getObject();
                if (string == null) continue;
                list2.add(ProtocolUtils.encodeUTF8(string));
            }
        }
    }

    private static void appendTime(StringBuilder stringBuilder, Calendar calendar, int n) {
        int n2 = calendar.get(11);
        if (n2 < 10) {
            stringBuilder.append('0');
        }
        stringBuilder.append(n2);
        stringBuilder.append(':');
        int n3 = calendar.get(12);
        if (n3 < 10) {
            stringBuilder.append('0');
        }
        stringBuilder.append(n3);
        stringBuilder.append(':');
        int n4 = calendar.get(13);
        if (n4 < 10) {
            stringBuilder.append('0');
        }
        stringBuilder.append(n4);
        if (n > 0) {
            char[] cArray = new char[]{'0', '0', '0', '0', '0', '0', '0', '0', '0'};
            char[] cArray2 = Integer.toString(n).toCharArray();
            System.arraycopy(cArray2, 0, cArray, cArray.length - cArray2.length, cArray2.length);
            stringBuilder.append('.');
            stringBuilder.append(cArray, 0, 6);
        }
    }

    private static void appendTimeZone(StringBuilder stringBuilder, Calendar calendar, long l) {
        int n = calendar.getTimeZone().getOffset(l) / 1000 / 60;
        int n2 = Math.abs(n);
        int n3 = n2 / 60;
        int n4 = n2 - n3 * 60;
        stringBuilder.append(n >= 0 ? " +" : " -");
        if (n3 < 10) {
            stringBuilder.append('0');
        }
        stringBuilder.append(n3);
        if (n4 < 10) {
            stringBuilder.append('0');
        }
        stringBuilder.append(n4);
    }

    public static int getColumnSize(int n, int n2) throws ClientErrorException {
        switch (n) {
            case 5: {
                return 1;
            }
            case 6: {
                return 20;
            }
            case 7: {
                return 15;
            }
            case 16: {
                return TypeUtils.getPrecision(n, n2);
            }
            case 10: {
                return 10;
            }
            case 11: 
            case 15: {
                int n3 = TypeUtils.getPrecision(n, n2);
                if (n3 == 0) {
                    return 8;
                }
                return 9 + n3;
            }
            case 12: 
            case 13: {
                int n4 = TypeUtils.getPrecision(n, n2);
                if (n4 == 0) {
                    return 19;
                }
                return 20 + n4;
            }
            case 14: 
            case 114: {
                int n5 = TypeUtils.getIntervalLeadingPrecision(n, n2);
                int n6 = TypeUtils.getPrecision(n, n2);
                int n7 = TypeUtils.getSQLTypeFromOID(n, n2);
                switch (n7) {
                    case 101: 
                    case 102: 
                    case 103: 
                    case 104: 
                    case 105: {
                        return n5;
                    }
                    case 107: 
                    case 108: 
                    case 111: {
                        return 3 + n5;
                    }
                    case 109: {
                        return 6 + n5;
                    }
                    case 106: {
                        if (n6 == 0) {
                            return n5;
                        }
                        return n5 + 1 + n6;
                    }
                    case 110: {
                        if (n6 == 0) {
                            return 9 + n5;
                        }
                        return 9 + n5 + 1 + n6;
                    }
                    case 112: {
                        if (n6 == 0) {
                            return 6 + n5;
                        }
                        return 6 + n5 + 1 + n6;
                    }
                    case 113: {
                        if (n6 == 0) {
                            return 3 + n5;
                        }
                        return 3 + n5 + 1 + n6;
                    }
                }
                throw new ClientErrorException("Invalid interval range");
            }
            case 115: 
            case 116: {
                if (n2 <= -1) {
                    return 32000000;
                }
                return n2 - 4;
            }
            case 4: 
            case 8: 
            case 9: 
            case 17: 
            case 117: {
                if (n2 <= -1) {
                    return 65000;
                }
                return n2 - 4;
            }
            case 20: {
                return 16;
            }
        }
        if (n2 <= -1) {
            return 65000;
        }
        return n2 - 4;
    }

    public static String getTypeName(int n, int n2) throws ClientErrorException {
        switch (n) {
            case 5: {
                return "Boolean";
            }
            case 6: {
                return "Integer";
            }
            case 7: {
                return "Float";
            }
            case 8: {
                return "Char";
            }
            case 4: 
            case 9: {
                return "Varchar";
            }
            case 115: {
                return "Long Varchar";
            }
            case 10: {
                return "Date";
            }
            case 11: {
                return "Time";
            }
            case 15: {
                return "TimeTz";
            }
            case 12: {
                return "Timestamp";
            }
            case 13: {
                return "TimestampTz";
            }
            case 14: 
            case 114: {
                int n3 = TypeUtils.getIntervalRange(n, n2);
                switch (n3) {
                    case 101: {
                        return "Interval Year";
                    }
                    case 107: {
                        return "Interval Year to Month";
                    }
                    case 102: {
                        return "Interval Month";
                    }
                    case 103: {
                        return "Interval Day";
                    }
                    case 108: {
                        return "Interval Day to Hour";
                    }
                    case 109: {
                        return "Interval Day to Minute";
                    }
                    case 110: {
                        return "Interval Day to Second";
                    }
                    case 104: {
                        return "Interval Hour";
                    }
                    case 111: {
                        return "Interval Hour to Minute";
                    }
                    case 112: {
                        return "Interval Hour to Second";
                    }
                    case 105: {
                        return "Interval Minute";
                    }
                    case 113: {
                        return "Interval Minute to Second";
                    }
                    case 106: {
                        return "Interval Second";
                    }
                    case 10: {
                        return "Interval";
                    }
                }
                throw new ClientErrorException("Invalid interval range: " + n3);
            }
            case 117: {
                return "Binary";
            }
            case 17: {
                return "Varbinary";
            }
            case 116: {
                return "Long Varbinary";
            }
            case 16: {
                return "Numeric";
            }
            case 20: {
                return "Uuid";
            }
            case 301: 
            case 1505: 
            case 1506: 
            case 1507: 
            case 1508: 
            case 1509: 
            case 1510: 
            case 1511: 
            case 1512: 
            case 1513: 
            case 1514: 
            case 1515: 
            case 1516: 
            case 1517: 
            case 1518: 
            case 1519: 
            case 1520: 
            case 1521: 
            case 1522: {
                return "Array";
            }
            case 300: 
            case 302: {
                return "Struct";
            }
        }
        return "Unknown";
    }

    public static int getSQLTypeFromOID(int n, int n2) throws ClientErrorException {
        switch (n) {
            case 4: {
                return 12;
            }
            case 5: {
                return -7;
            }
            case 6: {
                return -5;
            }
            case 7: {
                return 8;
            }
            case 8: {
                return 1;
            }
            case 9: {
                return 12;
            }
            case 115: {
                return -1;
            }
            case 10: {
                return 91;
            }
            case 11: 
            case 15: {
                return 92;
            }
            case 12: 
            case 13: {
                return 93;
            }
            case 14: 
            case 114: {
                return TypeUtils.getIntervalRange(n, n2);
            }
            case 117: {
                return -2;
            }
            case 17: {
                return -3;
            }
            case 116: {
                return -4;
            }
            case 16: {
                return 2;
            }
            case 20: {
                return -11;
            }
            case 301: 
            case 1505: 
            case 1506: 
            case 1507: 
            case 1508: 
            case 1509: 
            case 1510: 
            case 1511: 
            case 1512: 
            case 1513: 
            case 1514: 
            case 1515: 
            case 1516: 
            case 1517: 
            case 1518: 
            case 1519: 
            case 1520: 
            case 1521: 
            case 1522: 
            case 2705: 
            case 2706: 
            case 2707: 
            case 2708: 
            case 2709: 
            case 2710: 
            case 2711: 
            case 2712: 
            case 2713: 
            case 2714: 
            case 2715: 
            case 2716: 
            case 2717: 
            case 2718: 
            case 2719: 
            case 2720: 
            case 2721: 
            case 2722: {
                return 2003;
            }
            case 300: 
            case 302: {
                return 2002;
            }
        }
        return 12;
    }

    public static int getOIDFromSQLType(int n) {
        switch (n) {
            case -7: {
                return 5;
            }
            case -5: {
                return 6;
            }
            case 8: {
                return 7;
            }
            case 1: {
                return 8;
            }
            case 12: {
                return 9;
            }
            case -1: {
                return 115;
            }
            case 91: {
                return 10;
            }
            case 92: {
                return 11;
            }
            case 93: {
                return 12;
            }
            case -2: {
                return 117;
            }
            case -3: {
                return 17;
            }
            case -4: {
                return 116;
            }
            case 2: {
                return 16;
            }
            case 101: 
            case 102: 
            case 107: {
                return 114;
            }
            case 103: 
            case 104: 
            case 105: 
            case 106: 
            case 108: 
            case 109: 
            case 110: 
            case 111: 
            case 112: 
            case 113: {
                return 14;
            }
            case -11: {
                return 20;
            }
        }
        return 4;
    }

    private static int getPrecision(int n, int n2) throws ClientErrorException {
        switch (n) {
            case 5: {
                return 1;
            }
            case 6: {
                return 19;
            }
            case 7: {
                return 15;
            }
            case 16: {
                if (n2 == -1) {
                    return 1024;
                }
                return n2 - 4 >> 16 & 0xFFFF;
            }
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 114: {
                if (n2 == -1) {
                    return 6;
                }
                return n2 & 0xF;
            }
        }
        return TypeUtils.getColumnSize(n, n2);
    }

    private static int getNumericScale(int n) {
        return n == -1 ? 15 : n - 4 & 0xFF;
    }

    private static boolean isStringType(int n) {
        switch (n) {
            case 4: 
            case 8: 
            case 9: 
            case 17: 
            case 115: 
            case 116: 
            case 117: {
                return true;
            }
        }
        return false;
    }

    private static int getIntervalLeadingPrecision(int n, int n2) throws ClientErrorException {
        if (n != 14 && n != 114) {
            throw new ClientErrorException("Invalid OID: " + n);
        }
        int n3 = TypeUtils.getIntervalRange(n, n2);
        if (n2 == -1) {
            if (n == 14) {
                n3 = 110;
            } else if (n == 114) {
                n3 = 107;
            }
        }
        switch (n3) {
            case 101: 
            case 107: {
                return 18;
            }
            case 102: {
                return 19;
            }
            case 103: 
            case 108: 
            case 109: 
            case 110: {
                return 9;
            }
            case 104: 
            case 111: 
            case 112: {
                return 10;
            }
            case 105: 
            case 113: {
                return 12;
            }
            case 106: {
                return 13;
            }
        }
        throw new ClientErrorException("Unexpected SQL type [" + n3 + "]");
    }

    private static int getIntervalRange(int n, int n2) throws ClientErrorException {
        if (n2 == -1) {
            if (n == 114) {
                return 107;
            }
            if (n == 14) {
                return 110;
            }
        }
        if (n == 114) {
            if ((n2 & 0x60000) == 393216) {
                return 107;
            }
            if ((n2 & 0x40000) == 262144) {
                return 101;
            }
            if ((n2 & 0x20000) == 131072) {
                return 102;
            }
            return 107;
        }
        if (n == 14) {
            if ((n2 & 0x1C080000) == 470286336) {
                return 110;
            }
            if ((n2 & 0xC080000) == 0xC080000) {
                return 109;
            }
            if ((n2 & 0x4080000) == 0x4080000) {
                return 108;
            }
            if ((n2 & 0x80000) == 524288) {
                return 103;
            }
            if ((n2 & 0x1C000000) == 0x1C000000) {
                return 112;
            }
            if ((n2 & 0xC000000) == 0xC000000) {
                return 111;
            }
            if ((n2 & 0x4000000) == 0x4000000) {
                return 104;
            }
            if ((n2 & 0x18000000) == 0x18000000) {
                return 113;
            }
            if ((n2 & 0x8000000) == 0x8000000) {
                return 105;
            }
            if ((n2 & 0x10000000) == 0x10000000) {
                return 106;
            }
            return 110;
        }
        throw new ClientErrorException("Invalid OID: " + n);
    }

    private static boolean isSigned(int n) {
        switch (n) {
            case 6: 
            case 7: 
            case 14: 
            case 16: 
            case 114: {
                return true;
            }
        }
        return false;
    }

    private static int getNano(byte[] byArray) {
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        if (byArray.length == 0) {
            return 0;
        }
        for (n2 = 0; n2 < byArray.length && byArray[n2] != 46; ++n2) {
        }
        if (n2 == byArray.length) {
            return 0;
        }
        for (n3 = ++n2; n3 < byArray.length && byArray[n3] != 43 && byArray[n3] != 45; ++n3) {
        }
        --n3;
        int n6 = 100000;
        for (int i = n2; i <= n3; ++i) {
            n += (byArray[i] - 48) * n6;
            n6 /= 10;
        }
        n4 = n / 1000;
        n5 = n % 1000;
        n = n4 * 1000000 + n5 * 1000;
        return n;
    }

    public static TypeMetadata createTypeMetadata(int n, int n2, String string) throws ClientErrorException {
        try {
            TypeMetadata typeMetadata = TypeMetadata.createTypeMetadata(TypeUtils.getSQLTypeFromOID(n, n2), TypeUtils.isSigned(n));
            short s = 0;
            if (!TypeUtils.isStringType(n)) {
                s = (short)TypeUtils.getPrecision(n, n2);
            }
            typeMetadata.setPrecision(s);
            if (!TypeUtils.isStringType(n)) {
                if (n == 16) {
                    short s2 = (short)TypeUtils.getNumericScale(n2);
                    typeMetadata.setScale(s2);
                } else if (n == 14 || n == 114) {
                    typeMetadata.setScale(s);
                    typeMetadata.setIntervalPrecision(TypeUtils.getIntervalLeadingPrecision(n, n2));
                }
            }
            typeMetadata.setTypeName(string);
            return typeMetadata;
        }
        catch (ErrorException errorException) {
            throw new ClientErrorException(errorException.getMessage());
        }
    }

    private static VerticaYearMonthInterval parseIntervalYM(int n, byte[] byArray, int n2) throws ClientErrorException {
        boolean bl = false;
        if (n2 == 1) {
            long l = ByteBuffer.wrap(byArray).getLong();
            if (l < 0L) {
                bl = true;
                l = -l;
            }
            switch (n) {
                case 101: {
                    return new VerticaYearMonthInterval(n, (int)(l / 12L), 0, bl);
                }
                case 102: {
                    return new VerticaYearMonthInterval(n, 0, (int)l, bl);
                }
                case 107: {
                    return new VerticaYearMonthInterval(n, (int)(l / 12L), (int)(l % 12L), bl);
                }
            }
            throw new ClientErrorException("Unexpected SQL type [" + n + "]");
        }
        int n3 = 0;
        if (byArray[n3] == 45) {
            ++n3;
            bl = true;
        }
        int n4 = 0;
        while (n3 < byArray.length && byArray[n3] != 45) {
            if (!Character.isDigit(byArray[n3])) {
                throw new ClientErrorException(byArray[n3] + " should be a digit, but is not");
            }
            n4 = n4 * 10 + (byArray[n3++] - 48);
        }
        if (n3 == byArray.length) {
            return n == 101 ? new VerticaYearMonthInterval(n, n4, 0, bl) : new VerticaYearMonthInterval(n, 0, n4, bl);
        }
        if (n != 107) {
            throw new ClientErrorException("Unexpected SQL type [" + n + "]");
        }
        if (byArray[n3] != 45) {
            throw new ClientErrorException("Illegal character [" + byArray[n3] + "]");
        }
        ++n3;
        int n5 = 0;
        while (n3 < byArray.length) {
            if (!Character.isDigit(byArray[n3])) {
                throw new ClientErrorException(byArray[n3] + " should be a digit, but is not");
            }
            n5 = n5 * 10 + (byArray[n3++] - 48);
        }
        return new VerticaYearMonthInterval(n, n4, n5, bl);
    }

    private static VerticaDayTimeInterval parseInterval(int n, int n2, byte[] byArray, int n3) throws ClientErrorException {
        boolean bl = false;
        int n4 = TypeUtils.getPrecision(14, n2);
        int[] nArray = new int[]{0, 0, 0, 0, 0};
        if (n3 == 1) {
            long l = ByteBuffer.wrap(byArray).getLong();
            if (l < 0L) {
                bl = true;
                l = -l;
            }
            nArray[4] = (int)(l % 1000000L);
            nArray[3] = (int)((l /= 1000000L) % 60L);
            nArray[2] = (int)((l /= 60L) % 60L);
            nArray[1] = (int)((l /= 60L) % 24L);
            nArray[0] = (int)(l / 24L);
            if (nArray[4] > 0 && n4 > 0) {
                int n5 = 6 - n4;
                while (n5-- > 0) {
                    nArray[4] = nArray[4] / 10;
                }
            }
        } else {
            int n6 = 0;
            if (byArray[n6] == 45) {
                ++n6;
                bl = true;
            }
            int n7 = 0;
            while (n6 < byArray.length && byArray[n6] != 32 && byArray[n6] != 58 && byArray[n6] != 46) {
                n7 = n7 * 10 + (byArray[n6++] - 48);
            }
            boolean bl2 = n6 < byArray.length && byArray[n6] == 32;
            ++n6;
            int n8 = 0;
            switch (n) {
                case 103: {
                    n8 = 0;
                    break;
                }
                case 108: 
                case 109: 
                case 110: {
                    n8 = bl2 || n6 > byArray.length ? 0 : 1;
                    break;
                }
                case 104: 
                case 111: 
                case 112: {
                    n8 = 1;
                    break;
                }
                case 105: 
                case 113: {
                    n8 = 2;
                    break;
                }
                case 106: {
                    n8 = 3;
                    break;
                }
                default: {
                    throw new ClientErrorException("Unexpected SqlType: " + n);
                }
            }
            nArray[n8++] = n7;
            n7 = 0;
            int n9 = 0;
            if (n6 < byArray.length) {
                while (n6 < byArray.length) {
                    if (byArray[n6] == 58 || byArray[n6] == 46) {
                        nArray[n8++] = n7;
                        n7 = 0;
                    } else {
                        if (!Character.isDigit(byArray[n6])) {
                            throw new ClientErrorException(byArray[n6] + " should be a digit, but is not");
                        }
                        n7 = n7 * 10 + (byArray[n6] - 48);
                        if (n8 == 4 && n7 == 0) {
                            ++n9;
                        }
                    }
                    ++n6;
                }
                nArray[n8++] = n7;
                n7 = 0;
            }
            int n10 = 1;
            for (int i = 1; i < n4 - n9; ++i) {
                n10 *= 10;
            }
            while (nArray[4] > 0 && nArray[4] < n10) {
                nArray[4] = nArray[4] * 10;
            }
        }
        try {
            return new VerticaDayTimeInterval(n, nArray[0], nArray[1], nArray[2], nArray[3], nArray[4], n4, bl);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return null;
        }
    }

    public static byte[] stringBytesToBinary(byte[] byArray) {
        if (byArray == null) {
            return null;
        }
        int n = byArray.length;
        byte[] byArray2 = new byte[n];
        int n2 = 0;
        for (int i = 0; i < n; ++i) {
            byte by = byArray[i];
            if (by == 92) {
                int n3;
                byte by2;
                if ((by2 = byArray[++i]) == 92) {
                    byArray2[n2++] = 92;
                    continue;
                }
                if ((n3 = (by2 - 48) * 64 + (byArray[++i] - 48) * 8 + (byArray[++i] - 48)) > 127) {
                    n3 -= 256;
                }
                byArray2[n2++] = (byte)n3;
                continue;
            }
            byArray2[n2++] = by;
        }
        byte[] byArray3 = new byte[n2];
        System.arraycopy(byArray2, 0, byArray3, 0, n2);
        return byArray3;
    }

    private static byte[] binaryToString(byte[] byArray) {
        if (byArray == null) {
            return null;
        }
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(byArray.length + 3 * (byArray.length / 256));
        int n = 0;
        for (int i = 0; i < byArray.length; ++i) {
            if (byArray[i] != 92) continue;
            byteArrayOutputStream.write(byArray, n, i - n);
            byteArrayOutputStream.write(BACKSLASH_ESCAPE, 0, BACKSLASH_ESCAPE.length);
            n = i + 1;
        }
        if (n == 0) {
            return byArray;
        }
        if (n < byArray.length) {
            byteArrayOutputStream.write(byArray, n, byArray.length - n);
        }
        return byteArrayOutputStream.toByteArray();
    }

    public static Time deserializeTimeFromTextEncoding(int n, byte[] byArray) throws UnsupportedEncodingException, ClientErrorException {
        int n2;
        int[] nArray = new int[4];
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        boolean bl = false;
        for (n2 = 0; n2 < byArray.length; ++n2) {
            if (byArray[n2] == 58 || byArray[n2] == 58 || byArray[n2] == 32) {
                ++n3;
                continue;
            }
            if (byArray[n2] == 46) {
                ++n3;
                n4 = n2 + 1;
                continue;
            }
            if (byArray[n2] == 43 || byArray[n2] == 45) {
                n5 = n2;
                bl = true;
                break;
            }
            nArray[n3] = byArray[n2] - 48 + nArray[n3] * 10;
        }
        if (n5 == 0) {
            n5 = byArray.length;
        }
        long l = (long)nArray[0] * 3600000L + (long)nArray[1] * 60000L + (long)(nArray[2] * 1000);
        for (int i = n5 - n4; i < 9; ++i) {
            nArray[3] = nArray[3] * 10;
        }
        l += (long)((nArray[3] + 500000) / 1000000);
        Calendar calendar = null;
        if (bl) {
            if (n != 15) {
                throw new ClientErrorException("Invalid timetz type " + n);
            }
            int n6 = n2;
            int n7 = TypeUtils.getTimeZoneOffSet(byArray, n6);
            calendar = Calendar.getInstance(new SimpleTimeZone(n7, new String(byArray, n6, byArray.length - n6, VConnection.VERTICA_CHARSET)));
            TimeTz timeTz = new TimeTz(new Time(l -= (long)n7), calendar);
            return timeTz;
        }
        long l2 = Calendar.getInstance().getTimeZone().getOffset(0L);
        l -= l2;
        if (n != 11) {
            throw new ClientErrorException("Invalid time type " + n);
        }
        Time time = new Time(l);
        return time;
    }

    static {
        for (int i = 0; i < NUMBERS.length; ++i) {
            TypeUtils.NUMBERS[i] = ((i < 10 ? "0" : "") + Integer.toString(i)).toCharArray();
        }
    }
}

