/*
 * Decompiled with CFR 0.152.
 */
package com.vertica.jdbc.jdbc4;

import com.vertica.dsi.core.interfaces.IConnection;
import com.vertica.dsi.dataengine.interfaces.IArray;
import com.vertica.exceptions.ExceptionConverter;
import com.vertica.jdbc.common.SConnection;
import com.vertica.jdbc.jdbc4.S4Array;
import com.vertica.support.LogUtilities;
import java.sql.Array;
import java.sql.SQLException;

public class S4Connection
extends SConnection {
    public S4Connection(IConnection conn, String url) throws SQLException {
        super(conn, url);
    }

    @Override
    public Array createArrayOf(String typeName, Object[] elements) throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.m_logger, typeName, elements);
            IConnection dsiConnection = this.getDSIConnection();
            IArray dsiArray = dsiConnection.createArrayOf(typeName, elements);
            return new S4Array(dsiArray, dsiConnection, this.m_logger, this.m_warningListener);
        }
        catch (Exception e) {
            throw ExceptionConverter.getInstance().toSQLException(e, this.m_warningListener, this.m_logger);
        }
    }
}

