/*
 * Decompiled with CFR 0.152.
 */
package com.vertica.core;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.vertica.dsi.core.impl.DSILogger;
import com.vertica.support.ILogger;
import com.vertica.support.LogUtilities;
import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.net.HttpURLConnection;
import java.net.URL;

public class OAuthConnection {
    String refreshToken;
    String tokenUrl;
    String clientId;
    String clientSecret;
    String discoveryUrl;
    String scope;
    DSILogger m_log;

    public OAuthConnection(String string, String string2, String string3, String string4, String string5, String string6, DSILogger dSILogger) {
        this.refreshToken = string;
        this.tokenUrl = string2;
        this.clientId = string3;
        this.clientSecret = string4;
        this.discoveryUrl = string5;
        this.scope = string6;
        this.m_log = dSILogger;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private String GetTokenResponse(String string) {
        try {
            String string2 = "grant_type=refresh_token&client_secret=" + this.clientSecret + "&client_id=" + this.clientId + "&refresh_token=" + this.refreshToken;
            if (this.scope != null && !this.scope.isEmpty()) {
                string2 = string2 + "&scope=" + this.scope;
            }
            byte[] byArray = string2.getBytes("UTF-8");
            int n = byArray.length;
            URL uRL = new URL(string);
            HttpURLConnection httpURLConnection = (HttpURLConnection)uRL.openConnection();
            try {
                String string3;
                httpURLConnection.setDoOutput(true);
                httpURLConnection.setUseCaches(false);
                httpURLConnection.setRequestMethod("POST");
                httpURLConnection.setRequestProperty("Content-Type", "application/x-www-form-urlencoded");
                httpURLConnection.setRequestProperty("Content-Length", Integer.toString(n));
                httpURLConnection.setRequestProperty("charset", "UTF-8");
                httpURLConnection.setRequestProperty("Accept", "application/json");
                httpURLConnection.getOutputStream().write(byArray);
                BufferedInputStream bufferedInputStream = new BufferedInputStream(httpURLConnection.getInputStream());
                ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                int n2 = bufferedInputStream.read();
                while (n2 != -1) {
                    byteArrayOutputStream.write((byte)n2);
                    n2 = bufferedInputStream.read();
                }
                String string4 = string3 = byteArrayOutputStream.toString("UTF-8");
                return string4;
            }
            catch (Exception exception) {
                String string5 = "";
                try {
                    BufferedInputStream bufferedInputStream = new BufferedInputStream(httpURLConnection.getErrorStream());
                    ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                    int n3 = bufferedInputStream.read();
                    while (true) {
                        if (n3 == -1) {
                            string5 = byteArrayOutputStream.toString("UTF-8");
                            throw new OAuthTokenRefreshException("Error when trying to refresh token, response was: " + string5, exception);
                        }
                        byteArrayOutputStream.write((byte)n3);
                        n3 = bufferedInputStream.read();
                    }
                }
                catch (Exception exception2) {
                    LogUtilities.logWarning("Error reading error stream from failed OAuth token refresh: " + exception2.toString(), (ILogger)this.m_log);
                    throw new OAuthTokenRefreshException("Error when trying to refresh token", exception);
                }
            }
            finally {
                httpURLConnection.disconnect();
            }
        }
        catch (OAuthTokenRefreshException oAuthTokenRefreshException) {
            throw oAuthTokenRefreshException;
        }
        catch (Exception exception) {
            throw new OAuthTokenRefreshException("Error connecting to token refresh server: ", exception);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private String DiscoverTokenEndpoint(String string) {
        try {
            URL uRL = new URL(string);
            HttpURLConnection httpURLConnection = (HttpURLConnection)uRL.openConnection();
            try {
                String string2;
                httpURLConnection.setDoOutput(true);
                httpURLConnection.setUseCaches(false);
                httpURLConnection.setRequestMethod("GET");
                BufferedInputStream bufferedInputStream = new BufferedInputStream(httpURLConnection.getInputStream());
                ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                int n = bufferedInputStream.read();
                while (n != -1) {
                    byteArrayOutputStream.write((byte)n);
                    n = bufferedInputStream.read();
                }
                String string3 = byteArrayOutputStream.toString("UTF-8");
                JsonElement jsonElement = new JsonParser().parse(string3);
                JsonObject jsonObject = jsonElement.getAsJsonObject();
                String string4 = string2 = jsonObject.get("token_endpoint").getAsString();
                return string4;
            }
            catch (Exception exception) {
                String string5 = "";
                try {
                    BufferedInputStream bufferedInputStream = new BufferedInputStream(httpURLConnection.getErrorStream());
                    ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                    int n = bufferedInputStream.read();
                    while (true) {
                        if (n == -1) {
                            string5 = byteArrayOutputStream.toString("UTF-8");
                            throw new OAuthEndpointDiscoveryException("Error when fetching token endpoints, response was: " + string5, exception);
                        }
                        byteArrayOutputStream.write((byte)n);
                        n = bufferedInputStream.read();
                    }
                }
                catch (Exception exception2) {
                    LogUtilities.logWarning("Error reading error stream from failed OAuth token endpoint discovery: " + exception2.toString(), (ILogger)this.m_log);
                    throw new OAuthEndpointDiscoveryException("Error when fetching token endpoints", exception);
                }
            }
            finally {
                httpURLConnection.disconnect();
            }
        }
        catch (OAuthEndpointDiscoveryException oAuthEndpointDiscoveryException) {
            throw oAuthEndpointDiscoveryException;
        }
        catch (Exception exception) {
            throw new OAuthEndpointDiscoveryException("Error connecting to identity provider: ", exception);
        }
    }

    public String GetActiveToken() {
        String string = this.tokenUrl;
        if (this.discoveryUrl.length() > 0) {
            string = this.DiscoverTokenEndpoint(this.discoveryUrl);
        }
        String string2 = this.GetTokenResponse(string);
        try {
            JsonElement jsonElement = new JsonParser().parse(string2);
            JsonObject jsonObject = jsonElement.getAsJsonObject();
            String string3 = jsonObject.get("access_token").getAsString();
            return string3;
        }
        catch (Exception exception) {
            throw new OAuthTokenRefreshException("Failed when parsing token refresh response. ", exception);
        }
    }

    public class OAuthEndpointDiscoveryException
    extends RuntimeException {
        public OAuthEndpointDiscoveryException(String string, Exception exception) {
            super(string, exception);
        }
    }

    public class OAuthTokenRefreshException
    extends RuntimeException {
        public OAuthTokenRefreshException(String string, Exception exception) {
            super(string, exception);
        }
    }
}

