/*
 * Decompiled with CFR 0.152.
 */
package com.vertica.jdbc.kv;

import com.vertica.core.VDriver;
import com.vertica.dsi.core.impl.DSIDriverSingleton;
import com.vertica.dsi.core.impl.DSIMessageSource;
import com.vertica.exceptions.ExceptionConverter;
import com.vertica.support.exceptions.ExceptionType;
import com.vertica.util.ServerErrorData;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.util.Locale;

enum KVErrors {
    NoSuchColumn("42703"),
    InvalidColumnName("42602"),
    InvalidTableName("42V01"),
    TypeNotSupported("0A000"),
    NotEnoughPredicates("22000"),
    NoCompatibleProjections("42V21"),
    VGetClosed("HY000"),
    RoutableConnectionClosed("HY000"),
    ClusterFailedNoConnections("08006"),
    GetRetriedAsMultinode("01000"),
    ConnectionFailedGetRetried("01V02"),
    ConnectionFailedMetadataRetried("01V02"),
    ConsistentReadNotStarted("55000"),
    FlexTableOutputExpressionsNotSupported("0A000"),
    ErrCodeNumericValueOutOfRange("22003"),
    RoutableExecutorClosed("HY000"),
    ImproperSqlStatement("22000"),
    MissingSegmentationColumnName("22000"),
    MissingSegmentationInformation("22000");

    private final int errorCode = 102000 + this.ordinal();
    private final String sqlState;
    private final ExceptionType sdkExceptionType;
    private static final DSIMessageSource msgSrc;
    private static final int KV_COMPONENT_ID = 102;
    private static final int KV_ERRCODE_BASE = 102000;

    private KVErrors(String string2) {
        this.sqlState = string2;
        this.sdkExceptionType = ServerErrorData.getExceptionTypeForSQLState(string2);
    }

    public SQLException makeException(Object ... objectArray) {
        return this.makeException(null, objectArray);
    }

    private String getErrorText(Object ... objectArray) {
        Locale locale = DSIDriverSingleton.getInstance().getLocale();
        String string = msgSrc.loadMessage(locale, 102, this.toString(), objectArray);
        StringBuilder stringBuilder = new StringBuilder(string.length() + 3 + 6);
        try {
            stringBuilder.append(string, 0, 16);
            stringBuilder.append("(");
            stringBuilder.append(this.errorCode);
            stringBuilder.append(") ");
            stringBuilder.append(string, 16, string.length());
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            stringBuilder.append(string);
        }
        return stringBuilder.toString();
    }

    public SQLException makeException(Exception exception, Object ... objectArray) {
        String string = this.getErrorText(objectArray);
        SQLException sQLException = ExceptionConverter.getInstance().toSQLException(this.sqlState, string, this.errorCode, this.sdkExceptionType);
        if (exception != null) {
            sQLException.initCause(exception);
        }
        return sQLException;
    }

    public SQLWarning makeWarning(Exception exception, Object ... objectArray) {
        String string = this.getErrorText(objectArray);
        SQLWarning sQLWarning = new SQLWarning(string, this.sqlState, this.errorCode, exception);
        return sQLWarning;
    }

    public SQLWarning makeWarning(Object ... objectArray) {
        return this.makeWarning(null, objectArray);
    }

    static {
        msgSrc = VDriver.s_msgSrc;
        msgSrc.registerMessages("com.vertica.jdbc.kv.KVErrors", 102, "VJDBC");
    }
}

