/*
 * Decompiled with CFR 0.152.
 */
package com.vertica.utilities;

import com.vertica.dsi.core.utilities.ConnSettingRequestMap;
import com.vertica.dsi.core.utilities.ConnSettingResponseMap;
import com.vertica.dsi.core.utilities.ConnectionSetting;
import com.vertica.dsi.core.utilities.Variant;
import com.vertica.support.exceptions.ErrorException;
import com.vertica.support.exceptions.GeneralException;
import java.sql.DriverPropertyInfo;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.Properties;

public class PropertyTypeConverter {
    public static ConnSettingRequestMap toConnSettingRequestMap(Properties prop) throws ErrorException {
        ConnSettingRequestMap requestMap = new ConnSettingRequestMap();
        if (null == prop) {
            return requestMap;
        }
        Enumeration<Object> keys = prop.keys();
        while (keys.hasMoreElements()) {
            String key = keys.nextElement().toString();
            try {
                Variant var = new Variant(0, prop.get(key).toString());
                requestMap.setProperty(key, var);
            }
            catch (Exception e) {
                int nativeErrorCode = 0;
                if (e instanceof SQLException) {
                    nativeErrorCode = ((SQLException)e).getErrorCode();
                } else if (e instanceof ErrorException) {
                    throw (ErrorException)e;
                }
                throw new GeneralException(e.getLocalizedMessage(), nativeErrorCode, (Throwable)e);
            }
        }
        return requestMap;
    }

    public static DriverPropertyInfo[] toDriverPropertyInfo(ConnSettingResponseMap map) {
        if (null == map) {
            return new DriverPropertyInfo[0];
        }
        DriverPropertyInfo[] infoArray = new DriverPropertyInfo[map.size()];
        Iterator<String> keys = map.getKeysIterator();
        int currElement = 0;
        while (keys.hasNext()) {
            String key = keys.next();
            ConnectionSetting setting = map.getProperty(key);
            infoArray[currElement] = new DriverPropertyInfo(key, null);
            infoArray[currElement].description = setting.getLabel();
            infoArray[currElement].required = setting.isRequired();
            ArrayList<Variant> varList = setting.getValues();
            infoArray[currElement].choices = new String[varList.size()];
            for (int i = 0; i < varList.size(); ++i) {
                infoArray[currElement].choices[i] = varList.get(i).getString();
            }
            ++currElement;
        }
        return infoArray;
    }
}

