/*
 * Decompiled with CFR 0.152.
 */
package com.vertica.dsi.utilities;

import com.vertica.support.exceptions.ErrorException;

public final class DataRetrievalUtilities {
    private DataRetrievalUtilities() {
    }

    public static byte[] retrieveBinaryData(byte[] in_data, long offset, long maxSize, long targetColLen, DataRetrievalStatus dataRetrievalStatus) throws ErrorException {
        if (offset != 0L && (offset >= (long)in_data.length || offset >= targetColLen)) {
            throw new IllegalArgumentException("Invalid offset: " + offset);
        }
        int dataEnd = maxSize == -1L || maxSize > Long.MAX_VALUE - offset || (long)in_data.length <= maxSize + offset ? in_data.length : (int)(maxSize + offset);
        if (offset == 0L && (long)in_data.length <= maxSize && (long)in_data.length <= targetColLen) {
            dataRetrievalStatus.isTruncate = false;
            dataRetrievalStatus.hasMoreData = false;
            return in_data;
        }
        int copyEnd = (int)Math.min((long)dataEnd, targetColLen);
        byte[] ret = new byte[(int)((long)copyEnd - offset)];
        for (int i = 0; i < ret.length; ++i) {
            ret[i] = in_data[(int)((long)i + offset)];
        }
        dataRetrievalStatus.isTruncate = targetColLen < (long)dataEnd;
        dataRetrievalStatus.hasMoreData = !dataRetrievalStatus.isTruncate && copyEnd < in_data.length;
        return ret;
    }

    public static String retrieveCharData(String in_data, long offset, long maxSize, long targetColLen, DataRetrievalStatus dataRetrievalStatus) throws ErrorException {
        if (offset % 2L == 1L) {
            throw new IllegalStateException("Invalid offset value: " + offset);
        }
        int strLen = in_data.length();
        if ((offset /= 2L) != 0L && (offset >= (long)strLen || offset >= targetColLen)) {
            dataRetrievalStatus.isTruncate = false;
            dataRetrievalStatus.hasMoreData = false;
            return "";
        }
        int dataEnd = maxSize == -1L || maxSize / 2L > Long.MAX_VALUE - offset || (long)strLen <= maxSize / 2L + offset ? strLen : (int)(offset + maxSize / 2L);
        if (offset == 0L && strLen == dataEnd && (long)strLen <= targetColLen) {
            dataRetrievalStatus.isTruncate = false;
            dataRetrievalStatus.hasMoreData = false;
            return in_data;
        }
        dataRetrievalStatus.isTruncate = targetColLen < (long)dataEnd;
        int copyEnd = (int)Math.min(targetColLen, (long)dataEnd);
        dataRetrievalStatus.hasMoreData = !dataRetrievalStatus.isTruncate && copyEnd < strLen;
        return in_data.substring((int)offset, copyEnd);
    }

    public static class DataRetrievalStatus {
        public boolean isTruncate;
        public boolean hasMoreData;
    }
}

