/*
 * Decompiled with CFR 0.152.
 */
package com.vertica.jdbc.kv;

import com.vertica.core.VConnection;
import com.vertica.jdbc.kv.KVErrors;
import com.vertica.jdbc.kv.KVLogger;
import com.vertica.jdbc.kv.RoutableConnection;
import com.vertica.jdbc.kv.RoutableConnectionInternal;
import com.vertica.jdbc.kv.RoutableConnectionList;
import com.vertica.jdbc.kv.SQLExceptionChainer;
import com.vertica.jdbc.kv.VerticaRoutableConnection;
import java.sql.Driver;
import java.sql.DriverManager;
import java.sql.DriverPropertyInfo;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.atomic.AtomicInteger;

public class RoutableConnectionPool {
    Map<String, RoutableConnectionList> conns;
    List<String> nodes;
    int finger;
    int forceCloseFinger;
    long createTime;
    long totalOpens;
    long totalCloses;
    long checkoutTime;
    String username;
    String password;
    public int activeCheckouts;
    Driver driver = DriverManager.getDriver("jdbc:vertica");
    VerticaRoutableConnection parentConn;
    VConnection vConn;
    AtomicInteger connCounter;
    KVLogger log;

    public RoutableConnectionPool(RoutableConnectionInternal routableConnectionInternal, KVLogger kVLogger) throws SQLException {
        String string;
        Object object;
        this.parentConn = routableConnectionInternal.getRoutableConnection();
        this.connCounter = new AtomicInteger(0);
        this.log = kVLogger;
        this.vConn = routableConnectionInternal.getConnection();
        this.conns = new HashMap<String, RoutableConnectionList>();
        this.nodes = new ArrayList<String>();
        Statement statement = this.parentConn.createStatement();
        ResultSet resultSet = statement.executeQuery("select node_name, node_port from node_resources");
        HashMap<Object, String> hashMap = new HashMap<Object, String>();
        while (resultSet.next()) {
            object = resultSet.getString(1);
            string = resultSet.getString(2);
            hashMap.put(object, string);
        }
        resultSet.close();
        resultSet = statement.executeQuery("select node_name, node_address, export_address from nodes");
        object = this.extractConnectionProps();
        while (resultSet.next()) {
            Object object22;
            string = resultSet.getString(1);
            String string2 = resultSet.getString(2);
            String string3 = resultSet.getString(3);
            if (!"0".equals(string3)) {
                ((Properties)object).setProperty("host", string3);
            } else {
                ((Properties)object).setProperty("host", string2);
            }
            Properties properties = new Properties();
            for (Object object22 : ((Properties)object).keySet()) {
                String string4 = object22.toString();
                properties.setProperty(string4, ((Properties)object).getProperty(string4));
            }
            String string5 = (String)hashMap.get(string);
            if (string5 != null && !string5.equals(((Properties)object).getProperty("port"))) {
                properties.put("port", string5);
            }
            object22 = new RoutableConnectionList(this, string, properties);
            this.conns.put(string, (RoutableConnectionList)object22);
            this.nodes.add(string);
        }
        this.log.logInfo("Got " + this.nodes.size() + " nodes");
    }

    private Properties extractConnectionProps() throws SQLException {
        DriverPropertyInfo[] driverPropertyInfoArray;
        Properties properties = new Properties();
        for (DriverPropertyInfo driverPropertyInfo : driverPropertyInfoArray = this.driver.getPropertyInfo("jdbc:vertica", properties)) {
            Object object = this.parentConn.getProperty(driverPropertyInfo.name);
            if (object == null) continue;
            properties.setProperty(driverPropertyInfo.name, object.toString());
        }
        properties.setProperty("enableroutablequeries", "false");
        properties.setProperty("connectionloadbalance", "false");
        properties.setProperty("autocommit", "false");
        properties.setProperty("resultbuffersize", "0");
        properties.setProperty("password", this.vConn.getPassword());
        properties.setProperty("keystorepassword", this.vConn.getKeyStorePassword());
        properties.setProperty("truststorepassword", this.vConn.getTrustStorePassword());
        if (!properties.containsKey("sessionlabel")) {
            properties.setProperty("sessionlabel", "vjdbc-routable-conn");
        }
        properties.setProperty("simplequeriesonly", "true");
        return properties;
    }

    public synchronized RoutableConnection getAnyConnection() throws SQLException {
        return this.getConnection(this.nodes, true);
    }

    public synchronized RoutableConnection getConnection(List<String> list) throws SQLException {
        return this.getConnection(list, false);
    }

    public synchronized RoutableConnection getConnection(List<String> list, boolean bl) throws SQLException {
        int n;
        int n2 = list.size();
        int n3 = n = bl ? this.finger : 0;
        if (bl) {
            ++this.finger;
        }
        ++this.forceCloseFinger;
        int n4 = 0;
        long l = this.activeCheckouts > 0 ? this.checkoutTime / (long)this.activeCheckouts : this.checkoutTime;
        long l2 = System.currentTimeMillis() + l;
        long l3 = 0L;
        int n5 = 0;
        while (true) {
            Object object;
            Object object2;
            int n6;
            ++n5;
            int n7 = n % n2;
            n4 = 0;
            for (n6 = 0; n6 < n2; ++n6) {
                RoutableConnectionList routableConnectionList = this.conns.get(list.get(n7));
                object2 = routableConnectionList.checkout();
                if (object2 != null) {
                    return object2;
                }
                n4 += routableConnectionList.numOpen;
                if (++n7 != n2) continue;
                n7 = 0;
            }
            if (n4 > 0 && l > 0L) {
                try {
                    this.wait(l);
                }
                catch (InterruptedException interruptedException) {
                    Thread.currentThread().interrupt();
                }
                l = l2 - System.currentTimeMillis();
                continue;
            }
            boolean bl2 = true;
            if (this.totalOpens - this.totalCloses < (long)this.vConn.getMaxPooledConnections()) {
                n7 = n % n2;
                for (n6 = 0; n6 < n2; ++n6) {
                    object2 = this.conns.get(list.get(n7));
                    object = ((RoutableConnectionList)object2).construct();
                    if (object != null) {
                        return object;
                    }
                    bl2 &= ((RoutableConnectionList)object2).lastFailureTime > 0L;
                    if (++n7 != n2) continue;
                    n7 = 0;
                }
                if (this.totalOpens == this.totalCloses) {
                    throw KVErrors.ClusterFailedNoConnections.makeException(new Object[0]);
                }
            } else if (n2 < this.nodes.size()) {
                n7 = (this.forceCloseFinger + 1) % this.nodes.size();
                n6 = 0;
                while (n6 < this.nodes.size()) {
                    object2 = this.nodes.get(n7);
                    if (!list.contains(object2)) {
                        object = this.conns.get(object2);
                        if (((RoutableConnectionList)object).consume(false)) {
                            object = this.conns.get(list.get(n % n2));
                            RoutableConnection routableConnection = ((RoutableConnectionList)object).construct();
                            if (routableConnection != null) {
                                return routableConnection;
                            }
                            bl2 &= ((RoutableConnectionList)object).lastFailureTime > 0L;
                        }
                        ++n6;
                    }
                    if (++n7 != this.nodes.size()) continue;
                    n7 = 0;
                }
            }
            try {
                if (bl2) {
                    l3 = Math.max(1L, l);
                }
                if (this.log.isEnabled()) {
                    this.log.logDebug("No connections to " + list.toString() + " available; waiting for one. Attempt #" + n5);
                }
                this.wait(l3);
                continue;
            }
            catch (InterruptedException interruptedException) {
                Thread.currentThread().interrupt();
                continue;
            }
            break;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void returnConnection(RoutableConnection routableConnection) throws SQLException {
        try {
            this.conns.get(routableConnection.node).checkin(routableConnection);
        }
        finally {
            --this.activeCheckouts;
            this.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void destroyConnection(RoutableConnection routableConnection) {
        try {
            this.conns.get(routableConnection.node).remove(routableConnection);
        }
        catch (SQLException sQLException) {
        }
        finally {
            --this.activeCheckouts;
            this.notifyAll();
        }
    }

    public synchronized void shutdown() throws SQLException {
        this.log.logInfo("Shutting down connection pool");
        SQLExceptionChainer sQLExceptionChainer = new SQLExceptionChainer();
        while (this.totalOpens > this.totalCloses) {
            for (String string : this.nodes) {
                RoutableConnectionList routableConnectionList = this.conns.get(string);
                boolean bl = true;
                while (bl) {
                    try {
                        bl = routableConnectionList.consume(true);
                    }
                    catch (SQLException sQLException) {
                        sQLExceptionChainer.add(sQLException);
                    }
                }
            }
            if (this.totalOpens > this.totalCloses) {
                try {
                    this.wait();
                }
                catch (InterruptedException interruptedException) {
                    Thread.currentThread().interrupt();
                }
            }
            sQLExceptionChainer.throwIfSet();
        }
    }
}

