/*
 * Decompiled with CFR 0.152.
 */
package com.vertica.dsi.core.utilities;

import com.vertica.dsi.core.impl.DSIDriver;
import com.vertica.dsi.core.interfaces.IConnection;
import com.vertica.dsi.core.utilities.Variant;
import com.vertica.dsi.exceptions.BadAttrValException;
import com.vertica.dsi.exceptions.IncorrectTypeException;
import com.vertica.dsi.exceptions.NumericOverflowException;
import com.vertica.dsi.utilities.DSIMessageKey;
import com.vertica.support.IWarningListener;
import com.vertica.support.LogUtilities;
import com.vertica.support.Warning;
import com.vertica.support.exceptions.ErrorException;
import com.vertica.support.exceptions.ExceptionType;

public class PropertyUtilities {
    public static boolean hasCatalogSupport(IConnection connection) {
        assert (null != connection);
        try {
            if (0 == connection.getProperty(9).getString().length()) {
                return false;
            }
            if (0 == connection.getProperty(11).getString().length()) {
                return false;
            }
            return 0L != connection.getProperty(12).getLong();
        }
        catch (Exception e) {
            return false;
        }
    }

    public static boolean hasSavepointSupport(IConnection connection) {
        assert (null != connection);
        try {
            Variant variant = connection.getProperty(1000);
            return 1 == variant.getShort();
        }
        catch (Exception e) {
            return false;
        }
    }

    public static boolean hasSchemaSupport(IConnection connection) {
        assert (null != connection);
        try {
            if (0 == connection.getProperty(99).getString().length()) {
                return false;
            }
            return 0L != connection.getProperty(100).getLong();
        }
        catch (Exception e) {
            return false;
        }
    }

    public static boolean hasStoredFunctionsCallsSupport(IConnection connection) {
        assert (null != connection);
        try {
            Variant variant = connection.getProperty(1003);
            Short value = variant.getShort();
            return 1 == value;
        }
        catch (Exception e) {
            return false;
        }
    }

    public static boolean hasStoredProcedureSupport(IConnection connection) {
        assert (null != connection);
        try {
            if (0 == connection.getProperty(96).getString().length()) {
                return false;
            }
            return "Y".equals(connection.getProperty(97).getString());
        }
        catch (Exception e) {
            return false;
        }
    }

    public static boolean isReadOnly(IConnection connection) {
        assert (null != connection);
        try {
            long readOnly = connection.getProperty(16).getLong();
            if (1L != readOnly) {
                return false;
            }
            return "Y".equals(connection.getProperty(40).getString());
        }
        catch (Exception e) {
            return false;
        }
    }

    public static void setCatalogSupport(IConnection connection, boolean isEnabled) throws ErrorException {
        assert (null != connection);
        IWarningListener warningListener = connection.getWarningListener();
        if (null == warningListener) {
            warningListener = connection.getParentEnvironment().getWarningListener();
        }
        try {
            if (isEnabled) {
                connection.setProperty(9, new Variant(0, "Y"));
                connection.setProperty(11, new Variant(0, "catalog"));
                connection.setProperty(12, new Variant(3, 31L));
            } else {
                connection.setProperty(9, new Variant(0, "N"));
                connection.setProperty(11, new Variant(0, ""));
                connection.setProperty(12, new Variant(3, 0L));
            }
        }
        catch (BadAttrValException be) {
            throw DSIDriver.s_DSIMessages.createGeneralException(DSIMessageKey.BAD_ATTR_VAL.name(), (Throwable)be, ExceptionType.DEFAULT);
        }
        catch (NumericOverflowException noe) {
            throw DSIDriver.s_DSIMessages.createGeneralException(DSIMessageKey.PROP_NUMERIC_OVERFLOW.name(), (Throwable)noe, ExceptionType.DEFAULT);
        }
        catch (IncorrectTypeException ite) {
            throw DSIDriver.s_DSIMessages.createGeneralException(DSIMessageKey.PROP_VALTYPE_MISMATCH.name(), (Throwable)ite, ExceptionType.DEFAULT);
        }
        finally {
            PropertyUtilities.logWarnings(connection, warningListener);
        }
    }

    public static void setReadOnly(IConnection connection, boolean isReadOnly) throws ErrorException {
        assert (null != connection);
        IWarningListener warningListener = connection.getWarningListener();
        if (null == warningListener) {
            warningListener = connection.getParentEnvironment().getWarningListener();
        }
        try {
            if (isReadOnly) {
                connection.setProperty(16, new Variant(3, 1L));
                connection.setProperty(40, new Variant(0, "Y"));
            } else {
                connection.setProperty(16, new Variant(3, 0L));
                connection.setProperty(40, new Variant(0, "N"));
            }
        }
        catch (BadAttrValException be) {
            throw DSIDriver.s_DSIMessages.createGeneralException(DSIMessageKey.BAD_ATTR_VAL.name(), (Throwable)be, ExceptionType.DEFAULT);
        }
        catch (NumericOverflowException noe) {
            throw DSIDriver.s_DSIMessages.createGeneralException(DSIMessageKey.PROP_NUMERIC_OVERFLOW.name(), (Throwable)noe, ExceptionType.DEFAULT);
        }
        catch (IncorrectTypeException ite) {
            throw DSIDriver.s_DSIMessages.createGeneralException(DSIMessageKey.PROP_VALTYPE_MISMATCH.name(), (Throwable)ite, ExceptionType.DEFAULT);
        }
        finally {
            PropertyUtilities.logWarnings(connection, warningListener);
        }
    }

    public static void setSavepointSupport(IConnection connection, boolean isEnabled) throws ErrorException {
        assert (null != connection);
        IWarningListener warningListener = connection.getWarningListener();
        if (null == warningListener) {
            warningListener = connection.getParentEnvironment().getWarningListener();
        }
        try {
            if (isEnabled) {
                connection.setProperty(1000, new Variant(5, (short)1));
            } else {
                connection.setProperty(1000, new Variant(5, (short)0));
            }
        }
        catch (BadAttrValException be) {
            throw DSIDriver.s_DSIMessages.createGeneralException(DSIMessageKey.BAD_ATTR_VAL.name(), (Throwable)be, ExceptionType.DEFAULT);
        }
        catch (NumericOverflowException noe) {
            throw DSIDriver.s_DSIMessages.createGeneralException(DSIMessageKey.PROP_NUMERIC_OVERFLOW.name(), (Throwable)noe, ExceptionType.DEFAULT);
        }
        catch (IncorrectTypeException ite) {
            throw DSIDriver.s_DSIMessages.createGeneralException(DSIMessageKey.PROP_VALTYPE_MISMATCH.name(), (Throwable)ite, ExceptionType.DEFAULT);
        }
        finally {
            PropertyUtilities.logWarnings(connection, warningListener);
        }
    }

    public static void setSchemaSupport(IConnection connection, boolean isEnabled) throws ErrorException {
        assert (null != connection);
        IWarningListener warningListener = connection.getWarningListener();
        if (null == warningListener) {
            warningListener = connection.getParentEnvironment().getWarningListener();
        }
        try {
            if (isEnabled) {
                connection.setProperty(99, new Variant(0, "schema"));
                connection.setProperty(100, new Variant(3, 31L));
                connection.setProperty(81, new Variant(2, Character.valueOf('\u0100')));
            } else {
                connection.setProperty(99, new Variant(0, ""));
                connection.setProperty(100, new Variant(3, 0L));
                connection.setProperty(81, new Variant(2, Character.valueOf('\u0000')));
            }
        }
        catch (BadAttrValException be) {
            throw DSIDriver.s_DSIMessages.createGeneralException(DSIMessageKey.BAD_ATTR_VAL.name(), (Throwable)be, ExceptionType.DEFAULT);
        }
        catch (NumericOverflowException noe) {
            throw DSIDriver.s_DSIMessages.createGeneralException(DSIMessageKey.PROP_NUMERIC_OVERFLOW.name(), (Throwable)noe, ExceptionType.DEFAULT);
        }
        catch (IncorrectTypeException ite) {
            throw DSIDriver.s_DSIMessages.createGeneralException(DSIMessageKey.PROP_VALTYPE_MISMATCH.name(), (Throwable)ite, ExceptionType.DEFAULT);
        }
        finally {
            PropertyUtilities.logWarnings(connection, warningListener);
        }
    }

    public static void setStoredFunctionsCallsSupport(IConnection connection, boolean isEnabled) throws ErrorException {
        assert (null != connection);
        IWarningListener warningListener = connection.getWarningListener();
        if (null == warningListener) {
            warningListener = connection.getParentEnvironment().getWarningListener();
        }
        try {
            if (isEnabled) {
                connection.setProperty(1003, new Variant(5, (short)1));
            } else {
                connection.setProperty(1003, new Variant(5, (short)0));
            }
        }
        catch (BadAttrValException be) {
            throw DSIDriver.s_DSIMessages.createGeneralException(DSIMessageKey.BAD_ATTR_VAL.name(), (Throwable)be, ExceptionType.DEFAULT);
        }
        catch (NumericOverflowException noe) {
            throw DSIDriver.s_DSIMessages.createGeneralException(DSIMessageKey.PROP_NUMERIC_OVERFLOW.name(), (Throwable)noe, ExceptionType.DEFAULT);
        }
        catch (IncorrectTypeException ite) {
            throw DSIDriver.s_DSIMessages.createGeneralException(DSIMessageKey.PROP_VALTYPE_MISMATCH.name(), (Throwable)ite, ExceptionType.DEFAULT);
        }
        finally {
            PropertyUtilities.logWarnings(connection, warningListener);
        }
    }

    public static void setStoredProcedureSupport(IConnection connection, boolean isEnabled) throws ErrorException {
        assert (null != connection);
        IWarningListener warningListener = connection.getWarningListener();
        if (null == warningListener) {
            warningListener = connection.getParentEnvironment().getWarningListener();
        }
        try {
            if (isEnabled) {
                connection.setProperty(96, new Variant(0, "procedure"));
                connection.setProperty(97, new Variant(0, "Y"));
            } else {
                connection.setProperty(96, new Variant(0, ""));
                connection.setProperty(97, new Variant(0, "N"));
            }
        }
        catch (BadAttrValException be) {
            throw DSIDriver.s_DSIMessages.createGeneralException(DSIMessageKey.BAD_ATTR_VAL.name(), (Throwable)be, ExceptionType.DEFAULT);
        }
        catch (NumericOverflowException noe) {
            throw DSIDriver.s_DSIMessages.createGeneralException(DSIMessageKey.PROP_NUMERIC_OVERFLOW.name(), (Throwable)noe, ExceptionType.DEFAULT);
        }
        catch (IncorrectTypeException ite) {
            throw DSIDriver.s_DSIMessages.createGeneralException(DSIMessageKey.PROP_VALTYPE_MISMATCH.name(), (Throwable)ite, ExceptionType.DEFAULT);
        }
        finally {
            PropertyUtilities.logWarnings(connection, warningListener);
        }
    }

    private static void logWarnings(IConnection connection, IWarningListener warningListener) {
        if (null != warningListener) {
            for (Warning warning : warningListener.getWarnings()) {
                LogUtilities.logWarning(warning.getMessage(), connection.getConnectionLog());
            }
        }
    }
}

