/*
 * Decompiled with CFR 0.152.
 */
package com.vertica.support;

import com.vertica.support.IMessageSource;
import com.vertica.support.WarningCode;
import com.vertica.support.exceptions.DiagState;
import java.util.Locale;

public class Warning {
    private int m_nativeErrorCode = -1;
    private WarningCode m_warningCode;
    private String m_customState;
    private String m_msgKey;
    private String[] m_msgParams = null;
    private String m_message;
    private int m_componentId;
    private long m_rowNumber;
    private int m_columnNumber;
    private boolean m_hasPreformattedMessage = false;

    public Warning(WarningCode warningCode, String message, int nativeErrorCode) {
        this(warningCode, message, nativeErrorCode, -1L, -1);
    }

    public Warning(WarningCode warningCode, String message, int nativeErrorCode, long rowNumber, int columnNumber) {
        this.m_warningCode = warningCode;
        this.m_message = null == message ? "" : message;
        this.m_nativeErrorCode = nativeErrorCode;
        this.m_rowNumber = rowNumber;
        this.m_columnNumber = columnNumber;
    }

    public Warning(WarningCode warningCode, int componentId, String msgKey) {
        this(warningCode, componentId, msgKey, -1L, -1);
    }

    public Warning(WarningCode warningCode, int componentId, String msgKey, String[] msgParams) {
        this(warningCode, componentId, msgKey, msgParams, -1L, -1);
    }

    public Warning(WarningCode warningCode, int componentId, String msgKey, long rowNumber, int columnNumber) {
        this(warningCode, componentId, msgKey, null, rowNumber, columnNumber);
    }

    public Warning(WarningCode warningCode, int componentId, String msgKey, String[] msgParams, long rowNumber, int columnNumber) {
        this.m_warningCode = warningCode;
        this.m_customState = null;
        this.m_componentId = componentId;
        this.m_msgKey = msgKey;
        this.m_msgParams = msgParams;
        this.m_rowNumber = rowNumber;
        this.m_columnNumber = columnNumber;
    }

    public Warning(WarningCode warningCode, String message) {
        this(warningCode, message, -1, -1);
    }

    public Warning(WarningCode warningCode, String message, int rowNumber, int columnNumber) {
        this.m_warningCode = warningCode;
        this.m_message = null == message ? "" : message;
        this.m_hasPreformattedMessage = true;
        this.m_rowNumber = rowNumber;
        this.m_columnNumber = columnNumber;
    }

    public Warning(String customState, String message) {
        this(customState, message, -1, -1);
    }

    public Warning(String customState, String message, int rowNumber, int columnNumber) {
        this.m_warningCode = WarningCode.GENERAL_WARNING;
        this.m_customState = customState;
        this.m_message = null == message ? "" : message;
        this.m_hasPreformattedMessage = true;
        this.m_rowNumber = rowNumber;
        this.m_columnNumber = columnNumber;
    }

    public Warning(String customState, int componentId, String msgKey, int rowNumber, int columnNumber) {
        this(customState, componentId, msgKey, null, rowNumber, columnNumber);
    }

    public Warning(String customState, int componentId, String msgKey, String[] msgParams, int rowNumber, int columnNumber) {
        this.m_warningCode = WarningCode.GENERAL_WARNING;
        this.m_customState = customState;
        this.m_componentId = componentId;
        this.m_msgKey = msgKey;
        this.m_msgParams = msgParams;
        this.m_rowNumber = rowNumber;
        this.m_columnNumber = columnNumber;
    }

    public Warning(String customState, String message, int nativeErrorCode) {
        this(customState, message, nativeErrorCode, -1, -1);
    }

    public Warning(String customState, String message, int nativeErrorCode, int rowNumber, int columnNumber) {
        this.m_warningCode = WarningCode.GENERAL_WARNING;
        this.m_customState = customState;
        this.m_message = null == message ? "" : message;
        this.m_hasPreformattedMessage = true;
        this.m_nativeErrorCode = nativeErrorCode;
        this.m_rowNumber = rowNumber;
        this.m_columnNumber = columnNumber;
    }

    public Warning(String customState, String message, int nativeErrorCode, long rowNumber, int columnNumber, DiagState diagState) {
        this.m_warningCode = WarningCode.getWarningCode(diagState);
        this.m_customState = customState;
        this.m_message = null == message ? "" : message;
        this.m_hasPreformattedMessage = true;
        this.m_nativeErrorCode = nativeErrorCode;
        this.m_rowNumber = rowNumber;
        this.m_columnNumber = columnNumber;
    }

    public int getNativeErrorCode() {
        return this.m_nativeErrorCode;
    }

    public int getColumnNumber() {
        return this.m_columnNumber;
    }

    public int getComponentId() {
        return this.m_componentId;
    }

    public String getCustomState() {
        return this.m_customState;
    }

    public String getMessage() {
        return this.m_message;
    }

    public String getMessageKey() {
        return this.m_msgKey;
    }

    public String[] getMessageParams() {
        return this.m_msgParams;
    }

    public long getRowNumber() {
        return this.m_rowNumber;
    }

    public WarningCode getWarningCode() {
        return this.m_warningCode;
    }

    public boolean hasCustomState() {
        return null != this.m_customState;
    }

    public boolean hasMessageParams() {
        return null != this.m_msgParams;
    }

    public boolean hasPreformattedMessage() {
        return this.m_hasPreformattedMessage;
    }

    public void setLocalizedWarningMessage(IMessageSource messageSource, Locale locale) {
        if (this.m_hasPreformattedMessage || null == this.m_msgKey) {
            return;
        }
        this.m_message = this.hasMessageParams() ? messageSource.loadMessage(locale, this.m_componentId, this.m_msgKey, this.m_msgParams) : messageSource.loadMessage(locale, this.m_componentId, this.m_msgKey);
    }
}

