/*
 * Decompiled with CFR 0.152.
 */
package com.vertica.core;

import com.vertica.core.AddressList;
import com.vertica.core.OAuthConnection;
import com.vertica.core.VConnectionPropertyKey;
import com.vertica.core.VConnectionPropertyValue;
import com.vertica.core.VDriver;
import com.vertica.core.VEnvironment;
import com.vertica.core.VStatement;
import com.vertica.dataengine.SimpleQueryExecutor;
import com.vertica.dataengine.VMetadataSource;
import com.vertica.dataengine.VQueryExecutor;
import com.vertica.dataengine.VResultSet;
import com.vertica.dataengine.VStreamQueryExecutor;
import com.vertica.dsi.core.impl.DSIConnection;
import com.vertica.dsi.core.impl.DSILogger;
import com.vertica.dsi.core.interfaces.ITransactionStateListener;
import com.vertica.dsi.core.utilities.ClientInfoData;
import com.vertica.dsi.core.utilities.ConnSettingRequestMap;
import com.vertica.dsi.core.utilities.ConnSettingResponseMap;
import com.vertica.dsi.core.utilities.ConnectionSetting;
import com.vertica.dsi.core.utilities.Variant;
import com.vertica.dsi.dataengine.utilities.DataWrapper;
import com.vertica.dsi.dataengine.utilities.MetadataSourceColumnTag;
import com.vertica.dsi.dataengine.utilities.MetadataSourceID;
import com.vertica.dsi.exceptions.BadAttrValException;
import com.vertica.dsi.exceptions.BadAuthException;
import com.vertica.dsi.exceptions.BadPropertyKeyException;
import com.vertica.dsi.exceptions.IncorrectTypeException;
import com.vertica.dsi.exceptions.NumericOverflowException;
import com.vertica.dsi.exceptions.UtilsException;
import com.vertica.io.CopyErrorRequestMessage;
import com.vertica.io.ProtocolStream;
import com.vertica.io.ReadyForQueryResponseMessage;
import com.vertica.io.TerminateRequestMessage;
import com.vertica.localization.VMessageKey;
import com.vertica.security.KeyStoreResolver;
import com.vertica.security.TLSMode;
import com.vertica.security.TrustStoreResolver;
import com.vertica.support.ILogger;
import com.vertica.support.LogLevel;
import com.vertica.support.LogUtilities;
import com.vertica.support.Warning;
import com.vertica.support.WarningCode;
import com.vertica.support.exceptions.ClientInfoException;
import com.vertica.support.exceptions.DiagState;
import com.vertica.support.exceptions.ErrorException;
import com.vertica.support.exceptions.FailedPropertiesReason;
import com.vertica.support.exceptions.GeneralException;
import com.vertica.support.exceptions.InvalidAuthorizationException;
import com.vertica.support.exceptions.NonTransientConnectionException;
import com.vertica.util.ClientErrorException;
import com.vertica.util.ClientException;
import com.vertica.util.FeatureNotSupportedClientException;
import com.vertica.util.Features;
import com.vertica.util.LRSException;
import com.vertica.util.LRSWork;
import com.vertica.util.ProtocolUtils;
import com.vertica.util.ServerErrorData;
import com.vertica.util.TransactionStateException;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.Properties;
import java.util.UUID;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.ReentrantLock;

public class VConnection
extends DSIConnection {
    private static final int MAX_LABEL_LENGTH = 255;
    private static final String LOG_PREFIX_NAME = "vjdbc";
    private static final Properties s_buildProps;
    private static final String CLIENT_INFO_PROPERTY_APPLICATION_NAME = "APPLICATIONNAME";
    private static final String CLIENT_INFO_PROPERTY_CLIENT_USER = "CLIENTUSER";
    private static SimpleDateFormat LOG_DATE_FORMAT;
    private static final AtomicInteger s_connectionCounter;
    static final int AUTH_FAILED = 2248;
    static final int INVALID_USERNAME_OR_PASSWORD = 3781;
    static final int MISSING_USERNAME_FIELD = 4131;
    private OAuthConnection oauthConnection;
    public static final String VERTICA_CHARSET;
    public static final String DRIVER_FILENAME;
    private DSILogger m_log;
    private String m_logPackage;
    private String m_logPath;
    private ProtocolStream m_protocolStream;
    private SimpleQueryExecutor m_simpleQueryExecutor;
    private AtomicInteger m_statementCounter;
    private String m_host;
    private String m_dbname;
    private String m_user;
    private TLSMode m_tlsMode;
    private String m_password;
    private int m_port;
    private String m_hostnameVerifier;
    private KeyStoreResolver m_keyStore;
    private TrustStoreResolver m_trustStore;
    private TrustStoreResolver m_oauth_trustStore;
    private String m_sslSocketFactory;
    private int m_fixedProtocolVersion;
    private int m_loginTimeout;
    private int m_loginNetworkTimeout;
    private int m_loginNodeTimeout;
    private boolean m_isTimeout;
    private String m_socketFactoryName;
    private String m_sessionLabel;
    private boolean m_directBatchInsert;
    private String m_workload;
    private long m_resultBufferSize;
    private boolean m_useThreePartNaming;
    private boolean m_stringBatchInsert;
    private boolean m_enableRoutableQueries;
    private boolean m_simpleQueriesOnly;
    private boolean m_failOnMultinodePlans;
    private int m_maxPooledConnections;
    private int m_maxPooledConnectionsPerNode;
    private int m_maxPooledConnectionUses;
    private int m_nodeDownWaitTime;
    private int m_metadataCacheLifetime;
    private String m_locale;
    private String m_sessionTimezone = "Not set";
    private String m_connSettingsSql;
    private boolean m_areLongStringEnabled = true;
    private String m_backupServerNode;
    private String[] m_backupNodes = null;
    private boolean m_connectionLoadBalance;
    private VConnectionPropertyValue.AddressFamilyPreference m_preferredAddressFamily;
    private boolean m_marsEnabled = false;
    private String m_jaasConfigName;
    private String m_kerberosServiceName;
    private String m_kerberosHostName;
    private boolean m_kerberosUsesDefaultValues = true;
    private String m_oauthAccessToken;
    private String m_oauthRefreshToken;
    private String m_oauthTokenUrl;
    private String m_oauthClientId;
    private String m_oauthClientSecret;
    private String m_oauthDiscoveryUrl;
    private String m_oauthScope;
    private String m_oauthJsonConfig;
    private boolean m_streamingBatchInsert = false;
    private boolean m_disableCopyLocal = false;
    private boolean m_binaryTransfer = true;
    private boolean m_requestComplexTypes = true;
    private int m_networkBufferSize;
    private int m_cancelKey;
    private int m_serverProcId;
    private String m_serverVersion = "00.00.0000";
    private int m_effectiveProtocolVersion;
    private boolean m_inLRS;
    private List<LRSWork> m_lrsWorkQueue;
    private boolean m_isConnected;
    private boolean m_useStandardConformingStrings;
    private boolean m_useStrictCatalogFiltering;
    private boolean m_addTzToTimestampParameters;
    private boolean m_inTransactionAPICall;
    private boolean m_withinTransaction;
    private int m_networkTimeout;
    private char m_serverTransactionState;
    private VQueryExecutor m_currentCopyExecutor;
    private VResultSet m_currentOpenResult;
    private ServerErrorData m_currentServerError;
    private ServerErrorData m_lastServerError;
    private ReentrantLock m_connectionLock;
    private boolean m_interruptedSBI = false;
    private AddressList m_addressList;
    private VStatement m_currentOpenStatement;

    public String getHostnameVerifier() {
        return this.m_hostnameVerifier;
    }

    public KeyStoreResolver getKeyStoreResolver() {
        return this.m_keyStore;
    }

    public TrustStoreResolver getTrustStoreResolver() {
        return this.m_trustStore;
    }

    public TrustStoreResolver getOauthTrustStoreResolver() {
        return this.m_oauth_trustStore;
    }

    public String getKeyStorePath() {
        return this.m_keyStore.path;
    }

    public String getTrustStorePath() {
        return this.m_trustStore.path;
    }

    public String getOauthTrustStorePath() {
        return this.m_oauth_trustStore.path;
    }

    public String getSSLSocketFactoryName() {
        return this.m_sslSocketFactory;
    }

    public String getPassword() {
        return this.m_password;
    }

    public String getKeyStorePassword() {
        return this.m_keyStore.password;
    }

    public String getTrustStorePassword() {
        return this.m_trustStore.password;
    }

    public void lock() {
        this.m_connectionLock.lock();
    }

    public void unlock() {
        this.m_connectionLock.unlock();
    }

    protected VConnection(VEnvironment vEnvironment) throws ErrorException {
        super(vEnvironment);
        if (VERTICA_CHARSET == null) {
            throw VDriver.s_vExceptionBuilder.createGeneralException(VMessageKey.ERROR_NO_UTF8.toString());
        }
        this.getConnectionLog();
        LogUtilities.logFunctionEntrance(this.m_log, vEnvironment);
        this.m_simpleQueryExecutor = new SimpleQueryExecutor(this);
        this.m_statementCounter = new AtomicInteger();
        this.m_lrsWorkQueue = new ArrayList<LRSWork>();
        this.m_connectionLock = new ReentrantLock(true);
        this.setEffectiveProtocolVersion("3.15");
    }

    public void connectTask() throws BadAuthException, InvalidAuthorizationException, ErrorException {
        boolean bl = false;
        boolean bl2 = false;
        while (!bl) {
            try {
                this.connectNode();
                bl = true;
            }
            catch (BadAuthException badAuthException) {
                throw badAuthException;
            }
            catch (InvalidAuthorizationException invalidAuthorizationException) {
                if (!bl2 && this.oauthConnection != null) {
                    ServerErrorData serverErrorData = this.getCurrentServerErrorData();
                    int n = serverErrorData.getErrorCode();
                    if (n == 2248 || n == 3781 || n == 4131) {
                        throw new ClientErrorException("Did not receive proper OAuth Authentication response from server. Please upgrade to the latest Vertica server for OAuth Support.");
                    }
                    bl2 = true;
                    String string = this.oauthConnection.GetActiveToken();
                    this.setOAuthAccessToken(string);
                    continue;
                }
                throw invalidAuthorizationException;
            }
            catch (NonTransientConnectionException nonTransientConnectionException) {
                throw nonTransientConnectionException;
            }
            catch (ErrorException errorException) {
                if (!this.m_addressList.isLastAddress()) continue;
                throw errorException;
            }
        }
    }

    public void connectNode() throws BadAuthException, InvalidAuthorizationException, ErrorException {
        if (this.m_loginNodeTimeout <= 0) {
            this.connectNodeTask();
        } else {
            ExecutorService executorService = Executors.newSingleThreadExecutor();
            Future<String> future = executorService.submit(new Callable<String>(){

                @Override
                public String call() throws BadAuthException, InvalidAuthorizationException, ErrorException {
                    VConnection.this.connectNodeTask();
                    return "Node Connected";
                }
            });
            try {
                future.get(this.m_loginNodeTimeout, TimeUnit.SECONDS);
            }
            catch (InterruptedException interruptedException) {
                Thread.currentThread().interrupt();
                throw new NonTransientConnectionException(DiagState.DIAG_CLIENT_CANT_CONNECT, 101, VMessageKey.ERROR_CONNECTION_FAILED.toString(), new String[]{this.getServer(), this.getPort() + "", "Failed to establish a session because the current thread is interrupted"}, (Throwable)interruptedException);
            }
            catch (ExecutionException executionException) {
                Throwable throwable = executionException.getCause();
                if (throwable instanceof BadAuthException) {
                    throw (BadAuthException)throwable;
                }
                if (throwable instanceof ErrorException) {
                    throw (ErrorException)throwable;
                }
                throw new ErrorException(DiagState.DIAG_CLIENT_CANT_CONNECT, 101, "Unexpected error when connect to node", throwable);
            }
            catch (TimeoutException timeoutException) {
                LogUtilities.logError(timeoutException, (ILogger)this.m_log);
                throw new ErrorException(DiagState.DIAG_CLIENT_CANT_CONNECT, 101, "timeout when connect to node after " + this.m_loginNodeTimeout + " seconds");
            }
            finally {
                executorService.shutdownNow();
            }
        }
    }

    public void connectNodeTask() throws BadAuthException, InvalidAuthorizationException, ErrorException {
        this.m_protocolStream = new ProtocolStream(this);
        try {
            this.m_protocolStream.initSession(this.m_password);
        }
        catch (IOException iOException) {
            String[] stringArray = new String[]{this.m_host, String.format("%d", this.m_port), iOException.getLocalizedMessage()};
            throw VDriver.s_vExceptionBuilder.createGeneralException(VMessageKey.ERROR_CONNECTION_FAILED.toString(), stringArray);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void connect(ConnSettingRequestMap connSettingRequestMap) throws BadAuthException, InvalidAuthorizationException, ErrorException {
        LogUtilities.logFunctionEntrance(this.m_log, new Object[0]);
        boolean bl = false;
        try {
            this.loadPreConnectSettings(connSettingRequestMap);
            LogUtilities.logInfo(String.format("Connecting as %s to %s on %s:%d", this.m_user, this.m_dbname, this.m_host, this.m_port), (ILogger)this.m_log);
            if (this.m_loginTimeout <= 0) {
                this.connectTask();
                this.m_isConnected = true;
            } else {
                ExecutorService executorService = Executors.newSingleThreadExecutor();
                Future<String> future = executorService.submit(new Callable<String>(){

                    @Override
                    public String call() throws BadAuthException, InvalidAuthorizationException, ErrorException {
                        VConnection.this.connectTask();
                        VConnection.this.m_isConnected = true;
                        return "Connected!";
                    }
                });
                try {
                    future.get(this.m_loginTimeout, TimeUnit.SECONDS);
                }
                catch (InterruptedException interruptedException) {
                    Thread.currentThread().interrupt();
                    throw new NonTransientConnectionException(DiagState.DIAG_CLIENT_CANT_CONNECT, 101, VMessageKey.ERROR_CONNECTION_FAILED.toString(), new String[]{this.getServer(), this.getPort() + "", "Failed to establish a session because the current thread is interrupted"}, (Throwable)interruptedException);
                }
                catch (ExecutionException executionException) {
                    Throwable throwable = executionException.getCause();
                    if (throwable instanceof BadAuthException) {
                        throw (BadAuthException)throwable;
                    }
                    if (throwable instanceof ErrorException) {
                        throw (ErrorException)throwable;
                    }
                    throw new ErrorException(DiagState.DIAG_CLIENT_CANT_CONNECT, 101, "Unexpected error during connect", throwable);
                }
                catch (TimeoutException timeoutException) {
                    this.m_isTimeout = true;
                    LogUtilities.logError(timeoutException, (ILogger)this.m_log);
                    throw new NonTransientConnectionException(DiagState.DIAG_CONN_TIMEOUT_EXPIRED, 101, VMessageKey.ERROR_CONNECTION_FAILED.toString(), new String[]{this.getServer(), this.getPort() + "", "Failed to establish a session after " + this.m_loginTimeout + " seconds"}, (Throwable)timeoutException);
                }
                finally {
                    executorService.shutdownNow();
                }
            }
            this.loadPostConnectSettings(connSettingRequestMap);
            this.setConnectionProperties();
            bl = true;
            this.m_protocolStream.enableOpenChecking();
        }
        finally {
            if (!bl) {
                this.close();
            } else {
                LogUtilities.logInfo("Connection is ready", (ILogger)this.m_log);
            }
        }
    }

    private void loadPreConnectSettings(ConnSettingRequestMap connSettingRequestMap) throws GeneralException, BadAuthException, ClientErrorException {
        int n;
        String string;
        String string2;
        Variant variant = null;
        this.m_host = this.getRequiredSetting("host", connSettingRequestMap).getString();
        this.m_dbname = this.getOptionalSetting("database", connSettingRequestMap).getString();
        Variant variant2 = this.getOptionalSetting("oauthaccesstoken", connSettingRequestMap);
        this.setOAuthAccessToken(variant2 == null ? "" : variant2.getString());
        Variant variant3 = this.getOptionalSetting("oauthrefreshtoken", connSettingRequestMap);
        this.setOAuthRefreshToken(variant3 == null ? "" : variant3.getString());
        Variant variant4 = this.getOptionalSetting("oauthtokenurl", connSettingRequestMap);
        this.setLegacyOAuthTokenUrl(variant4 == null ? "" : variant4.getString());
        Variant variant5 = this.getOptionalSetting("oauthclientid", connSettingRequestMap);
        this.setLegacyOAuthClientId(variant5 == null ? "" : variant5.getString());
        Variant variant6 = this.getOptionalSetting("oauthclientsecret", connSettingRequestMap);
        this.setLegacyOAuthClientSecret(variant6 == null ? "" : variant6.getString());
        Variant variant7 = this.getOptionalSetting("oauthdiscoveryurl", connSettingRequestMap);
        this.setLegacyOAuthDiscoveryUrl(variant7 == null ? "" : variant7.getString());
        Variant variant8 = this.getOptionalSetting("oauthscope", connSettingRequestMap);
        this.setLegacyOAuthScope(variant8 == null ? "" : variant8.getString());
        Variant variant9 = this.getOptionalSetting("oauthjsonconfig", connSettingRequestMap);
        this.setOAuthJsonConfig(variant9 == null ? "" : variant9.getString());
        if (variant2 != null || variant3 != null || variant4 != null || variant5 != null || variant6 != null || variant7 != null || variant8 != null || variant9 != null) {
            variant = this.getOptionalSetting("user", connSettingRequestMap);
            this.m_user = variant == null ? "" : variant.getString();
            variant = this.getOptionalSetting("password", connSettingRequestMap);
            this.m_password = variant == null ? "" : variant.getString();
        } else {
            this.m_user = this.getRequiredSetting("user", connSettingRequestMap).getString();
            this.m_password = this.getRequiredSetting("password", connSettingRequestMap).getString();
        }
        try {
            variant = this.getOptionalSetting("port", connSettingRequestMap);
            this.m_port = variant == null ? 5433 : variant.getInt();
        }
        catch (UtilsException utilsException) {
            this.m_port = 5433;
            this.warnBadParameter("port", variant);
        }
        variant = this.getOptionalSetting("loglevel", connSettingRequestMap);
        this.setLogLevel(variant == null ? VConnectionPropertyValue.DEFAULT_LOG_LEVEL.toString() : variant.getString());
        variant = this.getOptionalSetting("lognamespace", connSettingRequestMap);
        this.setLogPackage(variant == null ? "com.vertica" : variant.getString());
        variant = this.getOptionalSetting("logpath", connSettingRequestMap);
        this.setLogPath(variant == null ? "" : variant.getString());
        try {
            variant = this.getOptionalSetting("resultbuffersize", connSettingRequestMap);
            this.setResultBufferSize(variant == null ? 8192L : variant.getLong());
        }
        catch (GeneralException generalException) {
            this.setResultBufferSize(8192L);
            this.warnBadParameter("resultbuffersize", variant);
        }
        catch (UtilsException utilsException) {
            this.setResultBufferSize(8192L);
            this.warnBadParameter("resultbuffersize", variant);
        }
        try {
            variant = this.getOptionalSetting("logintimeout", connSettingRequestMap);
            this.setLoginTimeout(variant == null ? 0 : variant.getInt());
        }
        catch (UtilsException utilsException) {
            this.setLoginTimeout(0);
            this.warnBadParameter("logintimeout", variant);
        }
        try {
            variant = this.getOptionalSetting("loginnetworktimeout", connSettingRequestMap);
            this.setLoginNetworkTimeout(variant == null ? 0 : variant.getInt());
        }
        catch (UtilsException utilsException) {
            this.setLoginNetworkTimeout(0);
            this.warnBadParameter("loginnetworktimeout", variant);
        }
        try {
            variant = this.getOptionalSetting("loginnodetimeout", connSettingRequestMap);
            this.setLoginNodeTimeout(variant == null ? 0 : variant.getInt());
        }
        catch (UtilsException utilsException) {
            this.setLoginNodeTimeout(0);
            this.warnBadParameter("loginnodetimeout", variant);
        }
        variant = this.getOptionalSetting("protocol", connSettingRequestMap);
        this.setFixedProtocolVersion(variant == null ? "3.5" : variant.getString());
        variant = this.getOptionalSetting("socketfactoryname", connSettingRequestMap);
        this.setSocketFactoryName(variant == null ? "" : variant.getString());
        variant = this.getOptionalSetting("sessionlabel", connSettingRequestMap);
        String string3 = variant == null ? "jdbc-" + VDriver.DRIVER_VERSION + "-" + UUID.randomUUID().toString() : variant.getString();
        this.setSessionLabel(string3);
        variant = this.getOptionalSetting("directbatchinsert", connSettingRequestMap);
        this.setDirectBatchInsert(variant == null ? false : Boolean.parseBoolean(variant.getString()));
        variant = this.getOptionalSetting("stringbatchinsert", connSettingRequestMap);
        this.setStringBatchInsert(variant == null ? true : Boolean.parseBoolean(variant.getString()));
        variant = this.getOptionalSetting("strictcatalogfiltering", connSettingRequestMap);
        this.setUseStrictCatalogFiltering(variant == null ? false : Boolean.parseBoolean(variant.getString()));
        variant = this.getOptionalSetting("addtztotimestampparameters", connSettingRequestMap);
        this.setAddTzToTimestampParameters(variant == null ? false : Boolean.parseBoolean(variant.getString()));
        variant = this.getOptionalSetting("ssl", connSettingRequestMap);
        this.setTLSMode(variant == null ? VConnectionPropertyValue.DEFAULT_TLSMODE : (Boolean.parseBoolean(variant.getString()) ? TLSMode.VERIFY_CA : TLSMode.DISABLE));
        variant = this.getOptionalSetting("tlsmode", connSettingRequestMap);
        if (variant != null) {
            this.setTLSMode(TLSMode.fromString(variant.getString()));
        }
        this.m_hostnameVerifier = (variant = this.getOptionalSetting("hostnameverifier", connSettingRequestMap)) == null ? VConnectionPropertyValue.DEFAULT_HOST_NAME_VERIFIER : variant.getString();
        variant = this.getOptionalSetting("sslsocketfactoryname", connSettingRequestMap);
        String string4 = this.m_sslSocketFactory = variant == null ? "" : variant.getString();
        if (!"".equals(this.m_sslSocketFactory)) {
            LogUtilities.logInfo("Using custom SSLSocketFactory " + this.m_sslSocketFactory + "; keyStore & trustStore connection options will not take effect", (ILogger)this.m_log);
        }
        if ((variant = this.getOptionalSetting("keystorepath", connSettingRequestMap)) == null) {
            this.m_keyStore = new KeyStoreResolver(this.m_log);
        } else {
            string2 = variant.getString();
            LogUtilities.logInfo("Using a custom keystore: " + string2, (ILogger)this.m_log);
            variant = this.getOptionalSetting("keystorepassword", connSettingRequestMap);
            string = variant == null ? "" : variant.getString();
            this.m_keyStore = new KeyStoreResolver(string2, string, this.m_log);
        }
        variant = this.getOptionalSetting("truststorepath", connSettingRequestMap);
        if (variant == null) {
            this.m_trustStore = new TrustStoreResolver(this.m_log);
        } else {
            string2 = variant.getString();
            LogUtilities.logInfo("Using a custom truststore: " + string2, (ILogger)this.m_log);
            variant = this.getOptionalSetting("truststorepassword", connSettingRequestMap);
            string = variant == null ? "" : variant.getString();
            this.m_trustStore = new TrustStoreResolver(string2, string, this.m_log);
        }
        variant = this.getOptionalSetting("oauthtruststorepath", connSettingRequestMap);
        if (variant == null) {
            this.m_oauth_trustStore = new TrustStoreResolver(this.m_log);
        } else {
            string2 = variant.getString();
            LogUtilities.logInfo("Using a custom truststore for oauth idp: " + string2, (ILogger)this.m_log);
            variant = this.getOptionalSetting("oauthtruststorepassword", connSettingRequestMap);
            string = variant == null ? "" : variant.getString();
            this.m_oauth_trustStore = new TrustStoreResolver(string2, string, this.m_log);
        }
        variant = this.getOptionalSetting("threepartnaming", connSettingRequestMap);
        this.setUseThreePartNaming(variant == null ? true : Boolean.parseBoolean(variant.getString()));
        variant = this.getOptionalSetting("backupservernode", connSettingRequestMap);
        this.setBackupServerNode(variant == null ? "" : variant.getString());
        variant = this.getOptionalSetting("connectionloadbalance", connSettingRequestMap);
        this.setConnectionLoadBalance(variant == null ? false : Boolean.parseBoolean(variant.getString()));
        variant = this.getOptionalSetting("jaasconfigname", connSettingRequestMap);
        this.setJAASConfigName(variant == null ? "verticajdbc" : variant.getString());
        this.setKerberosUsesDefaultValues(true);
        variant = this.getOptionalSetting("kerberosservicename", connSettingRequestMap);
        if (variant != null) {
            this.setKerberosUsesDefaultValues(false);
        }
        this.setKerberosServiceName(variant == null ? "vertica" : variant.getString());
        variant = this.getOptionalSetting("kerberoshostname", connSettingRequestMap);
        if (variant != null && variant.getString().length() != 0) {
            this.setKerberosUsesDefaultValues(false);
        }
        this.setKerberosHostName(variant == null || variant.getString().length() == 0 ? this.m_host : variant.getString());
        if (variant3 != null && (variant4 != null && variant5 != null && variant6 != null || variant9 != null)) {
            this.oauthConnection = new OAuthConnection(this.getOAuthRefreshToken(), this.getLegacyOAuthTokenUrl(), this.getLegacyOAuthClientId(), this.getLegacyOAuthClientSecret(), this.getLegacyOAuthDiscoveryUrl(), this.getLegacyOAuthScope(), this.m_oauth_trustStore, this.m_log);
            if (variant9 != null && !this.getOAuthJsonConfig().isEmpty()) {
                this.oauthConnection.ParseJsonConfig(this.getOAuthJsonConfig());
            }
        }
        this.setStreamingBatchInsert((variant = this.getOptionalSetting("streamingbatchinsert", connSettingRequestMap)) == null ? false : Boolean.parseBoolean(variant.getString()));
        variant = this.getOptionalSetting("requestcomplextypes", connSettingRequestMap);
        this.setRequestComplexTypes(variant == null ? true : Boolean.parseBoolean(variant.getString()));
        variant = this.getOptionalSetting("disablecopylocal", connSettingRequestMap);
        this.setDisableCopyLocal(variant == null ? false : Boolean.parseBoolean(variant.getString()));
        variant = this.getOptionalSetting("binarytransfer", connSettingRequestMap);
        this.setBinaryTransfer(variant == null ? true : Boolean.parseBoolean(variant.getString()));
        variant = this.getOptionalSetting("workload", connSettingRequestMap);
        this.setWorkload(variant == null ? "" : variant.getString());
        try {
            variant = this.getOptionalSetting("networkbuffersize", connSettingRequestMap);
            this.setNetworkBufferSize(variant == null ? 8192 : variant.getInt());
        }
        catch (UtilsException utilsException) {
            this.setNetworkBufferSize(8192);
            this.warnBadParameter("networkbuffersize", variant);
        }
        try {
            variant = this.getOptionalSetting("networktimeout", connSettingRequestMap);
            this.setNetworkTimeoutMember(variant == null ? 0 : variant.getInt());
        }
        catch (IOException iOException) {
            LogUtilities.logWarning("Attempt to set network timeout threw an exception: " + iOException.toString(), (ILogger)this.m_log);
        }
        catch (UtilsException utilsException) {
            try {
                this.setNetworkTimeoutMember(0);
            }
            catch (IOException iOException) {
                LogUtilities.logWarning("Attempt to set network timeout threw an exception: " + iOException.toString(), (ILogger)this.m_log);
            }
            this.warnBadParameter("networktimeout", variant);
        }
        variant = this.getOptionalSetting("enableroutablequeries", connSettingRequestMap);
        this.setEnableRoutableQueries(variant == null ? false : Boolean.parseBoolean(variant.getString()));
        if (this.getEnableRoutableQueries()) {
            LogUtilities.logWarning("Routable query support has been deprecated and is subject to removal in a future release", (ILogger)this.m_log);
        }
        this.setSimpleQueriesOnly((variant = this.getOptionalSetting("simplequeriesonly", connSettingRequestMap)) == null ? false : Boolean.parseBoolean(variant.getString()));
        variant = this.getOptionalSetting("failonmultinodeplans", connSettingRequestMap);
        this.setFailOnMultinodePlans(variant == null ? true : Boolean.parseBoolean(variant.getString()));
        try {
            variant = this.getOptionalSetting("maxpooledconnectionuses", connSettingRequestMap);
            this.setMaxPooledConnectionUses(variant == null ? 1000 : variant.getInt());
        }
        catch (UtilsException utilsException) {
            this.setMaxPooledConnectionUses(1000);
            this.warnBadParameter("maxpooledconnectionuses", variant);
        }
        try {
            variant = this.getOptionalSetting("maxpooledconnections", connSettingRequestMap);
            this.setMaxPooledConnections(variant == null ? 20 : variant.getInt());
        }
        catch (UtilsException utilsException) {
            this.setMaxPooledConnections(20);
            this.warnBadParameter("maxpooledconnections", variant);
        }
        try {
            variant = this.getOptionalSetting("maxpooledconnectionspernode", connSettingRequestMap);
            this.setMaxPooledConnectionsPerNode(variant == null ? 5 : variant.getInt());
        }
        catch (UtilsException utilsException) {
            this.setMaxPooledConnectionsPerNode(5);
            this.warnBadParameter("maxpooledconnectionspernode", variant);
        }
        try {
            variant = this.getOptionalSetting("metadatacachelifetime", connSettingRequestMap);
            this.setMetadataCacheLifetime(variant == null ? 300 : variant.getInt());
        }
        catch (UtilsException utilsException) {
            this.setMetadataCacheLifetime(300);
            this.warnBadParameter("metadatacachelifetime", variant);
        }
        try {
            variant = this.getOptionalSetting("nodedownwaittime", connSettingRequestMap);
            this.setNodeDownWaitTime(variant == null ? 60 : variant.getInt());
        }
        catch (UtilsException utilsException) {
            this.setNodeDownWaitTime(60);
            this.warnBadParameter("nodedownwaittime", variant);
        }
        try {
            variant = this.getOptionalSetting("preferredaddressfamily", connSettingRequestMap);
            this.setPreferredAddressFamily(variant == null ? VConnectionPropertyValue.DEFAULT_PREFERRED_ADDRESS_FAMILY : VConnectionPropertyValue.AddressFamilyPreference.fromString(variant.getString()));
        }
        catch (IllegalArgumentException illegalArgumentException) {
            this.setPreferredAddressFamily(VConnectionPropertyValue.DEFAULT_PREFERRED_ADDRESS_FAMILY);
            this.warnBadParameter("preferredaddressfamily", variant);
        }
        this.m_addressList = new AddressList(this.m_host, this.m_port, this.m_backupNodes, this.m_preferredAddressFamily, this);
        variant = this.getOptionalSetting("mars", connSettingRequestMap);
        if (variant != null) {
            LogUtilities.logDebug("MARS is " + variant.getString(), (ILogger)this.m_log);
            this.setMarsEnabled(Boolean.parseBoolean(variant.getString()));
        }
        if (this.m_clientInfoProperties != null) {
            this.m_clientInfoProperties.put(CLIENT_INFO_PROPERTY_APPLICATION_NAME, new ClientInfoData(CLIENT_INFO_PROPERTY_APPLICATION_NAME, 255, null, "The name of the label of current connection."));
        }
        if (this.getMarsEnabled() && this.m_fixedProtocolVersion < (n = ProtocolUtils.protocolStrToInt("3.6"))) {
            this.m_fixedProtocolVersion = n;
            LogUtilities.logInfo("Multiple active result sets specified; increasing base protocol version to 3.6", (ILogger)this.m_log);
        }
    }

    private void loadPostConnectSettings(ConnSettingRequestMap connSettingRequestMap) throws ErrorException {
        String string;
        Object object;
        Variant variant = null;
        try {
            this.setProperty(139, new Variant(0, this.m_user));
        }
        catch (BadAttrValException badAttrValException) {
            throw new ClientErrorException(badAttrValException.getMessage());
        }
        catch (UtilsException utilsException) {
            throw new ClientErrorException(utilsException.getMessage());
        }
        try {
            variant = this.getOptionalSetting("autocommit", connSettingRequestMap);
            boolean bl = variant == null ? true : Boolean.parseBoolean(variant.getString());
            object = new Variant(3, bl ? 1L : 0L);
            if (bl) {
                this.setProperty(19, (Variant)object);
            } else {
                this.setPropertySDKOnly(19, (Variant)object);
            }
        }
        catch (BadAttrValException badAttrValException) {
            this.warnBadParameter("autocommit", variant);
        }
        catch (UtilsException utilsException) {
            this.warnBadParameter("autocommit", variant);
        }
        try {
            variant = this.getOptionalSetting("readonly", connSettingRequestMap);
            boolean bl = variant == null ? false : Boolean.parseBoolean(variant.getString());
            object = new Variant(3, bl ? 1L : 0L);
            if (bl) {
                this.setProperty(16, (Variant)object);
            } else {
                this.setPropertySDKOnly(16, (Variant)object);
            }
        }
        catch (BadAttrValException badAttrValException) {
            this.warnBadParameter("readonly", variant);
        }
        catch (UtilsException utilsException) {
            this.warnBadParameter("readonly", variant);
        }
        try {
            variant = this.getOptionalSetting("transactionisolation", connSettingRequestMap);
            if (variant != null && variant.getLong() != 2L) {
                int n = variant.getInt();
                this.setProperty(26, new Variant(3, n));
            } else {
                this.setPropertySDKOnly(26, new Variant(3, 2L));
            }
        }
        catch (BadAttrValException badAttrValException) {
            this.warnBadParameter("transactionisolation", variant);
        }
        catch (UtilsException utilsException) {
            this.warnBadParameter("transactionisolation", variant);
        }
        variant = this.getOptionalSetting("locale", connSettingRequestMap);
        if (variant != null) {
            this.setServerLocale(variant.getString(), true);
        }
        if ((variant = this.getOptionalSetting("sessiontimezone", connSettingRequestMap)) != null && (string = variant.getString()) != null && !string.isEmpty()) {
            this.setAndSendSessionTimezone(string);
        }
        String string2 = (variant = this.getOptionalSetting("searchpath", connSettingRequestMap)) == null ? "" : variant.getString();
        this.setSearchPath(string2, true);
        variant = this.getOptionalSetting("connsettings", connSettingRequestMap);
        object = variant == null ? "" : variant.getString();
        this.setConnSettings((String)object);
        if (!"".equals(object)) {
            this.m_simpleQueryExecutor.execute((String)object, false);
        }
        try {
            this.setProperty(20, new Variant(3, 0L));
        }
        catch (BadAttrValException badAttrValException) {
            throw new ClientErrorException(badAttrValException.getMessage());
        }
        catch (UtilsException utilsException) {
            throw new ClientErrorException(utilsException.getMessage());
        }
    }

    private void warnBadParameter(String string, Variant variant) {
        String string2 = this.getMessageSource().loadMessage(this.getLocale(), 101, VMessageKey.ERROR_ILLEGAL_PARAM_VALUE.toString(), new String[]{string, variant == null ? "null" : variant.getString()}, false);
        LogUtilities.logWarning(string2, (ILogger)this.m_log);
        this.getWarningListener().postWarning(new Warning(WarningCode.INVALID_CONNECTION_STRING_ATTRIBUTE, string2));
    }

    private void setConnectionProperties() throws ErrorException {
        try {
            this.setProperty(169, new Variant(0, DRIVER_FILENAME));
            this.setProperty(1, new Variant(0, "N"));
            this.setProperty(2, new Variant(0, "Y"));
            long l = 0L;
            l = 64L;
            l |= 1L;
            l |= 2L;
            l |= 0x20L;
            l |= 4L;
            l |= 8L;
            this.setProperty(4, new Variant(3, l |= 0x10L));
            this.setProperty(5, new Variant(3, 0L));
            l = 32L;
            l |= 8L;
            l |= 0x8000L;
            l |= 0x40L;
            l |= 0x1000L;
            l |= 0x40L;
            l |= 0x200L;
            l |= 0x2000L;
            l |= 0x4000L;
            this.setProperty(6, new Variant(3, l |= 0x100L));
            this.setProperty(140, new Variant(3, 2L));
            l = 3L;
            this.setProperty(141, new Variant(3, l));
            this.setProperty(7, new Variant(3, 0L));
            this.setProperty(8, new Variant(3, 1L));
            this.setProperty(10, new Variant(0, "."));
            this.setProperty(11, new Variant(0, "catalog"));
            l = 21L;
            this.setProperty(12, new Variant(3, l));
            this.setProperty(13, new Variant(0, ""));
            this.setProperty(14, new Variant(0, "Y"));
            this.setProperty(15, new Variant(3, 0L));
            Variant variant = new Variant(3, 1597951L);
            Variant variant2 = new Variant(3, 25087L);
            Variant variant3 = new Variant(3, 25087L);
            long l2 = 0x1BF1FFL;
            Variant variant4 = new Variant(3, l2);
            Variant variant5 = new Variant(3, l2 | (this.m_areLongStringEnabled ? 512L : 0L));
            Variant variant6 = new Variant(3, 769L);
            Variant variant7 = new Variant(3, 262144L);
            Variant variant8 = new Variant(3, 0L);
            this.setProperty(106, variant);
            this.setProperty(107, new Variant(3, 3072L));
            this.setProperty(108, new Variant(3, 4353L));
            this.setProperty(109, variant4);
            this.setProperty(111, new Variant(3, 164097L));
            this.setProperty(112, variant3);
            this.setProperty(113, variant2);
            this.setProperty(114, variant2);
            this.setProperty(115, variant);
            this.setProperty(116, new Variant(3, 549145L));
            this.setProperty(117, new Variant(3, 0x116119L));
            this.setProperty(118, this.m_areLongStringEnabled ? variant7 : variant8);
            this.setProperty(119, this.m_areLongStringEnabled ? variant6 : variant8);
            this.setProperty(120, variant3);
            this.setProperty(121, variant2);
            this.setProperty(122, variant);
            this.setProperty(123, new Variant(3, 0x110101L));
            this.setProperty(124, new Variant(3, 229633L));
            this.setProperty(125, variant);
            this.setProperty(126, new Variant(3, 0xC00L | (this.m_areLongStringEnabled ? 262144L : 0L)));
            this.setProperty(127, variant5);
            this.setProperty(128, variant4);
            this.setProperty(130, variant5);
            this.setProperty(28, new Variant(3, 2L));
            this.setProperty(29, new Variant(3, 0L));
            this.setProperty(30, new Variant(3, 0L));
            this.setProperty(31, new Variant(3, 0L));
            this.setProperty(32, new Variant(3, 0L));
            this.setProperty(27, new Variant(3, 3L));
            l = 3L;
            this.setProperty(33, new Variant(3, l));
            l = 16L;
            l |= 4L;
            l |= 0x400L;
            this.setProperty(34, new Variant(3, l |= 1L));
            this.setProperty(35, new Variant(3, 0L));
            this.setProperty(36, new Variant(3, 1L));
            this.setProperty(37, new Variant(3, 1L));
            this.setProperty(38, new Variant(3, 1L));
            this.setProperty(39, new Variant(3, 0L));
            this.setProperty(40, new Variant(0, "N"));
            l = 1L;
            l |= 2L;
            l |= 4L;
            l |= 8L;
            l |= 0x10L;
            l |= 0x20L;
            l |= 0x40L;
            l |= 0x80L;
            l |= 0x100L;
            l |= 0x400L;
            l |= 0x800L;
            l |= 0x1000L;
            l |= 0x2000L;
            l |= 0x4000L;
            l |= 0x8000L;
            this.setProperty(43, new Variant(3, l |= 0x200L));
            this.setProperty(41, new Variant(0, VDriver.SERVER_PRODUCT_NAME));
            this.setProperty(42, new Variant(0, this.m_serverVersion));
            this.setProperty(44, new Variant(3, 0L));
            l = 2L;
            this.setProperty(45, new Variant(3, l));
            this.setProperty(46, new Variant(0, "N"));
            this.setProperty(47, new Variant(3, 0L));
            this.setProperty(48, new Variant(3, 0L));
            this.setProperty(49, new Variant(3, 0L));
            this.setProperty(50, new Variant(3, 0L));
            l = 1L;
            l |= 4L;
            this.setProperty(51, new Variant(3, l |= 2L));
            l = 1L;
            l |= 4L;
            this.setProperty(52, new Variant(3, l |= 2L));
            this.setProperty(53, new Variant(3, 0L));
            this.setProperty(54, new Variant(3, 1L));
            this.setProperty(1000, new Variant(5, (short)1));
            this.setProperty(1001, new Variant(3, 0L));
            this.setProperty(142, new Variant(3, 0L));
            this.setProperty(143, new Variant(3, 0L));
            this.setProperty(55, new Variant(0, "Y"));
            this.setProperty(144, new Variant(3, 1L));
            this.setProperty(145, new Variant(3, 1L));
            this.setProperty(56, new Variant(3, 2L));
            this.setProperty(57, new Variant(2, Character.valueOf('\u0004')));
            this.setProperty(58, new Variant(0, "\""));
            this.setProperty(59, new Variant(3, 0L));
            this.setProperty(146, new Variant(3, 0L));
            l = 1L;
            l |= 2L;
            this.setProperty(60, new Variant(3, l |= 4L));
            this.setProperty(61, new Variant(0, "N"));
            this.setProperty(147, new Variant(3, 0L));
            this.setProperty(148, new Variant(3, 0L));
            this.setProperty(1002, new Variant(3, 0L));
            this.setProperty(1012, new Variant(3, 1L));
            Character c = Character.valueOf('\u0000');
            Character c2 = Character.valueOf('\u0080');
            this.setProperty(63, new Variant(0, "Y"));
            this.setProperty(64, new Variant(3, 0L));
            this.setProperty(1004, new Variant(3, new Long(65000L)));
            this.setProperty(1005, new Variant(3, new Long(65000L)));
            this.setProperty(65, variant8);
            this.setProperty(66, new Variant(2, c));
            this.setProperty(67, variant8);
            this.setProperty(68, new Variant(2, c2));
            this.setProperty(69, new Variant(2, c));
            this.setProperty(70, new Variant(2, c));
            this.setProperty(71, new Variant(2, c));
            this.setProperty(72, new Variant(2, c));
            this.setProperty(73, new Variant(2, c));
            this.setProperty(74, new Variant(2, c));
            this.setProperty(75, new Variant(2, c));
            this.setProperty(76, new Variant(2, c2));
            this.setProperty(77, new Variant(3, 0L));
            this.setProperty(78, new Variant(2, c2));
            this.setProperty(79, new Variant(3, new Long(32000000L)));
            this.setProperty(80, new Variant(0, this.m_areLongStringEnabled ? "Y" : "N"));
            this.setProperty(81, new Variant(2, c2));
            this.setProperty(82, new Variant(3, 0L));
            this.setProperty(83, new Variant(2, c2));
            this.setProperty(84, new Variant(2, c));
            this.setProperty(85, new Variant(2, c2));
            this.setProperty(86, new Variant(0, "Y"));
            this.setProperty(87, new Variant(0, "Y"));
            this.setProperty(88, new Variant(3, 1L));
            this.setProperty(89, new Variant(3, 1L));
            l = 1L;
            l |= 2L;
            l |= 4L;
            l |= 8L;
            l |= 0x10L;
            l |= 0x20L;
            l |= 0x40L;
            l |= 0x80L;
            l |= 0x40000L;
            l |= 0x100L;
            l |= 0x200L;
            l |= 0x400L;
            l |= 0x800L;
            l |= 0x10000L;
            l |= 0x100000L;
            l |= 0x200000L;
            l |= 0x400000L;
            l |= 0x1000L;
            l |= 0x2000L;
            l |= 0x4000L;
            this.setProperty(90, new Variant(3, l |= 0x8000L));
            this.setProperty(91, new Variant(5, (short)1));
            l = 64L;
            l |= 4L;
            l |= 0x20L;
            l |= 1L;
            l |= 8L;
            l |= 0x10L;
            this.setProperty(92, new Variant(3, l |= 2L));
            this.setProperty(93, new Variant(0, "N"));
            this.setProperty(95, new Variant(3, 1L));
            this.setProperty(149, new Variant(3, 1L));
            this.setProperty(96, new Variant(0, "function"));
            this.setProperty(97, new Variant(0, "Y"));
            this.setProperty(98, new Variant(2, Character.valueOf('\u0004')));
            this.setProperty(150, new Variant(0, "N"));
            this.setProperty(99, new Variant(0, "schema"));
            l = 21L;
            this.setProperty(100, new Variant(3, l));
            this.setProperty(151, new Variant(0, "\\"));
            this.setProperty(101, new Variant(0, this.m_host));
            this.setProperty(102, new Variant(0, ""));
            this.setProperty(103, new Variant(3, 1L));
            l = 7L;
            this.setProperty(154, new Variant(3, l));
            this.setProperty(155, new Variant(3, 0L));
            this.setProperty(156, new Variant(3, 0L));
            l = 1024L;
            l |= 0x40L;
            l |= 0x800L;
            l |= 0x20L;
            l |= 0x100L;
            this.setProperty(159, new Variant(3, l |= 0x10L));
            l = 1L;
            l |= 0x10L;
            l |= 0x20L;
            this.setProperty(157, new Variant(3, l |= 4L));
            l = 2048L;
            l |= 0x1000L;
            l |= 1L;
            l |= 0x400L;
            l |= 2L;
            l |= 4L;
            l |= 0x2000L;
            this.setProperty(158, new Variant(3, l |= 0x80L));
            l = 2L;
            l |= 8L;
            l |= 0x10L;
            l |= 0x80L;
            l |= 0x40L;
            this.setProperty(160, new Variant(3, l |= 0x100L));
            this.setProperty(94, new Variant(0, "Y"));
            l = 128L;
            l |= 0x20L;
            l |= 0x400L;
            l |= 0x100L;
            l |= 0x2000L;
            l |= 0x1000L;
            l |= 0x1000L;
            this.setProperty(161, new Variant(3, l |= 0x10L));
            l = 4L;
            l |= 2L;
            this.setProperty(162, new Variant(3, l |= 1L));
            l = 1L;
            l |= 2L;
            l |= 8L;
            l |= 0x10L;
            l |= 0x20L;
            l |= 0x40L;
            this.setProperty(163, new Variant(3, l |= 0x80L));
            l = 1L;
            l |= 2L;
            l |= 8L;
            this.setProperty(164, new Variant(3, l |= 4L));
            l = 1L;
            this.setProperty(152, new Variant(3, 0L));
            this.setProperty(153, new Variant(3, 0L));
            l = 8192L;
            l |= 0x4000L;
            l |= 0x100000L;
            l |= 1L;
            l |= 2L;
            l |= 0x40L;
            l |= 4L;
            l |= 0x10L;
            l |= 8L;
            l |= 0x400000L;
            l |= 0x800000L;
            l |= 0x80L;
            l |= 0x100L;
            l |= 0x200L;
            l |= 0x400L;
            l |= 0x40000L;
            l |= 0x800L;
            this.setProperty(104, new Variant(3, l |= 0x1000L));
            l = 31L;
            this.setProperty(105, new Variant(3, l));
            l = 7L;
            this.setProperty(131, new Variant(3, l));
            this.setProperty(132, new Variant(0, "table"));
            l = 1L;
            l |= 4L;
            l |= 8L;
            l |= 0x10L;
            l |= 0x20L;
            l |= 0x40L;
            l |= 0x80L;
            this.setProperty(133, new Variant(3, l |= 0x100L));
            this.setProperty(134, new Variant(3, l));
            l = 131072L;
            l |= 0x40000L;
            l |= 0x80000L;
            l |= 2L;
            l |= 0x200L;
            l |= 8L;
            l |= 4L;
            l |= 0x10L;
            l |= 0x100000L;
            l |= 0x400L;
            l |= 0x800L;
            l |= 0x20L;
            l |= 1L;
            l |= 0x40L;
            l |= 0x1000L;
            l |= 0x2000L;
            l |= 0x4000L;
            l |= 0x80L;
            this.setProperty(135, new Variant(3, l |= 0x100L));
            this.setProperty(136, new Variant(2, Character.valueOf('\u0003')));
            l = 10L;
            this.setProperty(137, new Variant(3, l));
            l = 3L;
            this.setProperty(138, new Variant(3, l));
            this.setProperty(177, new Variant(3, 0L));
            this.setProperty(1010, new Variant(0, "N"));
            this.setProperty(1004, new Variant(3, 65000L));
            this.setProperty(1005, new Variant(3, 65000L));
        }
        catch (BadAttrValException badAttrValException) {
            throw new ClientErrorException(badAttrValException.getMessage());
        }
        catch (IncorrectTypeException incorrectTypeException) {
            throw new ClientErrorException(incorrectTypeException.getMessage());
        }
        catch (NumericOverflowException numericOverflowException) {
            throw new ClientErrorException(numericOverflowException.getMessage());
        }
    }

    protected void finalize() throws Throwable {
        try {
            this.close();
        }
        finally {
            super.finalize();
        }
    }

    @Override
    public void close() {
        LogUtilities.logFunctionEntrance(this.m_log, new Object[0]);
        this.disconnect();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void disconnect() {
        this.lock();
        try {
            LogUtilities.logFunctionEntrance(this.m_log, new Object[0]);
            if (this.m_protocolStream == null) {
                this.m_isConnected = false;
                return;
            }
            if (!this.m_isConnected && !this.m_isTimeout) {
                this.m_protocolStream.close();
                return;
            }
            try {
                this.m_protocolStream.sendMessage(new TerminateRequestMessage());
                this.m_protocolStream.flush();
            }
            catch (ErrorException errorException) {
                LogUtilities.logError(errorException, (ILogger)this.m_log);
            }
            finally {
                this.m_protocolStream.close();
                try {
                    this.setProperty(20, new Variant(3, 0L));
                }
                catch (BadAttrValException badAttrValException) {
                    throw new RuntimeException("Unexpected failure occured while disconnecting: \n\t" + badAttrValException);
                }
                catch (ErrorException errorException) {
                    throw new RuntimeException("Unexpected failure occured while disconnecting: \n\t" + errorException);
                }
                catch (IncorrectTypeException incorrectTypeException) {
                    throw new RuntimeException("Unexpected failure occured while disconnecting: \n\t" + incorrectTypeException);
                }
                catch (NumericOverflowException numericOverflowException) {
                    throw new RuntimeException("Unexpected failure occured while disconnecting: \n\t" + numericOverflowException);
                }
                this.m_isConnected = false;
            }
        }
        finally {
            this.unlock();
        }
    }

    @Override
    public VStatement createStatement() throws ErrorException {
        LogUtilities.logFunctionEntrance(this.m_log, new Object[0]);
        VStatement vStatement = new VStatement(this);
        return vStatement;
    }

    @Override
    public DSILogger getConnectionLog() {
        if (this.m_log == null) {
            this.m_log = new DSILogger("vjdbc-" + s_connectionCounter.incrementAndGet() + "-" + LOG_DATE_FORMAT.format(new Date()) + ".log");
        }
        return this.m_log;
    }

    @Override
    public void setProperty(int n, Variant variant) throws BadAttrValException, ErrorException {
        try {
            if (n == 19) {
                String string = variant.getLong() == 1L ? "on" : "off";
                this.executeTransactionStatement("set session autocommit to " + string, true);
            } else if (n == 26) {
                if (variant.getLong() == 1L) {
                    this.m_simpleQueryExecutor.execute("set session characteristics as transaction isolation level read uncommitted");
                } else if (variant.getLong() == 2L) {
                    this.m_simpleQueryExecutor.execute("set session characteristics as transaction isolation level read committed");
                } else if (variant.getLong() == 4L) {
                    this.m_simpleQueryExecutor.execute("set session characteristics as transaction isolation level repeatable read");
                } else if (variant.getLong() == 8L) {
                    this.m_simpleQueryExecutor.execute("set session characteristics as transaction isolation level serializable");
                } else {
                    variant = new Variant(3, 2L);
                }
            } else if (n == 16) {
                if (variant.getLong() == 1L) {
                    this.m_simpleQueryExecutor.execute("set session characteristics as transaction read only");
                } else if (variant.getLong() == 0L) {
                    this.m_simpleQueryExecutor.execute("set session characteristics as transaction read write");
                } else {
                    throw new ClientErrorException("Illegal property value [" + variant.getLong() + "]");
                }
            }
            super.setProperty(n, variant);
        }
        catch (IncorrectTypeException incorrectTypeException) {
            throw new ClientErrorException(incorrectTypeException.getMessage());
        }
        catch (NumericOverflowException numericOverflowException) {
            throw new ClientErrorException(numericOverflowException.getMessage());
        }
    }

    public void setPropertySDKOnly(int n, Variant variant) throws ClientErrorException {
        try {
            super.setProperty(n, variant);
        }
        catch (ErrorException errorException) {
            throw new ClientErrorException(errorException.getMessage());
        }
    }

    @Override
    public ConnSettingResponseMap updateConnectionSettings(ConnSettingRequestMap connSettingRequestMap) throws BadAuthException, GeneralException {
        LogUtilities.logFunctionEntrance(this.m_log, new Object[0]);
        ConnSettingResponseMap connSettingResponseMap = new ConnSettingResponseMap();
        this.verifyRequiredSetting("host", connSettingRequestMap, connSettingResponseMap);
        this.verifyOptionalSetting("port", connSettingRequestMap, connSettingResponseMap);
        this.verifyOptionalSetting("database", connSettingRequestMap, connSettingResponseMap);
        this.verifyOptionalSetting("user", connSettingRequestMap, connSettingResponseMap);
        this.verifyOptionalSetting("password", connSettingRequestMap, connSettingResponseMap);
        this.verifyOptionalSetting("loglevel", connSettingRequestMap, connSettingResponseMap);
        this.verifyOptionalSetting("logpath", connSettingRequestMap, connSettingResponseMap);
        this.verifyOptionalSetting("lognamespace", connSettingRequestMap, connSettingResponseMap);
        this.verifyOptionalSetting("autocommit", connSettingRequestMap, connSettingResponseMap);
        this.verifyOptionalSetting("directbatchinsert", connSettingRequestMap, connSettingResponseMap);
        this.verifyOptionalSetting("logintimeout", connSettingRequestMap, connSettingResponseMap);
        this.verifyOptionalSetting("readonly", connSettingRequestMap, connSettingResponseMap);
        this.verifyOptionalSetting("resultbuffersize", connSettingRequestMap, connSettingResponseMap);
        this.verifyOptionalSetting("sessionlabel", connSettingRequestMap, connSettingResponseMap);
        this.verifyOptionalSetting("ssl", connSettingRequestMap, connSettingResponseMap);
        this.verifyOptionalSetting("tlsmode", connSettingRequestMap, connSettingResponseMap);
        this.verifyOptionalSetting("hostnameverifier", connSettingRequestMap, connSettingResponseMap);
        this.verifyOptionalSetting("threepartnaming", connSettingRequestMap, connSettingResponseMap);
        this.verifyOptionalSetting("transactionisolation", connSettingRequestMap, connSettingResponseMap);
        this.verifyOptionalSetting("connsettings", connSettingRequestMap, connSettingResponseMap);
        this.verifyOptionalSetting("backupservernode", connSettingRequestMap, connSettingResponseMap);
        this.verifyOptionalSetting("connectionloadbalance", connSettingRequestMap, connSettingResponseMap);
        this.verifyOptionalSetting("jaasconfigname", connSettingRequestMap, connSettingResponseMap);
        this.verifyOptionalSetting("kerberosservicename", connSettingRequestMap, connSettingResponseMap);
        this.verifyOptionalSetting("kerberoshostname", connSettingRequestMap, connSettingResponseMap);
        this.verifyOptionalSetting("oauthaccesstoken", connSettingRequestMap, connSettingResponseMap);
        this.verifyOptionalSetting("oauthrefreshtoken", connSettingRequestMap, connSettingResponseMap);
        this.verifyOptionalSetting("oauthclientid", connSettingRequestMap, connSettingResponseMap);
        this.verifyOptionalSetting("oauthclientsecret", connSettingRequestMap, connSettingResponseMap);
        this.verifyOptionalSetting("oauthdiscoveryurl", connSettingRequestMap, connSettingResponseMap);
        this.verifyOptionalSetting("oauthscope", connSettingRequestMap, connSettingResponseMap);
        this.verifyOptionalSetting("streamingbatchinsert", connSettingRequestMap, connSettingResponseMap);
        this.verifyOptionalSetting("disablecopylocal", connSettingRequestMap, connSettingResponseMap);
        this.verifyOptionalSetting("binarytransfer", connSettingRequestMap, connSettingResponseMap);
        this.verifyOptionalSetting("workload", connSettingRequestMap, connSettingResponseMap);
        this.verifyOptionalSetting("networktimeout", connSettingRequestMap, connSettingResponseMap);
        this.verifyOptionalSetting("socketfactoryname", connSettingRequestMap, connSettingResponseMap);
        this.verifyOptionalSetting("sslsocketfactoryname", connSettingRequestMap, connSettingResponseMap);
        this.verifyOptionalSetting("keystorepath", connSettingRequestMap, connSettingResponseMap);
        this.verifyOptionalSetting("truststorepath", connSettingRequestMap, connSettingResponseMap);
        this.verifyOptionalSetting("keystorepassword", connSettingRequestMap, connSettingResponseMap);
        this.verifyOptionalSetting("truststorepassword", connSettingRequestMap, connSettingResponseMap);
        this.verifyOptionalSetting("oauthtruststorepath", connSettingRequestMap, connSettingResponseMap);
        this.verifyOptionalSetting("oauthtruststorepassword", connSettingRequestMap, connSettingResponseMap);
        this.verifyOptionalSetting("enableroutablequeries", connSettingRequestMap, connSettingResponseMap);
        this.verifyOptionalSetting("failonmultinodeplans", connSettingRequestMap, connSettingResponseMap);
        this.verifyOptionalSetting("maxpooledconnectionuses", connSettingRequestMap, connSettingResponseMap);
        this.verifyOptionalSetting("maxpooledconnections", connSettingRequestMap, connSettingResponseMap);
        this.verifyOptionalSetting("maxpooledconnectionspernode", connSettingRequestMap, connSettingResponseMap);
        this.verifyOptionalSetting("metadatacachelifetime", connSettingRequestMap, connSettingResponseMap);
        this.verifyOptionalSetting("nodedownwaittime", connSettingRequestMap, connSettingResponseMap);
        this.verifyOptionalSetting("preferredaddressfamily", connSettingRequestMap, connSettingResponseMap);
        this.verifyOptionalSetting("mars", connSettingRequestMap, connSettingResponseMap);
        this.verifyOptionalSetting("requestcomplextypes", connSettingRequestMap, connSettingResponseMap);
        Iterator<String> iterator = connSettingResponseMap.getKeysIterator();
        while (iterator.hasNext()) {
            String string = iterator.next();
            ConnectionSetting connectionSetting = connSettingResponseMap.getProperty(string);
            ArrayList<Variant> arrayList = VConnectionPropertyKey.getLegalValueVariants(string);
            if (arrayList != null) {
                connectionSetting.setValues(arrayList);
            }
            connectionSetting.setLabel(VConnectionPropertyKey.getProperyDescription(string));
        }
        return connSettingResponseMap;
    }

    @Override
    public void beginTransaction() throws GeneralException {
        LogUtilities.logFunctionEntrance(this.m_log, new Object[0]);
        this.m_withinTransaction = true;
    }

    public boolean withinTransaction() {
        return this.m_withinTransaction;
    }

    @Override
    public void commit() throws ErrorException {
        LogUtilities.logFunctionEntrance(this.m_log, new Object[0]);
        this.executeTransactionStatement("commit", true);
    }

    @Override
    public void rollback() throws ErrorException {
        LogUtilities.logFunctionEntrance(this.m_log, new Object[0]);
        try {
            this.endCurrentCopy();
        }
        catch (ErrorException errorException) {
            this.m_interruptedSBI = false;
            this.handleError(false, errorException);
        }
        this.executeTransactionStatement("rollback", true);
    }

    @Override
    public void createSavepoint(String string) throws ErrorException {
        LogUtilities.logFunctionEntrance(this.m_log, string);
        this.executeTransactionStatement("savepoint " + this.quoteIdentifier(string), false);
    }

    @Override
    public void releaseSavepoint(String string) throws ErrorException {
        LogUtilities.logFunctionEntrance(this.m_log, string);
        this.executeTransactionStatement("release savepoint " + this.quoteIdentifier(string), false);
    }

    @Override
    public void rollback(String string) throws ErrorException {
        LogUtilities.logFunctionEntrance(this.m_log, string);
        try {
            this.endCurrentCopy();
        }
        catch (ErrorException errorException) {
            this.m_interruptedSBI = false;
            this.handleError(false, errorException);
        }
        this.executeTransactionStatement("rollback to " + this.quoteIdentifier(string), true);
    }

    private String quoteIdentifier(String string) {
        if (!string.startsWith("\"")) {
            string = "\"" + string + "\"";
        }
        return string;
    }

    private void executeTransactionStatement(String string, boolean bl) throws ErrorException {
        this.lock();
        try {
            if (this.m_inTransactionAPICall) {
                throw new ClientErrorException("Illegally in transaction API call scope");
            }
            while (bl && this.inLRS()) {
                if (this.m_currentOpenResult == null) {
                    throw new ClientErrorException("Current open result must not be null");
                }
                this.m_currentOpenResult.close();
            }
            this.m_inTransactionAPICall = true;
            this.m_simpleQueryExecutor.execute(string);
        }
        finally {
            this.m_inTransactionAPICall = false;
            this.unlock();
        }
    }

    public boolean inTransactionAPICall() {
        return this.m_inTransactionAPICall;
    }

    public void cancelCurrentStatement(VStatement vStatement) throws ErrorException {
        LogUtilities.logFunctionEntrance(this.m_log, new Object[0]);
        VStatement vStatement2 = this.getCurrentStatement();
        VResultSet vResultSet = this.getCurrentResult();
        if (vStatement2 == vStatement || vResultSet != null && vResultSet.getParentStatement() == vStatement) {
            this.m_protocolStream.cancelCurrentStatement();
        }
    }

    public void setLongStringsEnabled(boolean bl) {
        this.m_areLongStringEnabled = bl;
    }

    public void setServerVersion(String string) {
        try {
            string = string.substring(1);
            String[] stringArray = string.split("[.]");
            int n = this.tryParseInt(stringArray[0]);
            int n2 = this.tryParseInt(stringArray[1]);
            int n3 = 0;
            int n4 = 0;
            if (stringArray.length > 2) {
                String[] stringArray2;
                String[] stringArray3 = stringArray[2].split("-");
                if (stringArray3.length > 0) {
                    n3 = this.tryParseInt(stringArray3[0]);
                }
                if (stringArray3.length > 1 && ((n4 = this.tryParseInt((stringArray2 = stringArray3[1].split("_"))[0])) < 0 || n4 > 99)) {
                    n4 = 0;
                }
            }
            this.m_serverVersion = String.format("%02d.%02d.%02d%02d", n, n2, n3, n4);
        }
        catch (Exception exception) {
            LogUtilities.logError("Could not parse the server version string. Server version will remain " + this.m_serverVersion, (ILogger)this.m_log);
        }
        LogUtilities.logInfo("Server version is " + this.m_serverVersion, (ILogger)this.m_log);
    }

    public String getServerVersion() {
        return this.m_serverVersion;
    }

    private int tryParseInt(String string) {
        int n = 0;
        try {
            n = Integer.parseInt(string);
        }
        catch (NumberFormatException numberFormatException) {
            LogUtilities.logError(numberFormatException, (ILogger)this.m_log);
        }
        return n;
    }

    public final ProtocolStream getProtocolStream() {
        return this.m_protocolStream;
    }

    public boolean inLRS() {
        return this.m_inLRS && this.m_isConnected;
    }

    public void setInLRS(boolean bl) {
        if (bl != this.m_inLRS) {
            LogUtilities.logInfo("LRS mode " + (bl ? "enabled." : "disabled."), (ILogger)this.m_log);
        }
        this.m_inLRS = bl;
    }

    public void executeLRSWorkQueue() throws ErrorException {
        try {
            for (LRSWork lRSWork : this.m_lrsWorkQueue) {
                lRSWork.execute();
            }
        }
        finally {
            this.m_lrsWorkQueue.clear();
        }
    }

    public void enqueueLRSWork(LRSWork lRSWork) {
        this.m_lrsWorkQueue.add(lRSWork);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void ensureNotInLRS(String string, long l) throws LRSException, ErrorException {
        this.lock();
        try {
            if (this.m_currentOpenResult != null) {
                this.m_currentOpenResult.tryFinishReadingResult();
            }
            if (this.m_inLRS) {
                if (this.m_currentOpenResult == null) {
                    throw new ClientErrorException("Current open result must not be null");
                }
                throw new LRSException(string, this.m_currentOpenResult.getResultBufferSize());
            }
        }
        finally {
            this.unlock();
        }
    }

    public void setCurrentCopy(VQueryExecutor vQueryExecutor) throws GeneralException {
        LogUtilities.logFunctionEntrance(this.m_log, vQueryExecutor);
        this.m_currentCopyExecutor = vQueryExecutor;
    }

    public void endCurrentCopy() throws ErrorException {
        this.m_interruptedSBI = false;
        try {
            if (this.m_currentCopyExecutor != null) {
                if (this.m_streamingBatchInsert && this.m_currentCopyExecutor instanceof VStreamQueryExecutor && !((VStreamQueryExecutor)this.m_currentCopyExecutor).getIsPreparedExecuteBatch() && ((VStreamQueryExecutor)this.m_currentCopyExecutor).getBatchCount() > 0) {
                    this.m_interruptedSBI = true;
                    throw new ErrorException(DiagState.DIAG_FUNC_SQNCE_ERR, 101, VMessageKey.ERROR_STREAMING_BATCH_INSERT_INTERRUPTED.toString());
                }
                this.m_currentCopyExecutor.endCopy();
            }
        }
        finally {
            if (!this.m_interruptedSBI) {
                this.m_currentCopyExecutor = null;
            }
        }
    }

    public void abortCurrentCopy() throws ErrorException {
        this.m_protocolStream.sendMessage(new CopyErrorRequestMessage(null));
    }

    public VQueryExecutor getCurrentCopyExecutor() {
        return this.m_currentCopyExecutor;
    }

    public void setCurrentServerErrorData(ServerErrorData serverErrorData) {
        this.m_currentServerError = serverErrorData;
        if (serverErrorData != null) {
            this.m_lastServerError = serverErrorData;
        }
    }

    public ServerErrorData getCurrentServerErrorData() {
        return this.m_currentServerError;
    }

    public ServerErrorData getLastServerErrorData() {
        return this.m_lastServerError;
    }

    public void clearLastServerErrorData() {
        LogUtilities.logFunctionEntrance(this.m_log, new Object[0]);
        this.m_lastServerError = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    public void handleError(boolean var1_1, ErrorException var2_2) throws ErrorException {
        this.lock();
        try {
            LogUtilities.logError(var2_2, (ILogger)this.m_log);
            if (var2_2 instanceof ClientException || this.m_interruptedSBI) {
                return;
            }
            var3_3 = false;
            if (this.m_currentServerError == null) ** GOTO lbl15
            var4_6 = this.m_currentServerError.getErrorLevel();
            if ("FATAL".equalsIgnoreCase((String)var4_6)) {
                this.close();
                return;
            }
            try {
                block14: {
                    var3_3 = "ROLLBACK".equalsIgnoreCase((String)var4_6);
                    break block14;
lbl15:
                    // 1 sources

                    if (this.getCurrentCopyExecutor() != null) {
                        var1_1 = false;
                        var4_6 = var2_2;
                        if (var2_2.getCause() != null) {
                            var4_6 = var2_2.getCause();
                        }
                        this.m_interruptedSBI = false;
                        this.m_protocolStream.sendMessage(new CopyErrorRequestMessage((Throwable)var4_6));
                    } else {
                        var1_1 = true;
                    }
                }
                var4_6 = this.m_protocolStream.resetProtocolState("Reset protocol state from error", var1_1);
                this.setInLRS(false);
                this.setCurrentCopy(null);
                this.setCurrentResult(null);
                this.setCurrentServerErrorData(null);
                this.setServerTxnState(((ReadyForQueryResponseMessage)var4_6).getTxnState(), var3_3, false);
            }
            catch (TransactionStateException var3_4) {
                throw new ClientErrorException(var3_4.getMessage());
            }
            catch (ErrorException var3_5) {
                LogUtilities.logError(var3_5, (ILogger)this.m_log);
                this.close();
                throw var3_5;
            }
        }
        finally {
            this.unlock();
        }
    }

    public String makeStatementName() {
        return "s" + this.m_statementCounter.incrementAndGet();
    }

    public VMetadataSource getMetadataSource(MetadataSourceID metadataSourceID, Map<MetadataSourceColumnTag, String> map, String string, String string2, boolean bl) throws ErrorException {
        return new VMetadataSource(this, metadataSourceID, map, string, string2, bl);
    }

    public ITransactionStateListener getTransactionStateListener() {
        return this.m_transactionListener;
    }

    public void setCurrentResult(VResultSet vResultSet) {
        LogUtilities.logFunctionEntrance(this.m_log, vResultSet);
        this.m_currentOpenResult = vResultSet;
    }

    public VResultSet getCurrentResult() {
        return this.m_currentOpenResult;
    }

    public VStatement getCurrentStatement() {
        return this.m_currentOpenStatement;
    }

    public void setCurrentStatement(VStatement vStatement) {
        LogUtilities.logFunctionEntrance(this.m_log, vStatement);
        this.m_currentOpenStatement = vStatement;
    }

    public void setServerTxnState(char c, boolean bl, boolean bl2) throws TransactionStateException {
        if (this.m_serverTransactionState != c) {
            this.m_serverTransactionState = c;
            this.m_withinTransaction = c == 'T';
            try {
                if (bl && !this.isAutoCommitEnabled() && c == 'I') {
                    if (bl2) {
                        this.getTransactionStateListener().notifyRollback();
                    } else {
                        this.getTransactionStateListener().notifyCommit();
                    }
                }
            }
            catch (ErrorException errorException) {
                throw new TransactionStateException(errorException);
            }
        }
    }

    public char getServerTxnState() {
        return this.m_serverTransactionState;
    }

    public boolean isAutoCommitEnabled() throws ClientErrorException {
        String string = null;
        try {
            return this.getProperty(19).getLong() == 1L;
        }
        catch (IncorrectTypeException incorrectTypeException) {
            string = incorrectTypeException.getMessage();
        }
        catch (BadPropertyKeyException badPropertyKeyException) {
            string = badPropertyKeyException.getMessage();
        }
        catch (ErrorException errorException) {
            string = errorException.getMessage();
        }
        catch (NumericOverflowException numericOverflowException) {
            string = numericOverflowException.getMessage();
        }
        throw new ClientErrorException(string);
    }

    public boolean isReadOnly() throws ClientErrorException {
        String string = null;
        try {
            Variant variant = this.getProperty(16);
            return variant.getLong() == 1L;
        }
        catch (IncorrectTypeException incorrectTypeException) {
            string = incorrectTypeException.getMessage();
        }
        catch (BadPropertyKeyException badPropertyKeyException) {
            string = badPropertyKeyException.getMessage();
        }
        catch (ErrorException errorException) {
            string = errorException.getMessage();
        }
        catch (NumericOverflowException numericOverflowException) {
            string = numericOverflowException.getMessage();
        }
        throw new ClientErrorException(string);
    }

    public void setDatabaseName(String string) {
        this.m_dbname = string;
    }

    public String getDatabaseName() {
        return this.m_dbname;
    }

    public String getHost() {
        return this.m_host;
    }

    public String getLogPath() {
        return this.m_logPath;
    }

    public void setLogPath(String string) {
        this.m_logPath = string;
    }

    public int getLoginTimeout() {
        return this.m_loginTimeout;
    }

    public void setLoginTimeout(int n) {
        LogUtilities.logInfo("Login timeout set to " + n, (ILogger)this.m_log);
        this.m_loginTimeout = n;
    }

    public int getLoginNetworkTimeout() {
        return this.m_loginNetworkTimeout;
    }

    public void setLoginNetworkTimeout(int n) {
        LogUtilities.logInfo("LoginNetworktimeout set to " + n, (ILogger)this.m_log);
        this.m_loginNetworkTimeout = n;
    }

    public int getLoginNodeTimeout() {
        return this.m_loginNodeTimeout;
    }

    public void setLoginNodeTimeout(int n) {
        LogUtilities.logInfo("LoginNodetimeout set to " + n, (ILogger)this.m_log);
        this.m_loginNodeTimeout = n;
    }

    public String getSocketFactoryName() {
        return this.m_socketFactoryName;
    }

    public void setSocketFactoryName(String string) {
        LogUtilities.logInfo("Socket Factory Name set to " + string, (ILogger)this.m_log);
        this.m_socketFactoryName = string;
    }

    public void setSessionLabel(String string) {
        if (string.length() > 255) {
            string = string.substring(0, 255);
        }
        LogUtilities.logInfo("Session label is " + string, (ILogger)this.m_log);
        this.m_sessionLabel = string;
    }

    public String getSessionLabel() {
        return this.m_sessionLabel;
    }

    public TLSMode getTLSMode() {
        return this.m_tlsMode;
    }

    public int getTxnIsolation() {
        try {
            return this.getProperty(26).getInt();
        }
        catch (Exception exception) {
            return 2;
        }
    }

    public void setLogLevel(String string) {
        LogUtilities.logInfo("Log level set to " + string, (ILogger)this.m_log);
        this.m_log.setLogLevel(LogLevel.getLogLevel(string));
    }

    public String getLogLevel() {
        return this.m_log.getLogLevel().toString();
    }

    public void setLogPackage(String string) {
        LogUtilities.logInfo("Log package set to " + string, (ILogger)this.m_log);
        this.m_logPackage = string;
        this.m_log.setLogPackage(string);
    }

    public String getLogNamespace() {
        return this.m_logPackage;
    }

    public void setServerLocale(String string, boolean bl) throws ErrorException {
        if (bl) {
            this.m_simpleQueryExecutor.execute("set locale to '" + string + "'");
        }
        this.m_locale = string;
    }

    public String getServerLocale() {
        return this.m_locale;
    }

    public String getSessionTimezone() {
        return this.m_sessionTimezone;
    }

    public void updateSessionTimezone(String string) {
        this.m_sessionTimezone = string;
    }

    public void setAndSendSessionTimezone(String string) throws ErrorException {
        LogUtilities.logInfo("Setting session timezone to " + string, (ILogger)this.m_log);
        this.m_sessionTimezone = string;
        this.m_simpleQueryExecutor.execute("set timezone to '" + this.m_sessionTimezone + "'");
    }

    public void setUseStrictCatalogFiltering(boolean bl) {
        LogUtilities.logInfo("Strict catalog filtering " + (bl ? "enabled." : "disabled."), (ILogger)this.m_log);
        this.m_useStrictCatalogFiltering = bl;
    }

    public boolean getUseStrictCatalogFiltering() {
        return this.m_useStrictCatalogFiltering;
    }

    public void setAddTzToTimestampParameters(boolean bl) {
        LogUtilities.logInfo("AddTzToTimestampParameters" + (bl ? "enabled." : "disabled."), (ILogger)this.m_log);
        this.m_addTzToTimestampParameters = bl;
    }

    public boolean getAddTzToTimestampParameters() {
        return this.m_addTzToTimestampParameters;
    }

    public boolean getDirectBatchInsert() {
        return this.m_directBatchInsert;
    }

    public void setDirectBatchInsert(boolean bl) {
        LogUtilities.logInfo("Direct batch insert " + (bl ? "enabled." : "disabled."), (ILogger)this.m_log);
        this.m_directBatchInsert = bl;
    }

    public long getResultBufferSize() {
        return this.m_resultBufferSize;
    }

    public void setResultBufferSize(long l) throws GeneralException {
        if (l <= 0L) {
            l = Long.MAX_VALUE;
        }
        if (this.m_resultBufferSize != l) {
            LogUtilities.logInfo("ResultBufferSize set to " + l, (ILogger)this.m_log);
        }
        this.m_resultBufferSize = l;
    }

    public String getServer() {
        return this.m_host;
    }

    public int getPort() {
        return this.m_port;
    }

    public boolean useStandardConformingStrings() {
        return this.m_useStandardConformingStrings;
    }

    public void setUseStandardConformingStrings(boolean bl) {
        LogUtilities.logInfo("Standard conforming strings " + (bl ? "enabled." : "disabled."), (ILogger)this.m_log);
        this.m_useStandardConformingStrings = bl;
    }

    public void setEnableRoutableQueries(boolean bl) {
        LogUtilities.logInfo("Routable queries " + (bl ? "enabled." : "disabled."), (ILogger)this.m_log);
        this.m_enableRoutableQueries = bl;
    }

    public void setSimpleQueriesOnly(boolean bl) {
        this.m_simpleQueriesOnly = bl;
    }

    public void setFailOnMultinodePlans(boolean bl) {
        LogUtilities.logInfo("FailOnMultiNodePlans " + (bl ? "enabled." : "disabled."), (ILogger)this.m_log);
        this.m_failOnMultinodePlans = bl;
    }

    public void setMaxPooledConnections(int n) {
        if (n < 0) {
            n = 20;
        } else if (n == 0) {
            n = Integer.MAX_VALUE;
        }
        LogUtilities.logInfo("MaxPooledConnections set to " + n, (ILogger)this.m_log);
        this.m_maxPooledConnections = n;
    }

    public void setMaxPooledConnectionsPerNode(int n) {
        if (n < 0) {
            n = 5;
        } else if (n == 0) {
            n = Integer.MAX_VALUE;
        }
        LogUtilities.logInfo("MaxPooledConnectionsPerNode set to " + n, (ILogger)this.m_log);
        this.m_maxPooledConnectionsPerNode = n;
    }

    public void setMaxPooledConnectionUses(int n) {
        if (n < 0) {
            n = 1000;
        } else if (n == 0) {
            n = Integer.MAX_VALUE;
        }
        LogUtilities.logInfo("MaxPooledConnectionUses set to " + n, (ILogger)this.m_log);
        this.m_maxPooledConnectionUses = n;
    }

    public void setNodeDownWaitTime(int n) {
        if (n < 0) {
            n = 60;
        } else if (n == 0) {
            n = Integer.MAX_VALUE;
        }
        LogUtilities.logInfo("NodeDownWaitTime set to " + n, (ILogger)this.m_log);
        this.m_nodeDownWaitTime = n;
    }

    public void setMetadataCacheLifetime(int n) {
        if (n < 0) {
            n = 300;
        }
        LogUtilities.logInfo("MetadataCacheLifeTime set to " + n, (ILogger)this.m_log);
        this.m_metadataCacheLifetime = n;
    }

    public void setPreferredAddressFamily(VConnectionPropertyValue.AddressFamilyPreference addressFamilyPreference) {
        this.m_preferredAddressFamily = addressFamilyPreference;
        LogUtilities.logInfo("PreferredAddressFamily set to " + (Object)((Object)addressFamilyPreference), (ILogger)this.m_log);
    }

    public VConnectionPropertyValue.AddressFamilyPreference getPreferredAddressFamily() {
        return this.m_preferredAddressFamily;
    }

    public void setMarsEnabled(boolean bl) {
        if (this.m_marsEnabled != bl) {
            if (bl && !Features.isSupported(Features.Feature.MARS, this.getEffectiveProtocolVersion())) {
                LogUtilities.logWarning("Multiple active result sets not enabled; feature is not supported by server", (ILogger)this.m_log);
                return;
            }
            this.m_marsEnabled = bl;
            LogUtilities.logInfo("Mars set to " + (bl ? "on" : "off"), (ILogger)this.m_log);
            return;
        }
        LogUtilities.logInfo("Mars unchanged: it is already " + (bl ? "on" : "off"), (ILogger)this.m_log);
    }

    public void setServerMarsEnabled(boolean bl) throws ErrorException {
        if (bl != this.m_marsEnabled) {
            if (bl && !Features.isSupported(Features.Feature.MARS, this.getEffectiveProtocolVersion())) {
                LogUtilities.logWarning("Multiple active result sets not enabled; feature is not supported by server", (ILogger)this.m_log);
                throw new FeatureNotSupportedClientException("0A", "Server does not support multiple active result sets", 0);
            }
            this.m_simpleQueryExecutor.execute("set mars to " + (bl ? "on" : "off"));
            LogUtilities.logInfo("Mars session parameter changed to " + (bl ? "on" : "off"), (ILogger)this.m_log);
        }
    }

    public boolean getMarsEnabled() {
        return this.m_marsEnabled;
    }

    public boolean getEnableRoutableQueries() {
        return this.m_enableRoutableQueries;
    }

    public boolean getSimpleQueriesOnly() {
        return this.m_simpleQueriesOnly;
    }

    public boolean getFailOnMultiNodePlans() {
        return this.m_failOnMultinodePlans;
    }

    public int getMaxPooledConnections() {
        return this.m_maxPooledConnections;
    }

    public int getMaxPooledConnectionsPerNode() {
        return this.m_maxPooledConnectionsPerNode;
    }

    public int getMaxPooledConnectionUses() {
        return this.m_maxPooledConnectionUses;
    }

    public int getNodeDownWaitTime() {
        return this.m_nodeDownWaitTime;
    }

    public int getMetadataCacheLifetime() {
        return this.m_metadataCacheLifetime;
    }

    public String getCatalogName() {
        return this.m_useThreePartNaming ? "'" + this.m_dbname + "'" : "NULL";
    }

    public boolean getUseThreePartNaming() {
        return this.m_useThreePartNaming;
    }

    public void setUseThreePartNaming(boolean bl) throws ClientErrorException {
        LogUtilities.logInfo("Three part naming " + (bl ? "enabled." : "disabled."), (ILogger)this.m_log);
        this.m_useThreePartNaming = bl;
        try {
            if (bl) {
                this.setProperty(9, new Variant(0, "Y"));
                this.setProperty(22, new Variant(0, this.m_dbname));
            } else {
                this.setProperty(9, new Variant(0, "N"));
                this.setProperty(22, new Variant(0, null));
            }
        }
        catch (Exception exception) {
            throw new ClientErrorException(exception.getMessage());
        }
    }

    public void setHost(String string) {
        this.m_host = string;
    }

    public void setPort(int n) {
        this.m_port = n;
    }

    public void setBackupServerNode(String string) {
        LogUtilities.logInfo("Backup server node set to " + string, (ILogger)this.m_log);
        this.m_backupServerNode = string;
        this.m_backupNodes = string.equals("") ? new String[0] : this.m_backupServerNode.split(",");
    }

    public String getBackupServerNode() {
        return this.m_backupServerNode;
    }

    public String[] getBackupNodes() {
        return this.m_backupNodes;
    }

    public void setConnectionLoadBalance(boolean bl) {
        LogUtilities.logInfo("Connection load balancing " + (bl ? "enabled." : "disabled."), (ILogger)this.m_log);
        this.m_connectionLoadBalance = bl;
    }

    public boolean getConnectionLoadBalance() {
        return this.m_connectionLoadBalance;
    }

    public void setJAASConfigName(String string) {
        LogUtilities.logInfo("JAAS config name set to " + string, (ILogger)this.m_log);
        this.m_jaasConfigName = string;
    }

    public String getJAASConfigName() {
        return this.m_jaasConfigName;
    }

    public void setKerberosUsesDefaultValues(boolean bl) {
        this.m_kerberosUsesDefaultValues = bl;
    }

    public boolean getKerberosUsesDefaultValues() {
        return this.m_kerberosUsesDefaultValues;
    }

    public void setKerberosServiceName(String string) {
        LogUtilities.logInfo("Kerberos service set to " + string, (ILogger)this.m_log);
        this.m_kerberosServiceName = string;
    }

    public String getKerberosServiceName() {
        return this.m_kerberosServiceName;
    }

    public void setKerberosHostName(String string) {
        LogUtilities.logInfo("Kerberos host set to " + string, (ILogger)this.m_log);
        this.m_kerberosHostName = string;
    }

    public String getKerberosHostName() {
        return this.m_kerberosHostName;
    }

    public void setOAuthAccessToken(String string) {
        this.m_oauthAccessToken = string;
    }

    public String getOAuthAccessToken() {
        return this.m_oauthAccessToken;
    }

    public void setOAuthRefreshToken(String string) {
        this.m_oauthRefreshToken = string;
    }

    public String getOAuthRefreshToken() {
        return this.m_oauthRefreshToken;
    }

    public void setOAuthJsonConfig(String string) {
        this.m_oauthJsonConfig = string;
    }

    public String getOAuthJsonConfig() {
        return this.m_oauthJsonConfig;
    }

    public void setLegacyOAuthTokenUrl(String string) {
        this.m_oauthTokenUrl = string;
    }

    public String getLegacyOAuthTokenUrl() {
        return this.m_oauthTokenUrl;
    }

    public void setLegacyOAuthClientId(String string) {
        this.m_oauthClientId = string;
    }

    public String getLegacyOAuthClientId() {
        return this.m_oauthClientId;
    }

    public void setLegacyOAuthClientSecret(String string) {
        this.m_oauthClientSecret = string;
    }

    public String getLegacyOAuthClientSecret() {
        return this.m_oauthClientSecret;
    }

    public void setLegacyOAuthDiscoveryUrl(String string) {
        this.m_oauthDiscoveryUrl = string;
    }

    public String getLegacyOAuthDiscoveryUrl() {
        return this.m_oauthDiscoveryUrl;
    }

    public void setLegacyOAuthScope(String string) {
        this.m_oauthScope = string;
    }

    public String getLegacyOAuthScope() {
        return this.m_oauthScope;
    }

    public void setStreamingBatchInsert(boolean bl) throws ClientErrorException {
        LogUtilities.logInfo("Streaming batch inserts " + (bl ? "enabled." : "disabled."), (ILogger)this.m_log);
        this.m_streamingBatchInsert = bl;
        String string = this.m_streamingBatchInsert ? "Y" : "N";
        try {
            this.setProperty(1006, new Variant(0, string));
        }
        catch (Exception exception) {
            throw new ClientErrorException(exception.getMessage());
        }
    }

    public boolean getStreamingBatchInsert() {
        return this.m_streamingBatchInsert;
    }

    public void setRequestComplexTypes(boolean bl) throws ClientErrorException {
        LogUtilities.logInfo("Requesting Complex Type Meta Data is " + (bl ? "enabled." : "disabled."), (ILogger)this.m_log);
        this.m_requestComplexTypes = bl;
    }

    public boolean getRequestComplexTypes() {
        return this.m_requestComplexTypes;
    }

    public void setDisableCopyLocal(boolean bl) {
        LogUtilities.logInfo("COPY LOCAL is " + (bl ? "disabled." : "enabled."), (ILogger)this.m_log);
        this.m_disableCopyLocal = bl;
    }

    public boolean getDisableCopyLocal() {
        return this.m_disableCopyLocal;
    }

    public void setBinaryTransfer(boolean bl) {
        LogUtilities.logInfo("Binary transfer is " + (bl ? "enabled." : "disabled."), (ILogger)this.m_log);
        this.m_binaryTransfer = bl;
    }

    public boolean getBinaryTransfer() {
        return this.m_binaryTransfer;
    }

    public void setWorkload(String string) {
        LogUtilities.logInfo("Workload set to " + string, (ILogger)this.m_log);
        this.m_workload = string;
    }

    public String getWorkload() {
        return this.m_workload;
    }

    public void setNetworkBufferSize(int n) {
        int n2 = this.m_networkBufferSize = n > 0 ? n : 8192;
        if (this.m_networkBufferSize != 8192) {
            LogUtilities.logInfo("NetworkBufferSize set to " + n, (ILogger)this.m_log);
        }
    }

    private void setNetworkTimeoutMember(int n) throws IOException {
        int n2 = this.m_networkTimeout = n >= 0 ? n : 0;
        if (n < 0) {
            LogUtilities.logWarning("User specified illegal network timeout value: " + n, (ILogger)this.m_log);
        }
        LogUtilities.logInfo("NetworkTimeout set to " + this.m_networkTimeout, (ILogger)this.m_log);
    }

    public void setNetworkTimeout(int n) throws IOException {
        this.setNetworkTimeoutMember(n);
        this.m_protocolStream.setNetworkTimeout(this.m_networkTimeout);
    }

    public int getNetworkTimeout() {
        return this.m_networkTimeout;
    }

    public int getNetworkBufferSize() {
        return this.m_networkBufferSize;
    }

    public void setConnSettings(String string) {
        if (!"".equals(string)) {
            LogUtilities.logInfo("ConnSettings set to " + string, (ILogger)this.m_log);
        }
        this.m_connSettingsSql = string;
    }

    public String getConnSettings() {
        return this.m_connSettingsSql;
    }

    public void setTLSMode(TLSMode tLSMode) {
        LogUtilities.logInfo("TLSMode set to " + tLSMode.toString(), (ILogger)this.m_log);
        this.m_tlsMode = tLSMode;
    }

    public boolean getReadOnly() {
        try {
            return this.getProperty(16).getLong() == 1L;
        }
        catch (Exception exception) {
            return false;
        }
    }

    public String getUser() {
        return this.m_user;
    }

    public void setSearchPath(String string, boolean bl) throws ErrorException {
        if ("".equals(string = string.trim())) {
            return;
        }
        String[] stringArray = string.split(",");
        StringBuilder stringBuilder = new StringBuilder(string.length() + 2 * stringArray.length + 19);
        stringBuilder.append("set search_path to ");
        for (int i = 0; i < stringArray.length; ++i) {
            stringBuilder.append(this.quoteIdentifier(stringArray[i].trim()));
            if (i >= stringArray.length - 1) continue;
            stringBuilder.append(",");
        }
        if (bl) {
            this.m_simpleQueryExecutor.execute(stringBuilder.toString());
        }
    }

    public String getSearchPath() throws ErrorException, IncorrectTypeException {
        VResultSet vResultSet = this.m_simpleQueryExecutor.execute("show search_path");
        vResultSet.moveToNextRow();
        DataWrapper dataWrapper = new DataWrapper();
        vResultSet.getData(1, 0L, -1L, dataWrapper);
        return dataWrapper.getVarChar();
    }

    public boolean useStringBatchInserts() {
        return this.m_stringBatchInsert;
    }

    public void setStringBatchInsert(boolean bl) {
        this.m_stringBatchInsert = bl;
    }

    public boolean isClosed() {
        return !this.m_isConnected;
    }

    @Override
    public boolean isAlive() {
        this.m_connectionLock.lockInterruptibly();
        try {
            if (!this.isClosed()) {
                try {
                    if (this.inLRS()) {
                        try {
                            this.m_currentOpenResult.tryFinishReadingResult();
                        }
                        catch (ErrorException errorException) {
                            this.handleError(false, errorException);
                        }
                    } else if (this.m_currentCopyExecutor != null) {
                        LogUtilities.logDebug("Connection isValid() check doesn't work during streaming process (Batch Insert or Copy Local)", (ILogger)this.m_log);
                    } else {
                        this.m_protocolStream.resetProtocolState("Connection isValid() check.", true);
                    }
                }
                catch (ErrorException errorException) {
                    this.close();
                    LogUtilities.logInfo("Failed to communicate with server during isAlive(). Connection is probably closed.", (ILogger)this.m_log);
                }
            }
            boolean bl = !this.isClosed();
            this.unlock();
            return bl;
        }
        catch (Throwable throwable) {
            try {
                this.unlock();
                throw throwable;
            }
            catch (InterruptedException interruptedException) {
                Thread.currentThread().interrupt();
                return false;
            }
        }
    }

    public AddressList getAddressList() {
        return this.m_addressList;
    }

    @Override
    public void setClientInfoProperty(String string, String string2) throws ClientInfoException {
        LogUtilities.logFunctionEntrance(this.m_log, new Object[0]);
        if (string.equals(CLIENT_INFO_PROPERTY_APPLICATION_NAME)) {
            this.setApplicationNameClientInfoProperty(string2);
            return;
        }
        if (string.equals(CLIENT_INFO_PROPERTY_CLIENT_USER)) {
            this.setUserClientInfoProperty(string2);
            return;
        }
        this.setLocalClientInfoProperty(string, string2);
    }

    private void setApplicationNameClientInfoProperty(String string) throws ClientInfoException {
        try {
            if (string == null) {
                this.m_simpleQueryExecutor.execute("select set_client_label('')");
                LogUtilities.logInfo("Client label is set to (null)", (ILogger)this.m_log);
            } else {
                this.m_simpleQueryExecutor.execute("select set_client_label('" + string + "')");
                LogUtilities.logInfo("Client label is set to " + (string.length() > 255 ? string.substring(0, 255) : string), (ILogger)this.m_log);
            }
        }
        catch (ErrorException errorException) {
            LogUtilities.logError(errorException, (ILogger)this.m_log);
            HashMap<String, FailedPropertiesReason> hashMap = new HashMap<String, FailedPropertiesReason>();
            hashMap.put(CLIENT_INFO_PROPERTY_APPLICATION_NAME, FailedPropertiesReason.UNKNOWN);
            throw new ClientInfoException(errorException.getDiagState(), 100024, CLIENT_INFO_PROPERTY_APPLICATION_NAME, hashMap);
        }
    }

    private void setUserClientInfoProperty(String string) throws ClientInfoException {
        ClientInfoData clientInfoData = (ClientInfoData)this.m_clientInfoProperties.get(CLIENT_INFO_PROPERTY_CLIENT_USER);
        if (clientInfoData != null && string != null && string.length() > clientInfoData.getMaxLength()) {
            super.setClientInfoProperty(CLIENT_INFO_PROPERTY_CLIENT_USER, string.substring(0, clientInfoData.getMaxLength()));
        } else {
            super.setClientInfoProperty(CLIENT_INFO_PROPERTY_CLIENT_USER, string);
        }
    }

    public void setLocalClientInfoProperty(String string, String string2) throws ClientInfoException {
        super.setClientInfoProperty(string, string2);
    }

    public int getFixedProtocolVersion() {
        return this.m_fixedProtocolVersion;
    }

    public void setFixedProtocolVersion(String string) {
        this.m_fixedProtocolVersion = ProtocolUtils.protocolStrToInt(string);
    }

    public int getEffectiveProtocolVersion() {
        return this.m_effectiveProtocolVersion;
    }

    public void setEffectiveProtocolVersion(String string) {
        this.m_effectiveProtocolVersion = ProtocolUtils.protocolStrToInt(string);
        if (this.m_marsEnabled && !Features.isSupported(Features.Feature.MARS, this.m_effectiveProtocolVersion)) {
            this.m_marsEnabled = false;
            LogUtilities.logWarning("Multiple active result sets are disabled; feature is not supported by server", (ILogger)this.m_log);
        }
        if (this.m_requestComplexTypes && !Features.isSupported(Features.Feature.ComplexTypes, this.m_effectiveProtocolVersion)) {
            this.m_requestComplexTypes = false;
            LogUtilities.logWarning("Complex Type support is disabled; feature is not supported by server", (ILogger)this.m_log);
        }
    }

    @Override
    protected void doReset() throws ErrorException {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static {
        block20: {
            LOG_DATE_FORMAT = new SimpleDateFormat("MM-dd_HH.mm.ss.SSSS");
            s_connectionCounter = new AtomicInteger(0);
            Properties properties = new Properties();
            InputStream inputStream = VDriver.class.getResourceAsStream("driver.properties");
            boolean bl = true;
            try {
                Charset.forName("UTF-8");
                "test".getBytes("UTF-8");
            }
            catch (Exception exception) {
                bl = false;
            }
            VERTICA_CHARSET = bl ? "UTF-8" : null;
            try {
                if (inputStream != null) {
                    properties.load(inputStream);
                } else {
                    bl = false;
                }
            }
            catch (MissingResourceException missingResourceException) {
                System.err.println(missingResourceException.getLocalizedMessage());
                bl = false;
            }
            catch (IOException iOException) {
                System.err.println(iOException.getLocalizedMessage());
                bl = false;
            }
            finally {
                s_buildProps = properties;
                if (inputStream != null) {
                    try {
                        inputStream.close();
                    }
                    catch (IOException iOException) {
                        System.err.println(iOException.getLocalizedMessage());
                        bl = false;
                    }
                }
                if (bl) break block20;
                throw new RuntimeException("Error loading driver properties.");
            }
        }
        DRIVER_FILENAME = s_buildProps.getProperty("driver.filename");
    }
}

