/*
 * Decompiled with CFR 0.152.
 */
package com.vertica.deserializer.impl;

import com.vertica.core.VConnection;
import com.vertica.deserializer.MultiFormatDeserializer;
import com.vertica.deserializer.impl.DateDeserializerImpl;
import com.vertica.deserializer.impl.TimeDeserializerImpl;
import com.vertica.deserializer.impl.TimestampDeserializerImpl;
import com.vertica.dsi.dataengine.utilities.DataWrapper;
import com.vertica.dsi.dataengine.utilities.TimestampTz;
import com.vertica.util.ClientErrorException;
import java.io.UnsupportedEncodingException;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.HashMap;
import java.util.SimpleTimeZone;

public class TimestampTZDeserializerImpl
implements MultiFormatDeserializer {
    public int m_oid;

    public TimestampTZDeserializerImpl(int n) {
        this.m_oid = n;
    }

    @Override
    public boolean deserializeBinary(long l, long l2, DataWrapper dataWrapper, byte[] byArray, HashMap<String, Object> hashMap) throws UnsupportedEncodingException, ClientErrorException {
        TimestampDeserializerImpl.deserializeTimestampBinary(this.m_oid, dataWrapper, byArray, hashMap);
        return false;
    }

    @Override
    public boolean deserializeText(long l, long l2, DataWrapper dataWrapper, byte[] byArray, HashMap<String, Object> hashMap) throws UnsupportedEncodingException, ClientErrorException {
        if (TimestampDeserializerImpl.deserializeInfinityTimestamp(dataWrapper, byArray)) {
            return false;
        }
        Calendar calendar = TimestampTZDeserializerImpl.getTimeZoneCalendar(byArray);
        DateDeserializerImpl.setCalendar(13, calendar, byArray);
        Timestamp timestamp = new Timestamp(calendar.getTimeInMillis());
        timestamp.setNanos(TimestampTZDeserializerImpl.getNano(byArray));
        dataWrapper.setTimestamp(new TimestampTz(timestamp, calendar));
        return false;
    }

    public static int getNano(byte[] byArray) {
        int n = 0;
        boolean bl = false;
        boolean bl2 = false;
        if (byArray.length == 0) {
            return 0;
        }
        int n2 = DateDeserializerImpl.BytesIndexOf(byArray, '.');
        if (n2 == -1) {
            return 0;
        }
        int n3 = 100000;
        ++n2;
        while (n2 < byArray.length && byArray[n2] != 43 && byArray[n2] != 45) {
            n += (byArray[n2] - 48) * n3;
            n3 /= 10;
            ++n2;
        }
        return n * 1000;
    }

    public static Calendar getTimeZoneCalendar(byte[] byArray) throws UnsupportedEncodingException {
        int n;
        for (n = byArray.length - 1; n >= 0 && byArray[n] != 43 && byArray[n] != 45; --n) {
        }
        String string = new String(byArray, n, byArray.length - n, VConnection.VERTICA_CHARSET);
        return Calendar.getInstance(new SimpleTimeZone(TimeDeserializerImpl.getTimeZoneOffSet(byArray, n), string));
    }
}

