/*
 * Decompiled with CFR 0.152.
 */
package com.vertica.support;

import java.io.File;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;

public class CustomClassLoader
extends URLClassLoader {
    private static final String FILE_PROTOCOL = "file://localhost/";
    private static final String JAR_PROTOCOL;
    private static final String JAR_END = "!/";
    private static final Method getClassLoadingLock;

    public CustomClassLoader(String classpath) throws MalformedURLException {
        super(CustomClassLoader.getURLArray(classpath));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Class<?> loadClass(String className) throws ClassNotFoundException {
        CustomClassLoader lock;
        try {
            lock = getClassLoadingLock == null ? this : getClassLoadingLock.invoke((Object)this, className);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        CustomClassLoader customClassLoader = lock;
        synchronized (customClassLoader) {
            Class<?> lClass = this.findLoadedClass(className);
            if (lClass == null) {
                try {
                    lClass = this.findClass(className);
                }
                catch (ClassNotFoundException cnfe) {
                    ClassLoader lparent = this.getParent();
                    lClass = lparent == null ? CustomClassLoader.getSystemClassLoader().loadClass(className) : lparent.loadClass(className);
                }
            }
            return lClass;
        }
    }

    @Override
    public URL getResource(String name) {
        URL url = this.findResource(name);
        if (null == url) {
            ClassLoader lparent = this.getParent();
            url = lparent != null ? lparent.getResource(name) : CustomClassLoader.getSystemClassLoader().getResource(name);
        }
        return url;
    }

    private static URL[] getURLArray(String classpath) throws MalformedURLException {
        StringBuilder builder = new StringBuilder();
        String[] paths = classpath.split(";");
        URL[] urlArray = new URL[paths.length];
        for (int i = 0; i < paths.length; ++i) {
            if (!new File(paths[i]).exists()) continue;
            File file = new File(paths[i]);
            if (file.isDirectory()) {
                builder.append(FILE_PROTOCOL + paths[i]);
                if (!paths[i].endsWith("/")) {
                    builder.append("/");
                }
            } else if (file.isFile()) {
                builder.append(JAR_PROTOCOL + paths[i] + JAR_END);
            }
            try {
                urlArray[i] = new URL(builder.toString());
                continue;
            }
            catch (MalformedURLException e) {
                throw new MalformedURLException("Malformed URL: " + paths[i]);
            }
        }
        return urlArray;
    }

    static {
        Method m;
        JAR_PROTOCOL = System.getProperty("os.name").toLowerCase().indexOf("win") >= 0 ? "jar:file:/" : "jar:file:";
        try {
            m = ClassLoader.class.getDeclaredMethod("getClassLoadingLock", String.class);
        }
        catch (NoSuchMethodException nsme) {
            m = null;
        }
        getClassLoadingLock = m;
    }
}

