/*
 * Decompiled with CFR 0.152.
 */
package com.vertica.deserializer.impl;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.vertica.core.VConnection;
import com.vertica.dataengine.ColumnDescription;
import com.vertica.deserializer.Deserializer;
import com.vertica.dsi.dataengine.utilities.DataWrapper;
import com.vertica.dsi.exceptions.IncorrectTypeException;
import com.vertica.support.exceptions.ErrorException;
import com.vertica.util.ClientErrorException;
import com.vertica.util.VerticaStruct;
import java.io.UnsupportedEncodingException;
import java.util.HashMap;

public class StructDeserializerImpl
implements Deserializer {
    private ColumnDescription m_columnDescription;

    public StructDeserializerImpl(ColumnDescription columnDescription) {
        this.m_columnDescription = columnDescription;
    }

    @Override
    public boolean deserialize(long l, long l2, DataWrapper dataWrapper, byte[] byArray, HashMap<String, Object> hashMap) throws UnsupportedEncodingException, ClientErrorException, ErrorException {
        String string = new String(byArray, 0, byArray.length, VConnection.VERTICA_CHARSET);
        JsonElement jsonElement = new JsonParser().parse(string);
        VerticaStruct verticaStruct = StructDeserializerImpl.parseStruct(this.m_columnDescription, jsonElement);
        try {
            dataWrapper.setData(2002, verticaStruct);
        }
        catch (IncorrectTypeException incorrectTypeException) {
            throw new ClientErrorException("Unable to convert Complex Type to Struct: " + jsonElement.toString());
        }
        return false;
    }

    public static VerticaStruct parseStruct(ColumnDescription columnDescription, JsonElement jsonElement) {
        JsonObject jsonObject = jsonElement.getAsJsonObject();
        return new VerticaStruct(columnDescription, jsonObject);
    }
}

