/*
 * Decompiled with CFR 0.152.
 */
package com.vertica.util;

import com.vertica.core.VConnection;
import com.vertica.util.ClientErrorException;
import java.io.UnsupportedEncodingException;
import java.util.Calendar;
import java.util.SimpleTimeZone;

public class TimeParser {
    private static final int ASCII_OFFSET = 48;
    private byte[] m_columnData;
    private int[] m_parts = new int[4];
    private int m_timezoneOffset = 0;
    private int m_tzStart = 0;
    private boolean m_sawTz = false;

    public TimeParser(byte[] byArray) throws ClientErrorException {
        this.m_columnData = byArray;
        this.ParseData();
    }

    private void ParseData() throws ClientErrorException {
        int n;
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        for (n = 0; n < this.m_columnData.length; ++n) {
            if (this.m_columnData[n] == 58 || this.m_columnData[n] == 32) {
                ++n2;
                continue;
            }
            if (this.m_columnData[n] == 46) {
                ++n2;
                n3 = n + 1;
                continue;
            }
            if (this.m_columnData[n] == 43 || this.m_columnData[n] == 45) {
                n4 = this.m_tzStart = n;
                this.m_sawTz = true;
                this.m_timezoneOffset = this.parseTimeZoneOffSet();
                break;
            }
            this.m_parts[n2] = this.m_parts[n2] * 10 + this.m_columnData[n] - 48;
        }
        if (n4 == 0) {
            n4 = this.m_columnData.length;
        }
        for (n = n4 - n3; n < 6; ++n) {
            this.m_parts[3] = this.m_parts[3] * 10;
        }
    }

    private int parseTimeZoneOffSet() throws ClientErrorException {
        int n = this.m_columnData[this.m_tzStart] == 45 ? -1 : 1;
        int n2 = 0;
        int n3 = 0;
        int[] nArray = new int[2];
        for (int i = this.m_tzStart + 1; i < this.m_columnData.length; ++i) {
            if (this.m_columnData[i] == 58) {
                if (++n2 != 2) continue;
                throw new ClientErrorException("Invalid timezone format");
            }
            if (this.m_columnData[i] == 32) break;
            nArray[n2] = nArray[n2] * 10 + this.m_columnData[i] - 48;
        }
        n3 = (nArray[0] * 60 + nArray[1]) * 60 * 1000;
        return n3 *= n;
    }

    public long calculateMilliSeconds() {
        long l = (long)this.getHours() * 3600000L + (long)this.getMinutes() * 60000L + (long)(this.getSeconds() * 1000);
        long l2 = (this.getFraction() + 500) / 1000;
        return l += l2;
    }

    public final boolean hasTimezone() {
        return this.m_sawTz;
    }

    public final int getTimzoneOffset() {
        return this.m_timezoneOffset;
    }

    public final String getTimezoneId() throws UnsupportedEncodingException {
        return new String(this.m_columnData, this.m_tzStart, this.m_columnData.length - this.m_tzStart, VConnection.VERTICA_CHARSET);
    }

    public final int getHours() {
        return this.m_parts[0];
    }

    public final int getMinutes() {
        return this.m_parts[1];
    }

    public final int getSeconds() {
        return this.m_parts[2];
    }

    public final int getFraction() {
        return this.m_parts[3];
    }

    public final Calendar getTimeZoneCalendar() throws UnsupportedEncodingException {
        return Calendar.getInstance(new SimpleTimeZone(this.m_timezoneOffset, this.getTimezoneId()));
    }
}

