/*
 * Decompiled with CFR 0.152.
 */
package com.vertica.dsi.dataengine.filters;

import com.vertica.dsi.dataengine.filters.IFilter;
import com.vertica.dsi.dataengine.utilities.DataWrapper;
import com.vertica.dsi.dataengine.utilities.MetadataSourceColumnTag;
import com.vertica.dsi.exceptions.IncorrectTypeException;
import java.util.regex.Pattern;

public class StringPatternFilter
implements IFilter {
    private MetadataSourceColumnTag m_columnTag;
    private Pattern m_regEx = null;
    private String m_valueAsRegexStr = null;
    boolean m_hasPatternFilter = false;
    boolean m_isCaseInsensitive = false;

    public StringPatternFilter(MetadataSourceColumnTag columnTag, String value, String escapeChar) {
        this.m_columnTag = columnTag;
        if (null != value) {
            this.m_valueAsRegexStr = this.convertToRegexString(value, escapeChar);
        }
    }

    public StringPatternFilter(MetadataSourceColumnTag columnTag, String value, String escapeChar, boolean isCaseInsensitive) {
        this(columnTag, value, escapeChar);
        this.m_isCaseInsensitive = isCaseInsensitive;
    }

    @Override
    public boolean filter(DataWrapper data) {
        if (null == this.m_valueAsRegexStr) {
            return true;
        }
        if (data.isNull()) {
            return false;
        }
        if (null == this.m_regEx) {
            this.m_regEx = this.m_isCaseInsensitive ? Pattern.compile(this.m_valueAsRegexStr, 2) : Pattern.compile(this.m_valueAsRegexStr);
        }
        try {
            switch (data.getType()) {
                case -8: 
                case 1: {
                    return this.m_regEx.matcher(data.getChar()).matches();
                }
                case -9: 
                case 12: {
                    return this.m_regEx.matcher(data.getVarChar()).matches();
                }
                case -10: 
                case -1: {
                    return this.m_regEx.matcher(data.getLongVarChar()).matches();
                }
            }
        }
        catch (IncorrectTypeException incorrectTypeException) {
            // empty catch block
        }
        assert (false);
        return false;
    }

    @Override
    public MetadataSourceColumnTag getColumnTag() {
        return this.m_columnTag;
    }

    public boolean hasPatternFilter() {
        return this.m_hasPatternFilter;
    }

    private String convertToRegexString(String value, String escapeChar) {
        StringBuilder sb = new StringBuilder(value.length());
        int chunkBeginning = 0;
        int curr = 0;
        boolean isEscaping = false;
        while (curr < value.length()) {
            if (escapeChar.length() > 0 && value.regionMatches(curr, escapeChar, 0, escapeChar.length())) {
                if (curr > chunkBeginning) {
                    sb.append(Pattern.quote(value.substring(chunkBeginning, curr)));
                }
                if (isEscaping) {
                    sb.append(Pattern.quote(escapeChar));
                    isEscaping = false;
                } else {
                    isEscaping = true;
                }
                chunkBeginning = curr += escapeChar.length();
                continue;
            }
            char currChar = value.charAt(curr);
            if ('_' == currChar || '%' == currChar) {
                if (curr > chunkBeginning) {
                    sb.append(Pattern.quote(value.substring(chunkBeginning, curr)));
                }
                if (isEscaping) {
                    sb.append(currChar);
                } else {
                    if ('_' == currChar) {
                        sb.append('.');
                    } else {
                        sb.append(".*");
                    }
                    this.m_hasPatternFilter = true;
                }
                chunkBeginning = ++curr;
            } else {
                ++curr;
            }
            isEscaping = false;
        }
        if (!isEscaping && curr > chunkBeginning) {
            sb.append(Pattern.quote(value.substring(chunkBeginning, curr)));
        }
        return "\\A" + sb.toString() + "\\z";
    }
}

