/*
 * Decompiled with CFR 0.152.
 */
package com.vertica.support.security;

import com.vertica.support.ILogger;
import com.vertica.support.security.ISecurityContext;
import com.vertica.support.security.SimbaCredentials;
import com.vertica.support.security.SimbaSecurityContext;
import java.security.PrivilegedAction;
import javax.security.auth.Subject;
import org.ietf.jgss.GSSContext;
import org.ietf.jgss.GSSCredential;
import org.ietf.jgss.GSSException;
import org.ietf.jgss.GSSManager;
import sun.security.jgss.GSSUtil;

class SimbaAuthenticatedCredentials
extends SimbaCredentials {
    private final ILogger m_logger = null;
    private final GSSContext m_remoteContext;
    private final GSSManager m_gssManager;
    private Subject m_subject = null;

    public SimbaAuthenticatedCredentials(ILogger logger, GSSManager manager, GSSContext context) {
        this.m_remoteContext = context;
        this.m_gssManager = manager;
    }

    @Override
    GSSCredential getCredentialHandle() throws GSSException {
        return this.m_remoteContext.getDelegCred();
    }

    @Override
    public ISecurityContext getSecurityContext(String in_spn) throws Exception {
        return new SimbaSecurityContext(this, this.m_logger, in_spn, this.m_gssManager);
    }

    @Override
    public String getName() throws Exception {
        return ((Object)this.m_remoteContext.getSrcName()).toString();
    }

    @Override
    public Object executeAs(PrivilegedAction action) throws Exception {
        if (null == this.m_subject) {
            GSSCredential credential;
            try {
                credential = this.m_remoteContext.getDelegCred();
            }
            catch (GSSException ex) {
                credential = null;
            }
            this.m_subject = GSSUtil.getSubject(this.m_remoteContext.getSrcName(), credential);
        }
        return Subject.doAsPrivileged(this.m_subject, action, null);
    }
}

